/***************************************************************************/
/*                                                                         */
/*                           S N D W A V E G . H                           */
/*                             Basic Definition                            */
/*                                                                         */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 8th, 2005                                  */
/*     Licence : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

//----- Constant Parameters -----

#define FILEVERSION     "SWG1"
#define VERSION         "1.2.0"
#define DATE            "December 24 2005"

//----- Constants -----

#define DEFORMSPEED_NONE     1
#define DEFORMSPEED_VERYFAST 2
#define DEFORMSPEED_FAST     4
#define DEFORMSPEED_MEDIUM   8
#define DEFORMSPEED_SLOW     16
#define DEFORMSPEED_VERYSLOW 32

#define DEFORMTYPE_STABLE     0
#define DEFORMTYPE_VARIABLE   1
#define DEFORMTYPE_RANDOM     2

#define WAVECUTTYPE_STABLE     0
#define WAVECUTTYPE_INCREMENT  1
#define WAVECUTTYPE_DECREMENT  2
#define WAVECUTTYPE_PEAK       3
#define WAVECUTTYPE_CREVACE    4
#define WAVECUTTYPE_RANDOM     5

#define AMPVARTYPE_NOVARIATION 0
#define AMPVARTYPE_RANDOM      1
#define AMPVARTYPE_STABLE      2
#define AMPVARTYPE_OPPOSITE    3
#define AMPVARTYPE_MINMAX      4

//#define FALSE  0
//#define TRUE   1

#define FREVARTYPE_RANDOM     0
#define FREVARTYPE_RAISELOWER 1
#define FREVARTYPE_MINMAX     2

#define ZLINETYPE_RANDOM     0
#define ZLINETYPE_RAISELOWER 1
#define ZLINETYPE_MINMAX     2


#define BITRATE_8BIT         8
#define BITRATE_16BIT        16

#define WAVEBASE_SIN         0
#define WAVEBASE_SAWTOOTH    1
#define WAVEBASE_RANDOM      2
#define WAVEBASE_SINH        3
#define WAVEBASE_ATAN        4
#define WAVEBASE_EMPTY0      5
#define WAVEBASE_TAN         6
#define WAVEBASE_TANH        7
#define WAVEBASE_J0          8
#define WAVEBASE_J1          9
#define WAVEBASE_Y0          10
#define WAVEBASE_Y1          11
#define WAVEBASE_SQRT        12
#define WAVEBASE_EXPM1       13
#define WAVEBASE_FLOOR       14
#define WAVEBASE_FMOD        15
#define WAVEBASE_EMPTY1      16
#define WAVEBASE_ILOGB       17
#define WAVEBASE_LDEXP       18
#define WAVEBASE_LOG         19
#define WAVEBASE_LOG10       20
#define WAVEBASE_POW3        21
#define WAVEBASE_RINT        22

#define WAVEMODIFIER_NONE        0
#define WAVEMODIFIER_ABS         1
#define WAVEMODIFIER_MIN0        2
#define WAVEMODIFIER_MAX0        3
#define WAVEMODIFIER_MIRROR      4
#define WAVEMODIFIER_INVERT      5
#define WAVEMODIFIER_AMPLIFY     6
#define WAVEMODIFIER_DEAMPLIFY   7
#define WAVEMODIFIER_ADDRANDOM   8
#define WAVEMODIFIER_BORDER      9

#define WAVEFUNCTION_NONE    0
#define WAVEFUNCTION_SIN     1
#define WAVEFUNCTION_COS     2
#define WAVEFUNCTION_TAN     3
#define WAVEFUNCTION_ASIN    4
#define WAVEFUNCTION_ACOS    5
#define WAVEFUNCTION_ATAN    6
#define WAVEFUNCTION_FLOOR   7
#define WAVEFUNCTION_SQRT    8
#define WAVEFUNCTION_SCALBN2 9
#define WAVEFUNCTION_POW3    10
#define WAVEFUNCTION_POW4    11
#define WAVEFUNCTION_LOG     12
#define WAVEFUNCTION_LOG1P   13
#define WAVEFUNCTION_MULRANDOM 14
#define WAVEFUNCTION_EXPM1   15
#define WAVEFUNCTION_EXP     16
#define WAVEFUNCTION_ERF     17
#define WAVEFUNCTION_CBRT    18
#define WAVEFUNCTION_J0      19
#define WAVEFUNCTION_J1      20
#define WAVEFUNCTION_Y0      21
#define WAVEFUNCTION_Y1      22

#define ENVPITVARTYPE_SOFT       0
#define ENVPITVARTYPE_HARD       1
#define ENVPITVARTYPE_SAWTOOTH   2
#define ENVPITVARTYPE_RSAWTOOTH  3

#define ENVPITVARVARTYPE_STABLE        0
#define ENVPITVARVARTYPE_INCREMENT     1
#define ENVPITVARVARTYPE_DECREMENT     2
#define ENVPITVARVARTYPE_PEAK          3
#define ENVPITVARVARTYPE_CREVACE       4
#define ENVPITVARVARTYPE_RANDOM        5

#define POINTFORMTYPE_SLOPE       0
#define POINTFORMTYPE_PLATFORM    1
#define POINTFORMTYPE_SAWTOOTH    2
#define POINTFORMTYPE_RSAWTOOTH   3

extern double dblmaxval;

#ifndef ALLEGRO_WINDOWS
   #define rnd(value) ( ( random()%((value)) ) + 1 )
   #define dblrnd ( ( (double)( random() / dblmaxval ) * 2 ) -1 )
#else   
   #define rnd(value) ( ( rand()%((value)) ) + 1 )
   #define dblrnd ( ( (double)( rand() / dblmaxval ) * 2 ) -1 )
#endif


//----- Data Types -----

typedef signed char tiny;
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;

//----- Structure definition -----

typedef struct s_coordinate
{
   short x;
   short y;
}s_coordinate;

typedef struct s_envpittype
{
   short varfreq; // number of variation per seconds
   short varprop; // variation proportion in %
   tiny vartype; // how variation is drawn on the envelope
   tiny varvartype; // variation of the variation proportion throught time
   tiny pointformtype; // how the point are interpreted
}s_envpittype;

typedef struct s_wavetype
{
   tiny base;
   tiny filter;
   tiny function;
   tiny deformlevel;
   tiny deformspeed;
   tiny deformtype;
   word cutfreq;
   word cutsize;
   tiny cuttype;
   tiny ampvprop;
   tiny ampvbust;
   tiny ampvtype;
   tiny frevprop;
   tiny frevtype;
   tiny zlinelevel;
   tiny zlinetype;
}s_wavetype;

typedef struct s_wave_parameter
{
   char swgfileID[4]; // SWGX where X is the version number
   tiny bitrate;
   tiny stereo;
   word frequency;
   dword length;
   s_wavetype waveform;
   s_coordinate envelope [ 8 ];
   s_envpittype envform;
   s_coordinate pitch [ 8 ];
   s_envpittype pitform;
}s_wave_parameter;

typedef struct s_wave_entry
{
//   short waveform;
   short frequency;
   short envelope;
}s_wave_entry;

typedef struct s_WAV_riff_header
{
   char ChunkID[4]; // "RIFF" 0x52494646
   int ChunkSize; // 36 + SubChunk2Size (sample )
   char format[4]; //" WAVE" 0x57415645
}s_WAV_riff_header;

typedef struct s_WAV_format_header
{
   char ChunkID[4]; // "fmt " 0x666d7420
   int ChunkSize; // 16 for PCM
   short AudioFormat; // PCM = 1
   short NumChannel; // mono = 1, stereo = 2
   int SampleRate; // 11025,etc
   int ByteRate; // samplerate * numchanel * bitpersample/8
   short BlockAlign; // numchanel * bitpersample/8
   short BitsPerSample; //8 bit, 16 bit
   //?? not sure if add other stuff
}s_WAV_format_header;

typedef struct s_WAV_sample_header
{
   char ChunkID[4]; // "data" 0x64617461
   int ChunkSize; // NumSample * NumChannels * BitPerSample/8
}s_WAV_sample_header;

//--- Global Variables ---

extern s_wave_entry* wcontain;
extern s_wave_parameter wparam; // sound parameters
extern s_coordinate winenvvar [ 8 ];
extern s_coordinate winpitvar [ 8 ];
extern SAMPLE *mainsample;

//----------- Prototype Declaration ----------------------

//--- Wave.cpp ---
SAMPLE* generate_sound ( s_wave_parameter waveinfo );
double wave_base ( tiny type, double radian );
double wave_modifier ( tiny type, double value, tiny pivot );
double wave_function ( tiny type, double value );
void envelope_callback(BITMAP *bmp, int x, int y, int d);
void pitch_callback(BITMAP *bmp, int x, int y, int d);

void reset_wave_parameter ( s_wave_parameter *wavp );
void validate_wave_parameter ( s_wave_parameter *wavp );
SAMPLE* make_test_waveform ( s_wave_parameter wavp );
SAMPLE* make_test_envelope ( s_wave_parameter wavp );
SAMPLE* make_test_pitch ( s_wave_parameter wavp );

tiny export_to_wav ( SAMPLE *tmpsample, char *filename );
tiny save_to_swg ( s_wave_parameter wavp, char *filename );
tiny load_from_swg ( s_wave_parameter *wavp, char *filename );

//--- Screen.cpp ---

void init_gui ( void );
void show_mainform ( void );
void show_waveform_property ( void );
void show_envelope_property ( void );
void show_pitch_property ( void );
void show_setting_property ( void );
void show_generated_sample ( void );
void show_about ( void );
void show_intro ( void );
void do_algo7_animation ( BITMAP *buffer, BITMAP *nextbuf );



