/***************************************************************************/
/*                                                                         */
/*                                G U I . H                                */
/*                              Module Definition                          */
/*                                                                         */
/*     Content : GUI related procedures                                    */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 9th, 2005                                  */
/*     Licence : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

//----- Constant Parameter -----

//----- Type Definition -----

//----- Global Variables -----

//--- Gui Object ---

//extern hidden_list_object ghls_waveform_basewave;
//extern hidden_list_object ghls_waveform_function;
//extern hidden_list_object ghls_waveform_filter;
//extern hidden_list_object ghls_waveform_deformspeed;
//extern edittext_object getx_deformlevel;
//extern edittext_object getx_wcutfreq;
//extern edittext_object getx_wcutlength;
//extern bitmap_object gbmp_waveform_waveform;
   // waveform window
extern hidden_list_object ghls_winwav_basewave;
extern hidden_list_object ghls_winwav_function;
extern hidden_list_object ghls_winwav_filter;
extern hidden_list_object ghls_winwav_deformspeed;
extern hidden_list_object ghls_winwav_deformtype;
extern hidden_list_object ghls_winwav_wavecuttype;
extern edittext_object getx_winwav_deformlevel;
extern edittext_object getx_winwav_wcutfreq;
extern edittext_object getx_winwav_wcutlength;
extern bitmap_object gbmp_winwav_waveform;
extern hidden_list_object ghls_winwav_ampvartype;//new
extern hidden_list_object ghls_winwav_frevartype;//new
extern hidden_list_object ghls_winwav_zlinetype;//new
extern edittext_object getx_winwav_ampvarprop;//new
extern edittext_object getx_winwav_frevarprop;//new
extern edittext_object getx_winwav_zlinelevel;//new
extern checkbox_object gchk_winwav_ampvarzline;//new


   // main windows
extern bitmap_object gbmp_main_waveform;
extern bitmap_object gbmp_main_envelope;
extern bitmap_object gbmp_main_pitch;
extern bitmap_object gbmp_main_waveforminfo;
extern bitmap_object gbmp_main_envelopeinfo;
extern bitmap_object gbmp_main_pitchinfo;
extern bitmap_object gbmp_main_generalinfo;
extern slider_object gsld_main_volume;
extern winbutton_object gbtn_exit;

   // envelope window
//extern edittext_object getx_winenv_varfreq;
//extern edittext_object getx_winenv_varprop;
//extern bitmap_object gbmp_winenv_envelope;
extern bitmap_object gbmp_winenv_envelope;
extern edittext_object getx_winenv_varfreq;
extern edittext_object getx_winenv_varprop;
extern hidden_list_object ghls_winenv_vartype;
extern hidden_list_object ghls_winenv_varvartype;
extern hidden_list_object ghls_winenv_pointformtype;

   // pitch window
//extern bitmap_object gbmp_winpit_pitch;
//extern hidden_list_object ghls_winpit_vtype;
//extern hidden_list_object ghls_winpit_vswitch;
//extern hidden_list_object glst_winpit_preset;
//extern edittext_object getx_winpit_freq;
//extern edittext_object getx_winpit_prop;

extern bitmap_object gbmp_winpit_pitch;
extern edittext_object getx_winpit_freq;
extern edittext_object getx_winpit_prop;
extern hidden_list_object ghls_winpit_vartype;
extern hidden_list_object ghls_winpit_varvartype;
extern hidden_list_object ghls_winpit_pointformtype;


   // setting windows
extern hidden_list_object ghls_winset_bitrate;
extern hidden_list_object ghls_winset_samfreq;
extern edittext_object getx_winset_length;

   // generation windows
extern bitmap_object gbmp_wingen_generate;


//Gui Bitmap
extern BITMAP* bbmp_waveform;
extern BITMAP* bbmp_envelope;
extern BITMAP* bbmp_pitch;
extern BITMAP* bbmp_generate;

extern BITMAP* bbmp_waveforminfo;
extern BITMAP* bbmp_envelopeinfo;
extern BITMAP* bbmp_pitchinfo;
extern BITMAP* bbmp_generalinfo;


#define SLST_WAVEBASE_SIZE    23
extern char SLST_WAVEBASE [ SLST_WAVEBASE_SIZE ] [ 26 ];
#define SLST_WAVEFUNCTION_SIZE    23
extern char SLST_WAVEFUNCTION [ SLST_WAVEFUNCTION_SIZE ] [ 26 ];
#define SLST_WAVEFILTER_SIZE     10
extern char SLST_WAVEFILTER [ SLST_WAVEFILTER_SIZE ] [ 26 ];
#define SLST_DEFORMSPEED_SIZE    6
extern char SLST_DEFORMSPEED [ SLST_DEFORMSPEED_SIZE ] [ 11 ];
#define SLST_DEFORMTYPE_SIZE    3
extern char SLST_DEFORMTYPE [ SLST_DEFORMTYPE_SIZE ] [ 11 ];
#define SLST_AMPVARTYPE_SIZE    5
extern char SLST_AMPVARTYPE [ SLST_AMPVARTYPE_SIZE ] [ 16 ];
#define SLST_FREVARTYPE_SIZE    3
extern char SLST_FREVARTYPE [ SLST_FREVARTYPE_SIZE ] [ 16 ];
#define SLST_ZLINETYPE_SIZE    3
extern char SLST_ZLINETYPE [ SLST_ZLINETYPE_SIZE ] [ 16 ];

#define SLST_ENVPITVARTYPE_SIZE    4
extern char SLST_ENVPITVARTYPE [ SLST_ENVPITVARTYPE_SIZE ] [ 16 ];
#define SLST_ENVPITVARVARTYPE_SIZE    6
extern char SLST_ENVPITVARVARTYPE [ SLST_ENVPITVARVARTYPE_SIZE ] [ 11 ];
#define SLST_ENVPITPOINTFORMTYPE_SIZE    4
extern char SLST_ENVPITPOINTFORMTYPE [ SLST_ENVPITPOINTFORMTYPE_SIZE ] [ 16 ];


#define SLST_SETTINGBITRATE_SIZE   2
extern char SLST_SETTINGBITRATE [ SLST_SETTINGBITRATE_SIZE ] [ 9 ];
#define SLST_SETTINGFREQUENCY_SIZE   3
extern char SLST_SETTINGFREQUENCY [ SLST_SETTINGFREQUENCY_SIZE ] [ 9 ];



#define DEFORMSPEED_SIZE    6
extern tiny DEFORMSPEED [ DEFORMSPEED_SIZE ];
#define FREQUENCY_SIZE    3
extern int FREQUENCY [ FREQUENCY_SIZE ];



//----- Prototype Declaration -----

char *flst_wavebase (int index, int *list_index );
char *flst_wavefunction (int index, int *list_index );
char *flst_wavefilter (int index, int *list_index );
char *flst_deformspeed (int index, int *list_index );
char *flst_deformtype (int index, int *list_index );
char *flst_ampvartype (int index, int *list_index );
char *flst_frevartype (int index, int *list_index );
char *flst_zlinetype (int index, int *list_index );
char *flst_envpitvartype (int index, int *list_index );
char *flst_envpitvarvartype (int index, int *list_index );
char *flst_envpitpointformtype (int index, int *list_index );
char *flst_settingbitrate (int index, int *list_index );
char *flst_settingfrequency (int index, int *list_index );


void set_waveform_property ( s_wave_parameter *wavp );
void get_waveform_property ( s_wave_parameter wavp  );
void set_envelope_property ( s_wave_parameter *wavp );
void get_envelope_property ( s_wave_parameter wavp  );
void set_pitch_property ( s_wave_parameter *wavp );
void get_pitch_property ( s_wave_parameter wavp  );
void set_setting_property ( s_wave_parameter *wavp );
void get_setting_property ( s_wave_parameter wavp  );


void draw_main_property ( s_wave_parameter wavp );
void draw_main_bitmap ( s_wave_parameter wavp );

void draw_waveform ( SAMPLE *tmpsample );
void draw_envelopeform ( SAMPLE *tmpsample );
void draw_pitchform ( SAMPLE *tmpsample );
void draw_envelope ( s_wave_parameter wavp );
void draw_pitch ( s_wave_parameter wavp );

void draw_generate ( SAMPLE *tmpsample );

int gc_waveform_preview_click ( void );
int gc_waveform_accept_click ( void );
int gc_waveform_cancel_click ( void );

int gc_envelope_preview_click ( void );
int gc_envelope_accept_click ( void );
int gc_envelope_cancel_click ( void );
int gc_envelope_pointA_click ( void );
int gc_envelope_pointB_click ( void );
int gc_envelope_pointC_click ( void );
int gc_envelope_pointD_click ( void );
int gc_envelope_pointE_click ( void );
int gc_envelope_pointF_click ( void );
int gc_envelope_pointG_click ( void );
int gc_envelope_pointH_click ( void );
int gc_envelope_pointgeneric_click ( int pointID );


int gc_pitch_preview_click ( void );
int gc_pitch_accept_click ( void );
int gc_pitch_cancel_click ( void );
int gc_pitch_pointA_click ( void );
int gc_pitch_pointB_click ( void );
int gc_pitch_pointC_click ( void );
int gc_pitch_pointD_click ( void );
int gc_pitch_pointE_click ( void );
int gc_pitch_pointF_click ( void );
int gc_pitch_pointG_click ( void );
int gc_pitch_pointH_click ( void );
int gc_pitch_pointgeneric_click ( int pointID );


int gc_setting_accept_click ( void );
int gc_main_generate_click ( void );

int gc_generate_play_click ( void  );
int gc_generate_export_click ( void  );
int gc_generate_close_click ( void  );



void move_envelope_point ( int pointid, s_wave_parameter *wavp );
void move_pitch_point ( int pointid, s_wave_parameter *wavp );



int mnu_proc ( void );
int mnu_file_new ( void );
int mnu_file_open ( void );
int mnu_file_save ( void );
int mnu_file_exit ( void );
int mnu_param_setting ( void );
int mnu_param_waveform ( void );
int mnu_param_envelope ( void );
int mnu_param_pitch ( void );
int mnu_help_help ( void );
int mnu_help_about ( void );



//void pointcopy ( s_coordinate *dst[], s_coordinate *src[] );

#define POINTCOPY(dst,src) for (z=0; z<8; z++) { (dst)[z].x = (src)[z].x; (dst)[z].y = (src)[z].y; }
extern int z;

//   define rnd(value) ( ( random()%((value)) ) + 1 )

/*void pointcopy ( s_coordinate *dst[], s_coordinate *src[] )
{
   int i;

   for ( i = 0 ; i < 4 ; i++ )    { dst [ i ] -> x = src [ i ] -> x; dst [ i ] -> y = src [ i ] -> y; }
} */


