#include<allegro.h>
#include "protot.h"
#include "ground.h"
#include "fire.h"
#include"motoko.h"

volatile int last_fps;
volatile int frame_counter;

void count_frames()
{
last_fps = frame_counter;
frame_counter = 0;
}
END_OF_FUNCTION(count_frames);

int mx=180,my=390,fr=0,aide=0;
int ex=0,ey=0,emode=0,etile=0,animo=0;
BITMAP *tilet,*buffer,*map,*trees;
PALLETE pal;
void *nuotio,*soihtu;


void load_map(char *fname);
void save_map(char *fname);
void create_saved_map(char *fname);
void draw_engine(BITMAP *where,int x,int y);

int get_tile(int x,int y);
void put_tile(int x,int y,int da);
int get_wall(int x,int y);
void put_wall(int x,int y,int da);
int get_sprite(int x,int y);
void put_sprite(int x,int y,int da);
int get_roof(int x,int y);
void put_roof(int x,int y,int da);
int get_second(int x,int y);
void put_second(int x,int y,int da);

main ()
{
_motoko_preset *lurrinlur1 = malloc(sizeof(_motoko_preset));
_motoko_preset *lurrinlur2 = malloc(sizeof(_motoko_preset));

char puffi[1024];
allegro_init();
install_keyboard();
install_timer();
LOCK_VARIABLE(last_fps);
LOCK_VARIABLE(frame_counter);
LOCK_FUNCTION(count_frames);
install_int_ex(count_frames, BPS_TO_TIMER(1));
set_color_depth(16);
set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);
set_color_conversion(COLORCONV_TOTAL);

init_fire_engine();
nuotio=new_fire(25,32,40);
soihtu=new_fire(10,16,20);

_motoko_preset_init(lurrinlur1,500, 310, 240, 0, -.01, 0, 0, 360, 1, 360, .3, .2, 0, 50, 0, 1, 240, 50, 400, 1, 500, 1, 0,3,0,makecol16(205,205,255));
_motoko_preset_init(lurrinlur2,15, 320, 240, 0, -.01, 0, 0, 360, 0, 360, .8, .2, 0, 1, 0, 1, 240, 300, 400, 1, 100, 1, 0,3,0,makecol16(255,255,0));
_motoko.di=2;
_motoko_all_kill();
_motoko_preset_group(0,lurrinlur1);
_motoko_preset_group(1,lurrinlur2);

set_tiles(ACT1);

tilet=load_bitmap("gfx/tilet.pcx",pal);
buffer=create_bitmap(640,480);
clear(buffer);
load_map("map/world1.pcx");
trees=load_lbm("gfx/trees.lbm",pal);

while(!key[KEY_ESC])
        {
        animo++;
        _motoko_all_logic();

        draw_engine(buffer,mx,my);
        if(animo==25)animo=0,fr++;
        if(fr==3)fr=0;
        if(keypressed())
                {
                //Editorial
                if((key[KEY_A])&&(etile<NUM_OF_TILES-1))etile++;
                if((key[KEY_Z])&&(etile>0))etile--;
                if((key[KEY_UP])&&(ey>=1))ey--;
                if((key[KEY_DOWN])&&(ey<=18))ey++;
                if((key[KEY_LEFT])&&(ex>=2))ex--;
                if((key[KEY_RIGHT])&&(ex<=19))ex++;
                if((key[KEY_HOME])&&(my>0))my--;
                if((key[KEY_DEL])&&(mx>0))mx--;
                if((key[KEY_END])&&(my<580))my++;
                if((key[KEY_PGDN])&&(mx<580))mx++;
                if(key[KEY_F1])emode=0;
                if(key[KEY_F2])emode=1;
                if(key[KEY_F3])emode=2;
                if(key[KEY_F4])emode=3;
                if(key[KEY_F5])emode=4;
                if(key[KEY_F12])save_map("map/world1.pcx");
                if(emode==0)
                        {
                        if(key[KEY_TAB])etile=get_tile(mx+ex,my+ey);
                        if(key[KEY_SPACE])put_tile(mx+ex,my+ey,etile);
			aide=0;
			if(key[KEY_0])aide=1;
                        }
                if(emode==1)
                        {
                        if(key[KEY_TAB])etile=get_wall(mx+ex,my+ey);
                        if(key[KEY_SPACE])put_wall(mx+ex,my+ey,etile);
                        }
                if(emode==2)
                        {
                        if(key[KEY_TAB])etile=get_sprite(mx+ex,my+ey);
                        if(key[KEY_SPACE])put_sprite(mx+ex,my+ey,etile);
                        }
                if(emode==3)
                        {
                        if(key[KEY_TAB])etile=get_roof(mx+ex,my+ey);
                        if(key[KEY_SPACE])put_roof(mx+ex,my+ey,etile);
			if(key[KEY_0])aide=2;
                        }
                if(emode==4)
                        {
                        if(key[KEY_TAB])etile=get_second(mx+ex,my+ey);
                        if(key[KEY_SPACE])put_second(mx+ex,my+ey,etile);
                        }
                }
        if(key[KEY_I]) {
            int x,y;
            for(x=0;x<600;x++) {
                for(y=0;y<600;y++) {
                    put_tile(x,y,rand ()%2);
                    }
                }
            }
        textprintf(buffer,font,0,0,makecol16(255,0,0),"FPS:%d",last_fps);
        textprintf(buffer,font,0,10,makecol16(255,0,0),"Emode:%d",emode);
        textprintf(buffer,font,0,20,makecol16(255,0,0),"Tile:%d",etile);
        textprintf(buffer,font,0,30,makecol16(255,0,0),"Coords:%d.%d",mx+ex,my+ey);
        textprintf(buffer,font,0,40,makecol16(255,0,0),"Map Depth:%d",bitmap_color_depth(map));
        if(emode==0)
                {
                textprintf(buffer,font,100,0,makecol16(255,0,0),"SOLID:%d",tile[etile].solid);
                textprintf(buffer,font,100,10,makecol16(255,0,0),"Anim:%d",tile[etile].animo);
                textprintf(buffer,font,100,20,makecol16(255,0,0),"Step:%s",tile[etile].step_sound);
                }
        if(emode==1)
                {
                textprintf(buffer,font,100,0,makecol16(255,0,0),"SOLID:%d",wall[etile].solid);
                textprintf(buffer,font,100,10,makecol16(255,0,0),"TYPE:%d",wall[etile].type);
                textprintf(buffer,font,100,20,makecol16(255,0,0),"HIDES:%d",wall[etile].hides);
                textprintf(buffer,font,100,30,makecol16(255,0,0),"NAME:%s",wall[etile].name);
                }
        blit(buffer,screen,0,0,0,0,640,480);
        clear(buffer);
        rest(20);
        vsync();
        frame_counter++;
        }
destroy_bitmap(buffer);
destroy_bitmap(tilet);
save_map("map/world1.pcx");
allegro_exit();
return (0);
}
END_OF_MAIN();

void save_map(char *fname)
{
save_pcx(fname,map,NULL);
}

void load_map(char *fname)
{
int x=0,y=0;
map=load_pcx(fname,pal);
if(!map)
        {
        clear_to_color(screen,makecol16(255,0,0));
        textprintf_centre(screen,font,320,240,makecol16(255,255,0),"ERROR CODE: KRT404");
        readkey();
        map=create_bitmap_ex(8,MAP_X,5*MAP_Y);
        clear(map);
	save_pcx(fname,map,NULL);
        }
}

void draw_engine(BITMAP *where,int x,int y)
{
int tx=20,ty=0,fix=0,fixy=0;
while(ty!=20)
        {
        fix=295+(ty*16);
        fixy=(ty*8)+124;
        while(tx!=0)
                {
		if(aide==1)put_tile(x+tx,y+ty,etile);
		if(aide==2)put_roof(x+tx,y+ty,etile);
                if(tile[get_tile(x+tx,y+ty)].animo==0)masked_blit(tilet,where,get_tile(x+tx,y+ty)*32,0,fix,fixy,32,40);
                if(tile[get_tile(x+tx,y+ty)].animo==1)masked_blit(tilet,where,(fr+get_tile(x+tx,y+ty))*32,0,fix,fixy,32,40);
                if((get_roof(x+tx,y+ty) == TREE_ROOF)&&(emode==3)) masked_blit(trees,where,get_second(x+tx,y+ty)*150,0,fix-59,fixy-115,150,100);
                if(get_wall(x+tx,y+ty)!=0)
                        {                
                        if((wall[get_wall(x+tx,y+ty)].type==END_FRAME_3)&&(animo==25))
                                {
                                put_wall(x+tx,y+ty,get_wall(x+tx,y+ty)-2);
                                goto pass_animo;
                                }
                        if((wall[get_wall(x+tx,y+ty)].type==END_FRAME_6)&&(animo==25))
                                {
                                put_wall(x+tx,y+ty,get_wall(x+tx,y+ty)-5);
                                goto pass_animo;
                                }
                        if((wall[get_wall(x+tx,y+ty)].type==UP_FRAME)&&(animo==25))put_wall(x+tx,y+ty,get_wall(x+tx,y+ty)+1);
                        pass_animo:
                        masked_blit(tilet,where,get_wall(x+tx,y+ty)*32,40,fix,fixy-40,32,80);
                        }
                if(get_sprite(x+tx,y+ty)!=0)
                        {
                        masked_blit(tilet,where,get_sprite(x+tx,y+ty)*32,120,fix,fixy-wall[get_wall(x+tx,y+ty)].nosto,32,40);
			if(get_sprite(x+tx,y+ty)==FX_TILE) {
				if(get_second(x+tx,y+ty)==0) draw_fire(soihtu,where,fix+16,30+fixy-wall[get_wall(x+tx,y+ty)].nosto);
				if(get_second(x+tx,y+ty)==1) _motoko_alt_group_draw(where,1,fix+16,(fixy+30)-wall[get_wall(x+tx,y+ty)].nosto);
				if(get_second(x+tx,y+ty)==2) draw_fire(nuotio,where,fix+16,(fixy+30)-wall[get_wall(x+tx,y+ty)].nosto);
				if(get_second(x+tx,y+ty)==3) _motoko_alt_group_draw(where,0,fix+16,fixy+20);
				}
                        }
                if((get_roof(x+tx,y+ty)!=0)&&(emode==3))masked_blit(tilet,where,get_roof(x+tx,y+ty)*32,160,fix,fixy-40,32,40);
                        //editorial
                        if((tx==ex)&&(ty==ey))
                                {
                                solid_mode();
                                rect(where,fix,fixy-32,fix+31,fixy+40,makecol16(255,0,0));
                                if(emode==0)masked_blit(tilet,where,etile*32,0,fix,fixy,32,40);
                                if(emode==1)masked_blit(tilet,where,etile*32,40,fix,fixy-40,32,80);
                                if(emode==2)masked_blit(tilet,where,etile*32,120,fix,fixy,32,40);
                                if(emode==3)masked_blit(tilet,where,etile*32,160,fix,fixy-40,32,40);
                                }
                if(((get_wall(x+tx,y+ty)!=0)||(get_sprite(x+tx,y+ty)!=0))&&(emode==4))textprintf(where,font,fix+3,fixy+18-wall[get_wall(x+tx,y+ty)].nosto,makecol16(0,255,0),"%d",get_second(x+tx,y+ty));
                fixy=fixy+8;
                fix=fix-16;
                tx--;
                }
        ty++,tx=20;
        }
}

int get_tile(int x,int y)
{
unsigned int taili=map->line[y][x];
if(taili>99)return 0;
return taili;
}

void put_tile(int x,int y,int da)
{
map->line[y][x]=da;
}

int get_sprite(int x,int y)
{
unsigned int taili=map->line[y+MAP_Y][x];
if(taili>NUM_OF_TILES-1)return 0;
return taili;
}

void put_sprite(int x,int y,int da)
{
map->line[y+MAP_Y][x]=da;
}

int get_roof(int x,int y)
{
unsigned int taili=map->line[y+(2*MAP_Y)][x];
if(taili>NUM_OF_TILES-1)return 0;
return taili;
}

void put_roof(int x,int y,int da)
{
map->line[y+(2*MAP_Y)][x]=da;
}

int get_wall(int x,int y)
{
unsigned int taili=map->line[y+(3*MAP_Y)][x];
if(taili>NUM_OF_TILES-1)return 0;
return taili;
}

void put_wall(int x,int y,int da)
{
map->line[y+(3*MAP_Y)][x]=da;
}

int get_second(int x,int y)
{
unsigned int taili=map->line[y+(4*MAP_Y)][x];
if(taili>NUM_OF_TILES-1)return 0;
return taili;
}

void put_second(int x,int y,int da)
{
map->line[y+(4*MAP_Y)][x]=da;
}

