// FPSEMU 1.2 by Kim A. Malde (c) 2003

int frame = 0; float fps = 100.;
int fe = 1, fc = 1, fll = 0, ft;
float fw = 5.;

volatile int t;
void tick(void) { t++; } END_OF_FUNCTION(tick);

void fps_init();
int fps_emu(int fs);

void fps_init()
{
    LOCK_VARIABLE(t);
    LOCK_FUNCTION(tick);
    install_int(tick, 10);
}

int fps_emu(int fs) // 1 for normal, 2 for double "speed"
{
    int i;
    for (i = t; i < t;) {}

    if (fs < 1) fs = 1;
    if (fe < 1) fe = 1;

    if (fll > 1) fll--;
    if (fll == 1) t = ft;
    if (fll == 0 && fe < fps) { fll = (fps+1) / fe + 1; ft = t; }
    if (fll > 1) return -1; // Skip frame data altering

    if (fc < fw * fs) { fc++; return 0; } // Skip frame
    if (t > 100) { fps = (100. * frame) / t; t = frame = 0; } else frame++;
    fw = fe / (fps + 1);
    fc = fll = 0;
    return 1; // A frame can be drawn
}
