#include <stdlib.h>                             // INCLUDES
#include <time.h>

enum suits { HEARTS, CLUBS, DIAMONDS, SPADES, BLANK }; // defines the suits

class CardDeck {
    struct card { suits suit; int value; };     // defines a card
    card myDeck[52];                              // defines a deck

  public:
    CardDeck ();                                // Creates a shuffled deck
    void Display ();
    suits CardSuit (int i);                     // returns suit of card i in deck
    int CardValue (int i);                      // returns value of card i in deck
    void Shuffle ();
};

CardDeck::CardDeck () {                         // Constructor Code
  int i;
  
  for (i = 0; i < 13; i++)
  {
    myDeck[i].suit = HEARTS;
    myDeck[i].value = i + 2;
  }

  for (i = 13; i < 26; i++)
  {
    myDeck[i].suit = CLUBS;
    myDeck[i].value = i - 11;
  }

  for (i = 26; i < 39; i++)
  {
    myDeck[i].suit = DIAMONDS;
    myDeck[i].value = i - 24;
  }

  for (i = 39; i < 52; i++)
  {
    myDeck[i].suit = SPADES;
    myDeck[i].value = i - 37;
  }
}

void CardDeck::Shuffle () {
  int i, random, irandom, temp_value;
  suits temp_suit;

  srand(time(0));

  for (i = 0; i < 100; i++)
  {
    random = rand()%52;
    irandom = rand()%52;
    temp_suit = myDeck[random].suit;
    temp_value = myDeck[random].value;

    myDeck[random].suit = myDeck[irandom].suit;
    myDeck[random].value = myDeck[irandom].value;

    myDeck[irandom].suit = temp_suit;
    myDeck[irandom].value = temp_value;
  }
}

void CardDeck::Display () {
  int i;

  for (i = 0; i < 13; i++)
  {
    cout << myDeck[i].suit << '_';
    cout << myDeck[i].value << ' ';
  }

  for (i = 13; i < 26; i++)
  {
    cout << myDeck[i].suit << '_';
    cout << myDeck[i].value << ' ';
  }

  for (i = 26; i < 39; i++)
  {
    cout << myDeck[i].suit << '_';
    cout << myDeck[i].value << ' ';
  }

  for (i = 39; i < 52; i++)
  {
    cout << myDeck[i].suit << '_';
    cout << myDeck[i].value << ' ';
  }
}

// returns suit of card i in deck
suits CardDeck::CardSuit (int i) { return myDeck[i].suit; }

// returns value of card i in deck
int CardDeck::CardValue (int i) { return myDeck[i].value; }

class Hand {
    struct card { suits suit; int value; };     // defines a card
    card myHand[14];                            // defines a hand (1 space in end for overshooting index)
  public:
    Hand ();
    Hand (const Hand &);
    card & operator[](int offset) { return myHand[offset]; }
    void SetHand (CardDeck Deck, int sindex);
    suits CardSuit (int i);
    int CardValue (int i);
    void OrgHand ();
    int FindCard (suits suit, int value);
    int CountSuit (suits suit);
    int LowClub ();
    bool VoidSuit(suits suit_desired);
    void RuleHash(int num_cards_played, suits suit_led, bool spades_broken);
    int HighCard(suits suit);
    int LowestCard(suits suit);
    void RemoveCard(suits suit, int value);
    int Bid();
};

Hand::Hand () { }

Hand::Hand (const Hand & rvalue)
{
  for (int i = 0; i < 13; i++) {
    myHand[i] = rvalue.myHand[i];
  }
}

void Hand::SetHand (CardDeck Deck, int sindex) {
    for (int i = 0; i < 13; i++) {
    myHand[i].suit = Deck.CardSuit(sindex);
    myHand[i].value = Deck.CardValue(sindex);
    sindex += 4;
  }
  myHand[13].suit = BLANK;
  myHand[13].value = 0;
}

suits Hand::CardSuit (int i) { return myHand[i].suit; };

int Hand::CardValue (int i) { return myHand[i].value; };

void Hand::OrgHand () {
  int i, temp_value, flag = 0;
  suits temp_suit;

  while (flag == 0) {
    flag = 1;
    for (i = 0; i < 12; i++) {                          // yes 12 IS correct
      if (myHand[i].suit * 13 + myHand[i].value > myHand[i + 1].suit * 13 + myHand[i + 1].value) {
        temp_suit = myHand[i].suit;
        temp_value = myHand[i].value;
        myHand[i].suit = myHand[i + 1].suit;
        myHand[i].value = myHand[i + 1].value;
        myHand[i + 1].suit = temp_suit;
        myHand[i + 1].value = temp_value;
        flag = 0;
      }
    }
  }
}


// Find position of a card in the deck
// Return -1 if not found
int Hand::FindCard (suits suit_sought, int value_sought) {
  for ( int i = 0; i < 13; i++) {
    if (myHand[i].suit == suit_sought && myHand[i].value == value_sought) {
      return i;
    }
  }
  return -1;
}

// Returns how many cards of a certain suit
int Hand::CountSuit(suits suit_sought) {
  int suit_count = 0, i;
  
  for (i = 0; i < 13; i++) {
    if (myHand[i].suit == suit_sought) {
      suit_count++;
    }
  }
  return suit_count;
}

// Return value of lowest club or -1 if no clubs
int Hand::LowClub () {
  for (int i = 0; i < 13; i++) {
    if (myHand[i].suit == CLUBS) {
      return myHand[i].value;
    }
  }
  return -1;
}

// Return true if suit_desired is in Hand; otherwise false
bool Hand::VoidSuit(suits suit_desired)
{
  for (int k = 0; k < 13; k++) {
    if (myHand[k].suit == suit_desired) {
      return false;
    }
  }
  return true;
}

void Hand::RuleHash(int num_cards_played, suits suit_led, bool spades_broken)
{
  int i;
  bool flag;

  // If low club led or have 2 of clubs to lead or play, respectivly
  if (num_cards_played == 0 && !VoidSuit(CLUBS)) {
    for (i = 0; i < 13; i++) {
      if (myHand[i].suit != CLUBS || myHand[i].value != LowClub()) {
        myHand[i].suit = BLANK;
        myHand[i].value = 0;
      }
    }
    return;
  }

  // If leading allow anything but spades until broken (in exception of nothing else to lead, then allow spades)
  if (suit_led == BLANK) {
    if (spades_broken == true) {
      return;
    } else {
      for (i = 0, flag = false; i < 13; i++) {					// Check for exception that need to break spades leading
        if (myHand[i].suit != SPADES) {
          flag = true;
        }
      }

      if (flag == false) {
        return;
      }

      for (i = 0; i < 13; i++) {
        if (myHand[i].suit == SPADES) {
          myHand[i].suit = BLANK;
          myHand[i].value = 0;
        }
      }
      return;
    }
  }

  // If void in suit led, can play anything.
  if (VoidSuit(suit_led)) {
    return;
  }

  // If have suit led, limit to that suit
  else
  {
    for (i = 0; i < 13; i++) {
      if (myHand[i].suit != suit_led) {
        myHand[i].suit = BLANK;
        myHand[i].value = 0;
      }
    }
  }
  return;
}

// Returns highest card of certain suit in hand
int Hand::HighCard(suits suit)
{
  for (int i = 14; i >= 2; i--) {
    if (FindCard(suit, i) != -1) {
      return i;
    }
  }
  return 0;
}

// Returns lowest card of certain suit in hand
int Hand::LowestCard(suits suit)
{
  for (int i = 2; i <= 14; i++) {
    if (FindCard(suit, i) != -1) {
      return i;
    }
  }
  return 0;
}

// Removes desired card and sets new last element to zero
void Hand::RemoveCard(suits suit, int value)
{
  int index = FindCard(suit, value);
  myHand[index].suit = BLANK;
  myHand[index].value = 0;
}

int Hand::Bid()
{
  int total_bid = 0, i, suit_count_hearts = CountSuit(HEARTS), suit_count_clubs = CountSuit(CLUBS), suit_count_diamonds = CountSuit(DIAMONDS), suit_count_spades = CountSuit(SPADES);

  // Hearts bidding
  if (suit_count_hearts <= 6 && FindCard(HEARTS, 14) != -1) {
    total_bid++;
  }
  if (suit_count_hearts <= 4 && suit_count_hearts >= 2 && FindCard(HEARTS, 13) != -1) {
    total_bid++;
  }

  // Clubs bidding
  if (suit_count_clubs <= 4 && FindCard(CLUBS, 14) != -1) {
    total_bid++;
  }
  if (suit_count_clubs == 3 && FindCard(CLUBS, 13) != -1) {
    total_bid++;
  }
  if (LowClub() >= 6) {
    total_bid++;
  }

  // Diamonds bidding
  if (suit_count_diamonds <= 6 && FindCard(DIAMONDS, 14) != -1) {
    total_bid++;
  }
  if (suit_count_diamonds <= 4 && suit_count_diamonds >= 2 && FindCard(DIAMONDS, 13) != -1) {
    total_bid++;
  }

  // Spades bidding
  if (FindCard(SPADES, 14) != -1) {
    total_bid++;
    suit_count_spades--;
  }
  if (suit_count_spades >= 2 && FindCard(SPADES, 13) != -1) {
    total_bid++;
    suit_count_spades -= 2;
  }
  if (suit_count_hearts < 3) {
    i = 3 - suit_count_hearts;
    for (i = 3 - suit_count_hearts; i > 0 && suit_count_spades > 0; i--, suit_count_spades--) {
      total_bid++;
    }
  }
  if (suit_count_clubs < 3) {
    i = 3 - suit_count_clubs;
    for (i = 3 - suit_count_clubs; i > 0 && suit_count_spades > 0; i--, suit_count_spades--) {
      total_bid++;
    }
  }
  if (suit_count_diamonds < 3) {
    i = 3 - suit_count_diamonds;
    for (i = 3 - suit_count_diamonds; i > 0 && suit_count_spades > 0; i--, suit_count_spades--) {
      total_bid++;
    }
  }

  return total_bid;
}



