// Title Module
// Copyright Kwame Alexander
// July 30, 2003
// Don't copy
#include <stdlib.h>
#include <time.h>
#include "title100.h"

static void create_blue_palette (void);
static void create_blue_palette2 (void);
static void calculate_effect (BITMAP *working, BITMAP *current);
static void calculate_effect_left (BITMAP *working, BITMAP *current);
static void calculate_effect_right (BITMAP *working, BITMAP *current);
static void calculate_effect_up (BITMAP *working, BITMAP *current, int min_bright);
static void calculate_effect_down (BITMAP *working, BITMAP *current);
static void silhouette (int x, int y, BITMAP *src, BITMAP *dest, unsigned char colour);
static void random_sources (BITMAP *current);
static int quick_fade (void);
static void Logo (void);
static void About_DarkEdge (char text[52][45]);
static void Instructions (char text[13][40]);
static void Story (char text[26][45]);
static void Credits (char text[65][45], int sound1, int sound2);
static void Picture_Rotation (void);

extern int counter;
/*
int main (void)
{
    allegro_init ();
    install_timer ();
    Input_Initialize ();
    Sound_Initialize ();

    srand (time(0));
    LOCK_VARIABLE(counter);
    LOCK_FUNCTION(increment_counter);
    install_int (increment_counter, 1);
    install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, ".");

    set_gfx_mode (GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0);
    clear_to_color (screen, 0);
    text_mode (-1); // transparent
///////////////////////////////////////////////////////////////////
    Title_Initialize ();

    return (0);
}
END_OF_MAIN()
*/

static void
create_blue_palette (void)
{
     int i;
     RGB pal[256];

     // Black to blue
     for (i = 0; i < 64; i++) {
         pal[i].r = 0;
         pal[i].g = 0;
         pal[i].b = i;
     }
     // Blue to cyan
     for (i = 64; i < 128; i++) {
         pal[i].r = 0;
         pal[i].g = i - 64;
         pal[i].b = 63;
     }
     // Cyan to white
     for (i = 128; i < 192; i++) {
         pal[i].r = i - 128;
         pal[i].g = 63;
         pal[i].b = 63;
     }

     for (i = 192; i < 256; i++) {
         pal[i].r = 0;
         pal[i].g = 0;
         pal[i].b = 0;
     }

     set_palette (pal);
}

static void
create_blue_palette2 (void)
{
     int i;
     RGB pal[256];

     // Cyan to white
     for (i = 0; i < 32; i++) {
         pal[i].r = 0;
         pal[i].g = 0;
         pal[i].b = i * 2;

         pal[i + 64].r = 0;
         pal[i + 64].g = i * 2;
         pal[i + 64].b = 64;
     }

     pal[0].r = 0;
     pal[0].g = 0;
     pal[0].b = 0;

     // Red
     for (i = 96; i < 96 + 8; i++) {
         pal[i].r = 63 - (i - 96) * 8;
         pal[i].g = 0;
         pal[i].b = 0;
     }

     // Black
     for (i = 104; i < 182; i++) {
         pal[i].r = 0;
         pal[i].g = 0;
         pal[i].b = 0;
     }

     // Yellow
     for (i = 182; i < 192; i++) {
         pal[i].r = 23 + (i - 182) * 4;
         pal[i].g = 23 + (i - 182) * 4;
         pal[i].b = 0;

         if (pal[i].r > 63) {
            pal[i].r = 63;
            pal[i].g = 63;
         }
     }

     // Gray
     for (i = 192; i < 256; i++) {
         pal[i].r = i - 192;
         pal[i].g = i - 192;
         pal[i].b = i - 192;
     }

     pal[255].r = 63;
     pal[255].g = 0;
     pal[255].b = 0;

     set_palette (pal);
}

static void
calculate_effect (BITMAP *working, BITMAP *current)
{
       int row, col, avg, width, height, i;
       unsigned char *temp;

       // Alias for convenience
       width = current->w;
       height = current->h;

       // Black out border
       hline (current, 0, 0, width - 1, MIN_BRIGHT);
       hline (current, height - 1, 0, width - 1, MIN_BRIGHT);
       vline (current, 0, 0, height - 1, MIN_BRIGHT);
       vline (current, width - 1, 0, height - 1, MIN_BRIGHT);

       for (row = 1; row < height - 1; row++) {
           for (col = 1; col < width - 1; col++) {
               avg = (current->line[row][col - 1] +
                      current->line[row][col + 1] +
                      current->line[row - 1][col - 1] +
                      current->line[row - 1][col] +
                      current->line[row - 1][col + 1] +
                      current->line[row + 1][col - 1] +
                      current->line[row + 1][col] +
                      current->line[row + 1][col + 1]) / 8;

               working->line[row][col] = (unsigned char)avg;
           }
       }

       blit (working, current, 0, 0, 0, 0, width, height);
}

static void // fade left
calculate_effect_left (BITMAP *working, BITMAP *current)
{
       int i, row, col, avg, width, height;
       unsigned char *temp;

       width = current->w;
       height = current->h;

       // Black out border
       hline (current, 0, 0, width - 1, MIN_BRIGHT);
       hline (current, height - 1, 0, width - 1, MIN_BRIGHT);
       vline (current, 0, 0, height - 1, MIN_BRIGHT);
       vline (current, width - 1, 0, height - 1, MIN_BRIGHT);

       for (row = 1; row < height - 1; row++) {
           for (col = 1; col < width - 1; col++) {
               avg = (//current->line[row][col - 1] +
                      current->line[row][col + 1] +
                      //current->line[row - 1][col - 1] +
                      current->line[row - 1][col] +
                      current->line[row - 1][col + 1] +
                      //current->line[row + 1][col - 1] +
                      current->line[row + 1][col] +
                      current->line[row + 1][col + 1]) / 5;

               working->line[row][col] = avg;
           }
       }

       blit (working, current, 0, 0, 0, 0, width, height);

} // end calculate_effect_left

static void // fade right
calculate_effect_right (BITMAP *working, BITMAP *current)
{
       int i, row, col, avg, width, height;
       unsigned char *temp;

       width = current->w;
       height = current->h;

       // Black out border
       hline (current, 0, 0, width - 1, MIN_BRIGHT);
       hline (current, height - 1, 0, width - 1, MIN_BRIGHT);
       vline (current, 0, 0, height - 1, MIN_BRIGHT);
       vline (current, width - 1, 0, height - 1, MIN_BRIGHT);

       for (row = 1; row < height - 1; row++) {
           for (col = 1; col < width - 1; col++) {
               avg = (current->line[row][col - 1] +
                      //current->line[row][col + 1] +
                      current->line[row - 1][col - 1] +
                      current->line[row - 1][col] +
                      //current->line[row - 1][col + 1] +
                      current->line[row + 1][col - 1] +
                      current->line[row + 1][col]
                      //current->line[row + 1][col + 1]
                      ) / 5;

               working->line[row][col] = (unsigned char)avg;
           }
       }

       blit (working, current, 0, 0, 0, 0, width, height);

} // end calculate_effect_right

static void // fade up
calculate_effect_up (BITMAP *working, BITMAP *current, int min_bright)
{
       int i, row, col, avg, width, height;
       unsigned char *temp;

       width = current->w;
       height = current->h;

       // Black out border
       hline (current, 0, 0, width - 1, min_bright);
       hline (current, height - 1, 0, width - 1, min_bright);
       vline (current, 0, 0, height - 1, min_bright);
       vline (current, width - 1, 0, height - 1, min_bright);

       for (row = 1; row < height - 1; row++) {
           for (col = 1; col < width - 1; col++) {
               avg = (current->line[row][col - 1] +
                      current->line[row][col + 1] +
                      //current->line[row - 1][col - 1] +
                      //current->line[row - 1][col] +
                      //current->line[row - 1][col + 1] +
                      current->line[row + 1][col - 1] +
                      current->line[row + 1][col] +
                      current->line[row + 1][col + 1]
                      ) / 5;

               if (avg < min_bright) {
                  avg = min_bright;
               }
               working->line[row][col] = (unsigned char)avg;
           }
       }

       blit (working, current, 0, 0, 0, 0, width, height);

} // end calculate_effect_up

static void // fade down
calculate_effect_down (BITMAP *working, BITMAP *current)
{
       int i, row, col, avg, width, height;
       unsigned char *temp;

       width = current->w;
       height = current->h;

       // Black out border
       hline (current, 0, 0, width - 1, MIN_BRIGHT);
       hline (current, height - 1, 0, width - 1, MIN_BRIGHT);
       vline (current, 0, 0, height - 1, MIN_BRIGHT);
       vline (current, width - 1, 0, height - 1, MIN_BRIGHT);

       for (row = 1; row < height - 1; row++) {
           for (col = 1; col < width - 1; col++) {
               avg = (current->line[row][col - 1] +
                      current->line[row][col + 1] +
                      current->line[row - 1][col - 1] +
                      current->line[row - 1][col] +
                      current->line[row - 1][col + 1]
                      //current->line[row + 1][col - 1] +
                      //current->line[row + 1][col] +
                      //current->line[row + 1][col + 1]
                      ) / 5;

               working->line[row][col] = (unsigned char)avg;
           }
       }

       blit (working, current, 0, 0, 0, 0, width, height);

} // end calculate_effect_down

static void
silhouette (int x, int y, BITMAP *src, BITMAP *dest, unsigned char colour)
{
     int row, col;

     for (row = 0; row < src->h; row++) {
         for (col = 0; col < src->w; col++) {
             if (src->line[row][col] > 0) {
                dest->line[y + row][x + col] = colour;
             }
         }
     }
}


static void
random_sources (BITMAP *current)
{
     int rand_x, rand_y;

     rand_x = (rand () % (current->w - 3)) + 1;
     rand_y = (rand () % (current->h - 3)) + 1;

     current->line[rand_y - 1][rand_x - 1] =
     current->line[rand_y - 1][rand_x] =
     current->line[rand_y - 1][rand_x + 1] =
     current->line[rand_y][rand_x - 1] =
     current->line[rand_y][rand_x] =
     current->line[rand_y][rand_x + 1] =
     current->line[rand_y + 1][rand_x - 1] =
     current->line[rand_y + 1][rand_x] =
     current->line[rand_y + 1][rand_x + 1] = MAX_BRIGHT;
}

static int
quick_fade (void)
{
     int i, done = 1;
     RGB pal[256];

     get_palette (pal);

     for (i = 0; i < 256; i++) {
         if (pal[i].r > 0) {
            done = 0;
            if (pal[i].r += 4 < 0) {
               pal[i].r = 0;
            }
         }
         if (pal[i].g > 0) {
            done = 0;
            if (pal[i].g += 4 < 0) {
               pal[i].g = 0;
            }
         }
         if (pal[i].b > 0) {
            done = 0;
            if (pal[i].b += 4 < 0) {
               pal[i].b = 0;
            }
         }
     }

     return (done);
}

static void
Logo (void)
{
    int i, frame = 0, flag = 0, time_keeper;
    char temp[10];
    BITMAP *working, *current, *logo;
    RGB temp_pal[256];

    logo = load_bitmap ("effect/logo.pcx", temp_pal);
    working = create_bitmap (logo->w, logo->h);
    current = create_bitmap (logo->w, logo->h);
    clear_to_color (working, MIN_BRIGHT);
    clear_to_color (current, MIN_BRIGHT);
    create_blue_palette ();

    // loop
    while (!Input_Any_Key_Pressed () && flag < 50) {

          time_keeper = counter;
          blit (current, screen, 0, 0, 50, 50, current->w, current->h);

          if (flag < 30) {
             random_sources (current);
          }

          silhouette (0, 0, logo, current, frame);

          if (frame < 192 && !flag) {
             frame += 4;
          }
          else {
             frame = 0;
             ++flag;
          }

          calculate_effect (working, current);
          while (counter < time_keeper + 50);
    }
    clear_to_color (screen, 0);
    Input_Unpress_All ();
    time_keeper = counter;
    while (counter < time_keeper + 200);

    destroy_bitmap (logo);
    destroy_bitmap (current);
    destroy_bitmap (working);
}

static void
Instructions (char text[13][40])
{
     int i, colour = 255;

     clear_to_color (screen, 0);
     for (i = 0; i < 13; i++) {
         textout (screen, font, text[i], 25, 20 + i * 8, colour);
         if (colour == 255) {
            colour = 254;
         }
         else {
            colour = 255;
         }
     }

     Input_Unpress_All ();
     while (!Input_Any_Key_Pressed ());
}

static void
About_DarkEdge (char text[52][45])
{
     int i, row = 180, time_keeper, colour;
     //char temp[10];

     clear_to_color (screen, 0);
     text_mode(0);

     while (!Input_Pressed_Scan (KEY_SPACE) &&
            !Input_Pressed_Scan (KEY_ENTER) &&
            !Input_Pressed_Scan (KEY_ENTER_PAD) &&
            !Input_Pressed_Scan (KEY_ESC) && row > -428)
     {
           time_keeper = counter;
           --row;
           if (Input_Pressed_Down ()) {
              row -= 7;
           }

           vsync ();
           for (i = 0; i < 52; i++) {
               if ((20 + i * 8) + row < 100) {
                  colour = 11 + (20 + i * 8 + row) / 5;
               }
               else {
                  colour = 11 + (200 - (20 + i * 8 + row)) / 5;
               }
               if (colour > 31) {
                  colour = 31;
               }
               if (20 + i * 8 + row > -8 && 20 + i * 8 + row < 200) {
                  textout (screen, font, text[i], 0, 20 + i * 8 + row, colour);
               }
           }
           //sprintf (temp, "%d    ", row);
           //textout (screen, font, temp, 0, 8, 31);

           while (counter < time_keeper + 100);
     }

     if (row <= -428) {
        Picture_Rotation ();
     }
     text_mode (-1);
}

static void
Story (char text[26][45])
{
     int i, row = 180, time_keeper, colour;
     //char temp[10];

     clear_to_color (screen, 0);
     text_mode(0);

     while (!Input_Pressed_Scan (KEY_SPACE) &&
            !Input_Pressed_Scan (KEY_ENTER) &&
            !Input_Pressed_Scan (KEY_ENTER_PAD) &&
            !Input_Pressed_Scan (KEY_ESC) && row > -216)
     {
           time_keeper = counter;
           --row;
           if (Input_Pressed_Down ()) {
               row -= 7;
           }

           for (i = 0; i < 26; i++) {
               if ((20 + i * 8) + row < 100) {
                  colour = 182 + (20 + i * 8 + row) / 10;
               }
               else {
                  colour = 182 + (200 - (20 + i * 8 + row)) / 10;
               }
               if (colour > 191) {
                colour = 191;
               }

               if (20 + i * 8 + row > -8 && 20 + i * 8 + row < 200) {
                  textout (screen, font, text[i], 0, 20 + i * 8 + row, colour);
               }
           }
           //sprintf (temp, "%d    ", row);
           //textout (screen, font, temp, 0, 8, 31);

           while (counter < time_keeper + 100);
     }
     text_mode (-1);
}

static void
Credits (char text[65][45], int sound1, int sound2)
{
     int i, row = 180, time_keeper, colour;
     //char temp[10];

     clear_to_color (screen, 0);
     text_mode(0);

     while (!Input_Pressed_Scan (KEY_SPACE) &&
            !Input_Pressed_Scan (KEY_ENTER) &&
            !Input_Pressed_Scan (KEY_ENTER_PAD) &&
            !Input_Pressed_Scan (KEY_ESC) && row > -524)
     {
           time_keeper = counter;
           --row;
           if (Input_Pressed_Down ()) {
              row -= 7;
           }

           for (i = 0; i < 65; i++) {
               if ((20 + i * 8) + row < 100) {
                  colour = 200 + (20 + i * 8 + row) / 3;
               }
               else {
                  colour = 200 + (200 - (20 + i * 8 + row)) / 3;
               }
               if (20 + i * 8 + row > -8 && 20 + i * 8 + row < 200) {
                  textout (screen, font, text[i], 0, 20 + i * 8 + row, colour);
               }
           }
           //sprintf (temp, "%d    ", row);
           //textout (screen, font, temp, 0, 8, 31);
           if (row == -40) {
              Sound_Play (sound1);
           }
           else if (row == -240) {
              Sound_Play (sound2);
           }
           while (counter < time_keeper + 100);
     }
     text_mode (-1);
}

static void
Picture_Rotation (void)
{
   int done, x, y, time_keeper;
   char filename[50], current;
   BITMAP *Kwame;
   RGB pal[256];

   strcpy (filename, "effect/Kwame .pcx");

   fade_out (1);
   current = (char)(rand () % 9);
   done = 0;
   Input_Unpress_All ();

   while (!Input_Pressed_Scan (KEY_SPACE) &&
          !Input_Pressed_Scan (KEY_ENTER) &&
          !Input_Pressed_Scan (KEY_ENTER_PAD) &&
          !Input_Pressed_Scan (KEY_ESC) && !done)
   {
          filename[12] = '0' + current;
          Kwame = load_bitmap (filename, pal);
          x = (320 - Kwame->w * 5 / 4) / 2;
          y = (200 - Kwame->h) / 2;
          clear_to_color (screen, 0);
          stretch_blit (Kwame, screen, 0, 0, Kwame->w, Kwame->h, x, y,
                        Kwame->w * 5 / 4, Kwame->h);
          destroy_bitmap (Kwame);
          fade_in (pal, 1);
          time_keeper = counter;

          // Actively wait five seconds
          while (counter < time_keeper + 5000 && !done) {
                if (Input_Any_Key_Pressed ()) {
                   done = 1;
                   Input_Unpress_All ();
                }
          }

          fade_out (1);
          ++current;
          if (current == 9) {
             current = 0;
          }
   }
   clear_to_color (screen, 0);
   create_blue_palette2 ();
}

void
Title_Initialize (void)
{
    int i, j, frame = 0, time_keeper, selection = 0, pad_flag;
    int testimony, fight, start_game = 0;
    char instructions[13][40], story[26][45], credits[65][45], about[51][45];
    FILE *fp;
    BITMAP *working[3], *current[3], *ruprect[3], *grog[3], *options, *title;
    BITMAP *choice;
    RGB temp_pal[256];
    MIDI *rising;

    if (rand () % 2) {
       rising = load_midi ("effect/title1.mid");
    }
    else {
       rising = load_midi ("effect/title2.mid");
    }
    set_volume (-1, 192);
    play_midi (rising, TRUE);
    time_keeper = counter;
    while (counter < time_keeper + 1000);

    Logo ();
    working[0] = create_bitmap (68, 73);
    current[0] = create_bitmap (68, 73);
    working[1] = create_bitmap (68, 73);
    current[1] = create_bitmap (68, 73);
    working[2] = create_bitmap (200, 70);
    current[2] = create_bitmap (200, 70);
    clear_to_color (working[0], MIN_BRIGHT);
    clear_to_color (working[1], MIN_BRIGHT);
    clear_to_color (working[2], MIN_BRIGHT2);
    clear_to_color (current[0], MIN_BRIGHT);
    clear_to_color (current[1], MIN_BRIGHT);
    clear_to_color (current[2], MIN_BRIGHT2);

    ruprect[0] = load_bitmap ("effect/rup_wlkl.pcx", temp_pal);
    ruprect[1] = load_bitmap ("effect/rupwlkl2.pcx", temp_pal);
    ruprect[2] = load_bitmap ("effect/rupwlkl3.pcx", temp_pal);
    grog[0] = load_bitmap ("effect/grg_wlkl.pcx", temp_pal);
    grog[1] = load_bitmap ("effect/grgwlkl2.pcx", temp_pal);
    grog[2] = load_bitmap ("effect/grgwlkl3.pcx", temp_pal);
    options = load_bitmap ("effect/options.pcx", temp_pal);
    choice = load_bitmap ("effect/choice.pcx", temp_pal);
    title = load_bitmap ("effect/title.pcx", temp_pal);

    // Load instructions
    fp = fopen ("effect/instruct.txt", "rt");
    for (i = 0; i < 13; i++) {
        fgets (instructions[i], 36, fp);
        for (j = 0; j < 40; j++) {
            if (instructions[i][j] == '\n') {
               instructions[i][j] = ' ';
            }
         }
    }
    fclose (fp);

    // Load story
    fp = fopen ("effect/story.txt", "rt");
    for (i = 0; i < 26; i++) {
        fgets (story[i], 45, fp);
        pad_flag = 0;
        for (j = 0; j < 45; j++) {
            if (story[i][j] == '\n') {
               pad_flag = 1;
            }
            if (pad_flag) {
               story[i][j] = ' ';
            }
        }
        story[i][44] = '\0';
    }
    fclose (fp);

    // Load credits
    testimony = Sound_Load ("effect/testimon.wav");
    fight = Sound_Load ("effect/fight.wav");
    Sound_Set_Volume (255);

    fp = fopen ("effect/credits.txt", "rt");
    for (i = 0; i < 65; i++) {
        fgets (credits[i], 45, fp);
        pad_flag = 0;
        for (j = 0; j < 45; j++) {
            if (credits[i][j] == '\n') {
               pad_flag = 1;
            }
            if (pad_flag) {
               credits[i][j] = ' ';
            }
        }
        credits[i][44] = '\0';
    }
    fclose (fp);

    // Load About DarkEdge
    fp = fopen ("effect/about.txt", "rt");
    for (i = 0; i < 52; i++) {
        //about[i] = (char *)malloc (45 * sizeof (char) + 1);
        fgets (about[i], 45, fp);
        pad_flag = 0;
        for (j = 0; j < 45; j++) {
            if (about[i][j] == '\n') {
               pad_flag = 1;
            }
            if (pad_flag) {
               about[i][j] = ' ';
            }
        }
        about[i][44] = '\0';
    }
    fclose (fp);

    create_blue_palette2 ();

    // loop
    while (!Input_Pressed_Scan (KEY_ESC)) {
          time_keeper = counter;

         // Change effect
         if (frame % 200 < 40) {
             calculate_effect (working[0], current[0]);
             calculate_effect (working[1], current[1]);
         }
         else if (frame % 200 < 80) {
             calculate_effect_left (working[0], current[0]);
             calculate_effect_left (working[1], current[1]);
         }
         else if (frame % 200 < 120) {
             calculate_effect_up (working[0], current[0], MIN_BRIGHT);
             calculate_effect_up (working[1], current[1], MIN_BRIGHT);
         }
         else if (frame % 200 < 160) {
             calculate_effect_right (working[0], current[0]);
             calculate_effect_right (working[1], current[1]);
         }
         else {
             calculate_effect_down (working[0], current[0]);
             calculate_effect_down (working[1], current[1]);
         }

         if (frame < 30) {
            calculate_effect_up (working[2], current[2], MIN_BRIGHT2);
         }

         silhouette (0, 0, title, current[2], 255);
         draw_sprite (screen, options, 110, 110);

         // Menu
         if (Input_Pressed_Up ()) {
            silhouette (110, 115 + selection * 10, choice, screen, 104);
            --selection;
            if (selection < 0) {
               selection = 4;
            }
         }
         if (Input_Pressed_Down ()) {
            silhouette (110, 115 + selection * 10, choice, screen, 104);
            ++selection;
            if (selection > 4) {
               selection = 0;
            }
         }
         if (Input_Pressed_Scan (KEY_SPACE) ||
             Input_Pressed_Scan (KEY_ENTER) ||
             Input_Pressed_Scan (KEY_ENTER_PAD))
         {
             i = counter;
             while (counter < i + 200);

             switch (selection)
             {
             case 0: // Start game
                  start_game = 1;
                  break;
             case 1: // Instructions
                  Instructions (instructions);
                  break;
             case 2: // About DarkEdge Games
                  About_DarkEdge (about);
                  break;
             case 3: // Credits!
                  Credits (credits, testimony, fight);
                  break;
             case 4: // Story
                  Story (story);
                  break;
             default:
                  textout (screen, font, "Menu error!", 100, 0, 255);
                  while (counter < time_keeper + 1000);
                  while (!Input_Any_Key_Pressed ());
                  break;
            }

            // Exit loop and start game
            if (start_game) {
               break;
            }

            i = counter;
            while (counter < i + 200);
            clear_to_color (screen, 0);
         }
         draw_sprite (screen, choice, 110, 115 + selection * 10);
         Input_Unpress_All ();

         blit (current[0], screen, 0, 0, 20, 100, current[0]->w, current[0]->h);
         blit (current[1], screen, 0, 0, 220, 100, current[1]->w, current[1]->h);
         blit (current[2], screen, 0, 0, 60, 30, current[2]->w, current[2]->h);

         // Fix title
         if (frame) {
            putpixel (screen, 112, 73, 254);
            putpixel (screen, 123, 73, 254);
         }
         else {
            putpixel (screen, 112, 73, 192);
            putpixel (screen, 123, 73, 192);
         }

         ++frame;

          switch (frame % 8)
          {
          case 0:
               draw_sprite (current[0], ruprect[0], 20, 20);
               draw_sprite (current[1], grog[1], 10, 15);
               break;
          case 2:
          case 6:
               draw_sprite (current[0], ruprect[1], 20, 13);
               draw_sprite (current[1], grog[0], 21, 15);
               break;
          case 4:
               draw_sprite (current[0], ruprect[2], 20, 20);
               draw_sprite (current[1], grog[2], 10, 15);
               break;
          }

          while (counter < time_keeper + 100);
    }
    fade_out (2);
    clear_to_color (screen, 0);

    Sound_Unload (fight);
    Sound_Unload (testimony);
    destroy_midi (rising);
    destroy_bitmap (title);
    destroy_bitmap (choice);
    destroy_bitmap (options);
    destroy_bitmap (grog[0]);
    destroy_bitmap (grog[1]);
    destroy_bitmap (grog[2]);
    destroy_bitmap (ruprect[0]);
    destroy_bitmap (ruprect[1]);
    destroy_bitmap (ruprect[2]);
    destroy_bitmap (current[0]);
    destroy_bitmap (current[1]);
    destroy_bitmap (current[2]);
    destroy_bitmap (working[0]);
    destroy_bitmap (working[1]);
    destroy_bitmap (working[2]);
}
