// Sound module
// June 18, 2002
// Copyright Kwame Alexander
// I will kill you if you copy this

#include "sound100.h"

static int loaded[MAX_SOUND], installed = 0;
static SAMPLE *effect[MAX_SOUND];

void
Sound_Initialize (void)
{
    int i;

    installed = 1;
    install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, ".");

    for (i = 0; i < MAX_SOUND; i++) {

        loaded[i] = 0;
    }
}

void
Sound_Shutdown (void)
{

    int i;

    if (installed) {
        for (i = 0; i < MAX_SOUND; i++) {
            if (loaded[i]) {
               stop_sample (effect[i]);
               destroy_sample (effect[i]);
            }
        }
    }
//    remove_sound ();

}

void
Sound_Play (int sound_num)
{
    if (sound_num >= 0 && installed) {
       if (loaded[sound_num]) {
          play_sample (effect[sound_num], 255, 128, 1000, FALSE);
       }
    }
}

int
Sound_Load (char *filename)
{
    int i = -62;

    if (installed == 1) {
       for (i = 0; i < MAX_SOUND; i++) {
           if (!loaded[i]) {
              break;
           }
       }

    // No free slots
       if (i == MAX_SOUND) {
          return (-1);
       }

       effect[i] = load_sample (filename);
       loaded[i] = 1;
    }
    return (i);
}

void
Sound_Stop (int sound_num)
{
    if (sound_num >= 0 && installed) {
       if (loaded[sound_num]) {
          stop_sample (effect[sound_num]);
       }
    }
}

void
Sound_Unload (int sound_num)
{
    if (sound_num >= 0 && installed) {
       if (loaded[sound_num]) {

            stop_sample (effect[sound_num]);
            destroy_sample (effect[sound_num]);
            loaded[sound_num] = 0;
       }
    }
}

void
Sound_Set_Volume (int volume)
{
    set_volume (volume, -1);
}
/*
void Sound_Initialize (void) {}
void Sound_Shutdown (void) {}
void Sound_Play (int sound_num) {}
int Sound_Load (char *filename) {}
void Sound_Stop (int sound_num) {}
void Sound_Unload (int sound_num) {}*/
