// Map module header file v 3.00
// Copyright Kwame Alexander May 29, 1999
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and one
// severe beating.

#ifndef MAP_MODULE
#define MAP_MODULE

#include <stdio.h>
#include "graph100.h"
#include "actor100.h"
#include "trigr100.h"
#include "music100.h"
#include "camera.h"

#define MAX_TILES           50
#define MAX_ENEMY_PATTERNS  30
#define MAX_SPECIAL_COORDS  40
#define MAP_NAME_LENGTH     30

#define MAX_TEXTBLOCKS      10

// Structures
typedef struct
{
    int x;
    int y;
} pos;

typedef struct
{
	int x;
	int y;
	int code;
    char filename[13];
} special_pos;

typedef struct
{
	int tile_graphic[MAX_TILES];
	int battle_background;
	unsigned int tiles_across;
	unsigned int tiles_down;
    unsigned int width;
    unsigned int height;
	int solid_tile[MAX_TILES];
	int num_enemy_patterns;
	int enemy_pattern[MAX_ENEMY_PATTERNS][4];
	int fight_chance;
	int run_chance;
	int num_tiles;
	int num_solid_tiles;
	int special_coords;
	special_pos special_coord[MAX_SPECIAL_COORDS];
	pos start;
	int *background;
	int *foreground;
	int music;
	char name[MAP_NAME_LENGTH];
} area, *area_ptr;

typedef struct
{
    int num_lines;
    char **text;
} TEXTBLOCK;

// Prototypes
void Map_Initialize (void);
void Map_Shutdown (void);
int Map_Solid_Tile (int x, int y);
int Map_Get_Tiles_Down (void);
int Map_Get_Tiles_Across (void);
void Map_Load (char *filename, int starting_point);
void Map_Unload (void);
void Map_Render_Layer (int layer);
char *Map_Get_Name (void);
void Map_Clip (void);
int Map_Get_Tile_Width (void);
int Map_Get_Tile_Height (void);
int Map_Get_Width (void);
int Map_Get_Height (void);

void Map_Render_Back (void);//remove
char **Map_Get_Text (int text_num);
void Map_Display_Text (int text_num, int position);
#endif
