// Main module file v 1.00
// Copyright Kwame Alexander February 28, 2001
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and a
// severe beating.
#include <allegro.h>
#include "graph100.h"
#include "input100.h"
#include "camera.h"
#include "map100.h"
#include "actor100.h"
#include "cinma100.h"
#include "trigr100.h"
#include "music100.h"
#include "sound100.h"

volatile int counter = 0;
int game_over = 0, switch_sound;

void
increment_counter ()
{
    ++counter;
}
END_OF_FUNCTION(increment_counter);

int main (void)
{
    int ranzou, i, time_keeper, starting_point, pal_pic;
    char first_level[30], snd_mus[10];
    FILE *fp;

    fp = fopen ("init", "rt");
    fscanf (fp, "%s", first_level);
    fscanf (fp, "%d", &starting_point);
    fscanf (fp, "%s", snd_mus);
    fclose (fp);

    allegro_init ();
    install_timer ();
    LOCK_VARIABLE(counter);
    LOCK_FUNCTION(increment_counter);
    install_int (increment_counter, 1);

    Input_Initialize ();
    Graphics_Initialize ();
    Camera_Initialize ();
    Actor_Initialize ();
    Map_Initialize ();
    Cinema_Initialize ();
    Trigger_Initialize ();

    // if sound/music enabled, then initialize
    if (snd_mus[0] != 'n' && snd_mus[0] != 'N') {
       Music_Initialize ();
       Sound_Initialize ();
       switch_sound = Sound_Load ("sound/switch.wav");
    }
    Title_Initialize ();

    pal_pic = Graphics_Load_Pic ("graphics/palette.pcx", 1); // Palette

    Map_Load (first_level, starting_point);

    while (!Input_Pressed_Scan (KEY_ESC) && !game_over) {
        time_keeper = counter;

        // For switching players
        if (Input_Pressed_Scan (KEY_ENTER) ||
            Input_Pressed_Scan (KEY_ENTER_PAD))
        {
           if (Actor_Switch (switch_sound)) {
              while (counter < time_keeper + 500);
           }
        }
        Actor_Update_All ();
        Map_Render_Back ();
        Actor_Display_All ();
        Graphics_Update_Particles ();
        Trigger_Test ();
        Map_Clip ();
        Graphics_Draw_Screen ();
       while (counter < time_keeper + 50);
    }

    fade_out (1);

    Graphics_Unload_Pic (pal_pic);
    Sound_Unload (switch_sound);

    Cinema_Unload ();

    Map_Unload ();

//    Sound_Shutdown ();
    Music_Shutdown ();
    Trigger_Shutdown ();
    Cinema_Shutdown ();
    Actor_Shutdown ();
    Graphics_Shutdown ();
    Input_Shutdown ();

    return (0);
}
END_OF_MAIN()
