#include "graph100.h"
#include <stdio.h>

// Global
static int num_pics = 0;
static char used_pic[GRAPHICS_MAX_PICS];
static BITMAP *double_buffer;
static RLE_SPRITE *pic[GRAPHICS_MAX_PICS];
static EMITTER emitter[MAX_EMITTERS];
RGB current_pal[256];
extern volatile int counter;

/******************************************************************/
/*	Local Functions						  */
/******************************************************************/

/******************************************************************/
/*	Public Functions					  */
/******************************************************************/

void
Graphics_Initialize (void)
{
        int i;

        set_gfx_mode (GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0);
        clear_to_color (screen, 0);
        text_mode (-1); // transparent

        for (i = 0; i < GRAPHICS_MAX_PICS; i++) {
            used_pic[i] = 0;
        }

    // Set up double buffer
    double_buffer = create_bitmap (SCREEN_W, SCREEN_H);

    // Seed random generator
    srand (time(0));
} // End Graphics_Initialize

void
Graphics_Shutdown (void)
{
	int i;

	for (i = 0; i < num_pics; i++) {
		Graphics_Unload_Pic (i);
    }

    set_gfx_mode (GFX_TEXT, 80, 24, 0, 0);
    destroy_bitmap (double_buffer);
} // End Graphics_Shutdown

int
Graphics_Load_Pic (char *filename, int load_palette)
{
    int pic_num;
    FILE *fp;
    BITMAP *temp_bitmap;
    RGB temp_pal[256];

    for (pic_num = 0; pic_num < GRAPHICS_MAX_PICS; pic_num++) {
        if (!used_pic[pic_num]) {

            ++num_pics;
            used_pic[pic_num] = 1;
            break;
        }
    }
    if (pic_num == GRAPHICS_MAX_PICS) {
       // Ran out of space!
       // Do error stuff

       fp = fopen ("error.txt", "at");
       fprintf (fp, "Graphics overload!");
       fclose (fp);
       return (-1);
    }

    // Actually load file
    //clear_to_color (&pic[i], 0);
    if (load_palette) {
       temp_bitmap  = load_bitmap (filename, current_pal);
       set_palette (current_pal);
    }
    else {
       temp_bitmap  = load_bitmap (filename, temp_pal);
    }

    pic[pic_num] = get_rle_sprite (temp_bitmap);
    destroy_bitmap (temp_bitmap);




    return (pic_num);
} // end Graphics_Load_Pic

// Add error checking
void
Graphics_Unload_Pic (int pic_num)
{
    if (pic_num >= 0) {
       if (used_pic[pic_num]) {
          destroy_rle_sprite (pic[pic_num]);
          used_pic[pic_num] = 0;
          --num_pics;
       }
    }
} // end Graphics_Unload_Pic

void
Graphics_Draw_Pic (int x, int y, int pic_num)
{
        draw_rle_sprite (double_buffer, pic[pic_num], x, y);

} // end Graphics_Draw_Pic

/*void
Graphics_Set_Mode (int vmode)
{
	asm mov AH, 0;
	asm mov AL, BYTE PTR vmode;
	asm int 10h;
} // end set_mode*/

void
Graphics_Draw_Box (int left, int top, int right, int bottom, int colour)
{
        rectfill (double_buffer, left, top, right, bottom, colour);
} // End Graphics_Draw_Box

void
Graphics_Draw_Box2 (int left, int top, int width, int height, int colour)
{
        rectfill (double_buffer, left, top, left + width, top + height,
                  colour);
} // End Graphics_Draw_Box2

void
Graphics_Draw_Screen (void)
{
    vsync ();
    blit (double_buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

int
Graphics_Get_Height (int pic_num)
{
    return (pic[pic_num]->h);
} // End Graphics_Get_Height

void
Graphics_Draw_Pixel (int x, int y, int colour)
{
    putpixel (double_buffer, x, y, colour);
}

void
Graphics_Draw_Box_Outline (int left, int top, int right, int bottom, int colour)
{
        rect (double_buffer, left, top, right, bottom, colour);
} // End Graphics_Draw_Box

void
Graphics_Clean_Pic (int fore_col, int back_col, char *old_filename,
                    char *new_filename)
{
    int x, y;

    BITMAP *bmp;
    RGB *pal;

    bmp = load_bitmap (old_filename, pal);

    for (x = 0; x < bmp->w; x++) {
        for (y = 0; y < bmp->h; y++) {
            if (bmp->line[y][x] != fore_col) {

                bmp->line[y][x] = back_col;
            }
        }
    }

    save_bitmap (new_filename, bmp, pal);

} // Graphics_Clean_Pic

void
Graphics_Draw_Text (int x, int y, int colour, unsigned char *string)
{

    textout (double_buffer, font, string, x, y, colour);
} // Graphics_Draw_Text

void
Graphics_Message_Box (int x, int y, int box_colour, int text_colour,
                      char **text, int num_lines)
{
    int max_length = 0, i, width, height;

    // Determine max length of text lines
    for (i = 0; i < num_lines; i++) {
        if (max_length < strlen (text[i])) {
           max_length = strlen (text[i]);
        }
    }

    // Draw der boxen
    width = 8 * (max_length + 2);
    height = 8 * (num_lines + 2);
    rectfill (double_buffer, x, y, x + width, y + height,
              box_colour);

    // Text o kaku
    for (i = 0; i < num_lines; i++) {
        Graphics_Draw_Text (x + 8, y + (i + 1) * 8, text_colour, text[i]);
    }
} // Graphics_Message_Box

void
Graphics_Standard_Message_Box (int x, int y, char **text, int num_lines)
{
    int max_length = 0, i, width, height;

    // Determine max length of text lines
    for (i = 0; i < num_lines; i++) {
        if (max_length < strlen (text[i])) {
           max_length = strlen (text[i]);
        }
    }

    // Draw der boxen
    width = 8 * (max_length + 2);
    height = 8 * (num_lines + 2);
//    rectfill (double_buffer, x, y, x + width, y + height,
//              40);
    for (i = 0; i < num_lines+2; i++) {
        rectfill (double_buffer, x, y + i * 8, x + width, y + (i + 1) * 8,
                  192 + i);
    }

    // Text o kaku
    for (i = 0; i < num_lines; i++) {
        Graphics_Draw_Text (x + 8, y + (i + 1) * 8, 31, text[i]);
    }

    // Border
    rect (double_buffer, x, y, x + width, y + height, 31);
} // end Graphics_Standard_Message_Box

void
Graphics_Emit_Particles (int x, int y, int x_vel, int y_vel, int colour)
{
    int i, j;

    for (i = 0; i < MAX_EMITTERS; i++) {

        if (!emitter[i].emitting) {
           break;
        }
    }

    if (i < MAX_EMITTERS) {

        emitter[i].emitting = 1;
        emitter[i].lifetime = EMITTER_LIFETIME;
        emitter[i].colour = colour;

        for (j = 0; j < NUM_PARTICLES; j++) {

            emitter[i].particle[j].x = x;
            emitter[i].particle[j].y = y;
            emitter[i].particle[j].x_vel = x_vel + rand () % 7 - 3;
            emitter[i].particle[j].y_vel = y_vel + rand () % 4;
        }
    }
} // End Graphics_Emit_Particles

void
Graphics_Update_Particles (void)
{
    int i, j;

    for (i = 0; i < MAX_EMITTERS; i++) {

        if (emitter[i].emitting) {

            for (j = 0; j < NUM_PARTICLES; j++) {

                emitter[i].particle[j].x += emitter[i].particle[j].x_vel;
                emitter[i].particle[j].y += emitter[i].particle[j].y_vel;
                emitter[i].particle[j].y_vel += 1; // gravity
                putpixel (double_buffer,
                          emitter[i].particle[j].x,
                          emitter[i].particle[j].y,
                          emitter[i].colour);
            }

            --emitter[i].lifetime;
            if (emitter[i].lifetime <= 0) {
               emitter[i].emitting = 0;
            }
        }
    }
} // End Graphics_Update_Particles

void
Graphics_Fade_Out (void)
{
   fade_out (2);
}

void
Graphics_Fade_In (void)
{
   fade_in (current_pal, 2);
}
