/* Cinema module v. 1.00 January 25, 2002 */
/* Copyright Kwame Alexander              */
/* Don't copy without permission or I     */
/* will hunt you down like the <insert    */
/* adjective> dog that you are.           */


#include "cinma100.h"

extern volatile int counter;

// Prototypes
static int Convert_Direction (char *dir);
static void Delay (int duration);
static void Text_Display (int position, int text_num);
static void Load_Performers (char *filename);
static void Render_Performers (void);
static void Insertion_Sort (int order[CINEMA_PERFORMERS][2]);

// Global variables
static int num_commands; // can I un-globalize this?
static int num_performers, num_text_blocks, loaded, num_sounds;
static int music[MAX_MUSIC], num_music, sound_list[CINEMA_NUM_SOUNDS];
static MOVIE_TEXT movie_text[15];
static MOVIE movie[CINEMA_LENGTH + 1];  // I don't know.
static PERFORMER performer[CINEMA_PERFORMERS];

void
Cinema_Initialize (void)
{
    int i, j;

    loaded = 0;
    num_sounds = 0;
    num_music = 0;

    for (i = 0; i < CINEMA_PERFORMERS; i++) {
        for (j = 0; j < 27; j++) {
            performer[i].frame[j] = -1;
        }
    }

    for (i = 0; i < MAX_MUSIC; i++) {
        music[i] = -1;
    }

    for (i = 0; i < CINEMA_NUM_SOUNDS; i++) {
        sound_list[i] = -1;
    }
} // end Cinema_Initialize

void
Cinema_Shutdown (void)
{
    if (loaded) {
       Cinema_Unload ();
    }
}

static int
Convert_Direction (char *dir)
{
    if (!strcasecmp (dir, "down") || !strcasecmp (dir, "d")) {
       return (CINEMA_DOWN);
    }

    if (!strcasecmp (dir, "left") || !strcasecmp (dir, "l")) {
       return (CINEMA_LEFT);
    }

    if (!strcasecmp (dir, "right") || !strcasecmp (dir, "r")) {
       return (CINEMA_RIGHT);
    }

//    if (!strcasecmp (dir, "up") || !strcasecmp (dir, "u")) {
       return (CINEMA_UP);
//    }
}

void
Cinema_Load (char *filename)
{
    int i = 0, arg[3], j, k;
    char command[20], s_arg[40];
    FILE *fp, *fp2;

    // Clean out old movie
    if (loaded) {
       Cinema_Unload ();
    }

    if ((fp = fopen (filename, "rt")) != NULL) {

        //while (command != "done") {
        while (strcmp (command, "done")) {

            fscanf (fp, "%s", command);

            if (!strcmp (command, "done")) {

                movie[i].command = CINEMA_DONE;
            }
            else if (!strcmp (command, "move")) {

                fscanf (fp, "%d", &arg[0]); // actor
                fscanf (fp, "%s", s_arg);  // direction
                fscanf (fp, "%d", &arg[1]); // amount
                fscanf (fp, "%d", &arg[2]); // speed

                movie[i].command = CINEMA_MOVE;
                movie[i].counter = arg[1] / arg[2];
                movie[i].argument[0] = arg[0]; // actor
                movie[i].argument[1] = Convert_Direction (s_arg); // direction
                movie[i].argument[2] = arg[2]; // speed
            }
            else if (!strcmp (command, "anim")) {

                fscanf (fp, "%d", &arg[0]); // actor
                fscanf (fp, "%d", &arg[1]); // anim
                fscanf (fp, "%d", &arg[2]); // length

                movie[i].command = CINEMA_ANIM;
                movie[i].counter = arg[2];
                movie[i].argument[0] = arg[0]; // actor
                movie[i].argument[1] = arg[1]; // anim
                //movie[i].argument[2] = arg[2]; not needed
            }
            else if (!strcmp (command, "fade") ||
                     !strcmp (command, "fade_out"))
            {
                movie[i].command = CINEMA_FADE;
                movie[i].counter = 1;
            }
            else if (!strcmp (command, "unfade") ||
                     !strcmp (command, "fade_in"))
            {
                movie[i].command = CINEMA_UNFADE;
                movie[i].counter = 1;
            }
            else if (!strcmp (command, "activate")) {

                fscanf (fp, "%d", &arg[0]); // actor

                movie[i].command = CINEMA_ACTIVATE;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];
            }
            else if (!strcmp (command, "deactivate")) {

                fscanf (fp, "%d", &arg[0]); // actor

                movie[i].command = CINEMA_DEACTIVATE;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];
            }
            else if (!strcmp (command, "place")) {

                fscanf (fp, "%d", &arg[0]); // actor
                fscanf (fp, "%d", &arg[1]); // x
                fscanf (fp, "%d", &arg[2]); // y

                movie[i].command = CINEMA_PLACE;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0]; // actor
                movie[i].argument[1] = arg[1]; // x
                movie[i].argument[2] = arg[2]; // y
            }
            else if (!strcmp (command, "endbatch")) {

                movie[i].command = CINEMA_ENDBATCH;
                movie[i].counter = 1;
            }
            else if (!strcmp (command, "frame")) {

                fscanf (fp, "%d", &arg[0]); // actor
                fscanf (fp, "%d", &arg[1]); // frame

                movie[i].command = CINEMA_FRAME;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0]; // actor
                movie[i].argument[1] = arg[1]; // frame
            }
            else if (!strcmp (command, "music_play")) {

                fscanf (fp, "%d", &arg[0]); // music

                movie[i].command = CINEMA_MUSIC_PLAY;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];
            }
            else if (!strcmp (command, "sound")) {

                fscanf (fp, "%d", &arg[0]); // sound

                movie[i].command = CINEMA_SOUND;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];
            }
            else if (!strcmp (command, "text")) {

                fscanf (fp, "%d", &arg[0]); // cinema text num
                fscanf (fp, "%s", s_arg); // position

                movie[i].command = CINEMA_TEXT;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];

                // Parse position
                if (s_arg[0] == 't' || s_arg[0] == 'T') {
                   movie[i].argument[1] = CINEMA_TOP;
                }
                else {
                   movie[i].argument[1] = CINEMA_BOTTOM;
                }
            }
            else if (!strcmp (command, "nop")) {

                fscanf (fp, "%d", &arg[0]); // duration

                movie[i].command = CINEMA_NOP;
                movie[i].counter = arg[0];
            }
            else if (!strcmp (command, "pan")) {

                fscanf (fp, "%d", &arg[0]); // x velocity
                fscanf (fp, "%d", &arg[1]); // y velocity
                fscanf (fp, "%d", &arg[2]); // amount

                movie[i].command = CINEMA_PAN;
                movie[i].counter = arg[2];
                movie[i].argument[0] = arg[0];
                movie[i].argument[1] = arg[1];
                movie[i].argument[2] = arg[2]; // I think that this is unnecessary
            }
            else if (!strcmp (command, "music_stop")) {

                movie[i].command = CINEMA_MUSIC_STOP;
                movie[i].counter = 1;
            }
            else if (!strcmp (command, "camera")) {

                // top-left corner
                fscanf (fp, "%d", &arg[0]); // x
                fscanf (fp, "%d", &arg[1]); // y

                movie[i].command = CINEMA_CAMERA;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];
                movie[i].argument[1] = arg[1];
            }
            else if (!strcmp (command, "music_volume")) {
                fscanf (fp, "%d", &arg[0]);

                movie[i].command = CINEMA_MUSIC_VOL;
                movie[i].counter = 1;
                movie[i].argument[0] = arg[0];
            }
            else { // Syntax Error
                printf ("Syntax error on line %d.\n", i);
            }

            ++i;
        }
        num_commands = i;

        // Load Performer file
        fscanf (fp, "%s", s_arg);
        Load_Performers (s_arg);

        // Load Music files
        fscanf (fp, "%d", &num_music);
        for (i = 0; i < num_music; i++) {
            fscanf (fp, "%s", s_arg);
            music[i] = Music_Load (s_arg);
        }

        // Load Sound files
        fscanf (fp, "%d", &num_sounds);
        for (i = 0; i < num_sounds; i++) {
            fscanf (fp, "%s", s_arg);
            sound_list[i] = Sound_Load (s_arg);
        }

        // Load text
        fscanf (fp, "%d", &num_text_blocks);

        for (i = 0; i < num_text_blocks; i++) {
            fscanf (fp, "%d", &movie_text[i].num_lines);
            movie_text[i].text = (char **)malloc (movie_text[i].num_lines *
                                                  sizeof (char *));

            // Get each individual line (34 long)
            for (j = 0; j < movie_text[i].num_lines; j++) {
                movie_text[i].text[j] = (char *)malloc (34 * sizeof (char));
                fscanf (fp, "%s", movie_text[i].text[j]);

                for (k = 0; k < 34; k++) {
                    if (movie_text[i].text[j][k] == '_') {
                       movie_text[i].text[j][k] = ' ';
                    }
                }
            }
        }

        fclose (fp);

        // This is necessary until dynamic allocation is implemented
        if (num_commands >= CINEMA_LENGTH) {
           printf ("Cinema length overrun.  Length = %d\n", num_commands);
        }

        // Clean out the rest of the movie (see just above)
        for (i = num_commands; i < CINEMA_LENGTH; i++) {
           movie[i].command = CINEMA_NOP;
           movie[i].counter = 1;
        }

        // Signal to everyone that there is a movie loaded
        loaded = 1;
    }
    else {
         fp2 = fopen ("cinma.txt", "wt");
         fprintf (fp2,"File read error.\n");
         fclose (fp2);
    }
} // End Cinema_Load

void Cinema_Unload (void)
{
    int i, j;

    if (loaded) {
       // Unload performers
       for (i = 0; i < num_performers; i++) {
           for (j = 0; j < 27; j++) {
               if (performer[i].frame[j] != -1) {
                  Graphics_Unload_Pic (performer[i].frame[j]);
                  performer[i].frame[j] = -1;
               }
           }
       }

       // Unload text
       for (i = 0; i < num_text_blocks; i++) {
           for (j = 0; j < movie_text[i].num_lines; j++) {
               free (movie_text[i].text[j]);
           }
           free (movie_text[i].text);
       }

        num_text_blocks = 0;
        num_performers = 0;
        loaded = 0;

        // Unload music
        for (i = 0; i < num_music; i++) {
            Music_Unload (music[i]);
            music[i] = -1;
        }

        // Unload sound
        for (i = 0; i < num_sounds; i++) {
            Sound_Unload (sound_list[i]);
            sound_list[i] = -1;
        }
    } // end if loaded
}

void
Cinema_Play (void)
{
    int person, direction, text = 0, sound, old_music;
    int current_pipe, last_command, command_offset;
    int frame, i, j, speed, done_batch, anim, text_pipe;
    PIPE pipe[CINEMA_NUM_PIPES + 1];
    FILE *fp;

    if (loaded) {

    // Save currently playing music
    old_music = Music_Get_Current ();

    // Clean out pipes
    for (i = 0; i < CINEMA_NUM_PIPES; i++) {
        pipe[i].counter = 0;
    }

    // Initialize command control variables
    command_offset = 0;
    last_command = 0;

    // Read commands from movie
    while (command_offset < num_commands &&
           last_command < num_commands)
    {
        i = 0;
        current_pipe = 0;

        // Copy movie information to pipes
        while (movie[command_offset + i].command != CINEMA_ENDBATCH &&
               current_pipe < CINEMA_NUM_PIPES)
        {
            pipe[current_pipe].command = movie[command_offset + i].command;
            pipe[current_pipe].counter = movie[command_offset + i].counter;

            for (j = 0; j < 3; j++) {
                pipe[current_pipe].argument[j] =
                    movie[command_offset + i].argument[j];
            }

            ++current_pipe;
            ++i;
            ++last_command;
        } // end while


        // Advance command_offset to next batch
        command_offset += i + 1; // + 1 for endbatch command

        // Execution loop
        do {
           done_batch = 1;

           for (current_pipe = 0; current_pipe < CINEMA_NUM_PIPES;
                current_pipe++)
           {
               if (pipe[current_pipe].counter > 0) {
                  // Execute command in current pipe
                  switch (pipe[current_pipe].command)
                  {
                  case CINEMA_MOVE:
                       person = pipe[current_pipe].argument[0];
                       speed = pipe[current_pipe].argument[2];

                        // Direction
                        switch (pipe[current_pipe].argument[1])
                        {
                            case CINEMA_LEFT:
                                 performer[person].x -= speed;
                                 break;
                            case CINEMA_RIGHT:
                                 performer[person].x += speed;
                                 break;
                            case CINEMA_UP:
                                 performer[person].y -= speed;
                                 break;
                            case CINEMA_DOWN:
                                 performer[person].y += speed;
                                 break;
                            default:
                                 break;
                        }
                        break;
                  case CINEMA_ANIM:
                       person = pipe[current_pipe].argument[0];
                       anim = pipe[current_pipe].argument[1];

                       performer[person].current_anim = anim;

                       // Cycle current_frame
                       ++performer[person].current_frame;

                       if (performer[person].current_frame >
                           performer[person].anim_length[anim])
                       {
                          performer[person].current_frame = 0;
                       }

                       // Set animating flag
                       performer[person].animating = 1;

                       // Last thing to do
                       if (pipe[current_pipe].counter == 1) {
                           // set current_frame
                           performer[person].current_frame =
                            performer[person].anim[anim][performer[
                             person].current_frame];

                           // change flag
                           performer[person].animating = 0;
                       }
                       break;

                  case CINEMA_ACTIVATE:
                       person = pipe[current_pipe].argument[0];
                       performer[person].active = 1;
                       break;
                  case CINEMA_DEACTIVATE:
                       person = pipe[current_pipe].argument[0];
                       performer[person].active = 0;
                       break;
                  case CINEMA_FRAME:
                       person = pipe[current_pipe].argument[0];
                       performer[person].current_frame =
                                             pipe[current_pipe].argument[1];
                       performer[person].animating = 0;
                       break;
                  case CINEMA_PLACE:
                       person = pipe[current_pipe].argument[0];
                       performer[person].x = pipe[current_pipe].argument[1];
                       performer[person].y = pipe[current_pipe].argument[2];
                       break;
                  case CINEMA_TEXT:
                       Text_Display (pipe[current_pipe].argument[1],
                                     pipe[current_pipe].argument[0]);
                       Graphics_Draw_Screen ();
                       while (Input_Pressed_Scan (KEY_SPACE)); // wait for release
                       while (!Input_Pressed_Scan (KEY_SPACE)); // wait for press
                       while (Input_Pressed_Scan (KEY_SPACE)); // wait for release
                       // Erase textbox by overwriting it with the background
                       Map_Render_Back ();
                       Render_Performers ();
                       Map_Clip ();
                       break;
                  case CINEMA_MUSIC_PLAY:
                       Music_Play (music[pipe[current_pipe].argument[0]]);
                       break;
                  case CINEMA_MUSIC_STOP:
                       Music_Stop ();
                       break;
                  case CINEMA_SOUND:
                       Sound_Play (sound_list[pipe[current_pipe].argument[0]]);
                       break;
                  case CINEMA_CAMERA:
                       Camera_Set_Position (pipe[current_pipe].argument[0],
                                            pipe[current_pipe].argument[1]);
                       break;
                  case CINEMA_MUSIC_VOL:
                       Music_Set_Volume (pipe[current_pipe].argument[0]);
                       break;
                  case CINEMA_NOP:
                       break;
                  default:
                       break;
                  } // end switch

                  --pipe[current_pipe].counter;

                  if (pipe[current_pipe].counter > 0) {

                     done_batch = 0;
                  }
               } // end if
           } // end for

           //fprintf (fp, "%d\n", performer[0].active);
           Map_Render_Back ();

           Render_Performers ();
/*----------------------------------------
           // To display text (using dirty pipes, no less)
//           if (text) {
              Text_Display (pipe[current_pipe].argument[1],
                                     pipe[current_pipe].argument[0]);

              //Text_Display (CINEMA_BOTTOM, 1);
           }
----------------------------------------*/
           // Render foreground (if I make one)
           Map_Clip ();
           Graphics_Draw_Screen ();

/*----------------------------------------
           // To pause text for reading
           if (text) {

              text = 0;
           }
----------------------------------------*/
           Delay (50);
        } while (!done_batch);

    } // end while (copying loop)

    // Restart music if necessary
    Music_Play (old_music);
    } // end if loaded
} // end Cinema_Play


static void
Delay (int duration)
{
    int time_keeper;

    time_keeper = counter;
    while (counter < time_keeper + duration);
}

static void
Text_Display (int position, int text_num)
{
    int i, max_length = 0;

    for (i = 0; i < movie_text[text_num].num_lines; i++) {
        if (max_length < strlen (movie_text[text_num].text[i])) {
           max_length = strlen (movie_text[text_num].text[i]);
        }
    }
    // Convert to box length
    max_length = 8 * (max_length + 2);

    switch (position)
    {
    case CINEMA_TOP:
         Graphics_Standard_Message_Box (160 - max_length / 2, 21,
                                        movie_text[text_num].text,
                                        movie_text[text_num].num_lines);
         break;
    case CINEMA_BOTTOM:
         Graphics_Standard_Message_Box (160 - max_length / 2,
                       178 - 8 * (movie_text[text_num].num_lines + 2),
                       movie_text[text_num].text,
                       movie_text[text_num].num_lines);
         break;
    default:
            break;
    }
} // end Text_Display

static void
Load_Performers (char *filename)
{
    int i, j, k, num_frames, frame_offset;
    int x_offset, y_offset, num_anim;
    char framefile[50], dummy[20];
    FILE *fp;

    // Unload performers
    for (i = 0; i < CINEMA_PERFORMERS; i++) {
        for (j = 0; j < 27; j++) {
            if (performer[i].frame[j] != -1) {

                Graphics_Unload_Pic (performer[i].frame[j]);
                performer[i].frame[j] = -1;
            }
        }
    }

    if ((fp = fopen (filename, "rt")) != NULL) {

        fscanf (fp, "%d", &num_performers);

        for (i = 0; i < num_performers; i++) {

            fscanf (fp, "%s", dummy); // Performer's Name or Number
            fscanf (fp, "%s", dummy); // <frameset>

            while (strcasecmp (dummy, "animation") &&
                   strcasecmp (dummy, "animations"))
            {
                if (!strcasecmp (dummy, "stand")) {
                   num_frames = 4;
                   frame_offset = 0;
                }
                else if (!strcasecmp (dummy, "walk")) {
                   num_frames = 8;
                   frame_offset = 4;
                }
                else if (!strcasecmp (dummy, "attack")) {
                   num_frames = 12;
                   frame_offset = 12;
                }
                else if (!strcasecmp (dummy, "hurt")) {
                   num_frames = 2;
                   frame_offset = 24;
                }
                else if (!strcasecmp (dummy, "dead")) {
                   num_frames = 1;
                   frame_offset = 26;
                }
                else { // full
                   num_frames = 27;
                   frame_offset = 0;
                }

                // load frames
                for (j = 0; j < num_frames; j++) {
                    fscanf (fp, "%s", framefile);
                    fscanf (fp, "%d",
                            &performer[i].x_frame_offset[frame_offset + j]);
                    fscanf (fp, "%d",
                            &performer[i].y_frame_offset[frame_offset + j]);
                    performer[i].frame[frame_offset + j] =
                                 Graphics_Load_Pic (framefile, 0);
                }

                fscanf (fp, "%s", dummy); // <frameset>
            } // end while

            // load animations
            fscanf (fp, "%d", &num_anim);

            for (j = 0; j < num_anim; j++) {
                fscanf (fp, "%d", &num_frames);
                performer[i].anim_length[j] = num_frames;

                for (k = 0; k < num_frames; k++) {
                    fscanf (fp, "%d", &performer[i].anim[j][k]);
                }
            }

            // Finishing touches
            performer[i].x = 0;
            performer[i].y = 0;
            performer[i].current_frame = 0;
            performer[i].active = 1;
            performer[i].animating = 0;
        }

        fclose (fp);
    }
    else {
         fp = fopen ("cinma.txt", "at");
         fprintf (fp, "\nPerformer load problem");
         fclose (fp);
    }
} // end Load_Performers

static void
Render_Performers (void)
{
    int j, anim, frame, order[CINEMA_PERFORMERS][2], y_sorted;

    // Initialize order
    for (j = 0; j < num_performers; j++) {
        order[j][0] = performer[j].y;
        order[j][1] = j;
    }

    // Sort here
    Insertion_Sort (order);

    // Render performers
    for (j = 0; j < num_performers; j++) {
        y_sorted = order[j][1];

        if (performer[y_sorted].active) {
           if (performer[y_sorted].animating) {
              anim = performer[y_sorted].current_anim;
              frame = performer[y_sorted].anim[anim][performer[y_sorted].current_frame];
           }
           else {
                frame = performer[y_sorted].current_frame;
           }

           Graphics_Draw_Pic (16 + performer[y_sorted].x - Camera_Get_X () -
                              performer[y_sorted].x_frame_offset[frame],
                              20 + performer[y_sorted].y - Camera_Get_Y () -
                              performer[y_sorted].y_frame_offset[frame],
                              performer[y_sorted].frame[frame]);
        } // end if active
    } // end for
} // end Render_Performers

static void
Insertion_Sort (int order[CINEMA_PERFORMERS][2])
{
    int i, j, key[2];

    for (j = 1; j < num_performers; j++) {
        key[0] = order[j][0];
        key[1] = order[j][1];
        i = j - 1;
        while (i >= 0 && order[i][0] > key[0]) {
              order[i + 1][0] = order[i][0];
              order[i + 1][1] = order[i][1];
              i = i - 1;
        }
        order[i + 1][0] = key[0];
        order[i + 1][1] = key[1];
    }
}
