// Actor module header file v 1.00
// Copyright Kwame Alexander February 28, 2001
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and one
// severe beating.

#ifndef ACTOR_MODULE
#define ACTOR_MODULE

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "graph100.h"
#include "sound100.h"

#define ACTOR_MAX       50
#define ACTOR_KEYBOARD  0
#define ACTOR_SCRIPT    1
#define ACTOR_RELATIVE  0
#define ACTOR_ABSOLUTE  1
#define ACTOR_FRAME     0
#define ACTOR_ANIMATION 1

// Script macros
#define STATE           0
#define ENDSTATE        1
#define CHANGESTATE     2
#define IF              3
#define IF_EQUAL_VN     4
#define IF_GREATER_VN   5
#define IF_LESS_VN      6
#define IF_EQUAL_VV     7
#define IF_GREATER_VV   8
#define IF_LESS_VV      9
#define ASSIGN_VN       10
#define ASSIGN_VV       11
#define RANDOM          12
#define ENDIF           13
#define MOVE_DOWN       14
#define STRIKE          15
#define ELSE            16
#define NOT             17
#define MOVE_LEFT       18
#define MOVE_RIGHT      19
#define MOVE_UP         20
#define IF_BUTTON       21
#define IF_NOT_BUTTON   22
#define IF_VARIABLE     23
#define IF_NOT_VARIABLE 24
#define ENDSTATE2       25
#define EXECUTE         26
#define DONE            27
#define IF_HIT          28
#define IF_NOT_HIT      29
#define SPAWN           30
#define TERMINATE       31
#define PASSABLE        32
#define IMPASSABLE      33
#define ADDASSIGN_VN    34
#define ADDASSIGN_VV    35
#define SUBASSIGN_VN    36
#define SUBASSIGN_VV    37
#define CHANGESTATE_V   38
#define IF_HIT_LEFT     39
#define IF_HIT_DOWN     40
#define IF_HIT_RIGHT    41
#define IF_HIT_UP       42
#define EXITSTATE       43
#define FRAME           44
#define TARGET          45
#define SOUND           46
#define SPAWN_XY	47
#define SPAWN_HERE	48
#define NEGASSIGN_VV	49

#define BUTTON_DOWN     0
#define BUTTON_LEFT     1
#define BUTTON_RIGHT    2
#define BUTTON_UP       3
#define BUTTON_1        4
#define BUTTON_2        5

#define HIT_LEFT        0
#define HIT_DOWN        1
#define HIT_RIGHT       2
#define HIT_UP          3

#define MAX_ACTOR_SOUNDS    10

#define DEATH_STATE     0
#define HURT_STATE      1

typedef struct
{
    int command;
    int parameter[5];
} INSTRUCTION;

typedef struct
{
    char name[30];
    int frame;
    int animation;
    int frame_or_animation; // 0 = frame, 1 = animation
} STATE_TYPE;

typedef struct
{
    int left;
    int top;
    int right;
    int bottom;
    int rel_or_abs; // 0 = relative, 1 = absolute
    int direction;
} STRIKEBOX;

typedef struct
{
    int hit;
    int damage;
    int type;
    int direction;
} STRUCK;

typedef struct
{
    char name[20];
    int offence;
    int hp;
    int ap;
    int hp_max;
    int ap_max;
    int width;
    int height;
    int x_offset;
    int y_offset;
    int team;
    int target;
    int **animation;
    int *frame;
    int *x_frame_offset;
    int *y_frame_offset;
    int framecounter;
    int num_frames;
    int num_anim;
    int num_states;
    int num_strikeboxes;
    int *anim_length;
    int execute;
    int x;
    int y;
    int current_frame;
    int current_state;
    int variable[20]; // Dynamically allocate later
    int num_variables;
    int active;
    int impassable;
    int standard_state[2];
    int public_frame[10];
    int ability_occurring;
    int blood_colour;
    STRUCK struck;
    STATE_TYPE state[50]; // Dynamically allocate later
    STRIKEBOX strikebox[10]; // Dynamically allocate later
    INSTRUCTION script[1200]; // Dynamically allocate later
} ACTOR;

void Actor_Initialize ();
void Actor_Shutdown ();
int Actor_Load (char *filename);
void Actor_Update (int actor_num); // Script parser
void Actor_Unload (int actor_num);
void Actor_Display (int actor_num);
void Actor_Display_All (void);
//int Actor_Get_ (int actor_num);
//void Actor_Set_ (int actor_num, int value);
void Actor_Update_All (void);
int Actor_Get_X (int actor_num);
int Actor_Get_Y (int actor_num);
void Actor_Set_X (int actor_num, int x);
void Actor_Set_Y (int actor_num, int y);
void Actor_Set_Active (int actor_num, int active);
void Actor_Set_Team (int actor_num, int team);
void Actor_Set_Target (int actor_num, int target);
void Actor_Strike (int actor_num, int strikebox);
int Actor_Switch (int switch_sound);
int Actor_Get_Width (int actor_num);
int Actor_Get_Height (int actor_num);
void Actor_Set_Sounds (int *effect_list, int number_of_sounds);
int Actor_Get_HP (int actor_num);
#endif
