// Actor module code file v 1.00
// Copyright Kwame Alexander February 28, 2001
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and one
// severe beating.

#include "actor100.h"

//#define TESTING
#define num_sboxes   actor[actor_num].num_strikeboxes

static void Insertion_Sort (int order[ACTOR_MAX][2]);
static void Set_Struck (ACTOR *attacker, int left, int top, int right,
                        int bottom, int damage, int type, int direction);
static int Actor_Collision (int actor_num);
static void Life_Bar (int actor_num, int x, int y, int colour);

// Globals
static int num_actors, used_actor[ACTOR_MAX], central, x_offset, y_offset;
static int low_scroll, high_scroll, left_scroll, right_scroll, scr_x_offset;
static int scr_y_offset, inactive, sound_list[MAX_ACTOR_SOUNDS], num_sounds;
static char command_name[50][30];
static ACTOR actor[ACTOR_MAX];
extern int game_over, switch_sound;

void
Actor_Initialize (void)
{
    int i, j;
    FILE *fp;

    srand (time(0));
    for (i = 0; i < ACTOR_MAX; i++) {

        used_actor[i] = 0;
        for (j = 0; j < 1000; j++) {
            actor[i].script[j].command = -1;
            actor[i].script[j].parameter[0] = -1;
            actor[i].script[j].parameter[1] = -1;
            actor[i].script[j].parameter[2] = -1;
            actor[i].script[j].parameter[3] = -1;
        }
        // standard states
        for (j = 0; j < 2; j++) {
            actor[i].standard_state[j] = -1;
        }
        actor[i].current_state = 0;
        actor[i].variable[0] = 0; // framecounter variable
        //actor[i].num_variables = 1;
        actor[i].x = rand () % 320;
        actor[i].y = rand () % 200;
        actor[i].num_strikeboxes = 0;
        actor[i].team = -1; // no one should ever have this team
        actor[i].struck.hit = 0;
        actor[i].struck.direction = -1;
        actor[i].active = 1;
        actor[i].target = 0;
    }
    num_actors = 0;
    central = 0;
    x_offset = 150;
    y_offset = 90;
    scr_x_offset = 16;
    scr_y_offset = 20;
    low_scroll = (SCR_HEIGHT - 2 * scr_y_offset) * 2 / 3;
    high_scroll = (SCR_HEIGHT - 2 * scr_y_offset) / 3;
    right_scroll = (SCR_WIDTH - 2 * scr_x_offset) * 2 / 3;
    left_scroll = (SCR_WIDTH - 2 * scr_x_offset) / 3;
    num_sounds = 0;

    actor[0].team = 0;
    actor[0].target = 2;

    // Loading both players
    i = Actor_Load ("actors/ruprect.act");
    Actor_Set_Team (i, 0);
    actor[i].active = 1;
    central = i;
    i = Actor_Load ("actors/grog.act");
    Actor_Set_Team (i, 0);
    inactive = i;
    actor[i].active = 0;
    actor[i].target = 0;

    // For actor.txt
    strcpy (command_name[0], "state");
    strcpy (command_name[1], "endstate");
    strcpy (command_name[2], "changestate");
    strcpy (command_name[3], "if");
    strcpy (command_name[4], "if_equal_vn");
    strcpy (command_name[5], "if_greater_vn");
    strcpy (command_name[6], "if_less_vn");
    strcpy (command_name[7], "if_equal_vv");
    strcpy (command_name[8], "if_greater_vv");
    strcpy (command_name[9], "if_less_vv");
    strcpy (command_name[10], "assign_vn");
    strcpy (command_name[11], "assign_vv");
    strcpy (command_name[12], "random");
    strcpy (command_name[13], "endif");
    strcpy (command_name[14], "move_down");
    strcpy (command_name[15], "strike");
    strcpy (command_name[16], "else");
    strcpy (command_name[17], "not");
    strcpy (command_name[18], "move_left");
    strcpy (command_name[19], "move_right");
    strcpy (command_name[20], "move_up");
    strcpy (command_name[21], "if_button");
    strcpy (command_name[22], "if_not_button");
    strcpy (command_name[23], "if_variable");
    strcpy (command_name[24], "if_not_variable");
    strcpy (command_name[25], "endstate2");
    strcpy (command_name[26], "execute");
    strcpy (command_name[27], "done");
    strcpy (command_name[28], "if_hit");
    strcpy (command_name[29], "if_not_hit");
    strcpy (command_name[30], "spawn");
    strcpy (command_name[31], "terminate");
    strcpy (command_name[32], "passable");
    strcpy (command_name[33], "impassable");
    strcpy (command_name[34], "addassign_vn");
    strcpy (command_name[35], "addassign_vv");
    strcpy (command_name[36], "subassign_vn");
    strcpy (command_name[37], "subassign_vv");
    strcpy (command_name[38], "changestate_v");
    strcpy (command_name[39], "if_hit_left");
    strcpy (command_name[40], "if_hit_down");
    strcpy (command_name[41], "if_hit_right");
    strcpy (command_name[42], "if_hit_up");
    strcpy (command_name[43], "exitstate");
    strcpy (command_name[44], "frame");
    strcpy (command_name[45], "target");

    for (i = 0; i < MAX_ACTOR_SOUNDS; i++) {
        sound_list[i] = -1;
    }
} // End Actor_Initialize

void
Actor_Shutdown (void)
{
    int i, actor_num;
    FILE *fp;

//    fp = fopen ("actor.txt", "at");
//    fprintf (fp, "%d", actor[0].struck.direction);
//    fclose (fp);

    for (i = 0; i < ACTOR_MAX; i++) {

        if (used_actor[i]) {

           Actor_Unload (i);
        }
    }

    // Unload sounds
    for (i = 0; i < num_sounds; i++) {

        Sound_Unload (sound_list[i]);
    }
//    fp = fopen ("actor.txt", "at");
//    fprintf (fp, "\nCurr_State: %2d\n", actor[0].current_state);
//    fclose (fp);
} // End Actor_Shutdown

int
Actor_Load (char *actor_filename)
{
    int i, j, actor_num, num_anim, anim, frame, num_frames, if_nest;
    int state, num_states, anim_length, num_strikeboxes, strikebox;
    int range, width, height, instruction_counter, done, param;
    int state_inst_number, inside_if_block, if_inst_number[10], var;
    char temp[100], graphics_dir[15], filename[100], statename[15];
    char command[30], variable_name[25][30], temp2[30];
    FILE *fp;

    instruction_counter = 0;
    if_nest = 0;

    // Setup directory names
    strcpy (graphics_dir, "graphics/");

    // Set up predefined variables
    strcpy (variable_name[0], "framecounter");
    strcpy (variable_name[1], "x");
    strcpy (variable_name[2], "y");
    strcpy (variable_name[3], "target_x");
    strcpy (variable_name[4], "target_y");
    strcpy (variable_name[5], "hp");
    strcpy (variable_name[6], "hp_max");
    strcpy (variable_name[7], "damage");
    strcpy (variable_name[8], "hit_direction");


    // Setup used_actor and num_actors;
    for (actor_num = 0; actor_num < ACTOR_MAX; actor_num++) {

        if (!used_actor[actor_num]) {
           used_actor[actor_num] = 1;
           break;
        }
    }

    if (actor_num >= ACTOR_MAX) {

        return (-1);
    }

    ++num_actors;

    // Read in Actor file
    if (!(fp = fopen (actor_filename, "rt"))) {
       printf ("File: %s not found.\n", actor_filename);
    }
    // Setup section
    fscanf (fp, "%s", temp);
    fscanf (fp, "%s", actor[actor_num].name);
    fscanf (fp, "%s", temp);
    fscanf (fp, "%d", &actor[actor_num].offence);
    fscanf (fp, "%s", temp);
    fscanf (fp, "%d", &actor[actor_num].hp_max);
    fscanf (fp, "%s", temp);
    fscanf (fp, "%d", &actor[actor_num].ap_max);
    fscanf (fp, "%s", temp);
    fscanf (fp, "%d", &actor[actor_num].width);
    fscanf (fp, "%s", temp);
    fscanf (fp, "%d", &actor[actor_num].height);
    fscanf (fp, "%s", temp);
    fscanf (fp, "%d", &actor[actor_num].blood_colour);

    actor[actor_num].hp = actor[actor_num].hp_max;
    actor[actor_num].ap = actor[actor_num].ap_max;
    actor[actor_num].current_state = 0;

    // Filter spaces into name
    for (i = 0; i < strlen (actor[actor_num].name) - 1; i++) {
        if (actor[actor_num].name[i] == '_') {
           actor[actor_num].name[i] = ' ';
        }
    }

    // Load frames
    fscanf (fp, "%d", &actor[actor_num].num_frames);
    num_frames = actor[actor_num].num_frames; // Convenience

    // Allocate memory for frames
    actor[actor_num].frame = (int *)malloc (num_frames * sizeof (int));
    actor[actor_num].x_frame_offset = (int *)malloc (num_frames * sizeof (int));
    actor[actor_num].y_frame_offset = (int *)malloc (num_frames * sizeof (int));

    for (frame = 0; frame < num_frames; frame++) {

        fscanf (fp, "%s", temp);
        strcpy (filename, graphics_dir);
        strcat (filename, temp);
        actor[actor_num].frame[frame] = Graphics_Load_Pic (filename, 0);
        fscanf (fp, "%d", &actor[actor_num].x_frame_offset[frame]);
        fscanf (fp, "%d", &actor[actor_num].y_frame_offset[frame]);
    }

    // Load animations
    fscanf (fp, "%d", &actor[actor_num].num_anim);
    num_anim = actor[actor_num].num_anim; // Convenience

    // Allocate space for animations
    actor[actor_num].animation = (int **)malloc (num_anim * sizeof (int *) + 1);
    actor[actor_num].anim_length = (int *)malloc (num_anim * sizeof (int) + 1);

    for (anim = 0; anim < num_anim; anim++) {

        fscanf (fp, "%d", &actor[actor_num].anim_length[anim]);
        anim_length = actor[actor_num].anim_length[anim];

        // Allocate space for current animation
        actor[actor_num].animation[anim] = (int *)malloc (anim_length * sizeof (int) + 1);

        for (frame = 0; frame < anim_length; frame++) {

            fscanf (fp, "%d", &actor[actor_num].animation[anim][frame]);
        }
    }

    // Setup states
    fscanf (fp, "%d", &actor[actor_num].num_states);
    num_states = actor[actor_num].num_states; // for convenience

    if (num_states < 1) {
       // No states declared ERROR!
       printf ("%d: No states declared.\n", instruction_counter);
    }


    for (state = 0; state < num_states; state++) {

        fscanf (fp, "%s", command);

        if (strcmp (command, "state")) {
           // Missing state directive ERROR!
           printf ("%d: Missing \'state\' directive.\n", instruction_counter);
        }

        // Get state name
        fscanf (fp, "%s", statename);

        for (i = 0; i < state; i++) {
            if (!strcmp (statename, actor[actor_num].state[i].name)) {
               // Duplicate state name ERROR!
               printf ("%d: Duplicate state name.\n", instruction_counter);
            }
        }

        strcpy (actor[actor_num].state[state].name, statename);

        // Get frame animation type
        fscanf (fp, "%s", command);

        if (command[0] == 'f') { // single frame
           actor[actor_num].state[state].frame_or_animation = ACTOR_FRAME;
           fscanf (fp, "%d", &actor[actor_num].state[state].frame);
        }
        else if (command[0] == 'a') { // animation
           actor[actor_num].state[state].frame_or_animation = ACTOR_ANIMATION;
           fscanf (fp, "%d", &actor[actor_num].state[state].animation);
        }
        else {
            // Not frame or animation ERROR!
            printf ("%d: Not \'frame\' or \'animation\'\n", instruction_counter);
        }
    }

    // Search for spawning state
    for (state = 0; state < num_states; state++) {
        if (!strcmp (actor[actor_num].state[state].name, "spawning")) {
           break;
        }
    }

    if (state == num_states) {
       // No spawning state ERROR!
       printf ("%d: No spawning state.\n", instruction_counter);
    }
    // Remember to search for any keyword

    // Clean out standard states
    for (i = 0; i < 2; i++) {
        actor[actor_num].standard_state[i] = -1;
    }

    // Setup standard states (just death and hurt for now)
    fscanf (fp, "%d", &num_states);

    for (i = 0; i < num_states; i++) {
        fscanf (fp, "%s", command);

        switch (command[0])
        {
        case 'd': // death_state
        case 'D':
            fscanf (fp, "%d", &actor[actor_num].standard_state[DEATH_STATE]);
            break;
        case 'h': // hurt_state
        case 'H':
            fscanf (fp, "%d", &actor[actor_num].standard_state[HURT_STATE]);
            break;
        default:
                // ERROR!  I will add error info here later
            break;
        }

    }

    // Setup strikeboxes
    fscanf (fp, "%d", &num_strikeboxes);

    for (strikebox = 0; strikebox < num_strikeboxes; strikebox++) {

         fscanf (fp, "%s", command);

         if (strcmp (command, "strikebox")) {
            // Missing strikebox directive ERROR!
            printf ("%d: Missing \'strikebox\' directive\n",
                    instruction_counter);
         }

         fscanf (fp, "%s", command);

         if (!strcmp (command, "standard")) {
            fscanf (fp, "%d", &range);
            width = actor[actor_num].width;
            height = actor[actor_num].height;
            // num_sboxes = actor[actor_num].num_strikeboxes;

            actor[actor_num].strikebox[num_sboxes].left = -range;
            actor[actor_num].strikebox[num_sboxes].top = -height;
            actor[actor_num].strikebox[num_sboxes].right = 0;
            actor[actor_num].strikebox[num_sboxes].bottom = 0;
            actor[actor_num].strikebox[num_sboxes].rel_or_abs = ACTOR_RELATIVE; // RELATIVE
            actor[actor_num].strikebox[num_sboxes].direction = HIT_LEFT;

            actor[actor_num].strikebox[num_sboxes + 1].left = width;
            actor[actor_num].strikebox[num_sboxes + 1].top = -height;
            actor[actor_num].strikebox[num_sboxes + 1].right = width + range;
            actor[actor_num].strikebox[num_sboxes + 1].bottom = 0;
            actor[actor_num].strikebox[num_sboxes + 1].rel_or_abs = ACTOR_RELATIVE; // RELATIVE
            actor[actor_num].strikebox[num_sboxes + 1].direction = HIT_RIGHT;

            actor[actor_num].strikebox[num_sboxes + 2].left = 0;
            actor[actor_num].strikebox[num_sboxes + 2].top = -height - range;
            actor[actor_num].strikebox[num_sboxes + 2].right = width;
            actor[actor_num].strikebox[num_sboxes + 2].bottom = -height;
            actor[actor_num].strikebox[num_sboxes + 2].rel_or_abs = ACTOR_RELATIVE; // RELATIVE
            actor[actor_num].strikebox[num_sboxes + 2].direction = HIT_UP;

            actor[actor_num].strikebox[num_sboxes + 3].left = 0;
            actor[actor_num].strikebox[num_sboxes + 3].top = 0;
            actor[actor_num].strikebox[num_sboxes + 3].right = width;
            actor[actor_num].strikebox[num_sboxes + 3].bottom = range;
            actor[actor_num].strikebox[num_sboxes + 3].rel_or_abs = ACTOR_RELATIVE; // RELATIVE
            actor[actor_num].strikebox[num_sboxes + 3].direction = HIT_DOWN;

            actor[actor_num].num_strikeboxes += 4;
         }
         else if ((command[0] >= '0' && command[0] <= '9') || command[0] == '-') {
            actor[actor_num].strikebox[num_sboxes].left = atoi (command);
            fscanf (fp, "%d", &param); // param is free now, so it can be used
            actor[actor_num].strikebox[num_sboxes].top = param;
            fscanf (fp, "%d", &param);
            actor[actor_num].strikebox[num_sboxes].right = param;
            fscanf (fp, "%d", &param);
            actor[actor_num].strikebox[num_sboxes].bottom = param;
            fscanf (fp, "%s", command);

            // if (relative)
            if (command[0] == 'r' || command[0] == 'R') {
               actor[actor_num].strikebox[num_sboxes].rel_or_abs = ACTOR_RELATIVE;
            }
            else {
               actor[actor_num].strikebox[num_sboxes].rel_or_abs = ACTOR_ABSOLUTE;
            }

            // direction
            fscanf (fp, "%s", command);

            switch (command[0])
            {
            case 'l':
            case 'L':
                 actor[actor_num].strikebox[num_sboxes].direction = HIT_LEFT;
                 break;
            case 'r':
            case 'R':
                 actor[actor_num].strikebox[num_sboxes].direction = HIT_RIGHT;
                 break;
            case 'u':
            case 'U':
                 actor[actor_num].strikebox[num_sboxes].direction = HIT_UP;
                 break;
            case 'd':
            case 'D':
                 actor[actor_num].strikebox[num_sboxes].direction = HIT_DOWN;
                 break;
            default:
                 // Bad direction ERROR!
                 printf ("Bad direction in strikebox declaration!\n");
                 break;
            }
            ++actor[actor_num].num_strikeboxes;
         }
         else {
              // Bad strikebox declaration ERROR!
              printf ("%d: Bad strikebox declaration", instruction_counter);

              /*// Not yet supported ERROR!
              printf ("%d: Only standard strikeboxes are supported, currently.\n",
                      instruction_counter);*/
         }
    }

    // Setup Variables
    fscanf (fp, "%d", &actor[actor_num].num_variables);

    // Start at 9 because of preset variables
    actor[actor_num].num_variables += 9;
    for (var = 9; var < actor[actor_num].num_variables; var++) {
        fscanf (fp, "%s", command);

        if (strcmp (command, "variable")) {

           // Missing variable directive ERROR!
           printf ("%d: Missing \'variable\' directive.\n", instruction_counter);
        }

        // Get variable name
        fscanf (fp, "%s", temp);

        for (i = 0; i < var; i++) {
            if (!strcmp (temp, variable_name[i])) {
               // Duplicate state name ERROR!
               printf ("%d: Duplicate state name.\n", instruction_counter);
            }
        }

        strcpy (variable_name[i], temp);
    } // end for var

    // Passable/Impassable Directive
    fscanf (fp, "%s", temp);

    // 'p' is for passable
    if (temp[0] == 'p' || temp[0] == 'P') {
       actor[actor_num].impassable = 0;
    }
    else {
       actor[actor_num].impassable = 1;
    }

    // Main Script Parser
    done = 0;
    inside_if_block = 0;
    actor[actor_num].execute = -1;

    while (!done) {

        fscanf (fp, "%s", command);

        // Commented line
        if (command[0] == '#') {
           while (getc (fp) != '\n');
           continue;
        }

        // state
        // search for states by that name
        for (i = 0; i < actor[actor_num].num_states; i++) {
            if (!strcmp (command, actor[actor_num].state[i].name)) {
               break;
            }
        }
        if (i < actor[actor_num].num_states) { // it's a state!

            state_inst_number = instruction_counter; // save location of state
            fscanf (fp, "%s", temp);
            if (strcmp (temp, "->")) {
               // Incorrect format for state ERROR!
               printf ("%d: Missing ->\n", instruction_counter);
            }
            actor[actor_num].script[instruction_counter].command = STATE;
            actor[actor_num].script[instruction_counter].parameter[0] = i;
        }

        // endstate
        if (!strcmp (command, "endstate")) {
           if (inside_if_block) {
              // Missing 'endif' ERROR!
              printf ("%d: Missing \'endif\'", instruction_counter);
           }

           if (actor[actor_num].execute == -1) { // Choose state
              actor[actor_num].script[instruction_counter].command = ENDSTATE;
           }
           else { // execute
              actor[actor_num].script[instruction_counter].command = ENDSTATE2;
           }
           // Save location of state block beginning
           actor[actor_num].script[state_inst_number].parameter[1] =
                                                      instruction_counter;
        }

        // changestate
        if (!strcmp (command, "changestate")) {
           actor[actor_num].script[instruction_counter].command = CHANGESTATE;

           fscanf (fp, "%s", temp);

           // Check if temp is a state number
           if (temp[0] >= '0' && temp[0] <= '9') {
              actor[actor_num].script[instruction_counter].parameter[0] = atoi (temp);
           }
           else {
                // search for states by that name
                for (i = 0; i < actor[actor_num].num_states; i++) {
                    if (!strcmp (temp, actor[actor_num].state[i].name)) {
                       break;
                       }
                }

                // state name found
                if (i < actor[actor_num].num_states) {
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                }
                else {
                     // search for variables by that name
                     for (i = 0; i < actor[actor_num].num_variables; i++) {
                         if (!strcmp (temp, variable_name[i])) {
                            break;
                         }
                     }

                    // it's a variable!
                    if (i < actor[actor_num].num_variables) {
                       actor[actor_num].script[instruction_counter].command = CHANGESTATE_V;
                       actor[actor_num].script[instruction_counter].parameter[0] = i;
                    }
                    else {
                         // No state or variable by that name ERROR!
                         printf ("%d: No state or variable by the name %s.\n",
                                 instruction_counter, temp);
                    } // end if variable
                } // end if state
           } // end if state number
        } // end if changestate

        // if
        if (!strcmp (command, "if")) {
           inside_if_block = 1;
           if_inst_number[if_nest++] = instruction_counter;

           fscanf (fp, "%s", temp);

           // Check not
           if (!strcmp (temp, "not")) {

              // Check for buttons
              fscanf (fp, "%s", temp);

              if (!strcmp (temp, "key_left")) {
                 actor[actor_num].script[instruction_counter].command =
                                                                      IF_NOT_BUTTON;
                 actor[actor_num].script[instruction_counter].parameter[0] =
                                                                BUTTON_LEFT;
              }
              if (!strcmp (temp, "key_right")) {
                 actor[actor_num].script[instruction_counter].command =
                                                                IF_NOT_BUTTON;
                 actor[actor_num].script[instruction_counter].parameter[0] =
                                                                BUTTON_RIGHT;
              }
              if (!strcmp (temp, "key_up")) {
                 actor[actor_num].script[instruction_counter].command =
                                                                IF_NOT_BUTTON;
                 actor[actor_num].script[instruction_counter].parameter[0] =
                                                                BUTTON_UP;
              }
              if (!strcmp (temp, "key_down")) {
                 actor[actor_num].script[instruction_counter].command =
                                                                IF_NOT_BUTTON;
                 actor[actor_num].script[instruction_counter].parameter[0] =
                                                                BUTTON_DOWN;
              }
              if (!strcmp (temp, "key_button1")) {
                 actor[actor_num].script[instruction_counter].command =
                                                                IF_NOT_BUTTON;
                 actor[actor_num].script[instruction_counter].parameter[0] =
                                                                BUTTON_1;
              }
              if (!strcmp (temp, "key_button2")) {
                 actor[actor_num].script[instruction_counter].command =
                                                                IF_NOT_BUTTON;
                 actor[actor_num].script[instruction_counter].parameter[0] =
                                                                BUTTON_2;
              }
              if (!strcmp (temp, "hit")) {
                 actor[actor_num].script[instruction_counter].command = IF_NOT_HIT;
              }
           strcpy (temp, "");
           } // end if "not"

           if (!strcmp (temp, "key_left") || // Check buttons
               !strcmp (temp, "key_right") ||
               !strcmp (temp, "key_up") ||
               !strcmp (temp, "key_down") ||
               !strcmp (temp, "key_button1") ||
               !strcmp (temp, "key_button2"))
           {

                if (!strcmp (temp, "key_left")) {
                   actor[actor_num].script[instruction_counter].command = IF_BUTTON;
                   actor[actor_num].script[instruction_counter].parameter[0] =
                                                                      BUTTON_LEFT;
                }
                if (!strcmp (temp, "key_right")) {
                   actor[actor_num].script[instruction_counter].command = IF_BUTTON;
                   actor[actor_num].script[instruction_counter].parameter[0] =
                                                                      BUTTON_RIGHT;
                }
                if (!strcmp (temp, "key_up")) {
                   actor[actor_num].script[instruction_counter].command = IF_BUTTON;
                   actor[actor_num].script[instruction_counter].parameter[0] =
                                                                      BUTTON_UP;
                }
                if (!strcmp (temp, "key_down")) {
                   actor[actor_num].script[instruction_counter].command = IF_BUTTON;
                   actor[actor_num].script[instruction_counter].parameter[0] =
                                                                      BUTTON_DOWN;
                }
                if (!strcmp (temp, "key_button1")) {
                   actor[actor_num].script[instruction_counter].command = IF_BUTTON;
                   actor[actor_num].script[instruction_counter].parameter[0] =
                                                                      BUTTON_1;
                }
                if (!strcmp (temp, "key_button2")) {
                   actor[actor_num].script[instruction_counter].command = IF_BUTTON;
                   actor[actor_num].script[instruction_counter].parameter[0] =
                                                                      BUTTON_2;
                }
                strcpy (temp, "");
           } // End if 'if key_x'

           // Check variables
           // Search for variable names here
           for (i = 0; i < actor[actor_num].num_variables; i++) {
               if (!strcmp (temp, variable_name[i])) {
                  break;
               }
           }
           if (i < actor[actor_num].num_variables) { // it's a variable!

               // Enter variable # into script
               actor[actor_num].script[instruction_counter].parameter[0] = i;
               fscanf (fp, "%s", temp);
               fscanf (fp, "%s", temp2);

               // Check if < or = or >
               switch (temp[0])
               {
               case '<':
                    // Check if next parameter is a number or a variable
                    if ((temp2[0] >= '0' && temp2[0] <= '9') || temp2[0] == '-') {
                       // number
                       actor[actor_num].script[instruction_counter].command =
                                                                   IF_LESS_VN;
                       actor[actor_num].script[instruction_counter].parameter[1] =
                                                                   atoi (temp2);
                    }
                    else { // variable
                        for (j = 0; j < actor[actor_num].num_variables; j++) {
                            if (!strcmp (temp2, variable_name[j])) {
                               break;
                            }
                        }
                        actor[actor_num].script[instruction_counter].command =
                                                                   IF_LESS_VV;
                        actor[actor_num].script[instruction_counter].parameter[1] = j;
                    }
                    break;
               case '=':
                    // Check if next parameter is a number or a variable
                    if ((temp2[0] >= '0' && temp2[0] <= '9') || temp2[0] == '-') {
                       // number
                       actor[actor_num].script[instruction_counter].command =
                                                                           IF_EQUAL_VN;
                       actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
                    }
                    else { // variable
                        for (j = 0; j < actor[actor_num].num_variables; j++) {
                            if (!strcmp (temp2, variable_name[j])) {
                               break;
                            }
                        }
                        actor[actor_num].script[instruction_counter].command =
                                                                           IF_EQUAL_VV;
                        actor[actor_num].script[instruction_counter].parameter[1] = j;
                    }
                    break;
               case '>':
                    // Check if next parameter is a number or a variable
                    if ((temp2[0] >= '0' && temp2[0] <= '9') || temp2[0] == '-') {
                       // number
                       actor[actor_num].script[instruction_counter].command =
                                                                           IF_GREATER_VN;
                       actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
                    }
                    else { // variable
                       for (j = 0; j < actor[actor_num].num_variables; j++) {
                            if (!strcmp (temp2, variable_name[j])) {
                               break;
                            }
                        }
                       actor[actor_num].script[instruction_counter].command =
                                                                           IF_GREATER_VV;
                       actor[actor_num].script[instruction_counter].parameter[1] = j;
                    }
                    break;
               default:
                    // Not < or = or > ERROR!
                    printf ("%d: Not < or = or > in if <variable>\n", instruction_counter);
                    break;
               }
               strcpy (temp, "");
           } // End if 'if <variable>'

           // check hit
           if (!strcmp (temp, "hit")) {
              actor[actor_num].script[instruction_counter].command = IF_HIT;
           }
           else if (!strcmp (temp, "hit_left")) {
              actor[actor_num].script[instruction_counter].command = IF_HIT_LEFT;
           }
           else if (!strcmp (temp, "hit_down")) {
              actor[actor_num].script[instruction_counter].command = IF_HIT_DOWN;
           }
           else if (!strcmp (temp, "hit_right")) {
              actor[actor_num].script[instruction_counter].command = IF_HIT_RIGHT;
           }
           else if (!strcmp (temp, "hit_up")) {
              actor[actor_num].script[instruction_counter].command = IF_HIT_UP;
           }

           fscanf (fp, "%s", temp);
           if (strcmp (temp, "then")) {
               // Missing then ERROR!
               printf ("%d: Missing \'then\'\n in actor:%s",
                       instruction_counter, actor_filename);
           }
        } // end if 'if'

        // endif
        if (!strcmp (command, "endif")) {
           inside_if_block = 0;
           actor[actor_num].script[instruction_counter].command = ENDIF;
           actor[actor_num].script[if_inst_number[--if_nest]].parameter[4] = instruction_counter;
        }

        // move
        if (!strcmp (command, "move")) {
           fscanf (fp, "%s", temp);

           switch (temp[0])
           {
           case 'd':
                actor[actor_num].script[instruction_counter].command = MOVE_DOWN;
                break;
           case 'l':
                actor[actor_num].script[instruction_counter].command = MOVE_LEFT;
                break;
           case 'r':
                actor[actor_num].script[instruction_counter].command = MOVE_RIGHT;
                break;
           case 'u':
                actor[actor_num].script[instruction_counter].command = MOVE_UP;
                break;
           default:
                   // Not a direction ERROR!
                   printf ("%d: Not a direction.\n", instruction_counter);
                break;
           }

           fscanf (fp, "%d", &param);
           actor[actor_num].script[instruction_counter].parameter[0] = param;
        }

        //strike
        if (!strcmp (command, "strike")) {
           actor[actor_num].script[instruction_counter].command = STRIKE;
           fscanf (fp, "%d", &param);
           actor[actor_num].script[instruction_counter].parameter[0] = param;
        }

        // execute:
        if (!strcmp (command, "execute:")) {
           actor[actor_num].execute = instruction_counter;
           actor[actor_num].script[instruction_counter].command = EXECUTE;
           //--instruction_counter;
        }

        // variable
        for (i = 0; i < actor[actor_num].num_variables; i++) {
            if (!strcmp (command, variable_name[i])) {
               break;
            }
        }
        if (i < actor[actor_num].num_variables) { // it's a variable!
            fscanf (fp, "%s", temp);

            if (temp[0] == '=') { // Assignment
               fscanf (fp, "%s", temp2);

               // Check if number or variable
               if (temp2[0] >= '0' && temp2[0] <= '9') { // Number
                   actor[actor_num].script[instruction_counter].command = ASSIGN_VN;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
               }
               else if (temp2[0] == '-') {
                    strcpy (temp, temp2 + sizeof (char)); // remove "-" from string
                    if (temp[0] >= '0' && temp[0] <= '9') // Negative Number
                    {
                       actor[actor_num].script[instruction_counter].command = ASSIGN_VN;
                       actor[actor_num].script[instruction_counter].parameter[0] = i;
                       actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
                    }
                    else {// negative variable
                       for (j = 0; j < actor[actor_num].num_variables; j++) {
                           if (!strcmp (temp, variable_name[j])) {
                              break;
                           }
                       }
                       actor[actor_num].script[instruction_counter].command = NEGASSIGN_VV;
                       actor[actor_num].script[instruction_counter].parameter[0] = i;
                       actor[actor_num].script[instruction_counter].parameter[1] = j;
                    }
               }
               else { // variable
                   for (j = 0; j < actor[actor_num].num_variables; j++) {
                       if (!strcmp (temp2, variable_name[j])) {
                          break;
                       }
                   }
                   // Check if variable exists
                   actor[actor_num].script[instruction_counter].command = ASSIGN_VV;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] = j;
               }
            } // end if '=' (assignment)
            else if (!strcmp (temp, "+=")) { // Addition Assignment
               fscanf (fp, "%s", temp2);

               // Check if number or variable
               if (temp2[0] >= '0' && temp2[0] <= '9') { // Number
                   actor[actor_num].script[instruction_counter].command = ADDASSIGN_VN;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
               }
               else if (temp2[0] == '-' &&
                   temp2[1] >= '0' && temp2[1] <= '9') // Negative Number
               {
                   actor[actor_num].script[instruction_counter].command = ADDASSIGN_VN;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
               }
               else { // variable
                   for (j = 0; j < actor[actor_num].num_variables; j++) {
                       if (!strcmp (temp2, variable_name[j])) {
                          break;
                       }
                   }
                   // Check if variable exists
                   actor[actor_num].script[instruction_counter].command = ADDASSIGN_VV;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] = j;
               }
            } // end if '+=' (addition assignment)
            else if (!strcmp (temp, "-=")) { // Subtraction Assignment
               fscanf (fp, "%s", temp2);

               // Check if number or variable
               if (temp2[0] >= '0' && temp2[0] <= '9') { // Number
                   actor[actor_num].script[instruction_counter].command = SUBASSIGN_VN;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] =
                                                                           atoi (temp2);
               }
               else { // variable
                   for (j = 0; j < actor[actor_num].num_variables; j++) {
                       if (!strcmp (temp2, variable_name[j])) {
                          break;
                       }
                   }
                   // Check if variable exists
                   actor[actor_num].script[instruction_counter].command = SUBASSIGN_VV;
                   actor[actor_num].script[instruction_counter].parameter[0] = i;
                   actor[actor_num].script[instruction_counter].parameter[1] = j;
               }
            } // end if '-=' (subtraction assignment)
            else {
               // Only assignments and addition assignments supported so far ERROR!
               printf ("%d: Only variable assignments and addition assignments supported\n", instruction_counter);
            }
        } // end for

        // Spawning (of other actors)
        if (!strcmp (command, "spawn")) {
            fscanf (fp, "%d", &param);
            actor[actor_num].script[instruction_counter].command = SPAWN;
            actor[actor_num].script[instruction_counter].parameter[0] = param;
        }

        // Termination
        if (!strcmp (command, "terminate")) {
            actor[actor_num].script[instruction_counter].command = TERMINATE;
        }

        // random
        if (!strcmp (command, "random")) {
            fscanf (fp, "%s", temp);

            // Search for variables by that name
            for (i = 0; i < actor[actor_num].num_variables; i++) {
                if (!strcmp (temp, variable_name[i])) {
                   break;
                }
            }
            if (i < actor[actor_num].num_variables) {
                actor[actor_num].script[instruction_counter].command = RANDOM;
                actor[actor_num].script[instruction_counter].parameter[0] = i;
                fscanf (fp, "%d", &param);
                actor[actor_num].script[instruction_counter].parameter[1] = param;
                fscanf (fp, "%d", &param);
                actor[actor_num].script[instruction_counter].parameter[2] = param;
            }
            else {
                 // Not a variable ERROR!
                 printf ("%d: Not a variable\n", instruction_counter);
            }
        } // end if 'random'

        // passable and impassable
        if (!strcmp (command, "passable")) {
           actor[actor_num].script[instruction_counter].command = PASSABLE;
        }
        if (!strcmp (command, "impassable")) {
           actor[actor_num].script[instruction_counter].command = IMPASSABLE;
        }

        // exitstate
        if (!strcmp (command, "exitstate")) {
           actor[actor_num].script[instruction_counter].command = EXITSTATE;
        }

        if (!strcmp (command, "frame")) {
           fscanf (fp, "%d", &param);
           actor[actor_num].script[instruction_counter].command = FRAME;
           actor[actor_num].script[instruction_counter].parameter[0] = param;
        }
        if (!strcmp (command, "target")) {
           fscanf (fp, "%d", &param);
           actor[actor_num].script[instruction_counter].command = TARGET;
           actor[actor_num].script[instruction_counter].parameter[0] = param;
        }
        if (!strcmp (command, "sound")) {
           fscanf (fp, "%d", &param);
           actor[actor_num].script[instruction_counter].command = SOUND;
           actor[actor_num].script[instruction_counter].parameter[0] = param;
        }
        if (!strcmp (command, "spawn_xy")) {
           fscanf (fp, "%d", &param); // actor number
           actor[actor_num].script[instruction_counter].parameter[0] = param;
           fscanf (fp, "%d", &param); // x
           actor[actor_num].script[instruction_counter].parameter[1] = param;
           fscanf (fp, "%d", &param); // y
           actor[actor_num].script[instruction_counter].parameter[2] = param;
        }
        // slight kludge.  Just to simplfy things
        if (!strcmp (command, "spawn_here")) {
            fscanf (fp, "%d", &param);
            actor[actor_num].script[instruction_counter].command = SPAWN_HERE;
            actor[actor_num].script[instruction_counter].parameter[0] = param;
        }

        // done or eof
        if (!strcmp (command, "done") || feof (fp)) {
           done = 1;
           actor[actor_num].script[instruction_counter].command = DONE;
        }

        ++instruction_counter;
    } // end while

    // Estimate number of instructions
    fseek (fp, 0, SEEK_SET);
    i = 0;
    while (!feof (fp)) {
          if (getc (fp) == '\n') {
             ++i;
          }
    }
    fclose (fp);
    //printf ("Instructions: %d\n", instruction_counter);
    //printf ("Estimate: %d\n", i);

    if (actor_num == 3) {
    //fp = fopen ("actor.txt", "wt");

/*    for (i = 0; i < instruction_counter; i++) {
        //fprintf (fp, "Command %2d: %15s %2d %2d\n", i,
                 command_name[actor[actor_num].script[i].command],
                 actor[actor_num].script[i].parameter[0],
                 actor[actor_num].script[i].parameter[1]);
    }*/
    //fclose (fp);
    }

    // For testing
/*  // Simple setup information
    printf ("Name: %s\n", actor[actor_num].name);
    printf ("Offence: %d\n", actor[actor_num].offence);
    printf ("Speed: %d\n", actor[actor_num].speed);
    printf ("HP: %d\n", actor[actor_num].hp);
    printf ("AP: %d\n", actor[actor_num].ap);
    printf ("Control: %d\n", actor[actor_num].control_type);
    printf ("#Frames: %d\n", actor[actor_num].num_frames);
    for (frame = 0; frame < actor[actor_num].num_frames; frame++) {
        printf ("%d ", actor[actor_num].frame[frame]);
    } printf ("\n");
    printf ("#Animations: %d\n", actor[actor_num].num_anim);
    for (anim = 0; anim < num_anim; anim++) {
        printf ("Anim_Length: %s\n", actor[actor_num].anim_length[anim]);
        for (frame = 0; frame < actor[actor_num].anim_length[anim]; frame++) {
            printf ("%s ", actor[actor_num].animation[anim][frame]);
        } printf ("\n");
    }

    //*/

/*  // State information
    printf ("#States: %d\n", actor[actor_num].num_states);
    for (i = 0; i < actor[actor_num].num_states; i++) {
        printf ("State: %s\n", actor[actor_num].state[i].name);
        if (actor[actor_num].state[i].frame_or_animation == 0) {
           printf ("Frame: %d\n", actor[actor_num].state[i].frame);
        }
        else {
           printf ("Animation: %d\n", actor[actor_num].state[i].animation);
        }
    }
//*/

/*    // Strikebox information
    for (i = 0; i < actor[actor_num].num_strikeboxes; i++) {
        printf ("Strikebox #: %d\n", i);
        printf ("(%d, %d)-", actor[actor_num].strikebox[i].left,
                             actor[actor_num].strikebox[i].top);
        printf ("(%d, %d)\n", actor[actor_num].strikebox[i].right,
                              actor[actor_num].strikebox[i].bottom);

        printf ("Type: ");
        if (actor[actor_num].strikebox[i].rel_or_abs == 0) {
           printf ("relative");
        }
        else {
             printf ("absolute");
        }
        printf ("\n");
    }

//*/
    return (actor_num);
} // End Actor_Load

void
Actor_Unload (int actor_num)
{
    int i;

    if (used_actor[actor_num]) {

        --num_actors;
        used_actor[actor_num] = 0;

        for (i = 0; i < actor[actor_num].num_frames; i++) {

            Graphics_Unload_Pic (actor[actor_num].frame[i]);
        }

        for (i = 0; i < actor[actor_num].num_anim; i++) {
            free (actor[actor_num].animation[i]);
        }
        free (actor[actor_num].anim_length);
        free (actor[actor_num].animation);
        free (actor[actor_num].y_frame_offset);
        free (actor[actor_num].x_frame_offset);
        free (actor[actor_num].frame);
    }
} // End Actor_Unload

void
Actor_Update (int actor_num)
{
    int counter, done, jump_to_execute, left, right, top, bottom, i, j, flag;
    static int colour = 0;
    INSTRUCTION *instruction;
    FILE *fp;

    counter = 0;
    done = 0;
    ++actor[actor_num].variable[0]; // framecounter variable
    actor[actor_num].variable[1] = actor[actor_num].x; // x
    actor[actor_num].variable[2] = actor[actor_num].y; // y
    actor[actor_num].variable[5] = actor[actor_num].hp; // hp
    actor[actor_num].variable[6] = actor[actor_num].hp_max; // hp_max
    actor[actor_num].variable[7] = actor[actor_num].struck.damage; // damage received
    actor[actor_num].variable[8] = actor[actor_num].struck.direction; // hit direction

    // If target < 0 then target is central actor
    if (actor[actor_num].target < 0) {
        actor[actor_num].variable[3] = actor[central].x; // target_x
        actor[actor_num].variable[4] = actor[central].y; // target_y
    }
    else {
        actor[actor_num].variable[3] = actor[actor[actor_num].target].x; // target_x
        actor[actor_num].variable[4] = actor[actor[actor_num].target].y; // target_y
    }

    // force damage for standard state
    if (actor[actor_num].struck.hit == 1 &&
        actor[actor_num].standard_state[HURT_STATE] != -1)
    {
        actor[actor_num].current_state = actor[actor_num].standard_state[HURT_STATE];
    }

    //force death for standard state (must be done before and after loop)
    if (actor[actor_num].hp <= 0 &&
        actor[actor_num].standard_state[DEATH_STATE] != -1)
    {
        actor[actor_num].current_state = actor[actor_num].standard_state[DEATH_STATE];
    }

    // Check for game over (assuming that it must be done before and after)
    if (actor[central].hp <= 0 && actor[inactive].hp <= 0) {
       game_over = 1;
    }
 /*   fp = fopen ("actor.txt", "at");
    if (actor[actor_num].name[0] == 'D')
    {
       fprintf (fp, "HP: %d\n", actor[actor_num].variable[5]);
    }*/

    while (!done) {
          instruction = &actor[actor_num].script[counter];



          switch (instruction->command)
          {
          case STATE:
               if (actor[actor_num].current_state !=
                   instruction->parameter[0])
               {
                    // Jump to just past the 'endstate'
                    counter = instruction->parameter[1];// + 1;

                    //instruction = &actor[actor_num].script[counter];

                    // This check doesn't work because the counter is
                    // incremented at the end of the loop
                    //if (instruction->command != STATE) {
                       //printf ("Not state!");
                    //}
               }

               break;
          case ENDSTATE:
               counter = actor[actor_num].execute;// - 1; // To make sure that
               // the correct instruction is executed, must go 1 before
               // execute (work it out)

               // Reset all default variables
               actor[actor_num].variable[1] = actor[actor_num].x; // x
               actor[actor_num].variable[2] = actor[actor_num].y; // y
               actor[actor_num].variable[3] = actor[actor[actor_num].target].x; // target_x
               actor[actor_num].variable[4] = actor[actor[actor_num].target].y; // target_y

               break;
          case ENDSTATE2:
               done = 1;
               //active = 1;
               break;
          case CHANGESTATE: // This does not exitstate
               actor[actor_num].current_state = instruction->parameter[0];
               // Reset framecounter
               actor[actor_num].variable[0] = 0;
               break;
          case CHANGESTATE_V:
               actor[actor_num].current_state =
                     actor[actor_num].variable[instruction->parameter[0]];
               // Reset framecounter
               actor[actor_num].variable[0] = 0;
               break;

          case IF_BUTTON:
               switch (instruction->parameter[0])
               {
               case BUTTON_LEFT:
                    if (!Input_Pressed_Left ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_RIGHT:
                    if (!Input_Pressed_Right ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_UP:
                    if (!Input_Pressed_Up ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_DOWN:
                     if (!Input_Pressed_Down ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_1:
                    if (!Input_Pressed_Button1 ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_2:
                    if (!Input_Pressed_Button2 ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               default:
                    printf ("Unsupported IF_BUTTON");
                    break;
               }
               break;
          case IF_NOT_BUTTON:
               switch (instruction->parameter[0])
               {
               case BUTTON_LEFT:
                    if (Input_Pressed_Left ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_RIGHT:
                    if (Input_Pressed_Right ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_UP:
                    if (Input_Pressed_Up ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_DOWN:
                     if (Input_Pressed_Down ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_1:
                    if (Input_Pressed_Button1 ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               case BUTTON_2:
                    if (Input_Pressed_Button2 ()) {
                       //active = 0;
                       counter = instruction->parameter[4];
                    }
                    break;
               default:
                    printf ("Unsupported IF_NOT_BUTTON");
                    break;
               }
               break;
          case ENDIF:
                  //active = 1;
               break;
          case MOVE_LEFT:
               if (actor[actor_num].active) {
                  actor[actor_num].x -= instruction->parameter[0];

                  if (actor_num == central) {
                     flag = 0;
                     if (actor[actor_num].x < Camera_Get_X () + left_scroll) {
                        Camera_Move_Position (-instruction->parameter[0], 0);
                        flag = 1;
                     }
                  }

                  if (Actor_Collision (actor_num)) {
                        actor[actor_num].x += instruction->parameter[0];

                     if (actor_num == central) {
                        if (flag && !Camera_At_Edge ()) {
                           Camera_Move_Position (instruction->parameter[0], 0);
                        }
                     }
                  }

               }
               break;
          case MOVE_RIGHT:
               if (actor[actor_num].active) {
                  actor[actor_num].x += instruction->parameter[0];

                  if (actor_num == central) {
                     flag = 0;
                     if (actor[actor_num].x > Camera_Get_X () + right_scroll) {
                        Camera_Move_Position (instruction->parameter[0], 0);
                        flag = 1;
                     }
                  }

                  if (Actor_Collision (actor_num)) {
                     actor[actor_num].x -= instruction->parameter[0];

                     if (actor_num == central) {
                        if (flag && !Camera_At_Edge ()) {
                           Camera_Move_Position (-instruction->parameter[0], 0);
                        }
                     }
                  }
               }
               break;
          case MOVE_UP:
               if (actor[actor_num].active) {
                  actor[actor_num].y -= instruction->parameter[0];

                  if (actor_num == central) {
                     flag = 0;
                     if (actor[actor_num].y < Camera_Get_Y () + high_scroll) {
                        Camera_Move_Position (0, -instruction->parameter[0]);
                        flag = 1;
                     }
                  }

                  if (Actor_Collision (actor_num)) {
                     actor[actor_num].y += instruction->parameter[0];

                     if (actor_num == central) {
                        if (flag && !Camera_At_Edge ()) {
                           Camera_Move_Position (0, instruction->parameter[0]);
                        }
                     }
                  }
               }
               break;
          case MOVE_DOWN:
               if (actor[actor_num].active) {
                  actor[actor_num].y += instruction->parameter[0];

                  if (actor_num == central) {
                     flag = 0;

                     if (actor[actor_num].y > Camera_Get_Y () + low_scroll) {
                        Camera_Move_Position (0, instruction->parameter[0]);
                        flag = 1;
                     }
                  }

                  if (Actor_Collision (actor_num)) {
                     actor[actor_num].y -= instruction->parameter[0];

                     if (actor_num == central) {
                        if (flag && !Camera_At_Edge ()) {
                           Camera_Move_Position (0, -instruction->parameter[0]);
                        }
                     }
                  }
               }
               break;
          case STRIKE:
               // Determine if any actors are hit
               // Determine if they are on your team
               // Determine if the are vulnerable
               // Signal that they are hit
               left = actor[actor_num].strikebox[instruction->parameter[0]].left;
               right = actor[actor_num].strikebox[instruction->parameter[0]].right;
               top = actor[actor_num].strikebox[instruction->parameter[0]].top;
               bottom = actor[actor_num].strikebox[instruction->parameter[0]].bottom;

               if (actor[actor_num].strikebox[instruction->parameter[0]].rel_or_abs ==
                   ACTOR_RELATIVE)
               {
                    #ifdef TESTING
                    Graphics_Draw_Box (16 + left + actor[actor_num].x - Camera_Get_X (),
                                       20 + top + actor[actor_num].y - Camera_Get_Y (),
                                       16 + right + actor[actor_num].x - Camera_Get_X (),
                                       20 + bottom + actor[actor_num].y - Camera_Get_Y (),
                                       colour++);
                    #endif

                    Set_Struck (&actor[actor_num], left + actor[actor_num].x,
                                   top + actor[actor_num].y,
                                   right + actor[actor_num].x,
                                   bottom + actor[actor_num].y,
                                   0, 0,
                                   actor[actor_num].strikebox[instruction->parameter[0]].direction);
               }
               else {
                    #ifdef TESTING
                    Graphics_Draw_Box (16 + left - Camera_Get_X (),
                                       20 + top - Camera_Get_Y (),
                                       16 + right - Camera_Get_X (),
                                       20 + bottom - Camera_Get_Y (),
                                       colour++);
                    #endif

                    Set_Struck (&actor[actor_num], left, top, right, bottom,
                                0, 0,
                                actor[actor_num].strikebox[instruction->parameter[0]].direction);
               }
               if (colour > 255) {
                   colour = 0;
               }

               break;
          case IF_VARIABLE:
               // Used for boolean?
               break;
          case IF_EQUAL_VN:
               if (actor[actor_num].variable[instruction->parameter[0]] !=
                   instruction->parameter[1])
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_GREATER_VN:
               if (actor[actor_num].variable[instruction->parameter[0]] <=
                   instruction->parameter[1])
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_LESS_VN:
               if (actor[actor_num].variable[instruction->parameter[0]] >=
                   instruction->parameter[1])
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_EQUAL_VV:
               if (actor[actor_num].variable[instruction->parameter[0]] !=
                   actor[actor_num].variable[instruction->parameter[1]])
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_GREATER_VV:
               if (actor[actor_num].variable[instruction->parameter[0]] <=
                   actor[actor_num].variable[instruction->parameter[1]])
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_LESS_VV:
               if (actor[actor_num].variable[instruction->parameter[0]] >=
                   actor[actor_num].variable[instruction->parameter[1]])
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_HIT:
               if (actor[actor_num].struck.hit != 1) {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_NOT_HIT:
               if (actor[actor_num].struck.hit == 1) {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_HIT_LEFT:
               if (actor[actor_num].struck.hit != 1 ||
                   actor[actor_num].struck.direction != HIT_LEFT)
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_HIT_DOWN:
               if (actor[actor_num].struck.hit != 1 ||
                   actor[actor_num].struck.direction != HIT_DOWN)
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_HIT_RIGHT:
               if (actor[actor_num].struck.hit != 1 ||
                   actor[actor_num].struck.direction != HIT_RIGHT)
               {
                  counter = instruction->parameter[4];
               }
               break;
          case IF_HIT_UP:
               if (actor[actor_num].struck.hit != 1 ||
                   actor[actor_num].struck.direction != HIT_UP)
               {
                  counter = instruction->parameter[4];
               }
               break;
          case ASSIGN_VN:
               actor[actor_num].variable[instruction->parameter[0]] =
                                                      instruction->parameter[1];
               break;
          case ASSIGN_VV:
               actor[actor_num].variable[instruction->parameter[0]] =
               actor[actor_num].variable[instruction->parameter[1]];
               break;
          case SPAWN:
               actor[instruction->parameter[0]].active = 1;
               actor[instruction->parameter[0]].hp = actor[instruction->parameter[0]].hp_max;
               actor[instruction->parameter[0]].current_state = 0; // Spawning
               break;
          case TERMINATE:
               actor[actor_num].active = 0;
               break;
          case RANDOM:
               actor[actor_num].variable[instruction->parameter[0]] =
               instruction->parameter[1] +
               rand () % (instruction->parameter[2] - instruction->parameter[1] + 1);
               break;
          case PASSABLE:
               actor[actor_num].impassable = 0;
               break;
          case IMPASSABLE:
               actor[actor_num].impassable = 1;
               break;
          case ADDASSIGN_VN:
               actor[actor_num].variable[instruction->parameter[0]] +=
                                                      instruction->parameter[1];
               break;
          case ADDASSIGN_VV:
               actor[actor_num].variable[instruction->parameter[0]] +=
               actor[actor_num].variable[instruction->parameter[1]];
               break;
          case SUBASSIGN_VN:
               actor[actor_num].variable[instruction->parameter[0]] -=
                                                      instruction->parameter[1];
               break;
          case SUBASSIGN_VV:
               actor[actor_num].variable[instruction->parameter[0]] -=
               actor[actor_num].variable[instruction->parameter[1]];
               break;
          case EXITSTATE:
               while (instruction->command != ENDSTATE &&
                      instruction->command != DONE)
               {
                     ++counter;
                     instruction = &actor[actor_num].script[counter];
               }
               --counter;
               break;
          case FRAME:
               break;
          case TARGET:
               actor[actor_num].target = instruction->parameter[0];
               break;
          case SOUND:
               Sound_Play (sound_list[instruction->parameter[0]]);
               break;
          case SPAWN_XY:
               actor[instruction->parameter[0]].active = 1;
               actor[instruction->parameter[0]].hp = actor[instruction->parameter[0]].hp_max;
               actor[instruction->parameter[0]].current_state = 0; // Spawning
               actor[instruction->parameter[0]].x = instruction->parameter[1];
               actor[instruction->parameter[0]].y = instruction->parameter[2];
               break;
          case SPAWN_HERE:
               actor[instruction->parameter[0]].active = 1;
               actor[instruction->parameter[0]].hp = actor[instruction->parameter[0]].hp_max;
               actor[instruction->parameter[0]].current_state = 0; // Spawning
               actor[instruction->parameter[0]].x = actor[actor_num].x;
               actor[instruction->parameter[0]].y = actor[actor_num].y;
               break;
          case NEGASSIGN_VV:
               actor[actor_num].variable[instruction->parameter[0]] =
               -actor[actor_num].variable[instruction->parameter[1]];
               break;
          case EXECUTE:
               break;
          case DONE:
               done = 1;
               //active = 1;
               break;
          default:
               // The parser did something wrong ERROR!
               printf ("Not a command.  Parser error. %d", instruction->command);
               break;
          }

          ++counter;
    } // end while

   //fclose (fp);

    // Setup new hp value
    actor[actor_num].hp = actor[actor_num].variable[5];

    //force death for standard state (must be done before and after loop)
    if (actor[actor_num].hp <= 0 &&
        actor[actor_num].standard_state[DEATH_STATE] != -1)
    {
        actor[actor_num].current_state = actor[actor_num].standard_state[DEATH_STATE];
    }

} // End Actor_Update

void
Actor_Display (int actor_num)
{
    int curr_frame, framecounter, num_anim_frames, height;
    STATE_TYPE *curr_state;
    ACTOR *the_actor;

    // Convenience
    the_actor = &actor[actor_num];
    curr_state = &the_actor->state[the_actor->current_state];

    if (curr_state->frame_or_animation == ACTOR_FRAME) {

       curr_frame = curr_state->frame;
    }
    else { // Animation

       framecounter = the_actor->variable[0];
       num_anim_frames = the_actor->anim_length[curr_state->animation];
       curr_frame = the_actor->animation[curr_state->animation]
                                        [framecounter % num_anim_frames];
    }

    Graphics_Draw_Pic (the_actor->x - the_actor->x_frame_offset[curr_frame],
                       the_actor->y - the_actor->y_frame_offset[curr_frame],
                       the_actor->frame[curr_frame]);
    Graphics_Draw_Pixel (the_actor->x, the_actor->y, 17);
} // End Actor_Display

void
Actor_Display_All (void)
{
    int curr_frame, framecounter, num_anim_frames, height;
    int actor_num, order[ACTOR_MAX][2], done, i, j, key[2];
    STATE_TYPE *curr_state;
    ACTOR *the_actor, *central_actor;

    // Initialize order
    for (i = 0; i < num_actors; i++) {
        order[i][0] = actor[i].y;
        order[i][1] = i;
    }

    // Sort here
    Insertion_Sort (order);

    // Convenience
    for (actor_num = 0; actor_num < num_actors; actor_num++) {

        the_actor = &actor[order[actor_num][1]];
        curr_state = &the_actor->state[the_actor->current_state];
        central_actor = &actor[central];

        if (the_actor->active) {
           if (curr_state->frame_or_animation == ACTOR_FRAME) {

                curr_frame = curr_state->frame;
           }
           else { // Animation

                framecounter = the_actor->variable[0];
                num_anim_frames = the_actor->anim_length[curr_state->animation];
                curr_frame = the_actor->animation[curr_state->animation]
                                             [framecounter % num_anim_frames];
           }

           Graphics_Draw_Pic (16 + the_actor->x - Camera_Get_X () -
                              the_actor->x_frame_offset[curr_frame],
                              20 + the_actor->y - Camera_Get_Y () -
                              the_actor->y_frame_offset[curr_frame],
                              the_actor->frame[curr_frame]);

           #ifdef TESTING
           for (i = 0; i < the_actor->num_strikeboxes; i++) {
                if (the_actor->strikebox[i].rel_or_abs == ACTOR_RELATIVE) {
                   Graphics_Draw_Box_Outline
                   (16 + the_actor->x + the_actor->strikebox[i].left - Camera_Get_X (),
                    20 + the_actor->y + the_actor->strikebox[i].top - Camera_Get_Y (),
                    16 + the_actor->x + the_actor->strikebox[i].right - Camera_Get_X (),
                    20 + the_actor->y + the_actor->strikebox[i].bottom - Camera_Get_Y (),
                    32);
                }
                else {
                   Graphics_Draw_Box_Outline
                   (16 + the_actor->strikebox[i].left - Camera_Get_X (),
                    20 + the_actor->strikebox[i].top - Camera_Get_Y (),
                    16 + the_actor->strikebox[i].right - Camera_Get_X (),
                    20 + the_actor->strikebox[i].bottom - Camera_Get_Y (),
                    32);
                }
            }

           Graphics_Draw_Box_Outline (16 + the_actor->x - Camera_Get_X (),
                                      20 + the_actor->y - Camera_Get_Y (),
                                      16 + the_actor->x - Camera_Get_X () + the_actor->width,
                                      20 + the_actor->y - Camera_Get_Y () - the_actor->y_offset,
                                      48);

           Graphics_Draw_Box_Outline (16 + the_actor->x - Camera_Get_X (),
                                      20 + the_actor->y - Camera_Get_Y (),
                                      16 + the_actor->x - Camera_Get_X () + the_actor->width,
                                      20 + the_actor->y - Camera_Get_Y () - the_actor->height,
                                      40);

           Graphics_Draw_Pixel (16 + the_actor->x - Camera_Get_X (),
                                20 + the_actor->y - Camera_Get_Y (), 17);


           #endif
        } // end if active
    }

    Life_Bar (central, 50, 22, 9);
    Life_Bar (actor[central].target, 200, 22, 4);
} // End Actor_Display_All

static int
Count_Instructions (FILE *fp)
{
    return (0);
}

void
Actor_Update_All (void)
{
    int actor_num;

    for (actor_num = 0; actor_num < num_actors; actor_num++) {
//    for (actor_num = num_actors-1; actor_num >= 0; actor_num--) {
        if (actor[actor_num].active) {
           Actor_Update (actor_num);
        }
    }

    // Clear out strikes
    for (actor_num = 0; actor_num < num_actors; actor_num++) {
        if (actor[actor_num].struck.hit) {
           --actor[actor_num].struck.hit;
        }
    }
}

static void
Insertion_Sort (int order[ACTOR_MAX][2])
{
    int i, j, key[2];

    for (j = 1; j < num_actors; j++) {
        key[0] = order[j][0];
        key[1] = order[j][1];
        i = j - 1;
        while (i >= 0 && order[i][0] > key[0]) {
              order[i + 1][0] = order[i][0];
              order[i + 1][1] = order[i][1];
              i = i - 1;
        }
        order[i + 1][0] =  key[0];
        order[i + 1][1] =  key[1];
    }
}

static void
Set_Struck (ACTOR *attacker, int left, int top, int right, int bottom,
            int damage, int type, int direction)
{
    int i;
    ACTOR *the_actor;
    FILE *fp;

    for (i = 0; i < num_actors; i++) {

        the_actor = &actor[i];
        if (the_actor->active) {
           if (the_actor->team != attacker->team) {
               if (the_actor->x < right &&
                  the_actor->x > left - the_actor->width && // avoid classic mistake
                  the_actor->y < bottom + the_actor->height && // avoid classic mistake
                  the_actor->y > top)
               {
                    the_actor->struck.hit = 2;
                    the_actor->struck.damage = attacker->offence;
                    the_actor->struck.type = type;
                    the_actor->struck.direction = direction;

                    Graphics_Emit_Particles (
                      16 + the_actor->x - Camera_Get_X () +
                      the_actor->width / 2,
                      20 + the_actor->y - Camera_Get_Y () -
                      the_actor->height / 2,
                      0, -5, the_actor->blood_colour);
                    // Change target
                    if (attacker == &actor[central]) { //[0]
                       attacker->target = i;
                    }
               }
           }
        }
    }
}


static int
Actor_Collision (int actor_num)
{
    int j, left, right, top, bottom, tile_width, tile_height, x, y;
    ACTOR *actor1, *actor2;
    FILE *fp; int flag = 0;

    actor1 = &actor[actor_num];
    tile_width = Map_Get_Tile_Width ();
    tile_height = Map_Get_Tile_Height ();

    // Check collisions against other actors
    for (j = 0; j < num_actors; j++) {

        if (j != actor_num && actor[j].active) { // Don't check collision with self

            actor2 = &actor[j];

            if (actor1->impassable || actor2->impassable) {
               if (abs (actor1->x - actor2->x) < 200 &&
                   abs (actor1->y - actor2->y) < 200)
               {
                  if (actor1->x < actor2->x + actor2->width &&
                      actor2->x < actor1->x + actor1->width &&
                      actor1->y > actor2->y - actor2->height &&
                      actor2->y > actor1->y - actor1->height)
                  {

                        return (1);
                  }
               }
            }
        }

    }

    // Check collisions against map
    left = actor1->x / tile_width;
    bottom = actor1->y / tile_height;
    right = (actor1->x + actor->width) / tile_width;
    top = (actor1->y - actor->height) / tile_height;

    for (y = top; y < bottom + 1; y++) {
        if (Map_Solid_Tile (left, y) ||
            Map_Solid_Tile (right, y))
        {
            return (1);
        }
    }

    for (x = left; x < right; x++) {
        if (Map_Solid_Tile (x, bottom) ||
            Map_Solid_Tile (x, top))
        {
            return (1);
        }
    }

    return (0);
}

int
Actor_Get_X (int actor_num)
{
    if (actor_num < 0) {
       return (actor[central].x);
    }
    return (actor[actor_num].x);
}

int
Actor_Get_Y (int actor_num)
{
    if (actor_num < 0) {
       return (actor[central].y);
    }
    return (actor[actor_num].y);
}

int
Actor_Get_Width (int actor_num)
{
    if (actor_num < 0) {
       return (actor[central].width);
    }
    return (actor[actor_num].width);
}

int
Actor_Get_Height (int actor_num)
{
    if (actor_num < 0) {
       return (actor[central].height);
    }
    return (actor[actor_num].height);
}

static void
Life_Bar (int actor_num, int x, int y, int colour)
{
    int name_length;

    // Avoid life bars of unhit or dead people
    if (actor_num > -1) {
    if (actor[actor_num].hp > 0) {

    for (name_length = 0; name_length < (int)sizeof(actor[actor_num].name);
         name_length++)
    {
        if (actor[actor_num].name[name_length] == '\0') {
           break;
        }
    }

    Graphics_Draw_Box (x - 8, y, (x + 8) + name_length * 8, y + 8, 21);
    Graphics_Draw_Text (x, y, 16, actor[actor_num].name);
    if (actor[actor_num].hp > 0) {
        Graphics_Draw_Box (x, (y + 10), x + actor[actor_num].hp * 4, (y + 10) + 4, colour);
    }

    } // end if actor.hp > 0
    } // end if actor_num > -1
}

void
Actor_Set_X (int actor_num, int x)
{
    if (actor_num < 0) {
       actor[central].x = x;
    }
    else {
       actor[actor_num].x = x;
    }
}

void
Actor_Set_Y (int actor_num, int y)
{
    if (actor_num < 0) {
       actor[central].y = y;
    }
    else {
       actor[actor_num].y = y;
    }
}

void
Actor_Set_Active (int actor_num, int active)
{
    actor[actor_num].active = active;
    actor[actor_num].current_state = 0; //spawning
}

void
Actor_Set_Team (int actor_num, int team)
{
    actor[actor_num].team = team;
}

void
Actor_Set_Target (int actor_num, int target)
{
    actor[actor_num].target = target;
}

/*void
Actor_Strike (int actor_num, int strikebox)
{
    int left, right, top, bottom;

    left = actor[actor_num].strikebox[instruction->parameter[0]].left;
    right = actor[actor_num].strikebox[instruction->parameter[0]].right;
    top = actor[actor_num].strikebox[instruction->parameter[0]].top;
    bottom = actor[actor_num].strikebox[instruction->parameter[0]].bottom;

    Set_Struck (&actor[actor_num], left + actor[actor_num].x,
                top + actor[actor_num].y,
                right + actor[actor_num].x,
                bottom + actor[actor_num].y,
                0, 0,
                actor[actor_num].strikebox[instruction->parameter[0]].direction);
}*/

int
Actor_Switch (int switch_sound)
{
    int temp;

    actor[inactive].x = actor[central].x;
    actor[inactive].y = actor[central].y;

    // Don't bring 'em back dead!
    if (actor[central].hp > 0)
    {
        actor[inactive].current_state = actor[central].current_state;
    }
    else {
        if (actor[inactive].hp > 0) {
           actor[inactive].current_state = 0; // spawning
        }
    }

    // Don't allow switching to a dead character
    if (actor[inactive].hp > 0) {
       // Switch them!
       temp = central;
       central = inactive;
       inactive = temp;

       actor[central].active = 1;
       actor[inactive].active = 0;

       Sound_Play (switch_sound);
       return (1);
    }

    return (0);
}

void
Actor_Set_Sounds (int *effect_list, int number_of_sounds)
{
    int i;

    // Unload sounds
    for (i = 0; i < num_sounds; i++) {

        Sound_Unload (sound_list[i]);
        sound_list[i] = -1;
    }

    num_sounds = number_of_sounds;

    for (i = 0; i < num_sounds; i++) {

        sound_list[i] = effect_list[i];
    }
} // end Actor_Set_Sounds

int
Actor_Get_HP (int actor_num) {

    return (actor[actor_num].hp);
}
