// Trigger header
// June 8, 2002
// Copyright Kwame Alexander
// I will kill you if you copy this

#ifndef TRIGGER_MODULE
#define TRIGGER_MODULE

#include <string.h>
#include "input100.h"
#include "actor100.h"
#include "map100.h"
#include "cinma100.h"

// Trips
#define ACTOR_POS           0
#define BUTTON_1_HIT        1
#define BUTTON_2_HIT        2
#define ACTOR_FACING_DIR    3
#define TRIGGER_TRIPPED     4
#define ACTOR_ALIVE         5
#define ACTOR_DEAD          6
#define ACTOR_REL_POS       7
#define ACTOR_AREA_POS      8
#define ACTOR_TILE_POS      9
#define NOT_TRIPPED         10
#define SPACEBAR_HIT        11

// Effects
#define LEVEL       0
#define PLAY_MOVIE  1
#define ACTIVATE    2
#define DEACTIVATE  3
#define PLACE       4
#define UNTRIP      5
#define TEXTBOX     6
#define MUSIC_PLAY  7
#define MUSIC_STOP  8
#define SOUND_PLAY  9
#define TRIP        10
#define GAME_OVER   11

#define MAX_TRIPS       15
#define MAX_EFFECTS     15
#define MAX_TRIGGERS    10

#define TRIGGER_MAX_SOUNDS 5

typedef struct
{
    int trip[MAX_TRIPS][6]; // command+5 args
    int effect[MAX_EFFECTS][4]; // command+3 args
    int num_trips;
    int num_effects;
    int tripped;
    char effect_arg[MAX_EFFECTS][30]; // for filenames and the like
} TRIGGER;

void Trigger_Initialize (void);
void Trigger_Shutdown (void);
void Trigger_Test (void);
void Trigger_Load (char *filename);
#endif
