// Trigger module
// June 8, 2002
// Copyright Kwame Alexander
// I will kill you if you copy this

#include "trigr100.h"

extern volatile int counter;
extern int game_over;

static int num_triggers, music[MAX_MUSIC], num_music;
static int sound_list[TRIGGER_MAX_SOUNDS], num_sounds;
TRIGGER trigger[MAX_TRIGGERS];

static int Trigger_Num (char *trig_name);
static void Delay (int duration);

void
Trigger_Initialize (void)
{
    int i;

    num_music = 0;
    num_sounds = 0;

    for (i = 0; i < TRIGGER_MAX_SOUNDS; i++) {
        sound_list[i] = -1;
    }

    for (i = 0; i < MAX_MUSIC; i++) {
        music[i] = -1;
    }
}

void
Trigger_Shutdown (void)
{
}

void
Trigger_Test (void)
{
    int trig_num, i, arg[5], j, tripped, level_changed;
    int x, y, actor_x, actor_y, left, right, bottom, top;
    FILE *fp;

    //trig_num = Trigger_Num (trig_name);
    for (trig_num = 0; trig_num < num_triggers; trig_num++) {

    // Don't bother processing if trigger has already
    // been tripped.  Indent properly later.
    if (!trigger[trig_num].tripped) {

    // if any trip is missed, then the
    // trigger has not been tripped
    for (i = 0; i < trigger[trig_num].num_trips; i++) {

        tripped = 0;

        // set up arguments
        for (j = 0; j < 5; j++) {
            arg[j] = trigger[trig_num].trip[i][j + 1];
        }

        switch (trigger[trig_num].trip[i][0])
        {
        case ACTOR_POS:
             if (Actor_Get_X (arg[0]) == arg[1] &&
                 Actor_Get_Y (arg[0]) == arg[2])
             {
                 tripped = 1;
             }
             break;
        case ACTOR_TILE_POS:

             left =  Actor_Get_X (arg[0]) / Map_Get_Tile_Width ();
             bottom = Actor_Get_Y (arg[0]) / Map_Get_Tile_Height ();
             right = (Actor_Get_X (arg[0]) + Actor_Get_Width (arg[0]))
                     / Map_Get_Tile_Width ();
             top = (Actor_Get_Y (arg[0]) - Actor_Get_Height (arg[0]))
                   / Map_Get_Tile_Height ();

             for (y = top; y < bottom + 1; y++) {
                for (x = left; x < right + 1; x++) {
                    if (x == arg[1] && y == arg[2]) {

                        tripped = 1;
                        break;
                    }
                }
                //if (tripped) {
                  // break;
                //}
             }

             break;
        case BUTTON_1_HIT:
             if (Input_Pressed_Button1 ()) {
                tripped = 1;
             }
             break;
        case BUTTON_2_HIT:
             if (Input_Pressed_Button2 ()) {
                tripped = 1;
             }
             break;
        case SPACEBAR_HIT:
             if (Input_Pressed_Scan (KEY_SPACE)) {
                tripped = 1;
             }
             break;
        case ACTOR_FACING_DIR:
             // Not useable right now
             break;
        case TRIGGER_TRIPPED:
             if (trigger[arg[0]].tripped) {
                tripped = 1;
             }
             break;
        case ACTOR_ALIVE:
             if (Actor_Get_HP (arg[0]) > 0) {
                tripped = 1;
             }
             break;
        case ACTOR_DEAD:
             if (Actor_Get_HP (arg[0]) <= 0) {
                tripped = 1;
             }
             break;
        case ACTOR_REL_POS: // may remove or adjust
             if (arg[2] == Actor_Get_X (arg[0]) -
                           Actor_Get_X (arg[1]) &&
                 arg[3] == Actor_Get_Y (arg[0]) -
                           Actor_Get_Y (arg[1]))
             {
                tripped = 1;
             }
             break;
        case NOT_TRIPPED:
             if (!trigger[trig_num].tripped) {
                tripped = 1;
             }
             break;
        default:
             //error
             break;
        } // end switch

        if (!tripped) {
           break;
        }
    } // end for

    // Trip trigger
    if (tripped) {
        trigger[trig_num].tripped = 1;

        level_changed = 0;

        // Execute effects here
        for (i = 0; i < trigger[trig_num].num_effects; i++) {

            // set up arguments
            for (j = 0; j < 3; j++) {
                arg[j] = trigger[trig_num].effect[i][j + 1];
            }

            switch (trigger[trig_num].effect[i][0])
            {
            case LEVEL:
                 Map_Load (trigger[trig_num].effect_arg[i],
                           trigger[trig_num].effect[i][1]);
                 level_changed = 1;
                 break;
            case PLAY_MOVIE:
                 Cinema_Play ();
                 break;
            case ACTIVATE:
                 Actor_Set_Active (arg[0], 1);
                 break;
            case DEACTIVATE:
                 Actor_Set_Active (arg[0], 0);
                 break;
            case PLACE:
                 Actor_Set_X (arg[0], arg[1]);
                 Actor_Set_Y (arg[0], arg[2]);
                 break;
            case UNTRIP:
                 trigger[arg[0]].tripped = 0;
                 break;
            case TEXTBOX:
                 Map_Display_Text (arg[0], arg[1]);
                 Map_Clip ();
                 Graphics_Draw_Screen ();
                 while (Input_Pressed_Scan (KEY_SPACE)); // wait for release
                 while (!Input_Pressed_Scan (KEY_SPACE)); // wait for press
                 while (Input_Pressed_Scan (KEY_SPACE)); // wait for release
                 // Erase textbox by overwriting it with the background
                 Map_Render_Back ();
                 Actor_Display_All ();
                 Map_Clip ();
                 break;
            case MUSIC_PLAY:
                 Music_Play (music[arg[0]]);
                 break;
            case MUSIC_STOP:
                 Music_Stop ();
                 break;
            case SOUND_PLAY:
                 Sound_Play (sound_list[arg[0]]);
                 break;
            case TRIP:
                 trigger[arg[0]].tripped = 1;
                 break;
            case GAME_OVER:
                 game_over = 1;
                 break;
            default:
                 // Error
                 break;
            } // end switch

            // Must break out of loop if level has changed
            // to avoid executing effects of the next trigger
            if (level_changed) {
               break;
            }
        } // end for
    }

    } // end if already tripped (indent later)

    } // end for (trig_num)
} // End Trigger_Test

void
Trigger_Load (char *filename)
{
    int i, j;
    char dummy[30], trip[20], effect[20];
    FILE *fp;


    if ((fp = fopen (filename, "rt")) != NULL) {

        for (i = 0; i < MAX_MUSIC; i++) {
            Music_Unload (music[i]);
            music[i] = -1;
        }

        for (i = 0; i < TRIGGER_MAX_SOUNDS; i++) {
            Sound_Unload (sound_list[i]);
            sound_list[i] = -1;
        }

        fscanf (fp, "%d", &num_triggers);

        for (i = 0; i < num_triggers; i++) {

            fscanf (fp, "%s", dummy); // Comment
            fscanf (fp, "%d", &trigger[i].num_trips);

            for (j = 0; j < trigger[i].num_trips; j++) {

                fscanf (fp, "%s", trip);

                if (!strcasecmp (trip, "actor_pos")) {

                    trigger[i].trip[j][0] = ACTOR_POS;
                    fscanf (fp, "%d", &trigger[i].trip[j][1]);
                    fscanf (fp, "%d", &trigger[i].trip[j][2]);
                    fscanf (fp, "%d", &trigger[i].trip[j][3]);
                }
                else if (!strcasecmp (trip, "button_1_hit")) {

                    trigger[i].trip[j][0] = BUTTON_1_HIT;
                }
                else if (!strcasecmp (trip, "button_2_hit")) {

                    trigger[i].trip[j][0] = BUTTON_2_HIT;
                }
                else if (!strcasecmp (trip, "spacebar_hit")) {

                    trigger[i].trip[j][0] = SPACEBAR_HIT;
                }
                else if (!strcasecmp (trip, "actor_facing_dir")) {
                }
                else if (!strcasecmp (trip, "trigger_tripped")) {
                     trigger[i].trip[j][0] = TRIGGER_TRIPPED;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                }
                else if (!strcasecmp (trip, "actor_alive")) {
                     trigger[i].trip[j][0] = ACTOR_ALIVE;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                }
                else if (!strcasecmp (trip, "actor_dead")) {

                     trigger[i].trip[j][0] = ACTOR_DEAD;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                }
                else if (!strcasecmp (trip, "actor_rel_pos")) {

                     trigger[i].trip[j][0] = ACTOR_REL_POS;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                     fscanf (fp, "%d", &trigger[i].trip[j][2]);
                     fscanf (fp, "%d", &trigger[i].trip[j][3]);
                     fscanf (fp, "%d", &trigger[i].trip[j][4]);
                }
                else if (!strcasecmp (trip, "actor_area_pos")) {

                     trigger[i].trip[j][0] = ACTOR_AREA_POS;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                     fscanf (fp, "%d", &trigger[i].trip[j][2]);
                     fscanf (fp, "%d", &trigger[i].trip[j][3]);
                     fscanf (fp, "%d", &trigger[i].trip[j][4]);
                     fscanf (fp, "%d", &trigger[i].trip[j][5]);
                }
                else if (!strcasecmp (trip, "actor_tile_pos")) {
                     trigger[i].trip[j][0] = ACTOR_TILE_POS;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                     fscanf (fp, "%d", &trigger[i].trip[j][2]);
                     fscanf (fp, "%d", &trigger[i].trip[j][3]);
                }
                else if (!strcasecmp (trip, "not_tripped")) {
                     trigger[i].trip[j][0] = NOT_TRIPPED;
                     fscanf (fp, "%d", &trigger[i].trip[j][1]);
                }
                else {
                     // Error
                }
            } // end for trips

            fscanf (fp, "%d", &trigger[i].num_effects);

            for (j = 0; j < trigger[i].num_effects; j++) {

                fscanf (fp, "%s", effect);

                if (!strcasecmp (effect, "level")) {

                    trigger[i].effect[j][0] = LEVEL;
                    fscanf (fp, "%s", trigger[i].effect_arg[j]);
                    fscanf (fp, "%d", &trigger[i].effect[j][1]); //starting point
                }
                else if (!strcasecmp (effect, "play_movie")) {

                    trigger[i].effect[j][0] = PLAY_MOVIE;
                }
                else if (!strcasecmp (effect, "activate")) {

                    trigger[i].effect[j][0] = ACTIVATE;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]);
                }
                else if (!strcasecmp (effect, "deactivate")) {

                    trigger[i].effect[j][0] = DEACTIVATE;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]);
                }
                else if (!strcasecmp (effect, "place")) {

                    trigger[i].effect[j][0] = PLACE;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]);
                    fscanf (fp, "%d", &trigger[i].effect[j][2]);
                    fscanf (fp, "%d", &trigger[i].effect[j][3]);
                }
                else if (!strcasecmp (effect, "untrip")) {

                    trigger[i].effect[j][0] = UNTRIP;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]);
                }
                else if (!strcasecmp (effect, "textbox")) {

                    trigger[i].effect[j][0] = TEXTBOX;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]);
                    fscanf (fp, "%s", dummy);

                    switch (dummy[0])
                    {
                    case 'B':
                    case 'b':
                         trigger[i].effect[j][2] = CINEMA_BOTTOM;
                         break;
                    default:
                         trigger[i].effect[j][2] = CINEMA_TOP;
                         break;
                    }
                }
                else if (!strcasecmp (effect, "music_play")) {

                    trigger[i].effect[j][0] = MUSIC_PLAY;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]); // music_num
                }
                else if (!strcasecmp (effect, "music_stop")) {

                    trigger[i].effect[j][0] = MUSIC_STOP;
                }
                else if (!strcasecmp (effect, "sound")) {

                    trigger[i].effect[j][0] = SOUND_PLAY;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]); // sound_num
                }
                else if (!strcasecmp (effect, "trip")) {

                    trigger[i].effect[j][0] = TRIP;
                    fscanf (fp, "%d", &trigger[i].effect[j][1]);
                }
                else if (!strcasecmp (effect, "game_over")) {

                    trigger[i].effect[j][0] = GAME_OVER;
                }
                else {
                    // Error
                }
            } // end for effects

            trigger[i].tripped = 0;
        } // end for triggers

        // Load music
        fscanf (fp, "%d", &num_music);
        for (i = 0; i < num_music; i++) {

            fscanf (fp, "%s", dummy);
            music[i] = Music_Load (dummy);
        }

        // Load sounds
        fscanf (fp, "%d", &num_sounds);
        for (i = 0; i < num_sounds; i++) {

            fscanf (fp, "%s", dummy);
            sound_list[i] = Sound_Load (dummy);
        }

        fclose (fp);
    }
    else {
         //Error
    }

} // End Trigger_Load

static void
Delay (int duration)
{
    int time_keeper;

    time_keeper = counter;
    while (counter < time_keeper + duration);
}
