// Music module
// June 16, 2002
// Copyright Kwame Alexander
// I will kill you if you copy this

#include "music100.h"

static int loaded[MAX_MUSIC], current, installed = 0;
static MIDI *song[MAX_MUSIC];

void
Music_Initialize (void)
{
    int i;

    installed = 1;

    install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, ".");

    current = -1;

    for (i = 0; i < MAX_MUSIC; i++) {

        loaded[i] = 0;
    }

    set_volume (255, 255);
}

void
Music_Shutdown (void)
{
    int i;

    if (installed) {
       stop_midi ();

        for (i = 0; i < MAX_MUSIC; i++) {
            if (loaded[i]) {
               destroy_midi (song[i]);
               loaded[i] = 0; // unnecessary
            }
        }
        remove_sound ();
    }
}

void
Music_Play (int music_num)
{
    if (music_num >= 0 && installed) {
        if (loaded[music_num] && music_num != current) {
           stop_midi ();
           play_midi (song[music_num], TRUE);
           current = music_num;
        }
    }
}

int
Music_Load (char *filename)
{
    int i;

    if (installed) {
        for (i = 0; i < MAX_MUSIC; i++) {
            if (!loaded[i]) {
               break;
            }
        }

        // No free slots
        if (i == MAX_MUSIC) {
           return (-1);
        }

        song[i] = load_midi (filename);

        if (song[i] != NULL) {
           loaded[i] = 1;

            return (i);
        }
    }

    return (-1);
}

void
Music_Stop (void)
{
    if (installed) {
       stop_midi ();
       current = -1;
    }
}

int
Music_Get_Current (void)
{
    return (current);
}

void
Music_Unload (int music_num)
{
    if (music_num >= 0 && installed) {
       if (loaded[music_num]) {

          if (current == music_num) {
             stop_midi ();
             current = -1;
          }
          destroy_midi (song[music_num]);
          loaded[music_num] = 0;
       }
    }
}

void
Music_Set_Volume (int volume)
{
    set_volume (-1, volume);
}
