// Map module code file v 1.00
// Copyright Kwame Alexander February 28, 2001
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and one
// severe beating.

#include "map100.h"

static void Load_Actor_Set (char *filename);
static void Unload_Actor_Set (void);

static int x_screen_tiles, y_screen_tiles;
static area room;
static int num_loaded_actors, num_textblocks;
static int actor_list[ACTOR_MAX], area_loaded;
static TEXTBLOCK textblock[MAX_TEXTBLOCKS];

// Prototypes
void
Map_Initialize (void)
{
    int i;

    num_loaded_actors = 0;
    area_loaded = 0;
    room.music = -1;

    for (i = 0; i < ACTOR_MAX; i++) {

        actor_list[i] = -1;
    }
}

void
Map_Shutdown (void)
{
    int i, j;

    Music_Unload (room.music);

    Map_Unload ();
}

void
Map_Load (char *filename, int starting_point)
{
	char tempfile1[35], tempfile2[35], temp, num_entrances;
	char already_on_list, actor_set_file[22], music_file[35];
    char trig_file[35], cin_file[35];
	unsigned int i, j, k, total_tiles, num_lines, music_volume;
	FILE *fp;

    Map_Unload ();

    if (!area_loaded) {
	// Open area file
	fp = fopen (filename, "rt");

	// Get area dimensions
	fscanf (fp, "%u", &room.tiles_across);
	fscanf (fp, "%u", &room.tiles_down);

	// Get Actor Set File
    fscanf (fp, "%s", actor_set_file);

	// Get Fight Probability
	fscanf (fp, "%d", &room.fight_chance);

	// Get Run Probability
	fscanf (fp, "%d", &room.run_chance);

	// Get battle screen graphic
	fscanf (fp, "%s", tempfile2);

	// Get number of tiles
	fscanf (fp, "%d", &room.num_tiles);

	// Get tile filenames and load them
	for (i = 0; i < room.num_tiles; i++) {
		fscanf (fp, "%s", tempfile2);
		strcpy (tempfile1, "graphics/tiles/");
		strcat (tempfile1, tempfile2);
		room.tile_graphic[i] = Graphics_Load_Pic (tempfile1, 0);
	}

	// Get number of solid tiles
	fscanf (fp, "%d", &room.num_solid_tiles);

	// Get solid tile #s
	for (i = 0; i < room.num_solid_tiles; i++) {
		fscanf (fp, "%d", &room.solid_tile[i]);
	}


	// Get starting point
	fscanf (fp, "%d", &num_entrances);

	for (i = 0; i < starting_point + 1; i++) {
		fscanf (fp, "%d", &room.start.x);
		fscanf (fp, "%d", &room.start.y);
	} // for

	for (i = starting_point + 1; i < num_entrances; i++) {
		fscanf (fp, "%d", &temp);
		fscanf (fp, "%d", &temp);
	}

	// Get Music
	fscanf (fp, "%s", music_file);
    // Get volume
    fscanf (fp, "%d", &music_volume);

	// Ease of access
	total_tiles = room.tiles_across * room.tiles_down;

	// Allocate background
	room.background = (int *) malloc ((total_tiles + room.tiles_across + 1) * sizeof (int) + (unsigned int) 1);

	// Load area data
	for (i = 0; i < total_tiles; i++) {
		fscanf (fp, "%d", &room.background[i]);
	} // end for

	// Allocate foreground
	room.foreground = (int *) malloc ((total_tiles + room.tiles_across + 1) * sizeof (int) + (unsigned int) 1);

	// Load area data
	for (i = 0; i < total_tiles; i++) {
		fscanf (fp, "%d", &room.foreground[i]);
	} // end for

	// Load memory stabilization data
	for (i = total_tiles; i < total_tiles + room.tiles_across + 1; i++) {
		room.background[i] = 0;
		room.foreground[i] = -1;
	} // end for

    // Get trigger filename
    fscanf (fp, "%s", trig_file);

    // Get cinema filename
    fscanf (fp, "%s", cin_file);

    // Load text blocks
    fscanf (fp, "%d", &num_textblocks);

    for (i = 0; i < num_textblocks; i++) {
        fscanf (fp, "%d", &textblock[i].num_lines);

        textblock[i].text =
            (char **)malloc (textblock[i].num_lines * sizeof (char *));

        //fgets (NULL, 40, fp);
        for (j = 0; j < textblock[i].num_lines; j++) {
            // 40 is an arbitrary length
            textblock[i].text[j] = (char *)malloc (40 * sizeof (char));
            fscanf (fp, "%s", textblock[i].text[j]);

            // Filter spaces into name
            for (k = 0; k < 40; k++) {
                if (textblock[i].text[j][k] == '_') {
                   textblock[i].text[j][k] = ' ';
                }
            }
        }
    }

	// Close file
	fclose (fp);

    // Load Actors
    Load_Actor_Set (actor_set_file);
    Actor_Set_Target (0, -1); // Set Ruprect's target to none
    Actor_Set_Target (1, -1); // Set Grog's target to none

	x_screen_tiles = SCR_WIDTH / 16;//room.tile_width
	y_screen_tiles = SCR_HEIGHT / 16;//room.tile_height

    room.width = room.tiles_across * 16;//room.tile_width
    room.height = room.tiles_down * 16;//room.tile_height

    area_loaded = 1;

    Actor_Set_X (-1, room.start.x);
    Actor_Set_Y (-1, room.start.y);

    Camera_Set_Position (room.start.x - 144 + 16,
                         room.start.y - 80 - 16);

    // Fade (and switch music)
    // Triggers and movies are loaded here for the music to
    // continue during the fade-out
    Graphics_Fade_Out ();
    Map_Render_Back ();
    Actor_Display_All ();
    Map_Clip ();
    Music_Unload (room.music); // Must unload room music before loading
    room.music = Music_Load (music_file); // cinema or trigger music
    Music_Set_Volume (music_volume);
    Trigger_Load (trig_file);
    Cinema_Load (cin_file);
    Music_Play (room.music);
    Graphics_Draw_Screen ();
    Graphics_Fade_In ();
    }
} // End Map_Set_Load_Room

void
Map_Unload (void)
{
	int i, j;

    if (area_loaded) {

    	for (i = 0; i < room.num_tiles; i++)
	    	Graphics_Unload_Pic (room.tile_graphic[i]);


	    free (room.background);
        free (room.foreground);

        Unload_Actor_Set ();
	/* Unload Music */
	    Music_Unload (room.music);

        for (i = 0; i < num_textblocks; i++) {
            for (j = 0; j < textblock[i].num_lines; j++) {
                free (textblock[i].text[j]);
            }

            free (textblock[i].text);
        }
        num_textblocks = 0;
        area_loaded = 0;
    }
} // End Map_Set_Unload_Room

void
Map_Render_Back (void)
{
	int x, y, x_offset, y_offset, start_tile_x, start_tile_y, end_tile_x, end_tile_y;
	int camera_x, camera_y, tile_width, tile_height, tiles_across, tile;

    camera_x = Camera_Get_X ();
    camera_y = Camera_Get_Y ();
	tile_width = 16;//room.tile_width;
	tile_height = 16;//room.tile_height;
	tiles_across = room.tiles_across;

	start_tile_x =  camera_x / 16;
	start_tile_y =  camera_y / 16;
	end_tile_x = start_tile_x + x_screen_tiles;
	end_tile_y = start_tile_y + y_screen_tiles;

	x_offset = camera_x - (start_tile_x * tile_width);
	y_offset = camera_y - (start_tile_y * tile_height);

	for (x = start_tile_x; x < end_tile_x - 1; x++) {
		for (y = start_tile_y; y < end_tile_y - 1; y++) {

            tile = x + y * tiles_across;
            if (tile >= (room.tiles_across * room.tiles_down)) {
               tile = room.tiles_across * room.tiles_down - 1;
            }
            else if (tile < 0) {
                 tile = 0;
            }

			Graphics_Draw_Pic ((x - start_tile_x + 1) * tile_width - x_offset,
			                   (y - start_tile_y  + 1) * tile_height - y_offset + 4,
					           room.tile_graphic[room.background[tile]]);
        }
    }

}

void
Map_Clip (void)
{
    Graphics_Draw_Box (0, 0, 16, 199, 203);
    Graphics_Draw_Box (319-16, 0, 319, 199, 203);
    Graphics_Draw_Box (16, 0, 319-16, 20, 203);
    Graphics_Draw_Box (16, 199-20, 319-16, 199, 203);//120//105

    Graphics_Draw_Box (7 + 16, 199 - 20, 319 - 16, 199 - 20 + 5, 16);
    Graphics_Draw_Box (319 - 16, 20 + 1 + 5, 319 - 16 + 7, 199 - 20 + 5, 16);
}

int
Map_Get_Tile_Width ()
{
    return (16);
}

int
Map_Get_Tile_Height ()
{
    return (16);
}

void
Map_Render_Layer (int layer)
{
	int x, y, x_offset, y_offset, start_tile_x, start_tile_y, end_tile_x, end_tile_y;
	int camera_x, camera_y, tile_width, tile_height, tiles_across;

	//camera_x = Camera_Get_Position ().x;
	//camera_y = Camera_Get_Position ().y;
	//tile_width = room.tile_width;
	//tile_height = room.tile_height;
	tiles_across = room.tiles_across;

	//start_tile_x =  camera_x / room.tile_width;
	//start_tile_y =  camera_y / room.tile_height;
	end_tile_x = start_tile_x + x_screen_tiles;
	end_tile_y = start_tile_y + y_screen_tiles;

	x_offset = camera_x - (start_tile_x * tile_width);
	y_offset = camera_y - (start_tile_y * tile_height);

	for (x = start_tile_x; x < end_tile_x; x++) {
		for (y = start_tile_y; y < end_tile_y; y++) {

//			Graphics_Draw_Pic (x * tile_width - x_offset, y * tile_height - y_offset,
//					   tilemap[layer][x + y * tiles_across]);
		}
	}

}

int // are x and y tiles?  I assume so.
Map_Solid_Tile (int x, int y)
{
	int i;

	for (i = 0; i < room.num_solid_tiles; i++)
		if (room.background[x + y * room.tiles_across] == room.solid_tile[i])
		   return (1);

	return (0);
} // End Map_Solid_Tile

int
Map_Get_Width (void)
{
    return (room.width);
}

int
Map_Get_Height (void)
{
    return (room.height);
}

char **
Map_Get_Text (int text_num)
{
    return (textblock[text_num].text);
}

void
Map_Display_Text (int text_num, int position)
{
    int i, max_length = 0;

    for (i = 0; i < textblock[text_num].num_lines; i++) {
        if (max_length < strlen (textblock[text_num].text[i])) {
           max_length = strlen (textblock[text_num].text[i]);
        }
    }
    // Convert to box length
    max_length = 8 * (max_length + 2);

    switch (position)
    {
    case CINEMA_TOP:
         Graphics_Standard_Message_Box (160 - max_length / 2, 21,
                                        textblock[text_num].text,
                                        textblock[text_num].num_lines);
         break;
    case CINEMA_BOTTOM:
         Graphics_Standard_Message_Box (160 - max_length / 2,
                       178 - 8 * (textblock[text_num].num_lines + 2),
                       textblock[text_num].text,
                       textblock[text_num].num_lines);
         break;
    default:
            break;
    }
} // end Map_Display_Text

static void
Load_Actor_Set (char *filename)
{
    int num_actors, i, team, x, y, active, actor_num, target;
    int num_sounds, sound_list[MAX_ACTOR_SOUNDS];
    char directory[10], full_filename[32], dummy[35], actor_file[13];
    FILE *fp;

    Unload_Actor_Set ();

    strcpy (directory, "actors/");

    fp = fopen (filename, "rt");

    fscanf (fp, "%s", dummy); // num_actors:
    fscanf (fp, "%d", &num_actors);
    fscanf (fp, "%s", dummy); // filename
    fscanf (fp, "%s", dummy); // team
    fscanf (fp, "%s", dummy); // x
    fscanf (fp, "%s", dummy); // y
    fscanf (fp, "%s", dummy); // active
    fscanf (fp, "%s", dummy); // target

    for (i = 0; i < num_actors; i++) {

        strcpy (full_filename, directory);
        fscanf (fp, "%s", actor_file);
        strcat (full_filename, actor_file);

        fscanf (fp, "%d", &team);
        fscanf (fp, "%d", &x);
        fscanf (fp, "%d", &y);
        fscanf (fp, "%s", dummy);
        if (dummy[0] == 'y' || dummy[0] == 'Y') {
           active = 1;
        }
        else {
           active = 0;
        }

        fscanf (fp, "%d", &target);

        actor_num = Actor_Load (full_filename);
        Actor_Set_X (actor_num, x);
        Actor_Set_Y (actor_num, y);
        Actor_Set_Active (actor_num, active);
        Actor_Set_Target (actor_num, target);
        Actor_Set_Team (actor_num, team);

        actor_list[num_loaded_actors] = actor_num;
        ++num_loaded_actors;
    }

    // Load sounds available to actors
    fscanf (fp, "%s", dummy);
    fscanf (fp, "%d", &num_sounds);

    for (i = 0; i < num_sounds; i++) {

        fscanf (fp, "%s", dummy);
        sound_list[i] = Sound_Load (dummy);
    }
    Actor_Set_Sounds (sound_list, num_sounds);

    fclose (fp);
} // end Load_Actor_Set

static void
Unload_Actor_Set (void)
{
    int i;

    for (i = ACTOR_MAX - 1; i >= 0; i--) {

        if (actor_list[i] != -1) {

            Actor_Unload (actor_list[i]);
            actor_list[i] = -1;

        }
    }

    num_loaded_actors = 0;
} // end Unload_Actor_Set

