// Graphics module header file v 1.00
// Copyright Kwame Alexander February 18, 2001
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and a
// severe beating.

#ifndef GRAPHICS_MODULE
#define GRAPHICS_MODULE

#include <allegro.h>
#include <stdlib.h>
#include <time.h>

#define SCR_WIDTH                   320
#define SCR_HEIGHT                  200
#define GRAPHICS_MAX_PICS           300
#define colour                      color
#define NUM_PARTICLES               10
#define MAX_EMITTERS                5
#define EMITTER_LIFETIME            10

// Structures
typedef struct
{
    int x;
    int y;
    int x_vel;
    int y_vel;
} PARTICLE;

typedef struct
{
    int lifetime;
    int emitting;
    int colour;
    PARTICLE particle[NUM_PARTICLES];
} EMITTER;

void Graphics_Initialize (void);
void Graphics_Shutdown (void);
int Graphics_Load_Pic (char *filename, int load_palette);
void Graphics_Unload_Pic (int pic_num);
void Graphics_Draw_Pic (int x, int y, int pic_num);
void Graphics_Set_Mode (int vmode);
void Graphics_Draw_Box (int left, int top, int right, int bottom, int colour);
void Graphics_Draw_Box2 (int left, int top, int width, int height, int colour);
void Graphics_Draw_Screen (void);
int Graphics_Get_Height (int pic_num);
void Graphics_Draw_Pixel (int x, int y, int c);
void Graphics_Draw_Box_Outline (int left, int top, int right, int bottom, int colour);
void Graphics_Clean_Pic (int fore_col, int back_col, char *old_filename, char *new_filename);
void Graphics_Draw_Text (int x, int y, int colour, unsigned char *string);
void Graphics_Message_Box (int x, int y, int box_colour, int text_colour,
     char **text, int num_lines);
void Graphics_Standard_Message_Box (int x, int y, char **text, int num_lines);
void Graphics_Update_Particles (void);
void Graphics_Emit_Particles (int x, int y, int x_vel, int y_vel, int colour);
void Graphics_Fade_Out (void);
void Graphics_Fade_In (void);
#endif
