/* Cinema module v. 1.00 January 25, 2002 */
/* Copyright Kwame Alexander              */
/* Don't copy without permission or I     */
/* will hunt you down like the <insert    */
/* adjective> dog that you are.           */

// This stuff will go in the header file
// when I get around to making it.
// Note: I got around to it!

#ifndef CINEMA_MODULE
#define CINEMA_MODULE

#include <stdio.h>
#include <string.h>
#include "camera.h"
#include "actor100.h"
#include "graph100.h"
#include "map100.h"
#include "input100.h"
#include "music100.h"


#define CINEMA_DONE         0
#define CINEMA_MOVE         1
#define CINEMA_ANIM         2
#define CINEMA_FADE         3
#define CINEMA_UNFADE       4
#define CINEMA_ACTIVATE     5
#define CINEMA_DEACTIVATE   6
#define CINEMA_PLACE        7
#define CINEMA_ENDBATCH     8
#define CINEMA_FRAME        9
#define CINEMA_MUSIC_PLAY   10
#define CINEMA_SOUND        11
#define CINEMA_TEXT         12
#define CINEMA_NOP          13
#define CINEMA_PAN          14
#define CINEMA_MUSIC_STOP   15
#define CINEMA_CAMERA       16
#define CINEMA_MUSIC_VOL      17

#define CINEMA_NUM_PIPES    10
#define CINEMA_NUM_SOUNDS   5

// This will be dynamically allocated later
#define CINEMA_LENGTH       100

// Directions (I should really standardize these someday)
#define CINEMA_DOWN         0
#define CINEMA_LEFT         1
#define CINEMA_RIGHT        2
#define CINEMA_UP           3

// This will be dynamically allocated later
#define CINEMA_PERFORMERS   10

#define CINEMA_TOP          0
#define CINEMA_BOTTOM       1

typedef struct
{
    int command;
    int counter;
    int argument[3];
} PIPE, MOVIE;

typedef struct
{
    int frame[27];
    int anim[5][20]; // five animations with 20 frames each
    int anim_length[5];
    int x_frame_offset[27];
    int y_frame_offset[27];
    int current_frame;
    int current_anim;
    int x;
    int y;
    int active;
    int animating;
} PERFORMER;

void Cinema_Initialize (void);
void Cinema_Shutdown (void);
void Cinema_Load (char *filename);
void Cinema_Unload (void);
void Cinema_Play (void);
#endif
