// Camera module file v 1.00
// Copyright Kwame Alexander February 28, 2001
// Any reproduction of this document without
// prior written consent from Kwame Alexander
// will result in swift prosecution and a
// severe beating.

#include "camera.h"

static int camera_x, camera_y;

void
Camera_Initialize ()
{
    camera_x = camera_y = 0;
}

void
Camera_Shutdown ()
{
}

void
Camera_Set_Position (int x, int y)
{
    camera_x = x;
    camera_y = y;

    if (camera_x < 0) {
        camera_x = 0;
    }

    if (camera_x >= Map_Get_Width () - (SCR_WIDTH - 2 * 16)) {
       camera_x = Map_Get_Width () - (SCR_WIDTH - 2 * 16) - 1;
    }

    if (camera_y < 0) {
       camera_y = 0;
    }

    if (camera_y >= Map_Get_Height () - (SCR_HEIGHT - 2 * 20)) {
       camera_y = Map_Get_Height () - (SCR_HEIGHT  - 2 * 20) - 1;
    }
}

void
Camera_Move_Position (int x, int y)
{
    camera_x += x;
    camera_y += y;

    if (camera_x < 0) {
        camera_x = 0;
    }

    if (camera_x >= Map_Get_Width () - (SCR_WIDTH - 2 * 16)) {
       camera_x = Map_Get_Width () - (SCR_WIDTH - 2 * 16) - 1;
    }

    if (camera_y < 0) {
       camera_y = 0;
    }

    if (camera_y >= Map_Get_Height () - (SCR_HEIGHT - 2 * 20)) {
       camera_y = Map_Get_Height () - (SCR_HEIGHT - 2 * 20) - 1;
    }
}

int
Camera_Get_X (void)
{
    return (camera_x);
}

int
Camera_Get_Y (void)
{
    return (camera_y);
}

int
Camera_At_Edge (void)
{
    if (camera_x <= 0 || camera_x >= Map_Get_Width () - (SCR_WIDTH - 2 * 16) - 1 ||
        camera_y <= 0 || camera_y >= Map_Get_Height () - (SCR_HEIGHT - 2 * 20) - 1)
    {
        return (1);
    }

    return (0);
}
