// ************************************************
// LevEd is the main program file for the Roxxout
// level editor.
// ************************************************

#ifndef LEVED_H
#define LEVED_H

// ***** Definitions *****
#define SCN_WIDTH 640
#define SCN_HEIGHT 480

#define LevEdSave 1

using namespace std;

#include "GameLevel.h"
#include "Definitions.h"
#include <jpgalleg.h>

// ***** Structorz *****
struct bitmaps {
  BITMAP *buf;
  BITMAP *buf2;
  BITMAP *menu;
  BITMAP *cursor;
};

struct variables {
  int currentLevel;
  int x;
  int y; 
};

// ***** Globals *****
// Globals are okay because pretty much every part
// of the program needs access to them.
GameLevel *levels[50];
int numLevels = 0;

// ***** The functions *****
void init();
void next(variables *vars);
void prev(variables *vars);
void save();
void load();
void addLevel(variables *vars);

// ***** The mechanism methods *****
BITMAP *getMenuGraphic();
BITMAP *getCursorGraphic();
void drawScreen(variables *vars, bitmaps *bmps);
void keyManage(variables *vars);

#endif
