/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

/***************************************************
 * Yes, the paddle class is the paddle that is at
 * the bottom of the screen and reflects balls.
 ***************************************************/

#ifndef PADDLE_H
#define PADDLE_H

#include "SpriteFile.h"
#include "Definitions.h"

#define MAX_PADDLE_SIZE 5

static int Paddle_Init = 0;
static BITMAP *paddlePics[4];

class Paddle
{
   public:
      Paddle();
      void draw(BITMAP *buf);
      int rebound(Ball *foo, int Speed);
      void shrink();
      void grow();

   private:
      int itsSize;
      int itsPos; // Coordinate of the leftmost side of the paddle
      void paddleInit();
      void updatePosition();
};

#endif
