/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

/*********************************************
 * The obligatory header file for the Manager
 * module, which will have the manage method.
 * This is essentially the game engine.
 *********************************************/

#ifndef MANAGER_H
#define MANAGER_H

using namespace std;

#include <allegro.h>
#include <fstream>
#include <list>
#include <math.h>
#include "GameLevel.h"
#include "Ball.h"
#include "Paddle.h"
#include "Definitions.h"
#include "Globals.h"
#include "particle.h"

class Manager{
    public:
	Manager();

	// ***** The manage function is the important one *****
	// (The file stream is a file containing the levels that
	// it will use.)
	int manage_game();

	void init(ifstream &fin); // Must be called before each game is managed

	// **** Internal methods *****
	BITMAP *getBallPic();
	void showWin();
	void showLose();
	int quitquery();
	void update_particles();
	void draw_particles();
	bool hover_ball();
	void buffer_wait();
	void draw_screen();
	void moveball(int i);
	void init_level();
	void init_life();
	bool init_tick();
	void paddle_ball(int i);
	void block_ball_collision(int i);
	void do_collision(int collide_type, int the_ball);
	void fix_difficulty();

	// ***** Flags and variables *****
	Globals *myGlobals;
	char theString[100];
	int gameOver, currentBG;
	int gameWon;
	int lives;
	int numBalls;
	int score;
	int levelNum;
	int levelOver;
	int speed;
	int ticks;
	int collisionType[3];
	int startoftick;
	int bonus;
	BITMAP *ballPic;
	Ball *balls[MAX_BALLS];
	Paddle *thePaddle;
	char scoreString[64];
	BITMAP *buf;
	BITMAP *levelup_bmp, *gameover_bmp;
	BITMAP *backgrounds[NUM_BACKGROUNDS];
	int numLevels;
	int Xblock, Yblock; // The x and y locations of a block

	// ***** Objects *****
	GameLevel *currentLevel;

	list<particle*> particle_list;

	SAMPLE *hitPaddleSound;
	SAMPLE *hitBlockSound;
	SAMPLE *hitSideSound;
	SAMPLE *hitPowerUpSound;

	MIDI *LevelupMIDI;

	DATAFILE *Music;
	DATAFILE *SysMusic;

	ifstream *fin;
};

#endif
