/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/
 
 /******************************************************************************
  * The interface object, which handles the menu and other shiny things
  *****************************************************************************/
  
#ifndef INTERFACE_H
#define INTERFACE_H

#include <allegro.h>
#include "Manager.h"
#include "Definitions.h"
#include "SpriteFile.h"
#include "SysMusic.h"
#include "Globals.h"
#include "Font.h"
#include "Menus.h"

// The struct that I use to save the high scores
struct hscores{
   int scores[5];
};

class Interface{
	public:
		Interface();
		void playgame();
		void optionMenu();
		int mainMenu();
		void showhelp();

	private:
		// Variables
		BITMAP *mouseCursorPic;
		BITMAP *title_bmp, *help_bmp, *levelselect_bmp;
		struct hscores theScores;
		DATAFILE *SysMusic;
		Globals *myGlobals;
		BITMAP *buf;
		Menus *myMenus;
		
		// Functions
		void showCursor();
		int levelMenu();
};

#endif
