/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

 /*
 * The block class.  Used to keep track of each
 * block on the playgrid in Roxxout.
 **/

#include "Definitions.h"
#include <allegro.h>
#include "Block.h"

// ************************************************
// The constructor makes a new block with the
// paramaters given.
// ************************************************
Block *Init_Block(int theType, int theColor)
{
       Block *temp;
       temp = (Block *)malloc(sizeof(Block));

       temp->type = theType;
       temp->blockColor = theColor;

       temp->Hp = 1;
       if (theType == B_up || theType == B_down)
          temp->Hp = 20;
       if (theType == B_gold)
          temp->Hp = 5;

       return temp;
}

// ************************************************
// The collide algorithm will not only return what
// kind of collision occured and whether a
// collision occured, but also will resolve what
// happens to the blocks.
// ************************************************
int Block_Collide(int dir, Block *foo)
{
       switch (foo->type)
       {
          case B_empty:
             return BC_empty;
             break;

          case B_normal:
             foo->type = B_empty;
             return BC_normal;
             break;

          case B_gold:
             foo->Hp--;
             if (foo->Hp == 0)
                foo->type = B_empty;
             case B_indestructable:
             return BC_rebound;
             break;

          case B_up:
             if (dir == down){
                foo->Hp--;
                if (foo->Hp == 0)
                   foo->type = B_empty;
                return BC_rebound; }
             else return BC_empty;
             break;

          case B_down:
             if (dir == up){
                foo->Hp--;
                if (foo->Hp == 0)
                   foo->type = B_empty;
                return BC_rebound; }
             else return BC_empty;
             break;

          default:
             int theResult = foo->type;
             foo->Hp = 0;
             foo->type = B_empty;
             return theResult;
      }
}
