/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/
#include "Ball.h"
#include <stdlib.h>

/****************************************
 * Initialize a ball to be travelling
 * slowly downward int he middle
 ****************************************/
Ball *Init_Ball()
{
   Ball *temp;
   temp = (Ball *) malloc(sizeof(Ball));

   temp->xd = 310;
   temp->yd = 300;
   temp->x = (int)temp->xd;
   temp->y = (int)temp->yd;
   temp->xv = 0;
   temp->yv = 4;

   return temp;
}

/*****************************************
 * Update updates a ball
 *****************************************/
void Update_Ball(Ball *foo)
{
   foo->xd = foo->xv + foo->xd;
   foo->yd = foo->yv + foo->yd;

   foo->x = (int)foo->xd;
   foo->y = (int)foo->yd;

   // Fudge factors for collision detection.
   // This is BAD CODE.  >.<  Hakka hakka hakka.
   foo->xvi = (int)foo->xv;
   foo->yvi = (int)foo->yv;
   if (foo->xv < 0)
      foo->xvi--;
   else
      foo->xvi++;
   if (foo->yv < 0)
      foo->yvi--;
   else
      foo->yvi++;
}

/******************************************
 * Resets its balls to the original values
 ******************************************/
void Reset_Ball(Ball *foo)
{
   foo->xd = 310;
   foo->yd = 300;
   foo->x = (int)foo->xd;
   foo->y = (int)foo->yd;
   foo->xv = 0;
   foo->yv = 1;
}


