/*****************************************************************************
 * An object used for particle effects.  It will decrease linearly from its
 * original alpha to 0 alpha, over the span of lifetime updates
 * **************************************************************************/

#ifndef PARTICLE_H
#define PARTICLE_H

#include <allegro.h>

class particle{
	public:
		particle(int alpha, int lifetime, BITMAP *picture, int x, int y, int xvel, int yvel);
		void set_limits(int _max_x, int _min_x, int _max_y, int _min_y);
		bool update();
		void draw(BITMAP *buf);

	private:
		int alpha, life, lifetime, x, y, x_vel, y_vel, first_alpha;
		int max_x, max_y, min_x, min_y;
		BITMAP *picca;
};

#endif
