/*****************************************************************************
 * Class for simple menus
 * ***************************************************************************/

#include "Menus.h"

/*****************************************************************************
 * Constructor initializes the menu system, of course
 * ***************************************************************************/
Menus::Menus(){
	// Initialize variables
	myGlobals = Globals::Instance();
	buf = myGlobals->getGraphics()->get_buffer();

	// Load the font
	DATAFILE *foo = load_datafile(INTERFACE_FONT);
	if (foo == NULL){
		allegro_message("Could not load font file");
		allegro_exit();
	}
	interface_font = (FONT *)foo[0].dat;
	if (interface_font == NULL){
		allegro_message("Could not load FROM Font.dat");
		allegro_exit();
	}

	// Load the hilights
	hilite_particle_bmp = load_bitmap(INTERFACE_PARTICLE, NULL);
	if (hilite_particle_bmp == NULL){
		allegro_message("Could not load the interface hilight particle graphic");
		allegro_exit();
	}
}

/*****************************************************************************
 * Presents the player with a menu, waits until he hits enter, and returns
 * the number representing his selection.
 *
 * -background can be NULL
 * -options can be NULL, if it is, the user will only be able to choose items
 *  with Enter
 * -If you want to have changeable options, options[][4] must have
 *  max_selection entries
 * -options[x][] = { Default, Maximum, Minimum, Change per arrow press }
 * -The player cannot choose changeable options with enter
 * -names[][50] needs max_selection entries, and should be the names of
 *  your options
 * -first_y is the y-coord of the first menu entry
 * -spread is how far apart the entries are.  1-2 is usually good
 * ***************************************************************************/
int Menus::do_menu(int max_selection, int first_y, double spread, char names[][50], BITMAP *background, int options[][4]){
	int answer = 0;
	int selection = 0;
	char cbuf[50];

	while(key[KEY_ENTER])
		;

	while (1){	
		// Draw menu
		clear_bitmap(buf);
		if (background != NULL)
			blit(background, buf, 0, 0, 0, 0, SCN_WIDTH, SCN_HEIGHT);
		for (int i = 0; i <= max_selection; i++){
			if (options != NULL && options[i][0] >= 0){
				sprintf(cbuf, "%s%i", names[i], options[i][0]);
				textout_centre_ex(buf, interface_font, cbuf, SCN_WIDTH/2, first_y + (int)(text_height(interface_font) * i * spread), 0xffffff, -1);
			} else
				textout_centre_ex(buf, interface_font, names[i], SCN_WIDTH/2, first_y + (int)(text_height(interface_font) * i * spread), 0xffffff, -1);
		}
		draw_hilite(int(first_y + spread * selection * text_height(interface_font)));
		myGlobals->getGraphics()->update();

		// Accept input
		if (keypressed())
			switch(readkey() >> 8){
				case KEY_DOWN:
					selection++;
					if (selection > max_selection)
						selection = 0;
					break;

				case KEY_UP:
					selection--;
					if (selection < 0)
						selection = max_selection;
					break;

				case KEY_ENTER:
					if (options == NULL || options[selection][0] == -1)
						return selection;
					break;

				case KEY_LEFT:
					if (options != NULL && options[selection][0] != -1){
						options[selection][0] -= options[selection][3];
						if (options[selection][0] < options[selection][2])
							options[selection][0] = options[selection][2];
					}
					break;

				case KEY_RIGHT:
					if (options != NULL && options[selection][0] != -1){
						options[selection][0] += options[selection][3];
						if (options[selection][0] > options[selection][1])
							options[selection][0] = options[selection][1];
					}
					break;
			}
	}	
}

/*******************************************************************************
 * draw_hilite draws the highlight accross the screen, with the top being at y
 * ****************************************************************************/
void Menus::draw_hilite(int y){
	// Add some particles
	for (int i = 0; i < 4; i++){
		particle *part = new particle(255, rand() % 20 + 15, hilite_particle_bmp, rand() % SCN_WIDTH, y + rand()  % 30, rand() % 3 - 1, rand() % 3 - 1);
		part->set_limits(SCN_WIDTH, 0, y + text_height(interface_font)-10, y);
		myGlobals->getGraphics()->add_particle(part);
	}
	solid_mode();
}
