/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

#include "Interface.h"

/*****************************************************
 * This is where the user interface takes place, and
 * when they decide to play, a Manager will be started.
 * It is the one with the main method, so it is of
 * particular note.
 *****************************************************/

/*****************************************************************************
 * The constructor loads screens and music up, and initializes variables
 * and things.
 *****************************************************************************/
Interface::Interface(){
	// Initialize variables
	myGlobals = Globals::Instance();
	buf = myGlobals->getGraphics()->get_buffer();
	mouseCursorPic = NULL;  // Must be set to NULL, or else it won't initialize
	myMenus = new Menus();

	// Load up the high scores
	ifstream sfin("dat/HScores.dat", ios::binary);
	if (sfin == NULL)
		for (int i = 0; i < 5; i ++)
			theScores.scores[i] = 0;
	else sfin.read((char *)(&theScores), sizeof(hscores));
	sfin.close();

	// Load the title screen and the music into memory
	title_bmp = load_bitmap("gfx//default//screens//title.jpg", NULL);
	help_bmp = load_bitmap("gfx//default//screens//help.jpg", NULL);
	levelselect_bmp = load_bitmap("gfx//default//screens//levelselect.jpg", NULL);
	if (title_bmp == NULL || help_bmp == NULL || levelselect_bmp == NULL){
		allegro_message("Cannot load a screen in Interface.cpp");
		allegro_exit(); 
	}

	SysMusic = load_datafile("dat/SysMusic.dat");
	if (SysMusic == NULL){
		allegro_message("Cannot load SysMusic.dat");
		allegro_exit(); 
	}
}

/*****************************************************************************
 * Prints the cursor onto the given bitmap.  Used by mainMenu and any other
 * menus that I get around to coding.
 *****************************************************************************/
void Interface::showCursor(){
	// Initialize the cursor if it hasn't been already done
	if (mouseCursorPic == NULL){
		DATAFILE *Sprites = load_datafile("dat/Sprites.dat");
		if (Sprites == NULL){
			allegro_message("Cannot load Sprites.dat");
			allegro_exit(); 
		}
		mouseCursorPic = create_bitmap(40, 40);
		blit((BITMAP *) Sprites[mouseCursor].dat, mouseCursorPic, 0, 0, 0, 0, 40, 40);
	}

	// Sticks that cursor on the given bitmap
	masked_blit(mouseCursorPic, buf, 0, 0, mouse_x, mouse_y, 40, 40);
}

/*****************************************************************************
 * Displays the main menu and cursor till something is chosen
 *****************************************************************************/
int Interface::mainMenu(){
	char mainnames[][50] = { "Play Game", "Help", "Options", "Quit" };
	BITMAP *title_bg = create_bitmap(SCN_WIDTH, SCN_HEIGHT);
	char scoreString[128];

	// Generate the background for the menu
	clear_bitmap(title_bg);
	blit(title_bmp, title_bg, 0, 0, 0, 0, SCN_WIDTH, SCN_HEIGHT);
	sprintf(scoreString, "Classic high score: %d Puzzle high score: %d", theScores.scores[0], theScores.scores[1]);
	textout_centre_ex(title_bg, font, scoreString, SCN_WIDTH / 2, SCN_HEIGHT - 20, 0xffffff, -1);
	sprintf(scoreString, "Design high score: %d Challenge high score: %d", theScores.scores[2], theScores.scores[3]);
	textout_centre_ex(title_bg, font, scoreString, SCN_WIDTH / 2, SCN_HEIGHT - 10, 0xffffff, -1);

	return myMenus->do_menu(3, 230, 1.5, mainnames, title_bg, NULL);
}

/****************************************************************************
 * Here the player chooses his level
 ****************************************************************************/
int Interface::levelMenu()
{
	char level_strings[][50] = {"Classic", "Puzzle", "Design", "Challenge", "Custom"};
	return myMenus->do_menu(4, 100, 1.5, level_strings, levelselect_bmp, NULL) + 1;
}


/****************************************************************************
 * The option menu, where the player has control over Global variables
 ****************************************************************************/
void Interface::optionMenu(){
	int the_options[][4] = { 
		{ myGlobals->getSoundVolume(), 255, 0, 20 },
		{ myGlobals->getDifficulty(), 4, 0, 1 },
		{ -1, -1, -1, -1 }
	};
	char names[][50] = {"Sound Volume: ", "Difficulty: ", "Quit options"};
	myMenus->do_menu(2, 60, 1.5, names, NULL, the_options);
	myGlobals->setSoundVolume(the_options[0][0]);
	myGlobals->setDifficulty(the_options[1][0]);
}

/*******************************************************************************
 * Displays the help screen to the player, because he just doesn't know
 ******************************************************************************/
void Interface::showhelp(){
	while(keypressed())
		;
	while(!keypressed()){
		blit(help_bmp, buf, 0, 0, 0, 0, SCN_WIDTH, SCN_HEIGHT);
		myGlobals->getGraphics()->update();
	}	
}

/*******************************************************************************
 * The playgame function, called from the main method.
 * This loads up the levels in a filestream and then sends it to the Manager,
 * where the player plays a full game.  Then, his final score is sent to the
 * high scores table
 ******************************************************************************/
void Interface::playgame(){
	// Here the player plays the game, since that was his choice
	int choice = levelMenu();
	int numLevels;

	char *levelchoice;
	switch (choice){
		case 1: levelchoice = "dat//Lclassic.dat"; break;
		case 2: levelchoice = "dat//Lpuzzle.dat"; break;
		case 3: levelchoice = "dat//Ldesign.dat"; break;
		case 4: levelchoice = "dat//Lhard.dat"; break;
		case 5: levelchoice = "dat//levels.dat"; break;
	}

	ifstream fin(levelchoice, ios::binary);
	myGlobals->getManager()->init(fin);
	int finalScore = myGlobals->getManager()->manage_game();
	fin.close();

	// Updates the high scores.
	if (theScores.scores[choice - 1] < finalScore)
		theScores.scores[choice - 1] = finalScore;

	// Save the new high score table, even if it didn't change
	ofstream sfin("dat//HScores.dat", ios::binary);
	sfin.write((char *)(&theScores), sizeof(hscores));
	sfin.close();
}
