/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

// ************************************************
// Yes, the name level had to be changed to
// GameLevel for unforseen reasons.  Cope with it.

// It's essentially an array of blocks and ways
// to manage them.
//*************************************************

#ifndef GAMELEVEL_H
#define GAMELEVEL_H

#include "Block.h"
#include <fstream>

static int GameLevelInit = 0;
static BITMAP *blockPics[19];

class GameLevel
{
      public:
             GameLevel();
             int collide(int x, int y, int dir);
             void draw(BITMAP *buf);
             void setTo(int x, int y, int type);
             void save(ofstream &fout);
             void load(ifstream &fin);
			 Block *get_block(int, int);
			 BITMAP *get_block_pic(int, int);

      private:
             Block *blocks[20][14];
             int normals;
             void InitGameLevel();
};

#endif
