/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/
 
 #include <allegro.h>
 #include <jpgalleg.h>
 #include "Definitions.h"
 #include "Interface.h"
 
 /*****************************************************************************
 * Initializes Allegro and the necessary components
 *****************************************************************************/
void InitRoxxout(){
   allegro_init();
   set_color_depth(16);
   Globals *init_globals = Globals::Instance();
   install_timer();
   install_keyboard();
   install_mouse();
   set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCN_WIDTH, SCN_HEIGHT, 0, 0);
   install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
   jpgalleg_init();
   Manager *init_manager = new Manager();
   init_globals->setManager(init_manager);
}
 
 /****************************************************************************
 * Main method.
 ****************************************************************************/
void main()
{
   InitRoxxout();
   Interface *theInterface = new Interface();
   int choice;

   // The main loop
   while(1){
      choice = 0;
      choice = theInterface->mainMenu();

      // Act on players choice
      switch(choice){

         // Player chooses to play game
         case 0:
         	theInterface->playgame();
            break;

         // Player needs help, because he's a little slow that way
         case 1:
            theInterface->showhelp();
            break;

         // Player wants to get into the options
         case 2:
            theInterface->optionMenu();
            break;

         // Player chooses to quit
         case 3:
            allegro_exit();
            return;
            break;
      }
   }
}
END_OF_MAIN();
