/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

// ******************************************
// This is where all my numbering conventions
// are defined.  I needed to do this because
// otherwise the whole game would look like
// a series of abstract numbers, and nobody
// would be able to tell what the fuck I was
// doing if they didn't have my original
// design documents.
// ******************************************

#ifndef DEFINITIONS_H
#define DEFINITIONS_H

#define ZERO 0  // Damn you Daniel and your coding practices

#define NUM_BACKGROUNDS 5
#define PADDLE_SPEED 7
#define FPS 60 
#define EXPLOSION_PARTICLES 1  
#define PARTICLE_MAX_VELOCITY 5

// ***** For the interface *****
#define INTERFACE_FONT "dat//Font.dat"
#define INTERFACE_PARTICLE "gfx//default//sprites//ball.bmp"

// ***** Screen size *****
#define SCN_WIDTH 640
#define SCN_HEIGHT 480

// ***** Game variables *****
#define MAX_BALLS 200
#define NUM_OF_BGS 5
#define POTENTIAL_BONUS 20000

// *****  Types of blocks *****
#define B_empty 0
#define B_normal 1
#define B_multi 2
#define B_uber 3
#define B_life 4
#define B_grow 5
#define B_shrink 6
#define B_fast 7
#define B_slow 8
#define B_up 9
#define B_down 10
#define B_indestructable 11
#define B_gold 12

// ***** Pictures for blocks *****
// (Ripped from an autogenerated Dat file header maker)
#define PB_blue                           0        /* BMP  */
#define PB_cyan                           1        /* BMP  */
#define PB_gold                           2        /* BMP  */
#define PB_green                          3        /* BMP  */
#define PB_orange                         4        /* BMP  */
#define PB_pink                           5        /* BMP  */
#define PB_purple                         6        /* BMP  */
#define PB_red                            7        /* BMP  */
#define PB_indestructable                 8        /* BMP  */
#define PB_yellow                         9        /* BMP  */
#define PBS_down                          10       /* BMP  */
#define PBS_life                          11       /* BMP  */
#define PBS_fast                          12       /* BMP  */
#define PBS_grow                          13       /* BMP  */
#define PBS_multi                         14       /* BMP  */
#define PBS_shrink                        15       /* BMP  */
#define PBS_slow                          16       /* BMP  */
#define PBS_uber                          17       /* BMP  */
#define PBS_up                            18       /* BMP  */
#define cursorGraphic                     19
#define PB_empty                          25

// ***** Block Collisions *****
// (Seen by GameLevel, propogated by blocks)
#define BC_empty 0
#define BC_normal 1   // A normal block is destroyed
#define BC_multi 2
#define BC_uber 3
#define BC_life 4
#define BC_grow 5
#define BC_shrink 6
#define BC_fast 7
#define BC_slow 8
#define BC_rebound 12 // A ball rebounds off gold or silver block

// ***** Level Collisions *****
// (Seen by the manager, propogated by GameLevels
#define LC_empty 0
#define LC_normal 1  // The ball rebounds off of something
#define LC_multi 2
#define LC_uber 3
#define LC_life 4
#define LC_grow 5
#define LC_shrink 6
#define LC_fast 7
#define LC_slow 8
#define LC_leveldone 9 // called only when the last normal block is destroyed

// ***** Directions *****
#define up 1
#define down 2

#endif
