/****************************************************************
 * Copyright (C) 2002  Joel Muzzerall
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************/

// ************************************************
// The source file header for the block class
// This is invisable to most of the other classes
// in roxxout, and is used only by Level objects.
// Levels can almost be said to be an interface
// for these blocks.
// ************************************************

#ifndef BLOCK_H
#define BLOCK_H

#include <allegro.h>

struct Block{
   int Hp;
   int blockColor;
   int type; 
};

// Function prototypes
Block *Init_Block(int theType, int blockColor);   // Constructor
int Block_Collide(int dir, Block *foo);                       // 1 = up, 2 = down

#endif
