#! /bin/sh
#
#  Sets up the JGMOD package for building under BeOS, converting text
#  files from CR/LF to LF format.


echo "Converting JGMOD files to BeOS format..."

find . -type f "(" \
   -name "*.c" -o -name "*.cfg" -o -name "*.cpp" -o -name "*.dep" -o \
   -name "*.h" -o -name "*.hin" -o -name "*.in" -o -name "*.inc" -o \
   -name "*.m4" -o -name "*.mft" -o -name "*.s" -o -name "*.sh" -o \
   -name "*.spec" -o -name "*.pl" -o -name "*.txt" -o -name "*._tx" -o \
   -name "makefile.*" -o -name "plugins.*" -o -name "*.scu" -o -name "readme.*" \
   ")" \
   -exec sh -c "echo {};
		mv {} _tmpfile;
		tr -d \\\r < _tmpfile > {};
		touch -r _tmpfile {}; 
		rm _tmpfile" \;

chmod +x *.sh

echo
echo "Done!"
echo
echo "Now 'cd src'"
echo "Then run make."
echo

echo \# generated by fixbe.sh > ./src/makefile
echo include makefile.be >> ./src/makefile

echo \# generated by fixbe.sh > ./examples/makefile
echo include makefile.be >> ./examples/makefile
