/* cps2 drivers, see cps1.c for the code (VERY similar to cps1) */

#include "gameinc.h"
#include "cps1.h"

static struct ROM_INFO _ssf2_roms[] =
{
  { "ssfe.03", 0x80000, 0xa597745d, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "ssfe.04", 0x80000, 0xb082aa67, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "ssfe.05", 0x80000, 0x02b9c137, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "ssfe.06", 0x80000, 0x70d470c5, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "ssfe.07", 0x80000, 0x2409001d, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "ssfex.03", 0x80000, 0x29690c24, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "ssfex.04", 0x80000, 0xd001e53a, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "ssfex.05", 0x80000, 0xa45602e4, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "ssfex.06", 0x80000, 0xae3c8a14, REGION_USER1, 0x180000, LOAD_SWAP_16 },
  { "ssfex.07", 0x80000, 0xf88f584e, REGION_USER1, 0x200000, LOAD_SWAP_16 },
  { "ssf.13", 0x200000, 0xcf94d275, REGION_GFX1, 0x000000, LOAD_16_64 },
  { "ssf.15", 0x200000, 0x5eb703af, REGION_GFX1, 0x000002, LOAD_16_64 },
  { "ssf.17", 0x200000, 0xffa60e0f, REGION_GFX1, 0x000004, LOAD_16_64 },
  { "ssf.19", 0x200000, 0x34e825c5, REGION_GFX1, 0x000006, LOAD_16_64 },
  { "ssf.14", 0x100000, 0xb7cc32e7, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "ssf.16", 0x100000, 0x8376ad18, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "ssf.18", 0x100000, 0xf5b1b336, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "ssf.20", 0x100000, 0x459d5c6b, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "ssf.01", 0x20000, 0xeb247e8c, REGION_ROM2, 0, LOAD_NORMAL },
  { "ssf.q01", 0x080000, 0xa6f9da5c, REGION_SMP1, 0x000000, LOAD_NORMAL },
  { "ssf.q02", 0x080000, 0x8c66ae26, REGION_SMP1, 0x080000, LOAD_NORMAL },
  { "ssf.q03", 0x080000, 0x695cc2ca, REGION_SMP1, 0x100000, LOAD_NORMAL },
  { "ssf.q04", 0x080000, 0x9d9ebe32, REGION_SMP1, 0x180000, LOAD_NORMAL },
  { "ssf.q05", 0x080000, 0x4770e7b7, REGION_SMP1, 0x200000, LOAD_NORMAL },
  { "ssf.q06", 0x080000, 0x4e79c951, REGION_SMP1, 0x280000, LOAD_NORMAL },
  { "ssf.q07", 0x080000, 0xcdd14313, REGION_SMP1, 0x300000, LOAD_NORMAL },
  { "ssf.q08", 0x080000, 0x6f5a088c, REGION_SMP1, 0x380000, LOAD_NORMAL },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _ddtod_roms[] =
{
  { "dade.03c", 0x80000, 0x8e73533d, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "dade.04c", 0x80000, 0x00c2e82e, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "dade.05c", 0x80000, 0xea996008, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "dade.06a", 0x80000, 0x6225495a, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "dade.07a", 0x80000, 0xb3480ec3, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "dadex.03c", 0x80000, 0x7b8b9b2c, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "dadex.04c", 0x80000, 0x370626d3, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "dadex.05c", 0x80000, 0x5fd29e95, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "dad.13", 0x200000, 0xda3cb7d6, REGION_GFX1, 0x000000, LOAD_16_64 },
  { "dad.15", 0x200000, 0x92b63172, REGION_GFX1, 0x000002, LOAD_16_64 },
  { "dad.17", 0x200000, 0xb98757f5, REGION_GFX1, 0x000004, LOAD_16_64 },
  { "dad.19", 0x200000, 0x8121ce46, REGION_GFX1, 0x000006, LOAD_16_64 },
  { "dad.14", 0x100000, 0x837e6f3f, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "dad.16", 0x100000, 0xf0916bdb, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "dad.18", 0x100000, 0xcef393ef, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "dad.20", 0x100000, 0x8953fe9e, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "dad.01", 0x20000, 0x3f5e2424, REGION_ROM2, 0, LOAD_NORMAL },
  { "dad.11", 0x200000, 0x0c499b67, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "dad.12", 0x200000, 0x2f0b5a4e, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _sgemf_roms[] =
{
  { "pcfu.03", 0x80000, 0xac2e8566, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "pcf.04", 0x80000, 0xf4314c96, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "pcf.05", 0x80000, 0x215655f6, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "pcf.06", 0x80000, 0xea6f13ea, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "pcf.07", 0x80000, 0x5ac6d5ea, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "pcfux.03", 0x80000, 0x652b7647, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "pcf.13", 0x400000, 0x22d72ab9, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "pcf.15", 0x400000, 0x16a4813c, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "pcf.17", 0x400000, 0x1097e035, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "pcf.19", 0x400000, 0xd362d874, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "pcf.14", 0x100000, 0x0383897c, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "pcf.16", 0x100000, 0x76f91084, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "pcf.18", 0x100000, 0x756c3754, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "pcf.20", 0x100000, 0x9ec9277d, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "pcf.01", 0x20000, 0x254e5f33, REGION_ROM2, 0, LOAD_NORMAL },
  { "pcf.02", 0x20000, 0x6902f4f9, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "pcf.11", 0x400000, 0xa5dea005, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "pcf.12", 0x400000, 0x4ce235fe, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _ecofghtr_roms[] =
{
  { "uece.03", 0x80000, 0xec2c1137, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "uece.04", 0x80000, 0xb35f99db, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "uece.05", 0x80000, 0xd9d42d31, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "uece.06", 0x80000, 0x9d9771cf, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "uecex.03", 0x80000, 0xe0ff3d51, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "uecex.04", 0x80000, 0xb9f998e8, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "uecex.05", 0x80000, 0x12410260, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "uecex.06", 0x80000, 0xd5b4b1a2, REGION_USER1, 0x180000, LOAD_SWAP_16 },
  { "uec.13", 0x200000, 0xdcaf1436, REGION_GFX1, 0x000000, LOAD_16_64 },
  { "uec.15", 0x200000, 0x2807df41, REGION_GFX1, 0x000002, LOAD_16_64 },
  { "uec.17", 0x200000, 0x8a708d02, REGION_GFX1, 0x000004, LOAD_16_64 },
  { "uec.19", 0x200000, 0xde7be0ef, REGION_GFX1, 0x000006, LOAD_16_64 },
  { "uec.14", 0x100000, 0x1a003558, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "uec.16", 0x100000, 0x4ff8a6f9, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "uec.18", 0x100000, 0xb167ae12, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "uec.20", 0x100000, 0x1064bdc2, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "uec.01", 0x20000, 0xc235bd15, REGION_ROM2, 0, LOAD_NORMAL },
  { "uec.11", 0x200000, 0x81b25d39, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "uec.12", 0x200000, 0x27729e52, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _xmcota_roms[] =
{
  { "xmne.03e", 0x80000, 0xa9a09b09, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "xmne.04e", 0x80000, 0x52fa2106, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "xmn.05a", 0x80000, 0xac0d7759, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "xmn.06a", 0x80000, 0x1b86a328, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "xmn.07a", 0x80000, 0x2c142a44, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "xmn.08a", 0x80000, 0xf712d44f, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "xmn.09a", 0x80000, 0x9241cae8, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "xmn.10a", 0x80000, 0x53c0eab9, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "xmnex.03e", 0x80000, 0x2f5daa9f, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "xmnex.04e", 0x80000, 0xf0e24605, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "xmn.13", 0x400000, 0xbf4df073, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "xmn.15", 0x400000, 0x4d7e4cef, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "xmn.17", 0x400000, 0x513eea17, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "xmn.19", 0x400000, 0xd23897fc, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "xmn.14", 0x400000, 0x778237b7, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "xmn.16", 0x400000, 0x67b36948, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "xmn.18", 0x400000, 0x015a7c4c, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "xmn.20", 0x400000, 0x9dde2758, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "xmn.01a", 0x20000, 0x40f479ea, REGION_ROM2, 0, LOAD_NORMAL },
  { "xmn.02a", 0x20000, 0x39d9b5ad, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "xmn.11", 0x200000, 0xc848a6bc, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "xmn.12", 0x200000, 0x729c188f, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _1944_roms[] =
{
  { "nffu.03", 0x80000, 0x9693cf8f, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "nff.04", 0x80000, 0xdba1c66e, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "nffu.05", 0x80000, 0xea813eb7, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "nffux.03", 0x80000, 0x675c8109, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "nff.13", 0x400000, 0xc9fca741, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "nff.15", 0x400000, 0xf809d898, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "nff.17", 0x400000, 0x15ba4507, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "nff.19", 0x400000, 0x3dd41b8c, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "nff.14", 0x100000, 0x3fe3a54b, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "nff.16", 0x100000, 0x565cd231, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "nff.18", 0x100000, 0x63ca5988, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "nff.20", 0x100000, 0x21eb8f3b, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "nff.01", 0x20000, 0xd2e44318, REGION_ROM2, 0, LOAD_NORMAL },
  { "nff.11", 0x400000, 0x243e4e05, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "nff.12", 0x400000, 0x4fcf1600, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _dimahoo_roms[] =
{
  { "gmdu.03", 0x80000, 0x43bcb15f, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "gmd.04", 0x80000, 0x37485567, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "gmd.05", 0x80000, 0xda269ffb, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "gmd.06", 0x80000, 0x55b483c9, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "gmdux.03", 0x80000, 0x9f820809, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "gmd.13", 0x400000, 0x80dd19f0, REGION_GFX1, 0x000000, LOAD_16_64 },
  { "gmd.15", 0x400000, 0xdfd93a78, REGION_GFX1, 0x000002, LOAD_16_64 },
  { "gmd.17", 0x400000, 0x16356520, REGION_GFX1, 0x000004, LOAD_16_64 },
  { "gmd.19", 0x400000, 0xdfc33031, REGION_GFX1, 0x000006, LOAD_16_64 },
  { "gmd.01", 0x20000, 0x3f9bc985, REGION_ROM2, 0, LOAD_NORMAL },
  { "gmd.02", 0x20000, 0x3fd39dde, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "gmd.11", 0x400000, 0x06a65542, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "gmd.12", 0x400000, 0x50bc7a31, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _avsp_roms[] =
{
  { "avpe.03d", 0x80000, 0x774334a9, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "avpe.04d", 0x80000, 0x7fa83769, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "avp.05d", 0x80000, 0xfbfb5d7a, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "avp.06", 0x80000, 0x190b817f, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "avpex.03d", 0x80000, 0x73dd740e, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "avpex.04d", 0x80000, 0x185f8c43, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "avp.13", 0x200000, 0x8f8b5ae4, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "avp.15", 0x200000, 0xb00280df, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "avp.17", 0x200000, 0x94403195, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "avp.19", 0x200000, 0xe1981245, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "avp.14", 0x200000, 0xebba093e, REGION_GFX1, 0x0800000, LOAD_16_64 },
  { "avp.16", 0x200000, 0xfb228297, REGION_GFX1, 0x0800002, LOAD_16_64 },
  { "avp.18", 0x200000, 0x34fb7232, REGION_GFX1, 0x0800004, LOAD_16_64 },
  { "avp.20", 0x200000, 0xf90baa21, REGION_GFX1, 0x0800006, LOAD_16_64 },
  { "avp.01", 0x20000, 0x2d3b4220, REGION_ROM2, 0, LOAD_NORMAL },
  { "avp.11", 0x200000, 0x83499817, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "avp.12", 0x200000, 0xf4110d49, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _dstlk_roms[] =
{
  { "vame.03a", 0x80000, 0x004c9cff, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "vame.04a", 0x80000, 0xae413ff2, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "vame.05a", 0x80000, 0x60678756, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "vame.06a", 0x80000, 0x912870b3, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "vame.07a", 0x80000, 0xdabae3e8, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "vame.08a", 0x80000, 0x2c6e3077, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "vame.09a", 0x80000, 0xf16db74b, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "vame.10a", 0x80000, 0x701e2147, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "vamex.03a", 0x80000, 0x2d1e4919, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "vamex.04a", 0x80000, 0xe5172837, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "vam.13", 0x400000, 0xc51baf99, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "vam.15", 0x400000, 0x3ce83c77, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "vam.17", 0x400000, 0x4f2408e0, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "vam.19", 0x400000, 0x9ff60250, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "vam.14", 0x100000, 0xbd87243c, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "vam.16", 0x100000, 0xafec855f, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "vam.18", 0x100000, 0x3a033625, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "vam.20", 0x100000, 0x2bff6a89, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "vam.01", 0x20000, 0x64b685d5, REGION_ROM2, 0, LOAD_NORMAL },
  { "vam.02", 0x20000, 0xcf7c97c7, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "vam.11", 0x200000, 0x4a39deb2, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "vam.12", 0x200000, 0x1a3e5c03, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _19xx_roms[] =
{
  { "19xu.03", 0x80000, 0x05955268, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "19xu.04", 0x80000, 0x3111ab7f, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "19xu.05", 0x80000, 0x38df4a63, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "19xu.06", 0x80000, 0x5c7e60d3, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "19x.07", 0x80000, 0x61c0296c, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "19xux.03", 0x80000, 0x239a08ae, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "19xux.04", 0x80000, 0xc13a1072, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "19xux.05", 0x80000, 0x8c066ec3, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "19xux.06", 0x80000, 0x4b1caeb9, REGION_USER1, 0x180000, LOAD_SWAP_16 },
  { "19x.13", 0x080000, 0x427aeb18, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "19x.15", 0x080000, 0x63bdbf54, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "19x.17", 0x080000, 0x2dfe18b5, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "19x.19", 0x080000, 0xcbef9579, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "19x.14", 0x200000, 0xe916967c, REGION_GFX1, 0x0800000, LOAD_16_64 },
  { "19x.16", 0x200000, 0x6e75f3db, REGION_GFX1, 0x0800002, LOAD_16_64 },
  { "19x.18", 0x200000, 0x2213e798, REGION_GFX1, 0x0800004, LOAD_16_64 },
  { "19x.20", 0x200000, 0xab9d5b96, REGION_GFX1, 0x0800006, LOAD_16_64 },
  { "19x.01", 0x20000, 0xef55195e, REGION_ROM2, 0, LOAD_NORMAL },
  { "19x.11", 0x200000, 0xd38beef3, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "19x.12", 0x200000, 0xd47c96e2, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _ringdest_roms[] =
{
  { "smbe.03b", 0x80000, 0xb8016278, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "smbe.04b", 0x80000, 0x18c4c447, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "smbe.05b", 0x80000, 0x18ebda7f, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "smbe.06b", 0x80000, 0x89c80007, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "smb.07", 0x80000, 0xb9a11577, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "smb.08", 0x80000, 0xf931b76b, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "smbex.03b", 0x80000, 0x3b1457bd, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "smbex.04b", 0x80000, 0x6299eb4e, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "smbex.05b", 0x80000, 0xbe4a84d1, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "smb.13", 0x200000, 0xd9b2d1de, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "smb.15", 0x200000, 0x9a766d92, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "smb.17", 0x200000, 0x51800f0f, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "smb.19", 0x200000, 0x35757e96, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "smb.14", 0x200000, 0xe5bfd0e7, REGION_GFX1, 0x0800000, LOAD_16_64 },
  { "smb.16", 0x200000, 0xc56c0866, REGION_GFX1, 0x0800002, LOAD_16_64 },
  { "smb.18", 0x200000, 0x4ded3910, REGION_GFX1, 0x0800004, LOAD_16_64 },
  { "smb.20", 0x200000, 0x26ea1ec5, REGION_GFX1, 0x0800006, LOAD_16_64 },
  { "smb.21", 0x080000, 0x0a08c5fc, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "smb.23", 0x080000, 0x0911b6c4, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "smb.25", 0x080000, 0x82d6c4ec, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "smb.27", 0x080000, 0x9b48678b, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "smb.01", 0x20000, 0x0abc229a, REGION_ROM2, 0, LOAD_NORMAL },
  { "smb.02", 0x20000, 0xd051679a, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "smb.11", 0x200000, 0xc56935f9, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "smb.12", 0x200000, 0x955b0782, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _nwarr_roms[] =
{
  { "vphu.03f", 0x80000, 0x85d6a359, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "vphu.04c", 0x80000, 0xcb7fce77, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "vphu.05e", 0x80000, 0xe08f2bba, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "vphu.06c", 0x80000, 0x08c04cdb, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "vphu.07b", 0x80000, 0xb5a5ab19, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "vphu.08b", 0x80000, 0x51bb20fb, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "vphu.09b", 0x80000, 0x41a64205, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "vphu.10b", 0x80000, 0x2b1d43ae, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "vphux.03f", 0x80000, 0xd1c35094, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "vphux.04c", 0x80000, 0x48b01f4e, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "vphux.05e", 0x80000, 0x0147c2a5, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "vph.13", 0x400000, 0xc51baf99, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "vph.15", 0x400000, 0x3ce83c77, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "vph.17", 0x400000, 0x4f2408e0, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "vph.19", 0x400000, 0x9ff60250, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "vph.14", 0x400000, 0x7a0e1add, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "vph.16", 0x400000, 0x2f41ca75, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "vph.18", 0x400000, 0x64498eed, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "vph.20", 0x400000, 0x17f2433f, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "vph.01", 0x20000, 0x5045dcac, REGION_ROM2, 0, LOAD_NORMAL },
  { "vph.02", 0x20000, 0x86b60e59, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "vph.11", 0x200000, 0xe1837d33, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "vph.12", 0x200000, 0xfbd3cd90, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _sfa_roms[] =
{
  { "sfze.03d", 0x80000, 0xebf2054d, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "sfz.04b", 0x80000, 0x8b73b0e5, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "sfz.05a", 0x80000, 0x0810544d, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "sfz.06", 0x80000, 0x806e8f38, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "sfzex.03d", 0x80000, 0x505a1b4a, REGION_USER1, 0x000000, LOAD_SWAP_16 },
/* Ignored : 	ROM_FILL(              0x000000, 0x800000, 0 ) */
  { "sfz.14", 0x200000, 0x90fefdb3, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "sfz.16", 0x200000, 0x5354c948, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "sfz.18", 0x200000, 0x41a1e790, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "sfz.20", 0x200000, 0xa549df98, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "sfz.01", 0x20000, 0xffffec7d, REGION_ROM2, 0, LOAD_NORMAL },
  { "sfz.02", 0x20000, 0x45f46a08, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "sfz.11", 0x200000, 0xc4b093cd, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "sfz.12", 0x200000, 0x8bdbc4b4, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _ddsom_roms[] =
{
  { "dd2e.03e", 0x80000, 0x449361af, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "dd2e.04e", 0x80000, 0x5b7052b6, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "dd2e.05e", 0x80000, 0x788d5f60, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "dd2e.06e", 0x80000, 0xe0807e1e, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "dd2e.07", 0x80000, 0xbb777a02, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "dd2e.08", 0x80000, 0x30970890, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "dd2e.09", 0x80000, 0x99e2194d, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "dd2e.10", 0x80000, 0xe198805e, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "dd2ex.03e", 0x80000, 0xbdbc9b38, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "dd2ex.04e", 0x80000, 0x24d1be86, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "dd2.13", 0x400000, 0xa46b4e6e, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "dd2.15", 0x400000, 0xd5fc50fc, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "dd2.17", 0x400000, 0x837c0867, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "dd2.19", 0x400000, 0xbb0ec21c, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "dd2.14", 0x200000, 0x6d824ce2, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "dd2.16", 0x200000, 0x79682ae5, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "dd2.18", 0x200000, 0xacddd149, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "dd2.20", 0x200000, 0x117fb0c0, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "dd2.01", 0x20000, 0x99d657e5, REGION_ROM2, 0, LOAD_NORMAL },
  { "dd2.02", 0x20000, 0x117a3824, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "dd2.11", 0x200000, 0x98d0c325, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "dd2.12", 0x200000, 0x5ea2e7fa, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _megaman2_roms[] =
{
  { "rm2u.03", 0x80000, 0x8ffc2cd1, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "rm2u.04", 0x80000, 0xbb30083a, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "rm2.05", 0x80000, 0x02ee9efc, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "rm2ux.03", 0x80000, 0x93e28bde, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "rm2ux.04", 0x80000, 0x74ebf83c, REGION_USER1, 0x080000, LOAD_SWAP_16 },
/* Ignored : 	ROM_FILL(              0x000000, 0x800000, 0 ) */
  { "rm2.14", 0x200000, 0x9b1f00b4, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "rm2.16", 0x200000, 0xc2bb0c24, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "rm2.18", 0x200000, 0x12257251, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "rm2.20", 0x200000, 0xf9b6e786, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "rm2.01a", 0x20000, 0xd18e7859, REGION_ROM2, 0, LOAD_NORMAL },
  { "rm2.02", 0x20000, 0xc463ece0, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "rm2.11", 0x200000, 0x2106174d, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "rm2.12", 0x200000, 0x546c1636, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _sfa2_roms[] =
{
  { "sz2u.03", 0x80000, 0x84a09006, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "sz2u.04", 0x80000, 0xac46e5ed, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "sz2u.05", 0x80000, 0x6c0c79d3, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "sz2u.06", 0x80000, 0xc5c8eb63, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "sz2u.07", 0x80000, 0x5de01cc5, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "sz2u.08", 0x80000, 0xbea11d56, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "sz2ux.03", 0x80000, 0x6bb6005f, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "sz2ux.04", 0x80000, 0x74308a4b, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "sz2.13", 0x400000, 0x4d1f1f22, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "sz2.15", 0x400000, 0x19cea680, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "sz2.17", 0x400000, 0xe01b4588, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "sz2.19", 0x400000, 0x0feeda64, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "sz2.14", 0x100000, 0x0560c6aa, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "sz2.16", 0x100000, 0xae940f87, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "sz2.18", 0x100000, 0x4bc3c8bc, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "sz2.20", 0x100000, 0x39e674c0, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "sz2.01a", 0x20000, 0x1bc323cf, REGION_ROM2, 0, LOAD_NORMAL },
  { "sz2.02a", 0x20000, 0xba6a5013, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "sz2.11", 0x200000, 0xaa47a601, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "sz2.12", 0x200000, 0x2237bc53, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _spf2t_roms[] =
{
  { "pzfu.03a", 0x80000, 0x346e62ef, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "pzf.04a", 0x80000, 0xb80649e2, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "pzfux.03a", 0x80000, 0x200feea6, REGION_USER1, 0x000000, LOAD_SWAP_16 },
/* Ignored : 	ROM_FILL(             0x000000, 0x800000, 0 ) */
  { "pzf.14", 0x100000, 0x2d4881cb, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "pzf.16", 0x100000, 0x4b0fd1be, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "pzf.18", 0x100000, 0xe43aac33, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "pzf.20", 0x100000, 0x7f536ff1, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "pzf.01", 0x20000, 0x600fb2a3, REGION_ROM2, 0, LOAD_NORMAL },
  { "pzf.02", 0x20000, 0x496076e0, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "pzf.11", 0x200000, 0x78442743, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "pzf.12", 0x200000, 0x399d2c7b, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _xmvsfr1_roms[] =
{
  { "xvse.03d", 0x80000, 0x5ae5bd3b, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "xvse.04d", 0x80000, 0x5eb9c02e, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "xvs.05a", 0x80000, 0x7db6025d, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "xvs.06a", 0x80000, 0xe8e2c75c, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "xvs.07", 0x80000, 0x08f0abed, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "xvs.08", 0x80000, 0x81929675, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "xvs.09", 0x80000, 0x9641f36b, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "xvsex.03d", 0x80000, 0x3b3e7836, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "xvsex.04d", 0x80000, 0x108863ce, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "xvs.13", 0x400000, 0xf6684efd, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "xvs.15", 0x400000, 0x29109221, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "xvs.17", 0x400000, 0x92db3474, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "xvs.19", 0x400000, 0x3733473c, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "xvs.14", 0x400000, 0xbcac2e41, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "xvs.16", 0x400000, 0xea04a272, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "xvs.18", 0x400000, 0xb0def86a, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "xvs.20", 0x400000, 0x4b40ff9f, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "xvs.01", 0x20000, 0x3999e93a, REGION_ROM2, 0, LOAD_NORMAL },
  { "xvs.02", 0x20000, 0x101bdee9, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "xvs.11", 0x200000, 0x9cadcdbc, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "xvs.12", 0x200000, 0x7b11e460, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _batcir_roms[] =
{
  { "btce.03", 0x80000, 0xbc60484b, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "btce.04", 0x80000, 0x457d55f6, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "btce.05", 0x80000, 0xe86560d7, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "btce.06", 0x80000, 0xf778e61b, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "btc.07", 0x80000, 0x7322d5db, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "btc.08", 0x80000, 0x6aac85ab, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "btc.09", 0x80000, 0x1203db08, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "btcex.03", 0x80000, 0x2d193cd0, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "btcex.04", 0x80000, 0xa3895d8b, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "btcex.05", 0x80000, 0xbdbed16f, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "btcex.06", 0x80000, 0x02048217, REGION_USER1, 0x180000, LOAD_SWAP_16 },
  { "btc.13", 0x400000, 0xdc705bad, REGION_GFX1, 0x000000, LOAD_16_64 },
  { "btc.15", 0x400000, 0xe5779a3c, REGION_GFX1, 0x000002, LOAD_16_64 },
  { "btc.17", 0x400000, 0xb33f4112, REGION_GFX1, 0x000004, LOAD_16_64 },
  { "btc.19", 0x400000, 0xa6fcdb7e, REGION_GFX1, 0x000006, LOAD_16_64 },
  { "btc.01", 0x20000, 0x1e194310, REGION_ROM2, 0, LOAD_NORMAL },
  { "btc.02", 0x20000, 0x01aeb8e6, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "btc.11", 0x200000, 0xc27f2229, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "btc.12", 0x200000, 0x418a2e33, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _csclub_roms[] =
{
  { "csce.03", 0x80000, 0xf2c852ef, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "csce.04", 0x80000, 0x1184530f, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "csce.05", 0x80000, 0x804e2b6b, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "csce.06", 0x80000, 0x09277cb9, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "csc.07", 0x80000, 0x01b05caa, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "cscex.03", 0x80000, 0x305fce70, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "cscex.04", 0x80000, 0xd11da066, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "cscex.05", 0x80000, 0x410c6220, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "cscex.06", 0x80000, 0xeaf70123, REGION_USER1, 0x180000, LOAD_SWAP_16 },
/* Ignored : 	ROM_FILL(              0x000000, 0x800000, 0 ) */
  { "csc.14", 0x200000, 0xe8904afa, REGION_GFX1, 0x800000, LOAD_16_64 },
  { "csc.16", 0x200000, 0xc98c8079, REGION_GFX1, 0x800002, LOAD_16_64 },
  { "csc.18", 0x200000, 0xc030df5a, REGION_GFX1, 0x800004, LOAD_16_64 },
  { "csc.20", 0x200000, 0xb4e55863, REGION_GFX1, 0x800006, LOAD_16_64 },
  { "csc.01", 0x20000, 0xee162111, REGION_ROM2, 0, LOAD_NORMAL },
  { "csc.11", 0x200000, 0xa027b827, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "csc.12", 0x200000, 0xcb7f6e55, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _mshvsfu_roms[] =
{
  { "mvsu.03g", 0x80000, 0x0664ab15, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mvsu.04g", 0x80000, 0x97e060ee, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "mvs.05d", 0x80000, 0x921fc542, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "mvs.06a", 0x80000, 0x959f3030, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "mvs.07b", 0x80000, 0x7f915bdb, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "mvs.08a", 0x80000, 0xc2813884, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "mvs.09b", 0x80000, 0x3ba08818, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "mvs.10b", 0x80000, 0xcf0dba98, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "mvsux.03g", 0x80000, 0x17b12a95, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "mvsux.04g", 0x80000, 0xf98200cf, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "mvs.13", 0x400000, 0x29b05fd9, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "mvs.15", 0x400000, 0xfaddccf1, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "mvs.17", 0x400000, 0x97aaf4c7, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "mvs.19", 0x400000, 0xcb70e915, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "mvs.14", 0x400000, 0xb3b1972d, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "mvs.16", 0x400000, 0x08aadb5d, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "mvs.18", 0x400000, 0xc1228b35, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "mvs.20", 0x400000, 0x366cc6c2, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "mvs.01", 0x20000, 0x68252324, REGION_ROM2, 0, LOAD_NORMAL },
  { "mvs.02", 0x20000, 0xb34e773d, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "mvs.11", 0x400000, 0x86219770, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "mvs.12", 0x400000, 0xf2fd7f68, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _gigawing_roms[] =
{
  { "ggwu.03", 0x80000, 0xac725eb2, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "ggwu.04", 0x80000, 0x392f4118, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "ggwu.05", 0x80000, 0x3239d642, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "ggwux.03", 0x80000, 0x2f18fd96, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "ggwux.04", 0x80000, 0x7be82def, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "ggw.13", 0x400000, 0x105530a4, REGION_GFX1, 0x000000, LOAD_16_64 },
  { "ggw.15", 0x400000, 0x9e774ab9, REGION_GFX1, 0x000002, LOAD_16_64 },
  { "ggw.17", 0x400000, 0x466e0ba4, REGION_GFX1, 0x000004, LOAD_16_64 },
  { "ggw.19", 0x400000, 0x840c8dea, REGION_GFX1, 0x000006, LOAD_16_64 },
  { "ggw.01", 0x20000, 0x4c6351d5, REGION_ROM2, 0, LOAD_NORMAL },
  { "ggw.11", 0x400000, 0xe172acf5, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "ggw.12", 0x400000, 0x4bee4e8f, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _mmatrix_roms[] =
{
  { "mmxu.03", 0x80000, 0xab65b599, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mmxu.04", 0x80000, 0x0135fc6c, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "mmxu.05", 0x80000, 0xf1fd2b84, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "mmxux.03", 0x80000, 0x7868ae77, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "mmxux.04", 0x80000, 0xa5ee6d07, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "mmxux.05", 0x80000, 0xb07745ff, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "mmx.13", 0x400000, 0x04748718, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "mmx.15", 0x400000, 0x38074f44, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "mmx.17", 0x400000, 0xe4635e35, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "mmx.19", 0x400000, 0x4400a3f2, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "mmx.14", 0x400000, 0xd52bf491, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "mmx.16", 0x400000, 0x23f70780, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "mmx.18", 0x400000, 0x2562c9d5, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "mmx.20", 0x400000, 0x583a9687, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "mmx.01", 0x20000, 0xc57e8171, REGION_ROM2, 0, LOAD_NORMAL },
  { "mmx.11", 0x400000, 0x4180b39f, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "mmx.12", 0x400000, 0x95e22a59, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _vsav_roms[] =
{
  { "vm3e.03d", 0x80000, 0xf5962a8c, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "vm3e.04d", 0x80000, 0x21b40ea2, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "vm3.05a", 0x80000, 0x4118e00f, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "vm3.06a", 0x80000, 0x2f4fd3a9, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "vm3.07b", 0x80000, 0xcbda91b8, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "vm3.08a", 0x80000, 0x6ca47259, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "vm3.09b", 0x80000, 0xf4a339e3, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "vm3.10b", 0x80000, 0xfffbb5b8, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "vm3ex.03d", 0x80000, 0xfa586edf, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "vm3ex.04d", 0x80000, 0xeb912f2b, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "vm3.13", 0x400000, 0xfd8a11eb, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "vm3.15", 0x400000, 0xdd1e7d4e, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "vm3.17", 0x400000, 0x6b89445e, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "vm3.19", 0x400000, 0x3830fdc7, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "vm3.14", 0x400000, 0xc1a28e6c, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "vm3.16", 0x400000, 0x194a7304, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "vm3.18", 0x400000, 0xdf9a9f47, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "vm3.20", 0x400000, 0xc22fc3d9, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "vm3.01", 0x20000, 0xf778769b, REGION_ROM2, 0, LOAD_NORMAL },
  { "vm3.02", 0x20000, 0xcc09faa1, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "vm3.11", 0x400000, 0xe80e956e, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "vm3.12", 0x400000, 0x9cd71557, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _vsav2_roms[] =
{
  { "vs2j.03", 0x80000, 0x89fd86b4, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "vs2j.04", 0x80000, 0x107c091b, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "vs2j.05", 0x80000, 0x61979638, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "vs2j.06", 0x80000, 0xf37c5bc2, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "vs2j.07", 0x80000, 0x8f885809, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "vs2j.08", 0x80000, 0x2018c120, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "vs2j.09", 0x80000, 0xfac3c217, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "vs2j.10", 0x80000, 0xeb490213, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "vs2jx.03", 0x80000, 0x8f83159a, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "vs2jx.04", 0x80000, 0xe9822de8, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "vs2.13", 0x400000, 0x5c852f52, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "vs2.15", 0x400000, 0xa20f58af, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "vs2.17", 0x400000, 0x39db59ad, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "vs2.19", 0x400000, 0x00c763a7, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "vs2.14", 0x400000, 0xcd09bd63, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "vs2.16", 0x400000, 0xe0182c15, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "vs2.18", 0x400000, 0x778dc4f6, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "vs2.20", 0x400000, 0x605d9d1d, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "vs2.01", 0x20000, 0x35190139, REGION_ROM2, 0, LOAD_NORMAL },
  { "vs2.02", 0x20000, 0xc32dba09, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "vs2.11", 0x400000, 0xd67e47b7, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "vs2.12", 0x400000, 0x6d020a14, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _mvscu_roms[] =
{
  { "mvcu.03d", 0x80000, 0xc6007557, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mvcu.04d", 0x80000, 0x724b2b20, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "mvc.05a", 0x80000, 0x2d8c8e86, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "mvc.06a", 0x80000, 0x8528e1f5, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "mvc.07", 0x80000, 0xc3baa32b, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "mvc.08", 0x80000, 0xbc002fcd, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "mvc.09", 0x80000, 0xc67b26df, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "mvc.10", 0x80000, 0x0fdd1e26, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "mvcux.03d", 0x80000, 0x86685cbf, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "mvcux.04d", 0x80000, 0x438ba92b, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "mvc.13", 0x400000, 0xfa5f74bc, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "mvc.15", 0x400000, 0x71938a8f, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "mvc.17", 0x400000, 0x92741d07, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "mvc.19", 0x400000, 0xbcb72fc6, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "mvc.14", 0x400000, 0x7f1df4e4, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "mvc.16", 0x400000, 0x90bd3203, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "mvc.18", 0x400000, 0x67aaf727, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "mvc.20", 0x400000, 0x8b0bade8, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "mvc.01", 0x20000, 0x41629e95, REGION_ROM2, 0, LOAD_NORMAL },
  { "mvc.02", 0x20000, 0x963abf6b, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "mvc.11", 0x400000, 0x850fe663, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "mvc.12", 0x400000, 0x7ccb1896, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _sfa3_roms[] =
{
  { "sz3u.03c", 0x80000, 0xe007da2e, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "sz3u.04c", 0x80000, 0x5f78f0e7, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "sz3.05c", 0x80000, 0x57fd0a40, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "sz3.06c", 0x80000, 0xf6305f8b, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "sz3.07c", 0x80000, 0x6eab0f6f, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "sz3.08c", 0x80000, 0x910c4a3b, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "sz3.09c", 0x80000, 0xb29e5199, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "sz3.10b", 0x80000, 0xdeb2ff52, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "sz3ux.03c", 0x80000, 0x7091276b, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "sz3ux.04c", 0x80000, 0x83b213b1, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "sz3.13", 0x400000, 0x0f7a60d9, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "sz3.15", 0x400000, 0x8e933741, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "sz3.17", 0x400000, 0xd6e98147, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "sz3.19", 0x400000, 0xf31a728a, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "sz3.14", 0x400000, 0x5ff98297, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "sz3.16", 0x400000, 0x52b5bdee, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "sz3.18", 0x400000, 0x40631ed5, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "sz3.20", 0x400000, 0x763409b4, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "sz3.01", 0x20000, 0xde810084, REGION_ROM2, 0, LOAD_NORMAL },
  { "sz3.02", 0x20000, 0x72445dc4, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "sz3.11", 0x400000, 0x1c89eed1, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "sz3.12", 0x400000, 0xf392b13a, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _mpangj_roms[] =
{
  { "mpnj.03a", 0x80000, 0xbf597b1c, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mpnj.04a", 0x80000, 0xf4a3ab0f, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "mpnjx.03a", 0x80000, 0xeccaf0cc, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "mpnjx.04a", 0x80000, 0x34ac83f8, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "mpn-sim.01c", 0x200000, 0x388db66b, REGION_GFX1, 0x0000000, LOAD_8_64 },
  { "mpn-sim.01d", 0x200000, 0xaff1b494, REGION_GFX1, 0x0000001, LOAD_8_64 },
  { "mpn-sim.01a", 0x200000, 0xa9c4857b, REGION_GFX1, 0x0000002, LOAD_8_64 },
  { "mpn-sim.01b", 0x200000, 0xf759df22, REGION_GFX1, 0x0000003, LOAD_8_64 },
  { "mpn-sim.03c", 0x200000, 0xdec6b720, REGION_GFX1, 0x0000004, LOAD_8_64 },
  { "mpn-sim.03d", 0x200000, 0xf8774c18, REGION_GFX1, 0x0000005, LOAD_8_64 },
  { "mpn-sim.03a", 0x200000, 0xc2aea4ec, REGION_GFX1, 0x0000006, LOAD_8_64 },
  { "mpn-sim.03b", 0x200000, 0x84d6dc33, REGION_GFX1, 0x0000007, LOAD_8_64 },
  { "mpn.01", 0x20000, 0x90c7adb6, REGION_ROM2, 0, LOAD_NORMAL },
  { "mpn-sim.05a", 0x200000, 0x318a2e21, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "mpn-sim.05b", 0x200000, 0x5462f4e8, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _armwarr1_roms[] =
{
  { "pwge.03b", 0x80000, 0xe822e3e9, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "pwge.04b", 0x80000, 0x4f89de39, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "pwge.05a", 0x80000, 0x83df24e5, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "pwg.06", 0x80000, 0x87a60ce8, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "pwg.07", 0x80000, 0xf7b148df, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "pwg.08", 0x80000, 0xcc62823e, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "pwg.09", 0x80000, 0xddc85ca6, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "pwg.10", 0x80000, 0x07c4fb28, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
/*	ROM_LOAD16_WORD_SWAP( "pwgex.03c", 0x000000, 0x80000, NO_DUMP ) */
/*	ROM_LOAD16_WORD_SWAP( "pwgex.04c", 0x000000, 0x80000, NO_DUMP ) */
  { "pwgex.03b", 0x80000, 0x741fc2b0, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "pwgex.04b", 0x80000, 0x5bb96a5d, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "pwg.13m", 0x400000, 0xae8fe08e, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "pwg.15m", 0x400000, 0xdb560f58, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "pwg.17m", 0x400000, 0xbc475b94, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "pwg.19m", 0x400000, 0x07439ff7, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "pwg.14m", 0x100000, 0xc3f9ba63, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "pwg.16m", 0x100000, 0x815b0e7b, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "pwg.18m", 0x100000, 0x0109c71b, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "pwg.20m", 0x100000, 0xeb75ffbe, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "pwg.01", 0x20000, 0x18a5c0e4, REGION_ROM2, 0, LOAD_NORMAL },
  { "pwg.02", 0x20000, 0xc9dfffa6, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "pwg.11m", 0x200000, 0xa78f7433, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "pwg.12m", 0x200000, 0x77438ed0, REGION_SMP1, 0x200000, LOAD_SWAP_16 },

  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _armwaru_roms[] =
{
  { "pwgu.03b", 0x80000, 0x8b95497a, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "pwgu.04b", 0x80000, 0x29eb5661, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "pwgu.05b", 0x80000, 0xa54e9e44, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "pwg.06", 0x80000, 0x87a60ce8, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "pwg.07", 0x80000, 0xf7b148df, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "pwg.08", 0x80000, 0xcc62823e, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "pwg.09a", 0x80000, 0x4c26baee, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "pwg.10", 0x80000, 0x07c4fb28, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "pwgux.03b", 0x80000, 0x5d41ddde, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "pwgux.04b", 0x80000, 0x4d0619f3, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "pwg.13m", 0x400000, 0xae8fe08e, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "pwg.15m", 0x400000, 0xdb560f58, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "pwg.17m", 0x400000, 0xbc475b94, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "pwg.19m", 0x400000, 0x07439ff7, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "pwg.14m", 0x100000, 0xc3f9ba63, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "pwg.16m", 0x100000, 0x815b0e7b, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "pwg.18m", 0x100000, 0x0109c71b, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "pwg.20m", 0x100000, 0xeb75ffbe, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "pwg.01", 0x20000, 0x18a5c0e4, REGION_ROM2, 0, LOAD_NORMAL },
  { "pwg.02", 0x20000, 0xc9dfffa6, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "pwg.11m", 0x200000, 0xa78f7433, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "pwg.12m", 0x200000, 0x77438ed0, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _cybots_roms[] =
{
  { "cybe.03", 0x80000, 0x234381cd, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "cybe.04", 0x80000, 0x80691061, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "cyb.05", 0x80000, 0xec40408e, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "cyb.06", 0x80000, 0x1ad0bed2, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "cyb.07", 0x80000, 0x6245a39a, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "cyb.08", 0x80000, 0x4b48e223, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "cyb.09", 0x80000, 0xe15238f6, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "cyb.10", 0x80000, 0x75f4003b, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
/*	ROM_LOAD16_WORD_SWAP( "cybex.03", 0x000000, 0x80000, NO_DUMP ) */
/*	ROM_LOAD16_WORD_SWAP( "cybex.04", 0x080000, 0x80000, NO_DUMP ) */
  { "cyb.13", 0x400000, 0xf0dce192, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "cyb.15", 0x400000, 0x187aa39c, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "cyb.17", 0x400000, 0x8a0e4b12, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "cyb.19", 0x400000, 0x34b62612, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "cyb.14", 0x400000, 0xc1537957, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "cyb.16", 0x400000, 0x15349e86, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "cyb.18", 0x400000, 0xd83e977d, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "cyb.20", 0x400000, 0x77cdad5c, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "cyb.01", 0x20000, 0x9c0fb079, REGION_ROM2, 0, LOAD_NORMAL },
  { "cyb.02", 0x20000, 0x51cb0c4e, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "cyb.11", 0x200000, 0x362ccab2, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "cyb.12", 0x200000, 0x7066e9cc, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _cybotsu_roms[] =
{
  { "cybu.03", 0x80000, 0xdb4da8f4, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "cybu.04", 0x80000, 0x1eec68ac, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "cyb.05", 0x80000, 0xec40408e, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "cyb.06", 0x80000, 0x1ad0bed2, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "cyb.07", 0x80000, 0x6245a39a, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "cyb.08", 0x80000, 0x4b48e223, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "cyb.09", 0x80000, 0xe15238f6, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "cyb.10", 0x80000, 0x75f4003b, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "cybux.03", 0x80000, 0x4b4f5b32, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "cybux.04", 0x80000, 0x6615a7e9, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "cyb.13", 0x400000, 0xf0dce192, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "cyb.15", 0x400000, 0x187aa39c, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "cyb.17", 0x400000, 0x8a0e4b12, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "cyb.19", 0x400000, 0x34b62612, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "cyb.14", 0x400000, 0xc1537957, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "cyb.16", 0x400000, 0x15349e86, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "cyb.18", 0x400000, 0xd83e977d, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "cyb.20", 0x400000, 0x77cdad5c, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "cyb.01", 0x20000, 0x9c0fb079, REGION_ROM2, 0, LOAD_NORMAL },
  { "cyb.02", 0x20000, 0x51cb0c4e, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "cyb.11", 0x200000, 0x362ccab2, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "cyb.12", 0x200000, 0x7066e9cc, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _msh_roms[] =
{
  { "mshe.03e", 0x80000, 0xbd951414, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mshe.04e", 0x80000, 0x19dd42f2, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "msh.05", 0x80000, 0x6a091b9e, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "msh.06b", 0x80000, 0x803e3fa4, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "msh.07a", 0x80000, 0xc45f8e27, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "msh.08a", 0x80000, 0x9ca6f12c, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "msh.09a", 0x80000, 0x82ec27af, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "msh.10b", 0x80000, 0x8d931196, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
/*	ROM_LOAD16_WORD_SWAP( "mshex.03e", 0x000000, 0x80000, NO_DUMP ) */
/*	ROM_LOAD16_WORD_SWAP( "mshex.04e", 0x080000, 0x80000, NO_DUMP ) */
  { "msh.13", 0x400000, 0x09d14566, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "msh.15", 0x400000, 0xee962057, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "msh.17", 0x400000, 0x604ece14, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "msh.19", 0x400000, 0x94a731e8, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "msh.14", 0x400000, 0x4197973e, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "msh.16", 0x400000, 0x438da4a0, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "msh.18", 0x400000, 0x4db92d94, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "msh.20", 0x400000, 0xa2b0c6c0, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "msh.01", 0x20000, 0xc976e6f9, REGION_ROM2, 0, LOAD_NORMAL },
  { "msh.02", 0x20000, 0xce67d0d9, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "msh.11", 0x200000, 0x37ac6d30, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "msh.12", 0x200000, 0xde092570, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _mshh_roms[] =
{
  { "mshh.03c", 0x80000, 0x8d84b0fa, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mshh.04c", 0x80000, 0xd638f601, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "msh.05a", 0x80000, 0xf37539e6, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "msh.06b", 0x80000, 0x803e3fa4, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "msh.07a", 0x80000, 0xc45f8e27, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "msh.08a", 0x80000, 0x9ca6f12c, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "msh.09a", 0x80000, 0x82ec27af, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "msh.10b", 0x80000, 0x8d931196, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "mshhx.03c", 0x80000, 0x6daf52bb, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "mshhx.04c", 0x80000, 0x5684655a, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "msh.13", 0x400000, 0x09d14566, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "msh.15", 0x400000, 0xee962057, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "msh.17", 0x400000, 0x604ece14, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "msh.19", 0x400000, 0x94a731e8, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "msh.14", 0x400000, 0x4197973e, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "msh.16", 0x400000, 0x438da4a0, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "msh.18", 0x400000, 0x4db92d94, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "msh.20", 0x400000, 0xa2b0c6c0, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "msh.01", 0x20000, 0xc976e6f9, REGION_ROM2, 0, LOAD_NORMAL },
  { "msh.02", 0x20000, 0xce67d0d9, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "msh.11", 0x200000, 0x37ac6d30, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "msh.12", 0x200000, 0xde092570, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _mshu_roms[] =
{
  { "mshu.03", 0x80000, 0xd2805bdd, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "mshu.04", 0x80000, 0x743f96ff, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "msh.05", 0x80000, 0x6a091b9e, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "msh.06b", 0x80000, 0x803e3fa4, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "msh.07a", 0x80000, 0xc45f8e27, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "msh.08a", 0x80000, 0x9ca6f12c, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "msh.09a", 0x80000, 0x82ec27af, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "msh.10b", 0x80000, 0x8d931196, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "mshux.03", 0x80000, 0x10bfc357, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "mshux.04", 0x80000, 0x871f0863, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "msh.13", 0x400000, 0x09d14566, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "msh.15", 0x400000, 0xee962057, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "msh.17", 0x400000, 0x604ece14, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "msh.19", 0x400000, 0x94a731e8, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "msh.14", 0x400000, 0x4197973e, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "msh.16", 0x400000, 0x438da4a0, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "msh.18", 0x400000, 0x4db92d94, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "msh.20", 0x400000, 0xa2b0c6c0, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "msh.01", 0x20000, 0xc976e6f9, REGION_ROM2, 0, LOAD_NORMAL },
  { "msh.02", 0x20000, 0xce67d0d9, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "msh.11", 0x200000, 0x37ac6d30, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "msh.12", 0x200000, 0xde092570, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _progear_roms[] =
{
  { "pgau.03", 0x80000, 0x343a783e, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "pgau.04", 0x80000, 0x16208d79, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "pgaux.03", 0x80000, 0xfd58616b, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "pgaux.04", 0x80000, 0x6081a891, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "pga-sim.01c", 0x200000, 0x452f98b0, REGION_GFX1, 0x0000000, LOAD_8_64 },
  { "pga-sim.01d", 0x200000, 0x9e672092, REGION_GFX1, 0x0000001, LOAD_8_64 },
  { "pga-sim.01a", 0x200000, 0xae9ddafe, REGION_GFX1, 0x0000002, LOAD_8_64 },
  { "pga-sim.01b", 0x200000, 0x94d72d94, REGION_GFX1, 0x0000003, LOAD_8_64 },
  { "pga-sim.03c", 0x200000, 0x48a1886d, REGION_GFX1, 0x0000004, LOAD_8_64 },
  { "pga-sim.03d", 0x200000, 0x172d7e37, REGION_GFX1, 0x0000005, LOAD_8_64 },
  { "pga-sim.03a", 0x200000, 0x9ee33d98, REGION_GFX1, 0x0000006, LOAD_8_64 },
  { "pga-sim.03b", 0x200000, 0x848dee32, REGION_GFX1, 0x0000007, LOAD_8_64 },
  { "pga.01", 0x20000, 0xbdbfa992, REGION_ROM2, 0, LOAD_NORMAL },
  { "pga-sim.05a", 0x200000, 0xc0aac80c, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "pga-sim.05b", 0x200000, 0x37a65d86, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { "pga-sim.06a", 0x200000, 0xd3f1e934, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { "pga-sim.06b", 0x200000, 0x8b39489a, REGION_SMP1, 0x600000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROMSW_DATA romsw_msh[] =
{
  { "Japan", 0x0},
  { "USA",0x2},
  { "Hispanic", 0x4},
  { "Asia",0x6},
  { "Euro",0x8},
  { "Brazil",0xa},
  { NULL,                    0    },
};

static struct ROMSW_DATA romsw_vhunt2[] =
{
  { "Japan", 0x0},
  { "USA",0x2},
  { "Hispanic", 0x4},
  { "Oceania",0x6},
  { "Asia",0x8},
  { "Euro",0xa},
  { "Brazil",0xc},
  { NULL,                    0    },
};

static struct ROMSW_INFO msh_romsw[] =
{
   { 0xc3, 0x04, romsw_msh },
   { 0,        0,    NULL },
};

static struct ROMSW_INFO vhunt2_romsw[] =
{
   { 0x10ce, 0x00, romsw_vhunt2 },
   { 0,        0,    NULL },
};

static struct ROMSW_INFO mpangj_romsw[] =
{
   { 0x7a0, 0x00, romsw_vhunt2 },
   { 0,        0,    NULL },
};

static struct ROM_INFO _vhunt2_roms[] =
{
  { "vh2j.03a", 0x80000, 0x9ae8f186, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "vh2j.04a", 0x80000, 0xe2fabf53, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "vh2j.05", 0x80000, 0xde34f624, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "vh2j.06", 0x80000, 0x6a3b9897, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "vh2j.07", 0x80000, 0xb021c029, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "vh2j.08", 0x80000, 0xac873dff, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "vh2j.09", 0x80000, 0xeaefce9c, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "vh2j.10", 0x80000, 0x11730952, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
/*	ROM_LOAD16_WORD_SWAP( "vh2jx.03a", 0x000000, 0x80000, NO_DUMP ) */
/*	ROM_LOAD16_WORD_SWAP( "vh2jx.04a", 0x080000, 0x80000, NO_DUMP ) */
  { "vh2.13", 0x400000, 0x3b02ddaa, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "vh2.15", 0x400000, 0x4e40de66, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "vh2.17", 0x400000, 0xb31d00c9, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "vh2.19", 0x400000, 0x149be3ab, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "vh2.14", 0x400000, 0xcd09bd63, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "vh2.16", 0x400000, 0xe0182c15, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "vh2.18", 0x400000, 0x778dc4f6, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "vh2.20", 0x400000, 0x605d9d1d, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "vh2.01", 0x20000, 0x67b9f779, REGION_ROM2, 0, LOAD_NORMAL },
  { "vh2.02", 0x20000, 0xaaf15fcb, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "vh2.11", 0x400000, 0x38922efd, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "vh2.12", 0x400000, 0x6e2430af, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _vhunt2r1_roms[] =
{
  { "vh2j.03", 0x80000, 0x1a5feb13, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "vh2j.04", 0x80000, 0x434611a5, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "vh2j.05", 0x80000, 0xde34f624, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "vh2j.06", 0x80000, 0x6a3b9897, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "vh2j.07", 0x80000, 0xb021c029, REGION_ROM1, 0x200000, LOAD_SWAP_16 },
  { "vh2j.08", 0x80000, 0xac873dff, REGION_ROM1, 0x280000, LOAD_SWAP_16 },
  { "vh2j.09", 0x80000, 0xeaefce9c, REGION_ROM1, 0x300000, LOAD_SWAP_16 },
  { "vh2j.10", 0x80000, 0x11730952, REGION_ROM1, 0x380000, LOAD_SWAP_16 },
  { "vh2jx.03", 0x80000, 0x7d5d7aae, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "vh2jx.04", 0x80000, 0xc66e9aea, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "vh2.13", 0x400000, 0x3b02ddaa, REGION_GFX1, 0x0000000, LOAD_16_64 },
  { "vh2.15", 0x400000, 0x4e40de66, REGION_GFX1, 0x0000002, LOAD_16_64 },
  { "vh2.17", 0x400000, 0xb31d00c9, REGION_GFX1, 0x0000004, LOAD_16_64 },
  { "vh2.19", 0x400000, 0x149be3ab, REGION_GFX1, 0x0000006, LOAD_16_64 },
  { "vh2.14", 0x400000, 0xcd09bd63, REGION_GFX1, 0x1000000, LOAD_16_64 },
  { "vh2.16", 0x400000, 0xe0182c15, REGION_GFX1, 0x1000002, LOAD_16_64 },
  { "vh2.18", 0x400000, 0x778dc4f6, REGION_GFX1, 0x1000004, LOAD_16_64 },
  { "vh2.20", 0x400000, 0x605d9d1d, REGION_GFX1, 0x1000006, LOAD_16_64 },
  { "vh2.01", 0x20000, 0x67b9f779, REGION_ROM2, 0, LOAD_NORMAL },
  { "vh2.02", 0x20000, 0xaaf15fcb, REGION_ROM2, 0x20000, LOAD_NORMAL },
  { "vh2.11", 0x400000, 0x38922efd, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "vh2.12", 0x400000, 0x6e2430af, REGION_SMP1, 0x400000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct ROM_INFO _pzloop2j_roms[] =
{
  { "pl2j.03a", 0x80000, 0x0a751bd0, REGION_ROM1, 0x000000, LOAD_SWAP_16 },
  { "pl2j.04a", 0x80000, 0xc3f72afe, REGION_ROM1, 0x080000, LOAD_SWAP_16 },
  { "pl2j.05a", 0x80000, 0x6ea9dbfc, REGION_ROM1, 0x100000, LOAD_SWAP_16 },
  { "pl2j.06a", 0x80000, 0x0f14848d, REGION_ROM1, 0x180000, LOAD_SWAP_16 },
  { "pl2jx.03a", 0x80000, 0x3c9bdc30, REGION_USER1, 0x000000, LOAD_SWAP_16 },
  { "pl2jx.04a", 0x80000, 0xaa1b28f4, REGION_USER1, 0x080000, LOAD_SWAP_16 },
  { "pl2jx.05a", 0x80000, 0xcd27c17d, REGION_USER1, 0x100000, LOAD_SWAP_16 },
  { "pl2jx.06a", 0x80000, 0x48f3ac5f, REGION_USER1, 0x180000, LOAD_SWAP_16 },
  { "pl2-simm.01c", 0x200000, 0x137b13a7, REGION_GFX1, 0x0000000, LOAD_8_64 },
  { "pl2-simm.01d", 0x200000, 0xa2db1507, REGION_GFX1, 0x0000001, LOAD_8_64 },
  { "pl2-simm.01a", 0x200000, 0x7e80ff8e, REGION_GFX1, 0x0000002, LOAD_8_64 },
  { "pl2-simm.01b", 0x200000, 0xcd93e6ed, REGION_GFX1, 0x0000003, LOAD_8_64 },
  { "pl2-simm.03c", 0x200000, 0x0f52bbca, REGION_GFX1, 0x0000004, LOAD_8_64 },
  { "pl2-simm.03d", 0x200000, 0xa62712c3, REGION_GFX1, 0x0000005, LOAD_8_64 },
  { "pl2-simm.03a", 0x200000, 0xb60c9f8e, REGION_GFX1, 0x0000006, LOAD_8_64 },
  { "pl2-simm.03b", 0x200000, 0x83fef284, REGION_GFX1, 0x0000007, LOAD_8_64 },
  { "pl2.01", 0x20000, 0x35697569, REGION_ROM2, 0, LOAD_NORMAL },
  { "pl2-simm.05a", 0x200000, 0x85d8fbe8, REGION_SMP1, 0x000000, LOAD_SWAP_16 },
  { "pl2-simm.05b", 0x200000, 0x1ed62584, REGION_SMP1, 0x200000, LOAD_SWAP_16 },
  { NULL, 0, 0, 0, 0, 0 }
};

static struct INPUT_INFO ddtod_inputs[] =
{
  { KB_DEF_P1_RIGHT, MSG_P1_RIGHT, 0x00, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P1_LEFT, MSG_P1_LEFT, 0x00, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P1_DOWN, MSG_P1_DOWN, 0x00, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P1_UP, MSG_P1_UP, 0x00, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P1_B1, MSG_P1_B1, 0x00, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P1_B2, MSG_P1_B2, 0x00, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P1_B3, MSG_P1_B3, 0x00, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_P1_B4, MSG_P1_B4, 0x00, 0x80, BIT_ACTIVE_0 },
  { KB_DEF_P2_RIGHT, MSG_P2_RIGHT, 0x01, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P2_LEFT, MSG_P2_LEFT, 0x01, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P2_DOWN, MSG_P2_DOWN, 0x01, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P2_UP, MSG_P2_UP, 0x01, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P2_B1, MSG_P2_B1, 0x01, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P2_B2, MSG_P2_B2, 0x01, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P2_B3, MSG_P2_B3, 0x01, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_P2_B4, MSG_P2_B4, 0x01, 0x80, BIT_ACTIVE_0 },

  { KB_DEF_P3_RIGHT, MSG_P3_RIGHT, 0x02, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P3_LEFT, MSG_P3_LEFT, 0x02, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P3_DOWN, MSG_P3_DOWN, 0x02, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P3_UP, MSG_P3_UP, 0x02, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P3_B1, MSG_P3_B1, 0x02, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P3_B2, MSG_P3_B2, 0x02, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P3_B3, MSG_P3_B3, 0x02, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_P3_B4, MSG_P3_B4, 0x02, 0x80, BIT_ACTIVE_0 },
  { KB_DEF_P4_RIGHT, MSG_P4_RIGHT, 0x03, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P4_LEFT, MSG_P4_LEFT, 0x03, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P4_DOWN, MSG_P4_DOWN, 0x03, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P4_UP, MSG_P4_UP, 0x03, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P4_B1, MSG_P4_B1, 0x03, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P4_B2, MSG_P4_B2, 0x03, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P4_B3, MSG_P4_B3, 0x03, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_P4_B4, MSG_P4_B4, 0x03, 0x80, BIT_ACTIVE_0 },

  { KB_DEF_TEST, MSG_TEST, 0x04, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_SERVICE, MSG_SERVICE, 0x04, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P1_START, MSG_P1_START, 0x05, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P2_START, MSG_P2_START, 0x05, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P3_START, MSG_P3_START, 0x05, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P4_START, MSG_P4_START, 0x05, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_COIN1, MSG_COIN1, 0x05, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_COIN2, MSG_COIN2, 0x05, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_COIN3, MSG_COIN3, 0x05, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_COIN4, MSG_COIN4, 0x05, 0x80, BIT_ACTIVE_0 },
   { 0, NULL, 0, 0, 0 },
};


static struct INPUT_INFO ssf2_inputs[] =
{
  { KB_DEF_P1_RIGHT, MSG_P1_RIGHT, 0x00, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P1_LEFT, MSG_P1_LEFT, 0x00, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P1_DOWN, MSG_P1_DOWN, 0x00, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P1_UP, MSG_P1_UP, 0x00, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P1_B1, MSG_P1_B1, 0x00, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P1_B2, MSG_P1_B2, 0x00, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P1_B3, MSG_P1_B3, 0x00, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_P2_RIGHT, MSG_P2_RIGHT, 0x01, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P2_LEFT, MSG_P2_LEFT, 0x01, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P2_DOWN, MSG_P2_DOWN, 0x01, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P2_UP, MSG_P2_UP, 0x01, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P2_B1, MSG_P2_B1, 0x01, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P2_B2, MSG_P2_B2, 0x01, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P2_B3, MSG_P2_B3, 0x01, 0x40, BIT_ACTIVE_0 },

  { KB_DEF_P1_B4, MSG_P1_B4, 0x02, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P1_B5, MSG_P1_B5, 0x02, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P1_B6, MSG_P1_B6, 0x02, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P2_B4, MSG_P2_B4, 0x02, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P2_B5, MSG_P2_B5, 0x02, 0x20, BIT_ACTIVE_0 },

  { KB_DEF_TEST, MSG_TEST, 0x04, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_SERVICE, MSG_SERVICE, 0x04, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P1_START, MSG_P1_START, 0x05, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P2_START, MSG_P2_START, 0x05, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_COIN1, MSG_COIN1, 0x05, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_COIN2, MSG_COIN2, 0x05, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P2_B6, MSG_P2_B6, 0x05, 0x40, BIT_ACTIVE_0 },
   { 0, NULL, 0, 0, 0 },
};

static struct INPUT_INFO ringdest_inputs[] =
{
  { KB_DEF_P1_RIGHT, MSG_P1_RIGHT, 0x00, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P1_LEFT, MSG_P1_LEFT, 0x00, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P1_DOWN, MSG_P1_DOWN, 0x00, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P1_UP, MSG_P1_UP, 0x00, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P1_B1, MSG_P1_B1, 0x00, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P1_B2, MSG_P1_B2, 0x00, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P1_B3, MSG_P1_B3, 0x00, 0x40, BIT_ACTIVE_0 },
  { KB_DEF_P2_RIGHT, MSG_P2_RIGHT, 0x01, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P2_LEFT, MSG_P2_LEFT, 0x01, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P2_DOWN, MSG_P2_DOWN, 0x01, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P2_UP, MSG_P2_UP, 0x01, 0x08, BIT_ACTIVE_0 },
  { KB_DEF_P2_B1, MSG_P2_B1, 0x01, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_P2_B2, MSG_P2_B2, 0x01, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P2_B3, MSG_P2_B3, 0x01, 0x40, BIT_ACTIVE_0 },

  { KB_DEF_P1_B4, MSG_P1_B4, 0x02, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_P1_B5, MSG_P1_B5, 0x02, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P2_B4, MSG_P2_B4, 0x02, 0x20, BIT_ACTIVE_0 },

  { KB_DEF_TEST, MSG_TEST, 0x04, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_SERVICE, MSG_SERVICE, 0x04, 0x04, BIT_ACTIVE_0 },
  { KB_DEF_P1_START, MSG_P1_START, 0x05, 0x01, BIT_ACTIVE_0 },
  { KB_DEF_P2_START, MSG_P2_START, 0x05, 0x02, BIT_ACTIVE_0 },
  { KB_DEF_COIN1, MSG_COIN1, 0x05, 0x10, BIT_ACTIVE_0 },
  { KB_DEF_COIN2, MSG_COIN2, 0x05, 0x20, BIT_ACTIVE_0 },
  { KB_DEF_P2_B5, MSG_P2_B5, 0x05, 0x40, BIT_ACTIVE_0 },
   { 0, NULL, 0, 0, 0 },
};

#define cps2_game(NAME,LONGNAME,YEAR,CTRL,TYPE)	\
							\
static struct DIR_INFO _##NAME##_dirs[] =		\
{							\
   { #NAME, },						\
   { NULL, },						\
};							\
							\
GAME( NAME,						\
   _##NAME##_dirs,					\
   _##NAME##_roms,						\
   CTRL##_inputs,					\
   NULL,							\
   NULL,						\
							\
   load_cps2,						\
   NULL,						\
   &cps1_video,						\
   execute_cps2_frame,					\
   #NAME,						\
   LONGNAME,						\
   NULL,						\
   COMPANY_ID_CAPCOM,					\
   NULL,						\
   YEAR,						\
   qsound_sound,					\
   TYPE							\
)

#define cps2_region(NAME,LONGNAME,YEAR,CTRL,TYPE,REGION)	\
							\
static struct DIR_INFO _##NAME##_dirs[] =		\
{							\
   { #NAME, },						\
   { NULL, },						\
};							\
							\
GAME( NAME,						\
   _##NAME##_dirs,					\
   _##NAME##_roms,						\
   CTRL##_inputs,					\
   NULL,							\
   REGION,						\
							\
   load_cps2,						\
   NULL,						\
   &cps1_video,						\
   execute_cps2_frame,					\
   #NAME,						\
   LONGNAME,						\
   NULL,						\
   COMPANY_ID_CAPCOM,					\
   NULL,						\
   YEAR,						\
   qsound_sound,					\
   TYPE							\
)

#define cps2_clone(NAME,LONGNAME,YEAR,CTRL,TYPE,CLONE,REGION)	\
							\
static struct DIR_INFO _##NAME##_dirs[] =		\
{							\
   { #NAME, },						\
   { ROMOF( CLONE ) },					\
   { CLONEOF( CLONE ) },					\
   { NULL, },						\
};						\
							\
GAME( NAME,						\
   _##NAME##_dirs,					\
   _##NAME##_roms,						\
   CTRL##_inputs,					\
   NULL,							\
   REGION,						\
							\
   load_cps2,						\
   NULL,						\
   &cps1_video,						\
   execute_cps2_frame,					\
   #NAME,						\
   LONGNAME,						\
   NULL,						\
   COMPANY_ID_CAPCOM,					\
   NULL,						\
   YEAR,						\
   qsound_sound,					\
   TYPE							\
)

/* Mame doen't care about having parents not working for a romset.
 * This is a solution to have at the same time mame compatibility, and not
 * supporting the broken parents : we list the parent in DIR_INFO, and list
 * every used rom in the ROM_INFO, this way the clone will load from the
 * parent rom, but the parent rom will not be supported alone... */
#define cps2_clone_no_parent(NAME,LONGNAME,YEAR,CTRL,TYPE,NOPARENT,REGION)	\
							\
static struct DIR_INFO _##NAME##_dirs[] =		\
{							\
   { #NAME, },						\
   { #NOPARENT },					\
   { NULL, },						\
};							\
							\
GAME( NAME,						\
   _##NAME##_dirs,					\
   _##NAME##_roms,						\
   CTRL##_inputs,					\
   NULL,							\
   REGION,						\
							\
   load_cps2,						\
   NULL,						\
   &cps1_video,						\
   execute_cps2_frame,					\
   #NAME,						\
   LONGNAME,						\
   NULL,						\
   COMPANY_ID_CAPCOM,					\
   NULL,						\
   YEAR,						\
   qsound_sound,					\
   TYPE							\
)

#define cps2_game_270(NAME,LONGNAME,YEAR,CTRL,TYPE)	\
							\
static struct DIR_INFO _##NAME##_dirs[] =		\
{							\
   { #NAME, },						\
   { NULL, },						\
};							\
							\
GAME( NAME,						\
   _##NAME##_dirs,					\
   _##NAME##_roms,					\
   CTRL##_inputs,					\
   NULL,							\
   NULL,						\
							\
   load_cps2,						\
   NULL,						\
   &cps1_video_270,					\
   execute_cps2_frame,					\
   #NAME,						\
   LONGNAME,						\
   NULL,						\
   COMPANY_ID_CAPCOM,					\
   NULL,						\
   YEAR,						\
   qsound_sound,					\
   TYPE							\
)

cps2_game(avsp,"Alien vs. Predator (Euro 940520)" ,1994,ssf2,GAME_BEAT);
cps2_game(dstlk,"Darkstalkers: The Night Warriors (Euro 940705)" ,1994,ssf2,GAME_BEAT);
cps2_game(ssf2,"Super Street Fighter 2: The New Challengers (World 930911)" ,1993,ssf2,GAME_BEAT);
cps2_game(sfa,"Street Fighter Alpha: Warriors' Dreams (Euro 950727)" ,1995,ssf2,GAME_BEAT);
cps2_game(ddtod,"Dungeons & Dragons: Tower of Doom (Euro 940412)" ,1993, ddtod,GAME_BEAT);
cps2_game(ecofghtr,"Eco Fighters (World 931203)" ,1993, ddtod,GAME_SHOOT);
cps2_game(xmcota,"X-Men: Children of the Atom (Euro 950105)" ,1995, ssf2,GAME_BEAT);
cps2_game(1944,"1944: The Loop Master (US 000620)" ,2000, ssf2,GAME_SHOOT);
cps2_game(sgemf,"Super Gem Fighter Mini Mix (US 970904)" ,1997, ddtod,GAME_BEAT);
cps2_game(ringdest,"Ring of Destruction: Slammasters II (Euro 940902)" ,1994, ringdest,GAME_BEAT);
cps2_game(nwarr,"Night Warriors: Darkstalkers' Revenge (US 950406)" ,1995, ssf2,GAME_BEAT);
cps2_game(ddsom,"Dungeons & Dragons: Shadow over Mystara (Euro 960619)" ,1996, ddtod,GAME_BEAT);
cps2_game(megaman2,"Mega Man 2: The Power Fighters (US 960708)" ,1996, ddtod,GAME_BEAT);
cps2_game(sfa2,"Street Fighter Alpha 2 (US 960306)",1996, ssf2,GAME_BEAT);
cps2_game(spf2t,"Super Puzzle Fighter 2 Turbo (US 960620)",1996, ssf2,GAME_PUZZLE);
// cps2_game(xmvsf,"X-Men Vs. Street Fighter (???)",1996, ssf2,GAME_BEAT);
cps2_clone_no_parent(xmvsfr1,"X-Men Vs. Street Fighter (Euro 960910)",1996, ssf2,GAME_BEAT, xmvsf , NULL);
cps2_game(batcir,"Battle Circuit (Euro 970319)", 1997, ddtod, GAME_BEAT);
cps2_game(csclub,"Capcom Sports Club (Euro 970722)", 1997, ddtod, GAME_BEAT);
// cps2_game(mshvsf,"Marvel Super Heroes Vs. Street Fighter (WORLD 970827)", 1997, ssf2, GAME_BEAT | GAME_NOT_WORKING);
cps2_clone_no_parent(mshvsfu,"Marvel Super Heroes Vs. Street Fighter (US 970827)", 1997, ssf2, GAME_BEAT, mshvsf ,NULL);
cps2_game(vsav,"Vampire Savior: The Lord of Vampire (Euro 970519)", 1997, ssf2, GAME_BEAT);
cps2_region(vsav2,"Vampire Savior 2: The Lord of Vampire (Japan 970913)", 1997, ssf2, GAME_BEAT, vhunt2_romsw);
// cps2_game(mvsc,"Marvel Vs. Capcom: Clash of Super Heroes (???)", 1998, ssf2, GAME_BEAT | GAME_NOT_WORKING);
cps2_clone_no_parent(mvscu,"Marvel Vs. Capcom: Clash of Super Heroes (US 980123)", 1998, ssf2, GAME_BEAT, mvsc , NULL);
cps2_game(sfa3,"Street Fighter Alpha 3 (US 980904)", 1998, ssf2, GAME_BEAT);

cps2_region(mpangj,"Mighty! Pang (Japan 001011)", 2000, ssf2, GAME_MISC,mpangj_romsw);

// There is NO region switch in pzloop2j (no EURO text in the rom)
cps2_game(pzloop2j,"Puzz Loop 2 (Japan 010205)", 2001, ddtod, GAME_MISC);

cps2_game(gigawing,"Giga Wing (US 990222)", 2000, ssf2, GAME_SHOOT);
cps2_game(mmatrix,"Mars Matrix: Hyper Solid Shooting (US 000412)", 2000, ssf2, GAME_SHOOT);
cps2_game_270(dimahoo,"Dimahoo (US 000121)" ,2000, ssf2,GAME_SHOOT);
cps2_game_270(19xx,"19XX: The War Against Destiny (US 951207)" ,1996, ssf2,GAME_SHOOT);

// Cave games in cps2 !

cps2_game(progear, "Progear (US 010117)", 2001, ssf2, GAME_SHOOT);

/* Stupid clones from mame (they added not working parent sets !!!). The price of
   compatibility is this kind of stupidity, sometimes ! */

// cps2_game(armwar, "Armored Warriors (Euro 941024)", 1994, ssf2, GAME_BEAT | GAME_NOT_WORKING);
cps2_clone_no_parent(armwaru, "Armored Warriors (US 941024)", 1994, ssf2, GAME_BEAT, armwar, NULL); /* and not "armwar" */
cps2_clone_no_parent(armwarr1, "Armored Warriors (EURO 941011)", 1994, ssf2, GAME_BEAT, armwar, NULL); /* NO PARENT */
cps2_game(cybots, "Cyberbots: Fullmetal Madness (Euro 950424)", 1995, ssf2, GAME_BEAT | GAME_NOT_WORKING);
cps2_clone(cybotsu, "Cyberbots: Fullmetal Madness (US 950424)", 1995, ssf2, GAME_BEAT, "cybots" , NULL);
cps2_game(msh, "Marvel Super Heroes (Euro 951024)", 1995, ssf2, GAME_BEAT | GAME_NOT_WORKING);
// reset if you try to play black heart when the character enters the stage
cps2_clone(mshh, "Marvel Super Heroes (Hispanic 951117)", 1995, ssf2, GAME_BEAT | GAME_PARTIALLY_WORKING, "msh" , msh_romsw);
cps2_clone(mshu, "Marvel Super Heroes (US 951024)", 1995, ssf2, GAME_BEAT, "msh" , msh_romsw);
cps2_game(vhunt2, "Vampire Hunter 2: Darkstalkers Revenge (Japan 970929)", 1997, ssf2, GAME_BEAT | GAME_NOT_WORKING);
cps2_clone(vhunt2r1, "Vampire Hunter 2: Darkstalkers Revenge (Japan 970913)", 1997, ssf2, GAME_BEAT, "vhunt2" , vhunt2_romsw);
