/******************************************************************************/
/*									      */
/*  'Default' driver, used to init some stuff with default values mainly...   */
/*									      */
/******************************************************************************/

#include "gameinc.h"
#include "arpro.h"
#include "default.h"
#include "savegame.h"
#include "sasound.h"            // sample support routines
#include "emumain.h"
#include "profile.h"
#include "timer.h" // default z80 frame
#include "adpcm.h"
#include "ay8910.h"
#include "priorities.h"
#include "tc100scn.h"
#ifdef HAVE_6502
#include "m6502hlp.h"
#endif
#include "emudx.h"
#include "bezel.h"
#include "config.h"
#include "hiscore.h"
#include "sasound.h"
#include "video/res.h"
#include "tc005rot.h"

void LoadDefault(void)
{
  memset(tc0100scn,0,sizeof(tc0100scn));
#ifdef RDTSC_PROFILE
  cycles_per_frame = 0; // recalibrate for non 60fps games
#endif
  fps = 60; // 60 fps (default)
  adpcm_amplify = ay8910_amplify = 1;

  ExitOnEI = 0;
  MouseB = &mouse_b;
  setup_z80_frame(CPU_Z80_0,CPU_FRAME_MHz(4,60));
  z80_offdata = 0; // code location = data location
  reset_timers();
  reset_z80_banks();

  ResetMemoryPool();				// Init game memory pool

   reset_arpro();				// Init action replay

   // ExecuteSoundFrame=NULL;			// Default execution for 1 frame (sound cpu execution)

   Clear68000List();				// Clear M68000 memory lists
   StarScreamEngine=0;				// No M68000 by default

   ClearZ80List();				// Clear Z80 memory lists
   MZ80Engine=0;				// No Z80 by default

#ifdef HAVE_6502
   ClearM6502List();				// Clear M6502 memory lists
   M6502Engine=0;				// No M6502 by default
#endif

   GameSound=0; 				// No Sound emulation by default
   GameMouse=0; 				// No Mouse driver by default

   raine_cfg.req_pause_game = 0;
   raine_cfg.req_save_screen = 0;

   dir_cfg.last_screenshot_num = 0;

   SaveSlot=0;					// Reset save slot to 0
   SaveDataCount=0;				// No save data
   SaveCallbackCount=0; 			// No save callbacks

   RAMSize=0x80000;				// Size of RAM memory allocated (should be 0 here really)

   clear_eeprom_list(); 			// No EEPROMs mapped

   if(raine_cfg.show_fps_mode==2) raine_cfg.show_fps_mode=0;			// Don't like it running from time=0

   PCMROM=NULL; 				// Might as well clear these too
   Z80ROM=NULL;
   ROM=RAM=GFX=NULL;

   tile_list_count = 0;
   max_tile_sprites = 0;
   set_pulse_time(15);

   tile_start = 0; // tile queue reset

   set_white_pen(255);

   current_cmap_func = NULL;
   current_colour_mapper = NULL;

   reset_layer_switches();
   set_reset_function(NULL);
}

void ClearDefault(void)
{
  use_scale2x = 0;
  tc0005rot.RAM = NULL;
  save_game_config();
  hs_close();
  if (current_game->clear_game)
    current_game->clear_game();

#ifdef RAINE_DEBUG
  if (load_region[REGION_CPU1]) {
    int code_size = get_region_size(REGION_CPU1);
    if (MC68020) {
      save_debug("ROM.bin",load_region[REGION_ROM1],code_size,0);
      if(StarScreamEngine>=1)
	save_debug("ROM2.bin",load_region[REGION_CPU2],get_region_size(REGION_CPU2),1);
    } else if(StarScreamEngine>=1) {
      save_debug("ROM.bin",load_region[REGION_ROM1],code_size,1);
    } else // 8 bit cpu
      save_debug("ROM.bin",ROM,code_size,0);
    if (!MC68020 && load_region[REGION_CPU2]) {
      if(StarScreamEngine>1)
	save_debug("ROM2.bin",load_region[REGION_CPU2],get_region_size(REGION_CPU2),1);
      else {
	save_debug("ROM2.bin",load_region[REGION_CPU2],get_region_size(REGION_CPU2),0);
      }
    }
  }
  save_debug("RAM.bin",RAM,RAMSize,0);
#endif

  save_eeprom();
#ifndef NO020
   MC68020 = 0;
#endif
   free_emudx();
   reset_arpro();				// Free action replay

   saDestroySound(1);				// Free all sound resources

   destroy_palette_map();			// Free colour mapping resources

   if(raine_cfg.show_fps_mode==2) raine_cfg.show_fps_mode=0;			// Don't like it running from time=0

   FreeMemoryPool();				// Free anything left in the memory pool

   LanguageSw.Count = 0;

   if (pbitmap) {
     destroy_bitmap(pbitmap);
     pbitmap = NULL;
   }

   clear_bezel();
   current_game = NULL;
}

