#include "68020.h"
//#include "config.h"
#include "m68k.h"

#include "newcpu.h"
#include "cputbl.h"

struct cputbl CPU_OP_NAME(_smalltbl)[] = {
{ CPU_OP_NAME(_0), 0, 0 }, /* OR */
{ CPU_OP_NAME(_10), 0, 16 }, /* OR */
{ CPU_OP_NAME(_18), 0, 24 }, /* OR */
{ CPU_OP_NAME(_20), 0, 32 }, /* OR */
{ CPU_OP_NAME(_28), 0, 40 }, /* OR */
{ CPU_OP_NAME(_30), 0, 48 }, /* OR */
{ CPU_OP_NAME(_38), 0, 56 }, /* OR */
{ CPU_OP_NAME(_39), 0, 57 }, /* OR */
{ CPU_OP_NAME(_3c), 0, 60 }, /* ORSR */
{ CPU_OP_NAME(_40), 0, 64 }, /* OR */
{ CPU_OP_NAME(_50), 0, 80 }, /* OR */
{ CPU_OP_NAME(_58), 0, 88 }, /* OR */
{ CPU_OP_NAME(_60), 0, 96 }, /* OR */
{ CPU_OP_NAME(_68), 0, 104 }, /* OR */
{ CPU_OP_NAME(_70), 0, 112 }, /* OR */
{ CPU_OP_NAME(_78), 0, 120 }, /* OR */
{ CPU_OP_NAME(_79), 0, 121 }, /* OR */
{ CPU_OP_NAME(_7c), 0, 124 }, /* ORSR */
{ CPU_OP_NAME(_80), 0, 128 }, /* OR */
{ CPU_OP_NAME(_90), 0, 144 }, /* OR */
{ CPU_OP_NAME(_98), 0, 152 }, /* OR */
{ CPU_OP_NAME(_a0), 0, 160 }, /* OR */
{ CPU_OP_NAME(_a8), 0, 168 }, /* OR */
{ CPU_OP_NAME(_b0), 0, 176 }, /* OR */
{ CPU_OP_NAME(_b8), 0, 184 }, /* OR */
{ CPU_OP_NAME(_b9), 0, 185 }, /* OR */
{ CPU_OP_NAME(_d0), 0, 208 }, /* CHK2 */
{ CPU_OP_NAME(_e8), 0, 232 }, /* CHK2 */
{ CPU_OP_NAME(_f0), 0, 240 }, /* CHK2 */
{ CPU_OP_NAME(_f8), 0, 248 }, /* CHK2 */
{ CPU_OP_NAME(_f9), 0, 249 }, /* CHK2 */
{ CPU_OP_NAME(_fa), 0, 250 }, /* CHK2 */
{ CPU_OP_NAME(_fb), 0, 251 }, /* CHK2 */
{ CPU_OP_NAME(_100), 0, 256 }, /* BTST */
{ CPU_OP_NAME(_108), 0, 264 }, /* MVPMR */
{ CPU_OP_NAME(_110), 0, 272 }, /* BTST */
{ CPU_OP_NAME(_118), 0, 280 }, /* BTST */
{ CPU_OP_NAME(_120), 0, 288 }, /* BTST */
{ CPU_OP_NAME(_128), 0, 296 }, /* BTST */
{ CPU_OP_NAME(_130), 0, 304 }, /* BTST */
{ CPU_OP_NAME(_138), 0, 312 }, /* BTST */
{ CPU_OP_NAME(_139), 0, 313 }, /* BTST */
{ CPU_OP_NAME(_13a), 0, 314 }, /* BTST */
{ CPU_OP_NAME(_13b), 0, 315 }, /* BTST */
{ CPU_OP_NAME(_13c), 0, 316 }, /* BTST */
{ CPU_OP_NAME(_140), 0, 320 }, /* BCHG */
{ CPU_OP_NAME(_148), 0, 328 }, /* MVPMR */
{ CPU_OP_NAME(_150), 0, 336 }, /* BCHG */
{ CPU_OP_NAME(_158), 0, 344 }, /* BCHG */
{ CPU_OP_NAME(_160), 0, 352 }, /* BCHG */
{ CPU_OP_NAME(_168), 0, 360 }, /* BCHG */
{ CPU_OP_NAME(_170), 0, 368 }, /* BCHG */
{ CPU_OP_NAME(_178), 0, 376 }, /* BCHG */
{ CPU_OP_NAME(_179), 0, 377 }, /* BCHG */
{ CPU_OP_NAME(_17a), 0, 378 }, /* BCHG */
{ CPU_OP_NAME(_17b), 0, 379 }, /* BCHG */
{ CPU_OP_NAME(_180), 0, 384 }, /* BCLR */
{ CPU_OP_NAME(_188), 0, 392 }, /* MVPRM */
{ CPU_OP_NAME(_190), 0, 400 }, /* BCLR */
{ CPU_OP_NAME(_198), 0, 408 }, /* BCLR */
{ CPU_OP_NAME(_1a0), 0, 416 }, /* BCLR */
{ CPU_OP_NAME(_1a8), 0, 424 }, /* BCLR */
{ CPU_OP_NAME(_1b0), 0, 432 }, /* BCLR */
{ CPU_OP_NAME(_1b8), 0, 440 }, /* BCLR */
{ CPU_OP_NAME(_1b9), 0, 441 }, /* BCLR */
{ CPU_OP_NAME(_1ba), 0, 442 }, /* BCLR */
{ CPU_OP_NAME(_1bb), 0, 443 }, /* BCLR */
{ CPU_OP_NAME(_1c0), 0, 448 }, /* BSET */
{ CPU_OP_NAME(_1c8), 0, 456 }, /* MVPRM */
{ CPU_OP_NAME(_1d0), 0, 464 }, /* BSET */
{ CPU_OP_NAME(_1d8), 0, 472 }, /* BSET */
{ CPU_OP_NAME(_1e0), 0, 480 }, /* BSET */
{ CPU_OP_NAME(_1e8), 0, 488 }, /* BSET */
{ CPU_OP_NAME(_1f0), 0, 496 }, /* BSET */
{ CPU_OP_NAME(_1f8), 0, 504 }, /* BSET */
{ CPU_OP_NAME(_1f9), 0, 505 }, /* BSET */
{ CPU_OP_NAME(_1fa), 0, 506 }, /* BSET */
{ CPU_OP_NAME(_1fb), 0, 507 }, /* BSET */
{ CPU_OP_NAME(_200), 0, 512 }, /* AND */
{ CPU_OP_NAME(_210), 0, 528 }, /* AND */
{ CPU_OP_NAME(_218), 0, 536 }, /* AND */
{ CPU_OP_NAME(_220), 0, 544 }, /* AND */
{ CPU_OP_NAME(_228), 0, 552 }, /* AND */
{ CPU_OP_NAME(_230), 0, 560 }, /* AND */
{ CPU_OP_NAME(_238), 0, 568 }, /* AND */
{ CPU_OP_NAME(_239), 0, 569 }, /* AND */
{ CPU_OP_NAME(_23c), 0, 572 }, /* ANDSR */
{ CPU_OP_NAME(_240), 0, 576 }, /* AND */
{ CPU_OP_NAME(_250), 0, 592 }, /* AND */
{ CPU_OP_NAME(_258), 0, 600 }, /* AND */
{ CPU_OP_NAME(_260), 0, 608 }, /* AND */
{ CPU_OP_NAME(_268), 0, 616 }, /* AND */
{ CPU_OP_NAME(_270), 0, 624 }, /* AND */
{ CPU_OP_NAME(_278), 0, 632 }, /* AND */
{ CPU_OP_NAME(_279), 0, 633 }, /* AND */
{ CPU_OP_NAME(_27c), 0, 636 }, /* ANDSR */
{ CPU_OP_NAME(_280), 0, 640 }, /* AND */
{ CPU_OP_NAME(_290), 0, 656 }, /* AND */
{ CPU_OP_NAME(_298), 0, 664 }, /* AND */
{ CPU_OP_NAME(_2a0), 0, 672 }, /* AND */
{ CPU_OP_NAME(_2a8), 0, 680 }, /* AND */
{ CPU_OP_NAME(_2b0), 0, 688 }, /* AND */
{ CPU_OP_NAME(_2b8), 0, 696 }, /* AND */
{ CPU_OP_NAME(_2b9), 0, 697 }, /* AND */
{ CPU_OP_NAME(_2d0), 0, 720 }, /* CHK2 */
{ CPU_OP_NAME(_2e8), 0, 744 }, /* CHK2 */
{ CPU_OP_NAME(_2f0), 0, 752 }, /* CHK2 */
{ CPU_OP_NAME(_2f8), 0, 760 }, /* CHK2 */
{ CPU_OP_NAME(_2f9), 0, 761 }, /* CHK2 */
{ CPU_OP_NAME(_2fa), 0, 762 }, /* CHK2 */
{ CPU_OP_NAME(_2fb), 0, 763 }, /* CHK2 */
{ CPU_OP_NAME(_400), 0, 1024 }, /* SUB */
{ CPU_OP_NAME(_410), 0, 1040 }, /* SUB */
{ CPU_OP_NAME(_418), 0, 1048 }, /* SUB */
{ CPU_OP_NAME(_420), 0, 1056 }, /* SUB */
{ CPU_OP_NAME(_428), 0, 1064 }, /* SUB */
{ CPU_OP_NAME(_430), 0, 1072 }, /* SUB */
{ CPU_OP_NAME(_438), 0, 1080 }, /* SUB */
{ CPU_OP_NAME(_439), 0, 1081 }, /* SUB */
{ CPU_OP_NAME(_440), 0, 1088 }, /* SUB */
{ CPU_OP_NAME(_450), 0, 1104 }, /* SUB */
{ CPU_OP_NAME(_458), 0, 1112 }, /* SUB */
{ CPU_OP_NAME(_460), 0, 1120 }, /* SUB */
{ CPU_OP_NAME(_468), 0, 1128 }, /* SUB */
{ CPU_OP_NAME(_470), 0, 1136 }, /* SUB */
{ CPU_OP_NAME(_478), 0, 1144 }, /* SUB */
{ CPU_OP_NAME(_479), 0, 1145 }, /* SUB */
{ CPU_OP_NAME(_480), 0, 1152 }, /* SUB */
{ CPU_OP_NAME(_490), 0, 1168 }, /* SUB */
{ CPU_OP_NAME(_498), 0, 1176 }, /* SUB */
{ CPU_OP_NAME(_4a0), 0, 1184 }, /* SUB */
{ CPU_OP_NAME(_4a8), 0, 1192 }, /* SUB */
{ CPU_OP_NAME(_4b0), 0, 1200 }, /* SUB */
{ CPU_OP_NAME(_4b8), 0, 1208 }, /* SUB */
{ CPU_OP_NAME(_4b9), 0, 1209 }, /* SUB */
{ CPU_OP_NAME(_4d0), 0, 1232 }, /* CHK2 */
{ CPU_OP_NAME(_4e8), 0, 1256 }, /* CHK2 */
{ CPU_OP_NAME(_4f0), 0, 1264 }, /* CHK2 */
{ CPU_OP_NAME(_4f8), 0, 1272 }, /* CHK2 */
{ CPU_OP_NAME(_4f9), 0, 1273 }, /* CHK2 */
{ CPU_OP_NAME(_4fa), 0, 1274 }, /* CHK2 */
{ CPU_OP_NAME(_4fb), 0, 1275 }, /* CHK2 */
{ CPU_OP_NAME(_600), 0, 1536 }, /* ADD */
{ CPU_OP_NAME(_610), 0, 1552 }, /* ADD */
{ CPU_OP_NAME(_618), 0, 1560 }, /* ADD */
{ CPU_OP_NAME(_620), 0, 1568 }, /* ADD */
{ CPU_OP_NAME(_628), 0, 1576 }, /* ADD */
{ CPU_OP_NAME(_630), 0, 1584 }, /* ADD */
{ CPU_OP_NAME(_638), 0, 1592 }, /* ADD */
{ CPU_OP_NAME(_639), 0, 1593 }, /* ADD */
{ CPU_OP_NAME(_640), 0, 1600 }, /* ADD */
{ CPU_OP_NAME(_650), 0, 1616 }, /* ADD */
{ CPU_OP_NAME(_658), 0, 1624 }, /* ADD */
{ CPU_OP_NAME(_660), 0, 1632 }, /* ADD */
{ CPU_OP_NAME(_668), 0, 1640 }, /* ADD */
{ CPU_OP_NAME(_670), 0, 1648 }, /* ADD */
{ CPU_OP_NAME(_678), 0, 1656 }, /* ADD */
{ CPU_OP_NAME(_679), 0, 1657 }, /* ADD */
{ CPU_OP_NAME(_680), 0, 1664 }, /* ADD */
{ CPU_OP_NAME(_690), 0, 1680 }, /* ADD */
{ CPU_OP_NAME(_698), 0, 1688 }, /* ADD */
{ CPU_OP_NAME(_6a0), 0, 1696 }, /* ADD */
{ CPU_OP_NAME(_6a8), 0, 1704 }, /* ADD */
{ CPU_OP_NAME(_6b0), 0, 1712 }, /* ADD */
{ CPU_OP_NAME(_6b8), 0, 1720 }, /* ADD */
{ CPU_OP_NAME(_6b9), 0, 1721 }, /* ADD */
{ CPU_OP_NAME(_6c0), 0, 1728 }, /* RTM */
{ CPU_OP_NAME(_6c8), 0, 1736 }, /* RTM */
{ CPU_OP_NAME(_6d0), 0, 1744 }, /* CALLM */
{ CPU_OP_NAME(_6e8), 0, 1768 }, /* CALLM */
{ CPU_OP_NAME(_6f0), 0, 1776 }, /* CALLM */
{ CPU_OP_NAME(_6f8), 0, 1784 }, /* CALLM */
{ CPU_OP_NAME(_6f9), 0, 1785 }, /* CALLM */
{ CPU_OP_NAME(_6fa), 0, 1786 }, /* CALLM */
{ CPU_OP_NAME(_6fb), 0, 1787 }, /* CALLM */
{ CPU_OP_NAME(_800), 0, 2048 }, /* BTST */
{ CPU_OP_NAME(_810), 0, 2064 }, /* BTST */
{ CPU_OP_NAME(_818), 0, 2072 }, /* BTST */
{ CPU_OP_NAME(_820), 0, 2080 }, /* BTST */
{ CPU_OP_NAME(_828), 0, 2088 }, /* BTST */
{ CPU_OP_NAME(_830), 0, 2096 }, /* BTST */
{ CPU_OP_NAME(_838), 0, 2104 }, /* BTST */
{ CPU_OP_NAME(_839), 0, 2105 }, /* BTST */
{ CPU_OP_NAME(_83a), 0, 2106 }, /* BTST */
{ CPU_OP_NAME(_83b), 0, 2107 }, /* BTST */
{ CPU_OP_NAME(_83c), 0, 2108 }, /* BTST */
{ CPU_OP_NAME(_840), 0, 2112 }, /* BCHG */
{ CPU_OP_NAME(_850), 0, 2128 }, /* BCHG */
{ CPU_OP_NAME(_858), 0, 2136 }, /* BCHG */
{ CPU_OP_NAME(_860), 0, 2144 }, /* BCHG */
{ CPU_OP_NAME(_868), 0, 2152 }, /* BCHG */
{ CPU_OP_NAME(_870), 0, 2160 }, /* BCHG */
{ CPU_OP_NAME(_878), 0, 2168 }, /* BCHG */
{ CPU_OP_NAME(_879), 0, 2169 }, /* BCHG */
{ CPU_OP_NAME(_87a), 0, 2170 }, /* BCHG */
{ CPU_OP_NAME(_87b), 0, 2171 }, /* BCHG */
{ CPU_OP_NAME(_880), 0, 2176 }, /* BCLR */
{ CPU_OP_NAME(_890), 0, 2192 }, /* BCLR */
{ CPU_OP_NAME(_898), 0, 2200 }, /* BCLR */
{ CPU_OP_NAME(_8a0), 0, 2208 }, /* BCLR */
{ CPU_OP_NAME(_8a8), 0, 2216 }, /* BCLR */
{ CPU_OP_NAME(_8b0), 0, 2224 }, /* BCLR */
{ CPU_OP_NAME(_8b8), 0, 2232 }, /* BCLR */
{ CPU_OP_NAME(_8b9), 0, 2233 }, /* BCLR */
{ CPU_OP_NAME(_8ba), 0, 2234 }, /* BCLR */
{ CPU_OP_NAME(_8bb), 0, 2235 }, /* BCLR */
{ CPU_OP_NAME(_8c0), 0, 2240 }, /* BSET */
{ CPU_OP_NAME(_8d0), 0, 2256 }, /* BSET */
{ CPU_OP_NAME(_8d8), 0, 2264 }, /* BSET */
{ CPU_OP_NAME(_8e0), 0, 2272 }, /* BSET */
{ CPU_OP_NAME(_8e8), 0, 2280 }, /* BSET */
{ CPU_OP_NAME(_8f0), 0, 2288 }, /* BSET */
{ CPU_OP_NAME(_8f8), 0, 2296 }, /* BSET */
{ CPU_OP_NAME(_8f9), 0, 2297 }, /* BSET */
{ CPU_OP_NAME(_8fa), 0, 2298 }, /* BSET */
{ CPU_OP_NAME(_8fb), 0, 2299 }, /* BSET */
{ CPU_OP_NAME(_a00), 0, 2560 }, /* EOR */
{ CPU_OP_NAME(_a10), 0, 2576 }, /* EOR */
{ CPU_OP_NAME(_a18), 0, 2584 }, /* EOR */
{ CPU_OP_NAME(_a20), 0, 2592 }, /* EOR */
{ CPU_OP_NAME(_a28), 0, 2600 }, /* EOR */
{ CPU_OP_NAME(_a30), 0, 2608 }, /* EOR */
{ CPU_OP_NAME(_a38), 0, 2616 }, /* EOR */
{ CPU_OP_NAME(_a39), 0, 2617 }, /* EOR */
{ CPU_OP_NAME(_a3c), 0, 2620 }, /* EORSR */
{ CPU_OP_NAME(_a40), 0, 2624 }, /* EOR */
{ CPU_OP_NAME(_a50), 0, 2640 }, /* EOR */
{ CPU_OP_NAME(_a58), 0, 2648 }, /* EOR */
{ CPU_OP_NAME(_a60), 0, 2656 }, /* EOR */
{ CPU_OP_NAME(_a68), 0, 2664 }, /* EOR */
{ CPU_OP_NAME(_a70), 0, 2672 }, /* EOR */
{ CPU_OP_NAME(_a78), 0, 2680 }, /* EOR */
{ CPU_OP_NAME(_a79), 0, 2681 }, /* EOR */
{ CPU_OP_NAME(_a7c), 0, 2684 }, /* EORSR */
{ CPU_OP_NAME(_a80), 0, 2688 }, /* EOR */
{ CPU_OP_NAME(_a90), 0, 2704 }, /* EOR */
{ CPU_OP_NAME(_a98), 0, 2712 }, /* EOR */
{ CPU_OP_NAME(_aa0), 0, 2720 }, /* EOR */
{ CPU_OP_NAME(_aa8), 0, 2728 }, /* EOR */
{ CPU_OP_NAME(_ab0), 0, 2736 }, /* EOR */
{ CPU_OP_NAME(_ab8), 0, 2744 }, /* EOR */
{ CPU_OP_NAME(_ab9), 0, 2745 }, /* EOR */
{ CPU_OP_NAME(_ad0), 0, 2768 }, /* CAS */
{ CPU_OP_NAME(_ad8), 0, 2776 }, /* CAS */
{ CPU_OP_NAME(_ae0), 0, 2784 }, /* CAS */
{ CPU_OP_NAME(_ae8), 0, 2792 }, /* CAS */
{ CPU_OP_NAME(_af0), 0, 2800 }, /* CAS */
{ CPU_OP_NAME(_af8), 0, 2808 }, /* CAS */
{ CPU_OP_NAME(_af9), 0, 2809 }, /* CAS */
{ CPU_OP_NAME(_c00), 0, 3072 }, /* CMP */
{ CPU_OP_NAME(_c10), 0, 3088 }, /* CMP */
{ CPU_OP_NAME(_c18), 0, 3096 }, /* CMP */
{ CPU_OP_NAME(_c20), 0, 3104 }, /* CMP */
{ CPU_OP_NAME(_c28), 0, 3112 }, /* CMP */
{ CPU_OP_NAME(_c30), 0, 3120 }, /* CMP */
{ CPU_OP_NAME(_c38), 0, 3128 }, /* CMP */
{ CPU_OP_NAME(_c39), 0, 3129 }, /* CMP */
{ CPU_OP_NAME(_c3a), 0, 3130 }, /* CMP */
{ CPU_OP_NAME(_c3b), 0, 3131 }, /* CMP */
{ CPU_OP_NAME(_c40), 0, 3136 }, /* CMP */
{ CPU_OP_NAME(_c50), 0, 3152 }, /* CMP */
{ CPU_OP_NAME(_c58), 0, 3160 }, /* CMP */
{ CPU_OP_NAME(_c60), 0, 3168 }, /* CMP */
{ CPU_OP_NAME(_c68), 0, 3176 }, /* CMP */
{ CPU_OP_NAME(_c70), 0, 3184 }, /* CMP */
{ CPU_OP_NAME(_c78), 0, 3192 }, /* CMP */
{ CPU_OP_NAME(_c79), 0, 3193 }, /* CMP */
{ CPU_OP_NAME(_c7a), 0, 3194 }, /* CMP */
{ CPU_OP_NAME(_c7b), 0, 3195 }, /* CMP */
{ CPU_OP_NAME(_c80), 0, 3200 }, /* CMP */
{ CPU_OP_NAME(_c90), 0, 3216 }, /* CMP */
{ CPU_OP_NAME(_c98), 0, 3224 }, /* CMP */
{ CPU_OP_NAME(_ca0), 0, 3232 }, /* CMP */
{ CPU_OP_NAME(_ca8), 0, 3240 }, /* CMP */
{ CPU_OP_NAME(_cb0), 0, 3248 }, /* CMP */
{ CPU_OP_NAME(_cb8), 0, 3256 }, /* CMP */
{ CPU_OP_NAME(_cb9), 0, 3257 }, /* CMP */
{ CPU_OP_NAME(_cba), 0, 3258 }, /* CMP */
{ CPU_OP_NAME(_cbb), 0, 3259 }, /* CMP */
{ CPU_OP_NAME(_cd0), 0, 3280 }, /* CAS */
{ CPU_OP_NAME(_cd8), 0, 3288 }, /* CAS */
{ CPU_OP_NAME(_ce0), 0, 3296 }, /* CAS */
{ CPU_OP_NAME(_ce8), 0, 3304 }, /* CAS */
{ CPU_OP_NAME(_cf0), 0, 3312 }, /* CAS */
{ CPU_OP_NAME(_cf8), 0, 3320 }, /* CAS */
{ CPU_OP_NAME(_cf9), 0, 3321 }, /* CAS */
{ CPU_OP_NAME(_cfc), 0, 3324 }, /* CAS2 */
{ CPU_OP_NAME(_e10), 0, 3600 }, /* MOVES */
{ CPU_OP_NAME(_e18), 0, 3608 }, /* MOVES */
{ CPU_OP_NAME(_e20), 0, 3616 }, /* MOVES */
{ CPU_OP_NAME(_e28), 0, 3624 }, /* MOVES */
{ CPU_OP_NAME(_e30), 0, 3632 }, /* MOVES */
{ CPU_OP_NAME(_e38), 0, 3640 }, /* MOVES */
{ CPU_OP_NAME(_e39), 0, 3641 }, /* MOVES */
{ CPU_OP_NAME(_e50), 0, 3664 }, /* MOVES */
{ CPU_OP_NAME(_e58), 0, 3672 }, /* MOVES */
{ CPU_OP_NAME(_e60), 0, 3680 }, /* MOVES */
{ CPU_OP_NAME(_e68), 0, 3688 }, /* MOVES */
{ CPU_OP_NAME(_e70), 0, 3696 }, /* MOVES */
{ CPU_OP_NAME(_e78), 0, 3704 }, /* MOVES */
{ CPU_OP_NAME(_e79), 0, 3705 }, /* MOVES */
{ CPU_OP_NAME(_e90), 0, 3728 }, /* MOVES */
{ CPU_OP_NAME(_e98), 0, 3736 }, /* MOVES */
{ CPU_OP_NAME(_ea0), 0, 3744 }, /* MOVES */
{ CPU_OP_NAME(_ea8), 0, 3752 }, /* MOVES */
{ CPU_OP_NAME(_eb0), 0, 3760 }, /* MOVES */
{ CPU_OP_NAME(_eb8), 0, 3768 }, /* MOVES */
{ CPU_OP_NAME(_eb9), 0, 3769 }, /* MOVES */
{ CPU_OP_NAME(_ed0), 0, 3792 }, /* CAS */
{ CPU_OP_NAME(_ed8), 0, 3800 }, /* CAS */
{ CPU_OP_NAME(_ee0), 0, 3808 }, /* CAS */
{ CPU_OP_NAME(_ee8), 0, 3816 }, /* CAS */
{ CPU_OP_NAME(_ef0), 0, 3824 }, /* CAS */
{ CPU_OP_NAME(_ef8), 0, 3832 }, /* CAS */
{ CPU_OP_NAME(_ef9), 0, 3833 }, /* CAS */
{ CPU_OP_NAME(_efc), 0, 3836 }, /* CAS2 */
{ CPU_OP_NAME(_1000), 0, 4096 }, /* MOVE */
{ CPU_OP_NAME(_1010), 0, 4112 }, /* MOVE */
{ CPU_OP_NAME(_1018), 0, 4120 }, /* MOVE */
{ CPU_OP_NAME(_1020), 0, 4128 }, /* MOVE */
{ CPU_OP_NAME(_1028), 0, 4136 }, /* MOVE */
{ CPU_OP_NAME(_1030), 0, 4144 }, /* MOVE */
{ CPU_OP_NAME(_1038), 0, 4152 }, /* MOVE */
{ CPU_OP_NAME(_1039), 0, 4153 }, /* MOVE */
{ CPU_OP_NAME(_103a), 0, 4154 }, /* MOVE */
{ CPU_OP_NAME(_103b), 0, 4155 }, /* MOVE */
{ CPU_OP_NAME(_103c), 0, 4156 }, /* MOVE */
{ CPU_OP_NAME(_1080), 0, 4224 }, /* MOVE */
{ CPU_OP_NAME(_1090), 0, 4240 }, /* MOVE */
{ CPU_OP_NAME(_1098), 0, 4248 }, /* MOVE */
{ CPU_OP_NAME(_10a0), 0, 4256 }, /* MOVE */
{ CPU_OP_NAME(_10a8), 0, 4264 }, /* MOVE */
{ CPU_OP_NAME(_10b0), 0, 4272 }, /* MOVE */
{ CPU_OP_NAME(_10b8), 0, 4280 }, /* MOVE */
{ CPU_OP_NAME(_10b9), 0, 4281 }, /* MOVE */
{ CPU_OP_NAME(_10ba), 0, 4282 }, /* MOVE */
{ CPU_OP_NAME(_10bb), 0, 4283 }, /* MOVE */
{ CPU_OP_NAME(_10bc), 0, 4284 }, /* MOVE */
{ CPU_OP_NAME(_10c0), 0, 4288 }, /* MOVE */
{ CPU_OP_NAME(_10d0), 0, 4304 }, /* MOVE */
{ CPU_OP_NAME(_10d8), 0, 4312 }, /* MOVE */
{ CPU_OP_NAME(_10e0), 0, 4320 }, /* MOVE */
{ CPU_OP_NAME(_10e8), 0, 4328 }, /* MOVE */
{ CPU_OP_NAME(_10f0), 0, 4336 }, /* MOVE */
{ CPU_OP_NAME(_10f8), 0, 4344 }, /* MOVE */
{ CPU_OP_NAME(_10f9), 0, 4345 }, /* MOVE */
{ CPU_OP_NAME(_10fa), 0, 4346 }, /* MOVE */
{ CPU_OP_NAME(_10fb), 0, 4347 }, /* MOVE */
{ CPU_OP_NAME(_10fc), 0, 4348 }, /* MOVE */
{ CPU_OP_NAME(_1100), 0, 4352 }, /* MOVE */
{ CPU_OP_NAME(_1110), 0, 4368 }, /* MOVE */
{ CPU_OP_NAME(_1118), 0, 4376 }, /* MOVE */
{ CPU_OP_NAME(_1120), 0, 4384 }, /* MOVE */
{ CPU_OP_NAME(_1128), 0, 4392 }, /* MOVE */
{ CPU_OP_NAME(_1130), 0, 4400 }, /* MOVE */
{ CPU_OP_NAME(_1138), 0, 4408 }, /* MOVE */
{ CPU_OP_NAME(_1139), 0, 4409 }, /* MOVE */
{ CPU_OP_NAME(_113a), 0, 4410 }, /* MOVE */
{ CPU_OP_NAME(_113b), 0, 4411 }, /* MOVE */
{ CPU_OP_NAME(_113c), 0, 4412 }, /* MOVE */
{ CPU_OP_NAME(_1140), 0, 4416 }, /* MOVE */
{ CPU_OP_NAME(_1150), 0, 4432 }, /* MOVE */
{ CPU_OP_NAME(_1158), 0, 4440 }, /* MOVE */
{ CPU_OP_NAME(_1160), 0, 4448 }, /* MOVE */
{ CPU_OP_NAME(_1168), 0, 4456 }, /* MOVE */
{ CPU_OP_NAME(_1170), 0, 4464 }, /* MOVE */
{ CPU_OP_NAME(_1178), 0, 4472 }, /* MOVE */
{ CPU_OP_NAME(_1179), 0, 4473 }, /* MOVE */
{ CPU_OP_NAME(_117a), 0, 4474 }, /* MOVE */
{ CPU_OP_NAME(_117b), 0, 4475 }, /* MOVE */
{ CPU_OP_NAME(_117c), 0, 4476 }, /* MOVE */
{ CPU_OP_NAME(_1180), 0, 4480 }, /* MOVE */
{ CPU_OP_NAME(_1190), 0, 4496 }, /* MOVE */
{ CPU_OP_NAME(_1198), 0, 4504 }, /* MOVE */
{ CPU_OP_NAME(_11a0), 0, 4512 }, /* MOVE */
{ CPU_OP_NAME(_11a8), 0, 4520 }, /* MOVE */
{ CPU_OP_NAME(_11b0), 0, 4528 }, /* MOVE */
{ CPU_OP_NAME(_11b8), 0, 4536 }, /* MOVE */
{ CPU_OP_NAME(_11b9), 0, 4537 }, /* MOVE */
{ CPU_OP_NAME(_11ba), 0, 4538 }, /* MOVE */
{ CPU_OP_NAME(_11bb), 0, 4539 }, /* MOVE */
{ CPU_OP_NAME(_11bc), 0, 4540 }, /* MOVE */
{ CPU_OP_NAME(_11c0), 0, 4544 }, /* MOVE */
{ CPU_OP_NAME(_11d0), 0, 4560 }, /* MOVE */
{ CPU_OP_NAME(_11d8), 0, 4568 }, /* MOVE */
{ CPU_OP_NAME(_11e0), 0, 4576 }, /* MOVE */
{ CPU_OP_NAME(_11e8), 0, 4584 }, /* MOVE */
{ CPU_OP_NAME(_11f0), 0, 4592 }, /* MOVE */
{ CPU_OP_NAME(_11f8), 0, 4600 }, /* MOVE */
{ CPU_OP_NAME(_11f9), 0, 4601 }, /* MOVE */
{ CPU_OP_NAME(_11fa), 0, 4602 }, /* MOVE */
{ CPU_OP_NAME(_11fb), 0, 4603 }, /* MOVE */
{ CPU_OP_NAME(_11fc), 0, 4604 }, /* MOVE */
{ CPU_OP_NAME(_13c0), 0, 5056 }, /* MOVE */
{ CPU_OP_NAME(_13d0), 0, 5072 }, /* MOVE */
{ CPU_OP_NAME(_13d8), 0, 5080 }, /* MOVE */
{ CPU_OP_NAME(_13e0), 0, 5088 }, /* MOVE */
{ CPU_OP_NAME(_13e8), 0, 5096 }, /* MOVE */
{ CPU_OP_NAME(_13f0), 0, 5104 }, /* MOVE */
{ CPU_OP_NAME(_13f8), 0, 5112 }, /* MOVE */
{ CPU_OP_NAME(_13f9), 0, 5113 }, /* MOVE */
{ CPU_OP_NAME(_13fa), 0, 5114 }, /* MOVE */
{ CPU_OP_NAME(_13fb), 0, 5115 }, /* MOVE */
{ CPU_OP_NAME(_13fc), 0, 5116 }, /* MOVE */
{ CPU_OP_NAME(_2000), 0, 8192 }, /* MOVE */
{ CPU_OP_NAME(_2008), 0, 8200 }, /* MOVE */
{ CPU_OP_NAME(_2010), 0, 8208 }, /* MOVE */
{ CPU_OP_NAME(_2018), 0, 8216 }, /* MOVE */
{ CPU_OP_NAME(_2020), 0, 8224 }, /* MOVE */
{ CPU_OP_NAME(_2028), 0, 8232 }, /* MOVE */
{ CPU_OP_NAME(_2030), 0, 8240 }, /* MOVE */
{ CPU_OP_NAME(_2038), 0, 8248 }, /* MOVE */
{ CPU_OP_NAME(_2039), 0, 8249 }, /* MOVE */
{ CPU_OP_NAME(_203a), 0, 8250 }, /* MOVE */
{ CPU_OP_NAME(_203b), 0, 8251 }, /* MOVE */
{ CPU_OP_NAME(_203c), 0, 8252 }, /* MOVE */
{ CPU_OP_NAME(_2040), 0, 8256 }, /* MOVEA */
{ CPU_OP_NAME(_2048), 0, 8264 }, /* MOVEA */
{ CPU_OP_NAME(_2050), 0, 8272 }, /* MOVEA */
{ CPU_OP_NAME(_2058), 0, 8280 }, /* MOVEA */
{ CPU_OP_NAME(_2060), 0, 8288 }, /* MOVEA */
{ CPU_OP_NAME(_2068), 0, 8296 }, /* MOVEA */
{ CPU_OP_NAME(_2070), 0, 8304 }, /* MOVEA */
{ CPU_OP_NAME(_2078), 0, 8312 }, /* MOVEA */
{ CPU_OP_NAME(_2079), 0, 8313 }, /* MOVEA */
{ CPU_OP_NAME(_207a), 0, 8314 }, /* MOVEA */
{ CPU_OP_NAME(_207b), 0, 8315 }, /* MOVEA */
{ CPU_OP_NAME(_207c), 0, 8316 }, /* MOVEA */
{ CPU_OP_NAME(_2080), 0, 8320 }, /* MOVE */
{ CPU_OP_NAME(_2088), 0, 8328 }, /* MOVE */
{ CPU_OP_NAME(_2090), 0, 8336 }, /* MOVE */
{ CPU_OP_NAME(_2098), 0, 8344 }, /* MOVE */
{ CPU_OP_NAME(_20a0), 0, 8352 }, /* MOVE */
{ CPU_OP_NAME(_20a8), 0, 8360 }, /* MOVE */
{ CPU_OP_NAME(_20b0), 0, 8368 }, /* MOVE */
{ CPU_OP_NAME(_20b8), 0, 8376 }, /* MOVE */
{ CPU_OP_NAME(_20b9), 0, 8377 }, /* MOVE */
{ CPU_OP_NAME(_20ba), 0, 8378 }, /* MOVE */
{ CPU_OP_NAME(_20bb), 0, 8379 }, /* MOVE */
{ CPU_OP_NAME(_20bc), 0, 8380 }, /* MOVE */
{ CPU_OP_NAME(_20c0), 0, 8384 }, /* MOVE */
{ CPU_OP_NAME(_20c8), 0, 8392 }, /* MOVE */
{ CPU_OP_NAME(_20d0), 0, 8400 }, /* MOVE */
{ CPU_OP_NAME(_20d8), 0, 8408 }, /* MOVE */
{ CPU_OP_NAME(_20e0), 0, 8416 }, /* MOVE */
{ CPU_OP_NAME(_20e8), 0, 8424 }, /* MOVE */
{ CPU_OP_NAME(_20f0), 0, 8432 }, /* MOVE */
{ CPU_OP_NAME(_20f8), 0, 8440 }, /* MOVE */
{ CPU_OP_NAME(_20f9), 0, 8441 }, /* MOVE */
{ CPU_OP_NAME(_20fa), 0, 8442 }, /* MOVE */
{ CPU_OP_NAME(_20fb), 0, 8443 }, /* MOVE */
{ CPU_OP_NAME(_20fc), 0, 8444 }, /* MOVE */
{ CPU_OP_NAME(_2100), 0, 8448 }, /* MOVE */
{ CPU_OP_NAME(_2108), 0, 8456 }, /* MOVE */
{ CPU_OP_NAME(_2110), 0, 8464 }, /* MOVE */
{ CPU_OP_NAME(_2118), 0, 8472 }, /* MOVE */
{ CPU_OP_NAME(_2120), 0, 8480 }, /* MOVE */
{ CPU_OP_NAME(_2128), 0, 8488 }, /* MOVE */
{ CPU_OP_NAME(_2130), 0, 8496 }, /* MOVE */
{ CPU_OP_NAME(_2138), 0, 8504 }, /* MOVE */
{ CPU_OP_NAME(_2139), 0, 8505 }, /* MOVE */
{ CPU_OP_NAME(_213a), 0, 8506 }, /* MOVE */
{ CPU_OP_NAME(_213b), 0, 8507 }, /* MOVE */
{ CPU_OP_NAME(_213c), 0, 8508 }, /* MOVE */
{ CPU_OP_NAME(_2140), 0, 8512 }, /* MOVE */
{ CPU_OP_NAME(_2148), 0, 8520 }, /* MOVE */
{ CPU_OP_NAME(_2150), 0, 8528 }, /* MOVE */
{ CPU_OP_NAME(_2158), 0, 8536 }, /* MOVE */
{ CPU_OP_NAME(_2160), 0, 8544 }, /* MOVE */
{ CPU_OP_NAME(_2168), 0, 8552 }, /* MOVE */
{ CPU_OP_NAME(_2170), 0, 8560 }, /* MOVE */
{ CPU_OP_NAME(_2178), 0, 8568 }, /* MOVE */
{ CPU_OP_NAME(_2179), 0, 8569 }, /* MOVE */
{ CPU_OP_NAME(_217a), 0, 8570 }, /* MOVE */
{ CPU_OP_NAME(_217b), 0, 8571 }, /* MOVE */
{ CPU_OP_NAME(_217c), 0, 8572 }, /* MOVE */
{ CPU_OP_NAME(_2180), 0, 8576 }, /* MOVE */
{ CPU_OP_NAME(_2188), 0, 8584 }, /* MOVE */
{ CPU_OP_NAME(_2190), 0, 8592 }, /* MOVE */
{ CPU_OP_NAME(_2198), 0, 8600 }, /* MOVE */
{ CPU_OP_NAME(_21a0), 0, 8608 }, /* MOVE */
{ CPU_OP_NAME(_21a8), 0, 8616 }, /* MOVE */
{ CPU_OP_NAME(_21b0), 0, 8624 }, /* MOVE */
{ CPU_OP_NAME(_21b8), 0, 8632 }, /* MOVE */
{ CPU_OP_NAME(_21b9), 0, 8633 }, /* MOVE */
{ CPU_OP_NAME(_21ba), 0, 8634 }, /* MOVE */
{ CPU_OP_NAME(_21bb), 0, 8635 }, /* MOVE */
{ CPU_OP_NAME(_21bc), 0, 8636 }, /* MOVE */
{ CPU_OP_NAME(_21c0), 0, 8640 }, /* MOVE */
{ CPU_OP_NAME(_21c8), 0, 8648 }, /* MOVE */
{ CPU_OP_NAME(_21d0), 0, 8656 }, /* MOVE */
{ CPU_OP_NAME(_21d8), 0, 8664 }, /* MOVE */
{ CPU_OP_NAME(_21e0), 0, 8672 }, /* MOVE */
{ CPU_OP_NAME(_21e8), 0, 8680 }, /* MOVE */
{ CPU_OP_NAME(_21f0), 0, 8688 }, /* MOVE */
{ CPU_OP_NAME(_21f8), 0, 8696 }, /* MOVE */
{ CPU_OP_NAME(_21f9), 0, 8697 }, /* MOVE */
{ CPU_OP_NAME(_21fa), 0, 8698 }, /* MOVE */
{ CPU_OP_NAME(_21fb), 0, 8699 }, /* MOVE */
{ CPU_OP_NAME(_21fc), 0, 8700 }, /* MOVE */
{ CPU_OP_NAME(_23c0), 0, 9152 }, /* MOVE */
{ CPU_OP_NAME(_23c8), 0, 9160 }, /* MOVE */
{ CPU_OP_NAME(_23d0), 0, 9168 }, /* MOVE */
{ CPU_OP_NAME(_23d8), 0, 9176 }, /* MOVE */
{ CPU_OP_NAME(_23e0), 0, 9184 }, /* MOVE */
{ CPU_OP_NAME(_23e8), 0, 9192 }, /* MOVE */
{ CPU_OP_NAME(_23f0), 0, 9200 }, /* MOVE */
{ CPU_OP_NAME(_23f8), 0, 9208 }, /* MOVE */
{ CPU_OP_NAME(_23f9), 0, 9209 }, /* MOVE */
{ CPU_OP_NAME(_23fa), 0, 9210 }, /* MOVE */
{ CPU_OP_NAME(_23fb), 0, 9211 }, /* MOVE */
{ CPU_OP_NAME(_23fc), 0, 9212 }, /* MOVE */
{ CPU_OP_NAME(_3000), 0, 12288 }, /* MOVE */
{ CPU_OP_NAME(_3008), 0, 12296 }, /* MOVE */
{ CPU_OP_NAME(_3010), 0, 12304 }, /* MOVE */
{ CPU_OP_NAME(_3018), 0, 12312 }, /* MOVE */
{ CPU_OP_NAME(_3020), 0, 12320 }, /* MOVE */
{ CPU_OP_NAME(_3028), 0, 12328 }, /* MOVE */
{ CPU_OP_NAME(_3030), 0, 12336 }, /* MOVE */
{ CPU_OP_NAME(_3038), 0, 12344 }, /* MOVE */
{ CPU_OP_NAME(_3039), 0, 12345 }, /* MOVE */
{ CPU_OP_NAME(_303a), 0, 12346 }, /* MOVE */
{ CPU_OP_NAME(_303b), 0, 12347 }, /* MOVE */
{ CPU_OP_NAME(_303c), 0, 12348 }, /* MOVE */
{ CPU_OP_NAME(_3040), 0, 12352 }, /* MOVEA */
{ CPU_OP_NAME(_3048), 0, 12360 }, /* MOVEA */
{ CPU_OP_NAME(_3050), 0, 12368 }, /* MOVEA */
{ CPU_OP_NAME(_3058), 0, 12376 }, /* MOVEA */
{ CPU_OP_NAME(_3060), 0, 12384 }, /* MOVEA */
{ CPU_OP_NAME(_3068), 0, 12392 }, /* MOVEA */
{ CPU_OP_NAME(_3070), 0, 12400 }, /* MOVEA */
{ CPU_OP_NAME(_3078), 0, 12408 }, /* MOVEA */
{ CPU_OP_NAME(_3079), 0, 12409 }, /* MOVEA */
{ CPU_OP_NAME(_307a), 0, 12410 }, /* MOVEA */
{ CPU_OP_NAME(_307b), 0, 12411 }, /* MOVEA */
{ CPU_OP_NAME(_307c), 0, 12412 }, /* MOVEA */
{ CPU_OP_NAME(_3080), 0, 12416 }, /* MOVE */
{ CPU_OP_NAME(_3088), 0, 12424 }, /* MOVE */
{ CPU_OP_NAME(_3090), 0, 12432 }, /* MOVE */
{ CPU_OP_NAME(_3098), 0, 12440 }, /* MOVE */
{ CPU_OP_NAME(_30a0), 0, 12448 }, /* MOVE */
{ CPU_OP_NAME(_30a8), 0, 12456 }, /* MOVE */
{ CPU_OP_NAME(_30b0), 0, 12464 }, /* MOVE */
{ CPU_OP_NAME(_30b8), 0, 12472 }, /* MOVE */
{ CPU_OP_NAME(_30b9), 0, 12473 }, /* MOVE */
{ CPU_OP_NAME(_30ba), 0, 12474 }, /* MOVE */
{ CPU_OP_NAME(_30bb), 0, 12475 }, /* MOVE */
{ CPU_OP_NAME(_30bc), 0, 12476 }, /* MOVE */
{ CPU_OP_NAME(_30c0), 0, 12480 }, /* MOVE */
{ CPU_OP_NAME(_30c8), 0, 12488 }, /* MOVE */
{ CPU_OP_NAME(_30d0), 0, 12496 }, /* MOVE */
{ CPU_OP_NAME(_30d8), 0, 12504 }, /* MOVE */
{ CPU_OP_NAME(_30e0), 0, 12512 }, /* MOVE */
{ CPU_OP_NAME(_30e8), 0, 12520 }, /* MOVE */
{ CPU_OP_NAME(_30f0), 0, 12528 }, /* MOVE */
{ CPU_OP_NAME(_30f8), 0, 12536 }, /* MOVE */
{ CPU_OP_NAME(_30f9), 0, 12537 }, /* MOVE */
{ CPU_OP_NAME(_30fa), 0, 12538 }, /* MOVE */
{ CPU_OP_NAME(_30fb), 0, 12539 }, /* MOVE */
{ CPU_OP_NAME(_30fc), 0, 12540 }, /* MOVE */
{ CPU_OP_NAME(_3100), 0, 12544 }, /* MOVE */
{ CPU_OP_NAME(_3108), 0, 12552 }, /* MOVE */
{ CPU_OP_NAME(_3110), 0, 12560 }, /* MOVE */
{ CPU_OP_NAME(_3118), 0, 12568 }, /* MOVE */
{ CPU_OP_NAME(_3120), 0, 12576 }, /* MOVE */
{ CPU_OP_NAME(_3128), 0, 12584 }, /* MOVE */
{ CPU_OP_NAME(_3130), 0, 12592 }, /* MOVE */
{ CPU_OP_NAME(_3138), 0, 12600 }, /* MOVE */
{ CPU_OP_NAME(_3139), 0, 12601 }, /* MOVE */
{ CPU_OP_NAME(_313a), 0, 12602 }, /* MOVE */
{ CPU_OP_NAME(_313b), 0, 12603 }, /* MOVE */
{ CPU_OP_NAME(_313c), 0, 12604 }, /* MOVE */
{ CPU_OP_NAME(_3140), 0, 12608 }, /* MOVE */
{ CPU_OP_NAME(_3148), 0, 12616 }, /* MOVE */
{ CPU_OP_NAME(_3150), 0, 12624 }, /* MOVE */
{ CPU_OP_NAME(_3158), 0, 12632 }, /* MOVE */
{ CPU_OP_NAME(_3160), 0, 12640 }, /* MOVE */
{ CPU_OP_NAME(_3168), 0, 12648 }, /* MOVE */
{ CPU_OP_NAME(_3170), 0, 12656 }, /* MOVE */
{ CPU_OP_NAME(_3178), 0, 12664 }, /* MOVE */
{ CPU_OP_NAME(_3179), 0, 12665 }, /* MOVE */
{ CPU_OP_NAME(_317a), 0, 12666 }, /* MOVE */
{ CPU_OP_NAME(_317b), 0, 12667 }, /* MOVE */
{ CPU_OP_NAME(_317c), 0, 12668 }, /* MOVE */
{ CPU_OP_NAME(_3180), 0, 12672 }, /* MOVE */
{ CPU_OP_NAME(_3188), 0, 12680 }, /* MOVE */
{ CPU_OP_NAME(_3190), 0, 12688 }, /* MOVE */
{ CPU_OP_NAME(_3198), 0, 12696 }, /* MOVE */
{ CPU_OP_NAME(_31a0), 0, 12704 }, /* MOVE */
{ CPU_OP_NAME(_31a8), 0, 12712 }, /* MOVE */
{ CPU_OP_NAME(_31b0), 0, 12720 }, /* MOVE */
{ CPU_OP_NAME(_31b8), 0, 12728 }, /* MOVE */
{ CPU_OP_NAME(_31b9), 0, 12729 }, /* MOVE */
{ CPU_OP_NAME(_31ba), 0, 12730 }, /* MOVE */
{ CPU_OP_NAME(_31bb), 0, 12731 }, /* MOVE */
{ CPU_OP_NAME(_31bc), 0, 12732 }, /* MOVE */
{ CPU_OP_NAME(_31c0), 0, 12736 }, /* MOVE */
{ CPU_OP_NAME(_31c8), 0, 12744 }, /* MOVE */
{ CPU_OP_NAME(_31d0), 0, 12752 }, /* MOVE */
{ CPU_OP_NAME(_31d8), 0, 12760 }, /* MOVE */
{ CPU_OP_NAME(_31e0), 0, 12768 }, /* MOVE */
{ CPU_OP_NAME(_31e8), 0, 12776 }, /* MOVE */
{ CPU_OP_NAME(_31f0), 0, 12784 }, /* MOVE */
{ CPU_OP_NAME(_31f8), 0, 12792 }, /* MOVE */
{ CPU_OP_NAME(_31f9), 0, 12793 }, /* MOVE */
{ CPU_OP_NAME(_31fa), 0, 12794 }, /* MOVE */
{ CPU_OP_NAME(_31fb), 0, 12795 }, /* MOVE */
{ CPU_OP_NAME(_31fc), 0, 12796 }, /* MOVE */
{ CPU_OP_NAME(_33c0), 0, 13248 }, /* MOVE */
{ CPU_OP_NAME(_33c8), 0, 13256 }, /* MOVE */
{ CPU_OP_NAME(_33d0), 0, 13264 }, /* MOVE */
{ CPU_OP_NAME(_33d8), 0, 13272 }, /* MOVE */
{ CPU_OP_NAME(_33e0), 0, 13280 }, /* MOVE */
{ CPU_OP_NAME(_33e8), 0, 13288 }, /* MOVE */
{ CPU_OP_NAME(_33f0), 0, 13296 }, /* MOVE */
{ CPU_OP_NAME(_33f8), 0, 13304 }, /* MOVE */
{ CPU_OP_NAME(_33f9), 0, 13305 }, /* MOVE */
{ CPU_OP_NAME(_33fa), 0, 13306 }, /* MOVE */
{ CPU_OP_NAME(_33fb), 0, 13307 }, /* MOVE */
{ CPU_OP_NAME(_33fc), 0, 13308 }, /* MOVE */
{ CPU_OP_NAME(_4000), 0, 16384 }, /* NEGX */
{ CPU_OP_NAME(_4010), 0, 16400 }, /* NEGX */
{ CPU_OP_NAME(_4018), 0, 16408 }, /* NEGX */
{ CPU_OP_NAME(_4020), 0, 16416 }, /* NEGX */
{ CPU_OP_NAME(_4028), 0, 16424 }, /* NEGX */
{ CPU_OP_NAME(_4030), 0, 16432 }, /* NEGX */
{ CPU_OP_NAME(_4038), 0, 16440 }, /* NEGX */
{ CPU_OP_NAME(_4039), 0, 16441 }, /* NEGX */
{ CPU_OP_NAME(_4040), 0, 16448 }, /* NEGX */
{ CPU_OP_NAME(_4050), 0, 16464 }, /* NEGX */
{ CPU_OP_NAME(_4058), 0, 16472 }, /* NEGX */
{ CPU_OP_NAME(_4060), 0, 16480 }, /* NEGX */
{ CPU_OP_NAME(_4068), 0, 16488 }, /* NEGX */
{ CPU_OP_NAME(_4070), 0, 16496 }, /* NEGX */
{ CPU_OP_NAME(_4078), 0, 16504 }, /* NEGX */
{ CPU_OP_NAME(_4079), 0, 16505 }, /* NEGX */
{ CPU_OP_NAME(_4080), 0, 16512 }, /* NEGX */
{ CPU_OP_NAME(_4090), 0, 16528 }, /* NEGX */
{ CPU_OP_NAME(_4098), 0, 16536 }, /* NEGX */
{ CPU_OP_NAME(_40a0), 0, 16544 }, /* NEGX */
{ CPU_OP_NAME(_40a8), 0, 16552 }, /* NEGX */
{ CPU_OP_NAME(_40b0), 0, 16560 }, /* NEGX */
{ CPU_OP_NAME(_40b8), 0, 16568 }, /* NEGX */
{ CPU_OP_NAME(_40b9), 0, 16569 }, /* NEGX */
{ CPU_OP_NAME(_40c0), 0, 16576 }, /* MVSR2 */
{ CPU_OP_NAME(_40d0), 0, 16592 }, /* MVSR2 */
{ CPU_OP_NAME(_40d8), 0, 16600 }, /* MVSR2 */
{ CPU_OP_NAME(_40e0), 0, 16608 }, /* MVSR2 */
{ CPU_OP_NAME(_40e8), 0, 16616 }, /* MVSR2 */
{ CPU_OP_NAME(_40f0), 0, 16624 }, /* MVSR2 */
{ CPU_OP_NAME(_40f8), 0, 16632 }, /* MVSR2 */
{ CPU_OP_NAME(_40f9), 0, 16633 }, /* MVSR2 */
{ CPU_OP_NAME(_4100), 0, 16640 }, /* CHK */
{ CPU_OP_NAME(_4110), 0, 16656 }, /* CHK */
{ CPU_OP_NAME(_4118), 0, 16664 }, /* CHK */
{ CPU_OP_NAME(_4120), 0, 16672 }, /* CHK */
{ CPU_OP_NAME(_4128), 0, 16680 }, /* CHK */
{ CPU_OP_NAME(_4130), 0, 16688 }, /* CHK */
{ CPU_OP_NAME(_4138), 0, 16696 }, /* CHK */
{ CPU_OP_NAME(_4139), 0, 16697 }, /* CHK */
{ CPU_OP_NAME(_413a), 0, 16698 }, /* CHK */
{ CPU_OP_NAME(_413b), 0, 16699 }, /* CHK */
{ CPU_OP_NAME(_413c), 0, 16700 }, /* CHK */
{ CPU_OP_NAME(_4180), 0, 16768 }, /* CHK */
{ CPU_OP_NAME(_4190), 0, 16784 }, /* CHK */
{ CPU_OP_NAME(_4198), 0, 16792 }, /* CHK */
{ CPU_OP_NAME(_41a0), 0, 16800 }, /* CHK */
{ CPU_OP_NAME(_41a8), 0, 16808 }, /* CHK */
{ CPU_OP_NAME(_41b0), 0, 16816 }, /* CHK */
{ CPU_OP_NAME(_41b8), 0, 16824 }, /* CHK */
{ CPU_OP_NAME(_41b9), 0, 16825 }, /* CHK */
{ CPU_OP_NAME(_41ba), 0, 16826 }, /* CHK */
{ CPU_OP_NAME(_41bb), 0, 16827 }, /* CHK */
{ CPU_OP_NAME(_41bc), 0, 16828 }, /* CHK */
{ CPU_OP_NAME(_41d0), 0, 16848 }, /* LEA */
{ CPU_OP_NAME(_41e8), 0, 16872 }, /* LEA */
{ CPU_OP_NAME(_41f0), 0, 16880 }, /* LEA */
{ CPU_OP_NAME(_41f8), 0, 16888 }, /* LEA */
{ CPU_OP_NAME(_41f9), 0, 16889 }, /* LEA */
{ CPU_OP_NAME(_41fa), 0, 16890 }, /* LEA */
{ CPU_OP_NAME(_41fb), 0, 16891 }, /* LEA */
{ CPU_OP_NAME(_4200), 0, 16896 }, /* CLR */
{ CPU_OP_NAME(_4210), 0, 16912 }, /* CLR */
{ CPU_OP_NAME(_4218), 0, 16920 }, /* CLR */
{ CPU_OP_NAME(_4220), 0, 16928 }, /* CLR */
{ CPU_OP_NAME(_4228), 0, 16936 }, /* CLR */
{ CPU_OP_NAME(_4230), 0, 16944 }, /* CLR */
{ CPU_OP_NAME(_4238), 0, 16952 }, /* CLR */
{ CPU_OP_NAME(_4239), 0, 16953 }, /* CLR */
{ CPU_OP_NAME(_4240), 0, 16960 }, /* CLR */
{ CPU_OP_NAME(_4250), 0, 16976 }, /* CLR */
{ CPU_OP_NAME(_4258), 0, 16984 }, /* CLR */
{ CPU_OP_NAME(_4260), 0, 16992 }, /* CLR */
{ CPU_OP_NAME(_4268), 0, 17000 }, /* CLR */
{ CPU_OP_NAME(_4270), 0, 17008 }, /* CLR */
{ CPU_OP_NAME(_4278), 0, 17016 }, /* CLR */
{ CPU_OP_NAME(_4279), 0, 17017 }, /* CLR */
{ CPU_OP_NAME(_4280), 0, 17024 }, /* CLR */
{ CPU_OP_NAME(_4290), 0, 17040 }, /* CLR */
{ CPU_OP_NAME(_4298), 0, 17048 }, /* CLR */
{ CPU_OP_NAME(_42a0), 0, 17056 }, /* CLR */
{ CPU_OP_NAME(_42a8), 0, 17064 }, /* CLR */
{ CPU_OP_NAME(_42b0), 0, 17072 }, /* CLR */
{ CPU_OP_NAME(_42b8), 0, 17080 }, /* CLR */
{ CPU_OP_NAME(_42b9), 0, 17081 }, /* CLR */
{ CPU_OP_NAME(_42c0), 0, 17088 }, /* MVSR2 */
{ CPU_OP_NAME(_42d0), 0, 17104 }, /* MVSR2 */
{ CPU_OP_NAME(_42d8), 0, 17112 }, /* MVSR2 */
{ CPU_OP_NAME(_42e0), 0, 17120 }, /* MVSR2 */
{ CPU_OP_NAME(_42e8), 0, 17128 }, /* MVSR2 */
{ CPU_OP_NAME(_42f0), 0, 17136 }, /* MVSR2 */
{ CPU_OP_NAME(_42f8), 0, 17144 }, /* MVSR2 */
{ CPU_OP_NAME(_42f9), 0, 17145 }, /* MVSR2 */
{ CPU_OP_NAME(_4400), 0, 17408 }, /* NEG */
{ CPU_OP_NAME(_4410), 0, 17424 }, /* NEG */
{ CPU_OP_NAME(_4418), 0, 17432 }, /* NEG */
{ CPU_OP_NAME(_4420), 0, 17440 }, /* NEG */
{ CPU_OP_NAME(_4428), 0, 17448 }, /* NEG */
{ CPU_OP_NAME(_4430), 0, 17456 }, /* NEG */
{ CPU_OP_NAME(_4438), 0, 17464 }, /* NEG */
{ CPU_OP_NAME(_4439), 0, 17465 }, /* NEG */
{ CPU_OP_NAME(_4440), 0, 17472 }, /* NEG */
{ CPU_OP_NAME(_4450), 0, 17488 }, /* NEG */
{ CPU_OP_NAME(_4458), 0, 17496 }, /* NEG */
{ CPU_OP_NAME(_4460), 0, 17504 }, /* NEG */
{ CPU_OP_NAME(_4468), 0, 17512 }, /* NEG */
{ CPU_OP_NAME(_4470), 0, 17520 }, /* NEG */
{ CPU_OP_NAME(_4478), 0, 17528 }, /* NEG */
{ CPU_OP_NAME(_4479), 0, 17529 }, /* NEG */
{ CPU_OP_NAME(_4480), 0, 17536 }, /* NEG */
{ CPU_OP_NAME(_4490), 0, 17552 }, /* NEG */
{ CPU_OP_NAME(_4498), 0, 17560 }, /* NEG */
{ CPU_OP_NAME(_44a0), 0, 17568 }, /* NEG */
{ CPU_OP_NAME(_44a8), 0, 17576 }, /* NEG */
{ CPU_OP_NAME(_44b0), 0, 17584 }, /* NEG */
{ CPU_OP_NAME(_44b8), 0, 17592 }, /* NEG */
{ CPU_OP_NAME(_44b9), 0, 17593 }, /* NEG */
{ CPU_OP_NAME(_44c0), 0, 17600 }, /* MV2SR */
{ CPU_OP_NAME(_44d0), 0, 17616 }, /* MV2SR */
{ CPU_OP_NAME(_44d8), 0, 17624 }, /* MV2SR */
{ CPU_OP_NAME(_44e0), 0, 17632 }, /* MV2SR */
{ CPU_OP_NAME(_44e8), 0, 17640 }, /* MV2SR */
{ CPU_OP_NAME(_44f0), 0, 17648 }, /* MV2SR */
{ CPU_OP_NAME(_44f8), 0, 17656 }, /* MV2SR */
{ CPU_OP_NAME(_44f9), 0, 17657 }, /* MV2SR */
{ CPU_OP_NAME(_44fa), 0, 17658 }, /* MV2SR */
{ CPU_OP_NAME(_44fb), 0, 17659 }, /* MV2SR */
{ CPU_OP_NAME(_44fc), 0, 17660 }, /* MV2SR */
{ CPU_OP_NAME(_4600), 0, 17920 }, /* NOT */
{ CPU_OP_NAME(_4610), 0, 17936 }, /* NOT */
{ CPU_OP_NAME(_4618), 0, 17944 }, /* NOT */
{ CPU_OP_NAME(_4620), 0, 17952 }, /* NOT */
{ CPU_OP_NAME(_4628), 0, 17960 }, /* NOT */
{ CPU_OP_NAME(_4630), 0, 17968 }, /* NOT */
{ CPU_OP_NAME(_4638), 0, 17976 }, /* NOT */
{ CPU_OP_NAME(_4639), 0, 17977 }, /* NOT */
{ CPU_OP_NAME(_4640), 0, 17984 }, /* NOT */
{ CPU_OP_NAME(_4650), 0, 18000 }, /* NOT */
{ CPU_OP_NAME(_4658), 0, 18008 }, /* NOT */
{ CPU_OP_NAME(_4660), 0, 18016 }, /* NOT */
{ CPU_OP_NAME(_4668), 0, 18024 }, /* NOT */
{ CPU_OP_NAME(_4670), 0, 18032 }, /* NOT */
{ CPU_OP_NAME(_4678), 0, 18040 }, /* NOT */
{ CPU_OP_NAME(_4679), 0, 18041 }, /* NOT */
{ CPU_OP_NAME(_4680), 0, 18048 }, /* NOT */
{ CPU_OP_NAME(_4690), 0, 18064 }, /* NOT */
{ CPU_OP_NAME(_4698), 0, 18072 }, /* NOT */
{ CPU_OP_NAME(_46a0), 0, 18080 }, /* NOT */
{ CPU_OP_NAME(_46a8), 0, 18088 }, /* NOT */
{ CPU_OP_NAME(_46b0), 0, 18096 }, /* NOT */
{ CPU_OP_NAME(_46b8), 0, 18104 }, /* NOT */
{ CPU_OP_NAME(_46b9), 0, 18105 }, /* NOT */
{ CPU_OP_NAME(_46c0), 0, 18112 }, /* MV2SR */
{ CPU_OP_NAME(_46d0), 0, 18128 }, /* MV2SR */
{ CPU_OP_NAME(_46d8), 0, 18136 }, /* MV2SR */
{ CPU_OP_NAME(_46e0), 0, 18144 }, /* MV2SR */
{ CPU_OP_NAME(_46e8), 0, 18152 }, /* MV2SR */
{ CPU_OP_NAME(_46f0), 0, 18160 }, /* MV2SR */
{ CPU_OP_NAME(_46f8), 0, 18168 }, /* MV2SR */
{ CPU_OP_NAME(_46f9), 0, 18169 }, /* MV2SR */
{ CPU_OP_NAME(_46fa), 0, 18170 }, /* MV2SR */
{ CPU_OP_NAME(_46fb), 0, 18171 }, /* MV2SR */
{ CPU_OP_NAME(_46fc), 0, 18172 }, /* MV2SR */
{ CPU_OP_NAME(_4800), 0, 18432 }, /* NBCD */
{ CPU_OP_NAME(_4808), 0, 18440 }, /* LINK */
{ CPU_OP_NAME(_4810), 0, 18448 }, /* NBCD */
{ CPU_OP_NAME(_4818), 0, 18456 }, /* NBCD */
{ CPU_OP_NAME(_4820), 0, 18464 }, /* NBCD */
{ CPU_OP_NAME(_4828), 0, 18472 }, /* NBCD */
{ CPU_OP_NAME(_4830), 0, 18480 }, /* NBCD */
{ CPU_OP_NAME(_4838), 0, 18488 }, /* NBCD */
{ CPU_OP_NAME(_4839), 0, 18489 }, /* NBCD */
{ CPU_OP_NAME(_4840), 0, 18496 }, /* SWAP */
{ CPU_OP_NAME(_4848), 0, 18504 }, /* BKPT */
{ CPU_OP_NAME(_4850), 0, 18512 }, /* PEA */
{ CPU_OP_NAME(_4868), 0, 18536 }, /* PEA */
{ CPU_OP_NAME(_4870), 0, 18544 }, /* PEA */
{ CPU_OP_NAME(_4878), 0, 18552 }, /* PEA */
{ CPU_OP_NAME(_4879), 0, 18553 }, /* PEA */
{ CPU_OP_NAME(_487a), 0, 18554 }, /* PEA */
{ CPU_OP_NAME(_487b), 0, 18555 }, /* PEA */
{ CPU_OP_NAME(_4880), 0, 18560 }, /* EXT */
{ CPU_OP_NAME(_4890), 0, 18576 }, /* MVMLE */
{ CPU_OP_NAME(_48a0), 0, 18592 }, /* MVMLE */
{ CPU_OP_NAME(_48a8), 0, 18600 }, /* MVMLE */
{ CPU_OP_NAME(_48b0), 0, 18608 }, /* MVMLE */
{ CPU_OP_NAME(_48b8), 0, 18616 }, /* MVMLE */
{ CPU_OP_NAME(_48b9), 0, 18617 }, /* MVMLE */
{ CPU_OP_NAME(_48c0), 0, 18624 }, /* EXT */
{ CPU_OP_NAME(_48d0), 0, 18640 }, /* MVMLE */
{ CPU_OP_NAME(_48e0), 0, 18656 }, /* MVMLE */
{ CPU_OP_NAME(_48e8), 0, 18664 }, /* MVMLE */
{ CPU_OP_NAME(_48f0), 0, 18672 }, /* MVMLE */
{ CPU_OP_NAME(_48f8), 0, 18680 }, /* MVMLE */
{ CPU_OP_NAME(_48f9), 0, 18681 }, /* MVMLE */
{ CPU_OP_NAME(_49c0), 0, 18880 }, /* EXT */
{ CPU_OP_NAME(_4a00), 0, 18944 }, /* TST */
{ CPU_OP_NAME(_4a10), 0, 18960 }, /* TST */
{ CPU_OP_NAME(_4a18), 0, 18968 }, /* TST */
{ CPU_OP_NAME(_4a20), 0, 18976 }, /* TST */
{ CPU_OP_NAME(_4a28), 0, 18984 }, /* TST */
{ CPU_OP_NAME(_4a30), 0, 18992 }, /* TST */
{ CPU_OP_NAME(_4a38), 0, 19000 }, /* TST */
{ CPU_OP_NAME(_4a39), 0, 19001 }, /* TST */
{ CPU_OP_NAME(_4a3a), 0, 19002 }, /* TST */
{ CPU_OP_NAME(_4a3b), 0, 19003 }, /* TST */
{ CPU_OP_NAME(_4a3c), 0, 19004 }, /* TST */
{ CPU_OP_NAME(_4a40), 0, 19008 }, /* TST */
{ CPU_OP_NAME(_4a48), 0, 19016 }, /* TST */
{ CPU_OP_NAME(_4a50), 0, 19024 }, /* TST */
{ CPU_OP_NAME(_4a58), 0, 19032 }, /* TST */
{ CPU_OP_NAME(_4a60), 0, 19040 }, /* TST */
{ CPU_OP_NAME(_4a68), 0, 19048 }, /* TST */
{ CPU_OP_NAME(_4a70), 0, 19056 }, /* TST */
{ CPU_OP_NAME(_4a78), 0, 19064 }, /* TST */
{ CPU_OP_NAME(_4a79), 0, 19065 }, /* TST */
{ CPU_OP_NAME(_4a7a), 0, 19066 }, /* TST */
{ CPU_OP_NAME(_4a7b), 0, 19067 }, /* TST */
{ CPU_OP_NAME(_4a7c), 0, 19068 }, /* TST */
{ CPU_OP_NAME(_4a80), 0, 19072 }, /* TST */
{ CPU_OP_NAME(_4a88), 0, 19080 }, /* TST */
{ CPU_OP_NAME(_4a90), 0, 19088 }, /* TST */
{ CPU_OP_NAME(_4a98), 0, 19096 }, /* TST */
{ CPU_OP_NAME(_4aa0), 0, 19104 }, /* TST */
{ CPU_OP_NAME(_4aa8), 0, 19112 }, /* TST */
{ CPU_OP_NAME(_4ab0), 0, 19120 }, /* TST */
{ CPU_OP_NAME(_4ab8), 0, 19128 }, /* TST */
{ CPU_OP_NAME(_4ab9), 0, 19129 }, /* TST */
{ CPU_OP_NAME(_4aba), 0, 19130 }, /* TST */
{ CPU_OP_NAME(_4abb), 0, 19131 }, /* TST */
{ CPU_OP_NAME(_4abc), 0, 19132 }, /* TST */
{ CPU_OP_NAME(_4ac0), 0, 19136 }, /* TAS */
{ CPU_OP_NAME(_4ad0), 0, 19152 }, /* TAS */
{ CPU_OP_NAME(_4ad8), 0, 19160 }, /* TAS */
{ CPU_OP_NAME(_4ae0), 0, 19168 }, /* TAS */
{ CPU_OP_NAME(_4ae8), 0, 19176 }, /* TAS */
{ CPU_OP_NAME(_4af0), 0, 19184 }, /* TAS */
{ CPU_OP_NAME(_4af8), 0, 19192 }, /* TAS */
{ CPU_OP_NAME(_4af9), 0, 19193 }, /* TAS */
{ CPU_OP_NAME(_4c00), 0, 19456 }, /* MULL */
{ CPU_OP_NAME(_4c10), 0, 19472 }, /* MULL */
{ CPU_OP_NAME(_4c18), 0, 19480 }, /* MULL */
{ CPU_OP_NAME(_4c20), 0, 19488 }, /* MULL */
{ CPU_OP_NAME(_4c28), 0, 19496 }, /* MULL */
{ CPU_OP_NAME(_4c30), 0, 19504 }, /* MULL */
{ CPU_OP_NAME(_4c38), 0, 19512 }, /* MULL */
{ CPU_OP_NAME(_4c39), 0, 19513 }, /* MULL */
{ CPU_OP_NAME(_4c3a), 0, 19514 }, /* MULL */
{ CPU_OP_NAME(_4c3b), 0, 19515 }, /* MULL */
{ CPU_OP_NAME(_4c3c), 0, 19516 }, /* MULL */
{ CPU_OP_NAME(_4c40), 0, 19520 }, /* DIVL */
{ CPU_OP_NAME(_4c50), 0, 19536 }, /* DIVL */
{ CPU_OP_NAME(_4c58), 0, 19544 }, /* DIVL */
{ CPU_OP_NAME(_4c60), 0, 19552 }, /* DIVL */
{ CPU_OP_NAME(_4c68), 0, 19560 }, /* DIVL */
{ CPU_OP_NAME(_4c70), 0, 19568 }, /* DIVL */
{ CPU_OP_NAME(_4c78), 0, 19576 }, /* DIVL */
{ CPU_OP_NAME(_4c79), 0, 19577 }, /* DIVL */
{ CPU_OP_NAME(_4c7a), 0, 19578 }, /* DIVL */
{ CPU_OP_NAME(_4c7b), 0, 19579 }, /* DIVL */
{ CPU_OP_NAME(_4c7c), 0, 19580 }, /* DIVL */
{ CPU_OP_NAME(_4c90), 0, 19600 }, /* MVMEL */
{ CPU_OP_NAME(_4c98), 0, 19608 }, /* MVMEL */
{ CPU_OP_NAME(_4ca8), 0, 19624 }, /* MVMEL */
{ CPU_OP_NAME(_4cb0), 0, 19632 }, /* MVMEL */
{ CPU_OP_NAME(_4cb8), 0, 19640 }, /* MVMEL */
{ CPU_OP_NAME(_4cb9), 0, 19641 }, /* MVMEL */
{ CPU_OP_NAME(_4cba), 0, 19642 }, /* MVMEL */
{ CPU_OP_NAME(_4cbb), 0, 19643 }, /* MVMEL */
{ CPU_OP_NAME(_4cd0), 0, 19664 }, /* MVMEL */
{ CPU_OP_NAME(_4cd8), 0, 19672 }, /* MVMEL */
{ CPU_OP_NAME(_4ce8), 0, 19688 }, /* MVMEL */
{ CPU_OP_NAME(_4cf0), 0, 19696 }, /* MVMEL */
{ CPU_OP_NAME(_4cf8), 0, 19704 }, /* MVMEL */
{ CPU_OP_NAME(_4cf9), 0, 19705 }, /* MVMEL */
{ CPU_OP_NAME(_4cfa), 0, 19706 }, /* MVMEL */
{ CPU_OP_NAME(_4cfb), 0, 19707 }, /* MVMEL */
{ CPU_OP_NAME(_4e40), 0, 20032 }, /* TRAP */
{ CPU_OP_NAME(_4e50), 0, 20048 }, /* LINK */
{ CPU_OP_NAME(_4e58), 0, 20056 }, /* UNLK */
{ CPU_OP_NAME(_4e60), 0, 20064 }, /* MVR2USP */
{ CPU_OP_NAME(_4e68), 0, 20072 }, /* MVUSP2R */
{ CPU_OP_NAME(_4e70), 0, 20080 }, /* RESET */
{ CPU_OP_NAME(_4e71), 0, 20081 }, /* NOP */
{ CPU_OP_NAME(_4e72), 0, 20082 }, /* STOP */
{ CPU_OP_NAME(_4e73), 0, 20083 }, /* RTE */
{ CPU_OP_NAME(_4e74), 0, 20084 }, /* RTD */
{ CPU_OP_NAME(_4e75), 0, 20085 }, /* RTS */
{ CPU_OP_NAME(_4e76), 0, 20086 }, /* TRAPV */
{ CPU_OP_NAME(_4e77), 0, 20087 }, /* RTR */
{ CPU_OP_NAME(_4e7a), 0, 20090 }, /* MOVEC2 */
{ CPU_OP_NAME(_4e7b), 0, 20091 }, /* MOVE2C */
{ CPU_OP_NAME(_4e90), 0, 20112 }, /* JSR */
{ CPU_OP_NAME(_4ea8), 0, 20136 }, /* JSR */
{ CPU_OP_NAME(_4eb0), 0, 20144 }, /* JSR */
{ CPU_OP_NAME(_4eb8), 0, 20152 }, /* JSR */
{ CPU_OP_NAME(_4eb9), 0, 20153 }, /* JSR */
{ CPU_OP_NAME(_4eba), 0, 20154 }, /* JSR */
{ CPU_OP_NAME(_4ebb), 0, 20155 }, /* JSR */
{ CPU_OP_NAME(_4ed0), 0, 20176 }, /* JMP */
{ CPU_OP_NAME(_4ee8), 0, 20200 }, /* JMP */
{ CPU_OP_NAME(_4ef0), 0, 20208 }, /* JMP */
{ CPU_OP_NAME(_4ef8), 0, 20216 }, /* JMP */
{ CPU_OP_NAME(_4ef9), 0, 20217 }, /* JMP */
{ CPU_OP_NAME(_4efa), 0, 20218 }, /* JMP */
{ CPU_OP_NAME(_4efb), 0, 20219 }, /* JMP */
{ CPU_OP_NAME(_5000), 0, 20480 }, /* ADD */
{ CPU_OP_NAME(_5010), 0, 20496 }, /* ADD */
{ CPU_OP_NAME(_5018), 0, 20504 }, /* ADD */
{ CPU_OP_NAME(_5020), 0, 20512 }, /* ADD */
{ CPU_OP_NAME(_5028), 0, 20520 }, /* ADD */
{ CPU_OP_NAME(_5030), 0, 20528 }, /* ADD */
{ CPU_OP_NAME(_5038), 0, 20536 }, /* ADD */
{ CPU_OP_NAME(_5039), 0, 20537 }, /* ADD */
{ CPU_OP_NAME(_5040), 0, 20544 }, /* ADD */
{ CPU_OP_NAME(_5048), 0, 20552 }, /* ADDA */
{ CPU_OP_NAME(_5050), 0, 20560 }, /* ADD */
{ CPU_OP_NAME(_5058), 0, 20568 }, /* ADD */
{ CPU_OP_NAME(_5060), 0, 20576 }, /* ADD */
{ CPU_OP_NAME(_5068), 0, 20584 }, /* ADD */
{ CPU_OP_NAME(_5070), 0, 20592 }, /* ADD */
{ CPU_OP_NAME(_5078), 0, 20600 }, /* ADD */
{ CPU_OP_NAME(_5079), 0, 20601 }, /* ADD */
{ CPU_OP_NAME(_5080), 0, 20608 }, /* ADD */
{ CPU_OP_NAME(_5088), 0, 20616 }, /* ADDA */
{ CPU_OP_NAME(_5090), 0, 20624 }, /* ADD */
{ CPU_OP_NAME(_5098), 0, 20632 }, /* ADD */
{ CPU_OP_NAME(_50a0), 0, 20640 }, /* ADD */
{ CPU_OP_NAME(_50a8), 0, 20648 }, /* ADD */
{ CPU_OP_NAME(_50b0), 0, 20656 }, /* ADD */
{ CPU_OP_NAME(_50b8), 0, 20664 }, /* ADD */
{ CPU_OP_NAME(_50b9), 0, 20665 }, /* ADD */
{ CPU_OP_NAME(_50c0), 0, 20672 }, /* Scc */
{ CPU_OP_NAME(_50c8), 0, 20680 }, /* DBcc */
{ CPU_OP_NAME(_50d0), 0, 20688 }, /* Scc */
{ CPU_OP_NAME(_50d8), 0, 20696 }, /* Scc */
{ CPU_OP_NAME(_50e0), 0, 20704 }, /* Scc */
{ CPU_OP_NAME(_50e8), 0, 20712 }, /* Scc */
{ CPU_OP_NAME(_50f0), 0, 20720 }, /* Scc */
{ CPU_OP_NAME(_50f8), 0, 20728 }, /* Scc */
{ CPU_OP_NAME(_50f9), 0, 20729 }, /* Scc */
{ CPU_OP_NAME(_50fa), 0, 20730 }, /* TRAPcc */
{ CPU_OP_NAME(_50fb), 0, 20731 }, /* TRAPcc */
{ CPU_OP_NAME(_50fc), 0, 20732 }, /* TRAPcc */
{ CPU_OP_NAME(_5100), 0, 20736 }, /* SUB */
{ CPU_OP_NAME(_5110), 0, 20752 }, /* SUB */
{ CPU_OP_NAME(_5118), 0, 20760 }, /* SUB */
{ CPU_OP_NAME(_5120), 0, 20768 }, /* SUB */
{ CPU_OP_NAME(_5128), 0, 20776 }, /* SUB */
{ CPU_OP_NAME(_5130), 0, 20784 }, /* SUB */
{ CPU_OP_NAME(_5138), 0, 20792 }, /* SUB */
{ CPU_OP_NAME(_5139), 0, 20793 }, /* SUB */
{ CPU_OP_NAME(_5140), 0, 20800 }, /* SUB */
{ CPU_OP_NAME(_5148), 0, 20808 }, /* SUBA */
{ CPU_OP_NAME(_5150), 0, 20816 }, /* SUB */
{ CPU_OP_NAME(_5158), 0, 20824 }, /* SUB */
{ CPU_OP_NAME(_5160), 0, 20832 }, /* SUB */
{ CPU_OP_NAME(_5168), 0, 20840 }, /* SUB */
{ CPU_OP_NAME(_5170), 0, 20848 }, /* SUB */
{ CPU_OP_NAME(_5178), 0, 20856 }, /* SUB */
{ CPU_OP_NAME(_5179), 0, 20857 }, /* SUB */
{ CPU_OP_NAME(_5180), 0, 20864 }, /* SUB */
{ CPU_OP_NAME(_5188), 0, 20872 }, /* SUBA */
{ CPU_OP_NAME(_5190), 0, 20880 }, /* SUB */
{ CPU_OP_NAME(_5198), 0, 20888 }, /* SUB */
{ CPU_OP_NAME(_51a0), 0, 20896 }, /* SUB */
{ CPU_OP_NAME(_51a8), 0, 20904 }, /* SUB */
{ CPU_OP_NAME(_51b0), 0, 20912 }, /* SUB */
{ CPU_OP_NAME(_51b8), 0, 20920 }, /* SUB */
{ CPU_OP_NAME(_51b9), 0, 20921 }, /* SUB */
{ CPU_OP_NAME(_51c0), 0, 20928 }, /* Scc */
{ CPU_OP_NAME(_51c8), 0, 20936 }, /* DBcc */
{ CPU_OP_NAME(_51d0), 0, 20944 }, /* Scc */
{ CPU_OP_NAME(_51d8), 0, 20952 }, /* Scc */
{ CPU_OP_NAME(_51e0), 0, 20960 }, /* Scc */
{ CPU_OP_NAME(_51e8), 0, 20968 }, /* Scc */
{ CPU_OP_NAME(_51f0), 0, 20976 }, /* Scc */
{ CPU_OP_NAME(_51f8), 0, 20984 }, /* Scc */
{ CPU_OP_NAME(_51f9), 0, 20985 }, /* Scc */
{ CPU_OP_NAME(_51fa), 0, 20986 }, /* TRAPcc */
{ CPU_OP_NAME(_51fb), 0, 20987 }, /* TRAPcc */
{ CPU_OP_NAME(_51fc), 0, 20988 }, /* TRAPcc */
{ CPU_OP_NAME(_52c0), 0, 21184 }, /* Scc */
{ CPU_OP_NAME(_52c8), 0, 21192 }, /* DBcc */
{ CPU_OP_NAME(_52d0), 0, 21200 }, /* Scc */
{ CPU_OP_NAME(_52d8), 0, 21208 }, /* Scc */
{ CPU_OP_NAME(_52e0), 0, 21216 }, /* Scc */
{ CPU_OP_NAME(_52e8), 0, 21224 }, /* Scc */
{ CPU_OP_NAME(_52f0), 0, 21232 }, /* Scc */
{ CPU_OP_NAME(_52f8), 0, 21240 }, /* Scc */
{ CPU_OP_NAME(_52f9), 0, 21241 }, /* Scc */
{ CPU_OP_NAME(_52fa), 0, 21242 }, /* TRAPcc */
{ CPU_OP_NAME(_52fb), 0, 21243 }, /* TRAPcc */
{ CPU_OP_NAME(_52fc), 0, 21244 }, /* TRAPcc */
{ CPU_OP_NAME(_53c0), 0, 21440 }, /* Scc */
{ CPU_OP_NAME(_53c8), 0, 21448 }, /* DBcc */
{ CPU_OP_NAME(_53d0), 0, 21456 }, /* Scc */
{ CPU_OP_NAME(_53d8), 0, 21464 }, /* Scc */
{ CPU_OP_NAME(_53e0), 0, 21472 }, /* Scc */
{ CPU_OP_NAME(_53e8), 0, 21480 }, /* Scc */
{ CPU_OP_NAME(_53f0), 0, 21488 }, /* Scc */
{ CPU_OP_NAME(_53f8), 0, 21496 }, /* Scc */
{ CPU_OP_NAME(_53f9), 0, 21497 }, /* Scc */
{ CPU_OP_NAME(_53fa), 0, 21498 }, /* TRAPcc */
{ CPU_OP_NAME(_53fb), 0, 21499 }, /* TRAPcc */
{ CPU_OP_NAME(_53fc), 0, 21500 }, /* TRAPcc */
{ CPU_OP_NAME(_54c0), 0, 21696 }, /* Scc */
{ CPU_OP_NAME(_54c8), 0, 21704 }, /* DBcc */
{ CPU_OP_NAME(_54d0), 0, 21712 }, /* Scc */
{ CPU_OP_NAME(_54d8), 0, 21720 }, /* Scc */
{ CPU_OP_NAME(_54e0), 0, 21728 }, /* Scc */
{ CPU_OP_NAME(_54e8), 0, 21736 }, /* Scc */
{ CPU_OP_NAME(_54f0), 0, 21744 }, /* Scc */
{ CPU_OP_NAME(_54f8), 0, 21752 }, /* Scc */
{ CPU_OP_NAME(_54f9), 0, 21753 }, /* Scc */
{ CPU_OP_NAME(_54fa), 0, 21754 }, /* TRAPcc */
{ CPU_OP_NAME(_54fb), 0, 21755 }, /* TRAPcc */
{ CPU_OP_NAME(_54fc), 0, 21756 }, /* TRAPcc */
{ CPU_OP_NAME(_55c0), 0, 21952 }, /* Scc */
{ CPU_OP_NAME(_55c8), 0, 21960 }, /* DBcc */
{ CPU_OP_NAME(_55d0), 0, 21968 }, /* Scc */
{ CPU_OP_NAME(_55d8), 0, 21976 }, /* Scc */
{ CPU_OP_NAME(_55e0), 0, 21984 }, /* Scc */
{ CPU_OP_NAME(_55e8), 0, 21992 }, /* Scc */
{ CPU_OP_NAME(_55f0), 0, 22000 }, /* Scc */
{ CPU_OP_NAME(_55f8), 0, 22008 }, /* Scc */
{ CPU_OP_NAME(_55f9), 0, 22009 }, /* Scc */
{ CPU_OP_NAME(_55fa), 0, 22010 }, /* TRAPcc */
{ CPU_OP_NAME(_55fb), 0, 22011 }, /* TRAPcc */
{ CPU_OP_NAME(_55fc), 0, 22012 }, /* TRAPcc */
{ CPU_OP_NAME(_56c0), 0, 22208 }, /* Scc */
{ CPU_OP_NAME(_56c8), 0, 22216 }, /* DBcc */
{ CPU_OP_NAME(_56d0), 0, 22224 }, /* Scc */
{ CPU_OP_NAME(_56d8), 0, 22232 }, /* Scc */
{ CPU_OP_NAME(_56e0), 0, 22240 }, /* Scc */
{ CPU_OP_NAME(_56e8), 0, 22248 }, /* Scc */
{ CPU_OP_NAME(_56f0), 0, 22256 }, /* Scc */
{ CPU_OP_NAME(_56f8), 0, 22264 }, /* Scc */
{ CPU_OP_NAME(_56f9), 0, 22265 }, /* Scc */
{ CPU_OP_NAME(_56fa), 0, 22266 }, /* TRAPcc */
{ CPU_OP_NAME(_56fb), 0, 22267 }, /* TRAPcc */
{ CPU_OP_NAME(_56fc), 0, 22268 }, /* TRAPcc */
{ CPU_OP_NAME(_57c0), 0, 22464 }, /* Scc */
{ CPU_OP_NAME(_57c8), 0, 22472 }, /* DBcc */
{ CPU_OP_NAME(_57d0), 0, 22480 }, /* Scc */
{ CPU_OP_NAME(_57d8), 0, 22488 }, /* Scc */
{ CPU_OP_NAME(_57e0), 0, 22496 }, /* Scc */
{ CPU_OP_NAME(_57e8), 0, 22504 }, /* Scc */
{ CPU_OP_NAME(_57f0), 0, 22512 }, /* Scc */
{ CPU_OP_NAME(_57f8), 0, 22520 }, /* Scc */
{ CPU_OP_NAME(_57f9), 0, 22521 }, /* Scc */
{ CPU_OP_NAME(_57fa), 0, 22522 }, /* TRAPcc */
{ CPU_OP_NAME(_57fb), 0, 22523 }, /* TRAPcc */
{ CPU_OP_NAME(_57fc), 0, 22524 }, /* TRAPcc */
{ CPU_OP_NAME(_58c0), 0, 22720 }, /* Scc */
{ CPU_OP_NAME(_58c8), 0, 22728 }, /* DBcc */
{ CPU_OP_NAME(_58d0), 0, 22736 }, /* Scc */
{ CPU_OP_NAME(_58d8), 0, 22744 }, /* Scc */
{ CPU_OP_NAME(_58e0), 0, 22752 }, /* Scc */
{ CPU_OP_NAME(_58e8), 0, 22760 }, /* Scc */
{ CPU_OP_NAME(_58f0), 0, 22768 }, /* Scc */
{ CPU_OP_NAME(_58f8), 0, 22776 }, /* Scc */
{ CPU_OP_NAME(_58f9), 0, 22777 }, /* Scc */
{ CPU_OP_NAME(_58fa), 0, 22778 }, /* TRAPcc */
{ CPU_OP_NAME(_58fb), 0, 22779 }, /* TRAPcc */
{ CPU_OP_NAME(_58fc), 0, 22780 }, /* TRAPcc */
{ CPU_OP_NAME(_59c0), 0, 22976 }, /* Scc */
{ CPU_OP_NAME(_59c8), 0, 22984 }, /* DBcc */
{ CPU_OP_NAME(_59d0), 0, 22992 }, /* Scc */
{ CPU_OP_NAME(_59d8), 0, 23000 }, /* Scc */
{ CPU_OP_NAME(_59e0), 0, 23008 }, /* Scc */
{ CPU_OP_NAME(_59e8), 0, 23016 }, /* Scc */
{ CPU_OP_NAME(_59f0), 0, 23024 }, /* Scc */
{ CPU_OP_NAME(_59f8), 0, 23032 }, /* Scc */
{ CPU_OP_NAME(_59f9), 0, 23033 }, /* Scc */
{ CPU_OP_NAME(_59fa), 0, 23034 }, /* TRAPcc */
{ CPU_OP_NAME(_59fb), 0, 23035 }, /* TRAPcc */
{ CPU_OP_NAME(_59fc), 0, 23036 }, /* TRAPcc */
{ CPU_OP_NAME(_5ac0), 0, 23232 }, /* Scc */
{ CPU_OP_NAME(_5ac8), 0, 23240 }, /* DBcc */
{ CPU_OP_NAME(_5ad0), 0, 23248 }, /* Scc */
{ CPU_OP_NAME(_5ad8), 0, 23256 }, /* Scc */
{ CPU_OP_NAME(_5ae0), 0, 23264 }, /* Scc */
{ CPU_OP_NAME(_5ae8), 0, 23272 }, /* Scc */
{ CPU_OP_NAME(_5af0), 0, 23280 }, /* Scc */
{ CPU_OP_NAME(_5af8), 0, 23288 }, /* Scc */
{ CPU_OP_NAME(_5af9), 0, 23289 }, /* Scc */
{ CPU_OP_NAME(_5afa), 0, 23290 }, /* TRAPcc */
{ CPU_OP_NAME(_5afb), 0, 23291 }, /* TRAPcc */
{ CPU_OP_NAME(_5afc), 0, 23292 }, /* TRAPcc */
{ CPU_OP_NAME(_5bc0), 0, 23488 }, /* Scc */
{ CPU_OP_NAME(_5bc8), 0, 23496 }, /* DBcc */
{ CPU_OP_NAME(_5bd0), 0, 23504 }, /* Scc */
{ CPU_OP_NAME(_5bd8), 0, 23512 }, /* Scc */
{ CPU_OP_NAME(_5be0), 0, 23520 }, /* Scc */
{ CPU_OP_NAME(_5be8), 0, 23528 }, /* Scc */
{ CPU_OP_NAME(_5bf0), 0, 23536 }, /* Scc */
{ CPU_OP_NAME(_5bf8), 0, 23544 }, /* Scc */
{ CPU_OP_NAME(_5bf9), 0, 23545 }, /* Scc */
{ CPU_OP_NAME(_5bfa), 0, 23546 }, /* TRAPcc */
{ CPU_OP_NAME(_5bfb), 0, 23547 }, /* TRAPcc */
{ CPU_OP_NAME(_5bfc), 0, 23548 }, /* TRAPcc */
{ CPU_OP_NAME(_5cc0), 0, 23744 }, /* Scc */
{ CPU_OP_NAME(_5cc8), 0, 23752 }, /* DBcc */
{ CPU_OP_NAME(_5cd0), 0, 23760 }, /* Scc */
{ CPU_OP_NAME(_5cd8), 0, 23768 }, /* Scc */
{ CPU_OP_NAME(_5ce0), 0, 23776 }, /* Scc */
{ CPU_OP_NAME(_5ce8), 0, 23784 }, /* Scc */
{ CPU_OP_NAME(_5cf0), 0, 23792 }, /* Scc */
{ CPU_OP_NAME(_5cf8), 0, 23800 }, /* Scc */
{ CPU_OP_NAME(_5cf9), 0, 23801 }, /* Scc */
{ CPU_OP_NAME(_5cfa), 0, 23802 }, /* TRAPcc */
{ CPU_OP_NAME(_5cfb), 0, 23803 }, /* TRAPcc */
{ CPU_OP_NAME(_5cfc), 0, 23804 }, /* TRAPcc */
{ CPU_OP_NAME(_5dc0), 0, 24000 }, /* Scc */
{ CPU_OP_NAME(_5dc8), 0, 24008 }, /* DBcc */
{ CPU_OP_NAME(_5dd0), 0, 24016 }, /* Scc */
{ CPU_OP_NAME(_5dd8), 0, 24024 }, /* Scc */
{ CPU_OP_NAME(_5de0), 0, 24032 }, /* Scc */
{ CPU_OP_NAME(_5de8), 0, 24040 }, /* Scc */
{ CPU_OP_NAME(_5df0), 0, 24048 }, /* Scc */
{ CPU_OP_NAME(_5df8), 0, 24056 }, /* Scc */
{ CPU_OP_NAME(_5df9), 0, 24057 }, /* Scc */
{ CPU_OP_NAME(_5dfa), 0, 24058 }, /* TRAPcc */
{ CPU_OP_NAME(_5dfb), 0, 24059 }, /* TRAPcc */
{ CPU_OP_NAME(_5dfc), 0, 24060 }, /* TRAPcc */
{ CPU_OP_NAME(_5ec0), 0, 24256 }, /* Scc */
{ CPU_OP_NAME(_5ec8), 0, 24264 }, /* DBcc */
{ CPU_OP_NAME(_5ed0), 0, 24272 }, /* Scc */
{ CPU_OP_NAME(_5ed8), 0, 24280 }, /* Scc */
{ CPU_OP_NAME(_5ee0), 0, 24288 }, /* Scc */
{ CPU_OP_NAME(_5ee8), 0, 24296 }, /* Scc */
{ CPU_OP_NAME(_5ef0), 0, 24304 }, /* Scc */
{ CPU_OP_NAME(_5ef8), 0, 24312 }, /* Scc */
{ CPU_OP_NAME(_5ef9), 0, 24313 }, /* Scc */
{ CPU_OP_NAME(_5efa), 0, 24314 }, /* TRAPcc */
{ CPU_OP_NAME(_5efb), 0, 24315 }, /* TRAPcc */
{ CPU_OP_NAME(_5efc), 0, 24316 }, /* TRAPcc */
{ CPU_OP_NAME(_5fc0), 0, 24512 }, /* Scc */
{ CPU_OP_NAME(_5fc8), 0, 24520 }, /* DBcc */
{ CPU_OP_NAME(_5fd0), 0, 24528 }, /* Scc */
{ CPU_OP_NAME(_5fd8), 0, 24536 }, /* Scc */
{ CPU_OP_NAME(_5fe0), 0, 24544 }, /* Scc */
{ CPU_OP_NAME(_5fe8), 0, 24552 }, /* Scc */
{ CPU_OP_NAME(_5ff0), 0, 24560 }, /* Scc */
{ CPU_OP_NAME(_5ff8), 0, 24568 }, /* Scc */
{ CPU_OP_NAME(_5ff9), 0, 24569 }, /* Scc */
{ CPU_OP_NAME(_5ffa), 0, 24570 }, /* TRAPcc */
{ CPU_OP_NAME(_5ffb), 0, 24571 }, /* TRAPcc */
{ CPU_OP_NAME(_5ffc), 0, 24572 }, /* TRAPcc */
{ CPU_OP_NAME(_6000), 0, 24576 }, /* Bcc */
{ CPU_OP_NAME(_6001), 0, 24577 }, /* Bcc */
{ CPU_OP_NAME(_60ff), 0, 24831 }, /* Bcc */
{ CPU_OP_NAME(_6100), 0, 24832 }, /* BSR */
{ CPU_OP_NAME(_6101), 0, 24833 }, /* BSR */
{ CPU_OP_NAME(_61ff), 0, 25087 }, /* BSR */
{ CPU_OP_NAME(_6200), 0, 25088 }, /* Bcc */
{ CPU_OP_NAME(_6201), 0, 25089 }, /* Bcc */
{ CPU_OP_NAME(_62ff), 0, 25343 }, /* Bcc */
{ CPU_OP_NAME(_6300), 0, 25344 }, /* Bcc */
{ CPU_OP_NAME(_6301), 0, 25345 }, /* Bcc */
{ CPU_OP_NAME(_63ff), 0, 25599 }, /* Bcc */
{ CPU_OP_NAME(_6400), 0, 25600 }, /* Bcc */
{ CPU_OP_NAME(_6401), 0, 25601 }, /* Bcc */
{ CPU_OP_NAME(_64ff), 0, 25855 }, /* Bcc */
{ CPU_OP_NAME(_6500), 0, 25856 }, /* Bcc */
{ CPU_OP_NAME(_6501), 0, 25857 }, /* Bcc */
{ CPU_OP_NAME(_65ff), 0, 26111 }, /* Bcc */
{ CPU_OP_NAME(_6600), 0, 26112 }, /* Bcc */
{ CPU_OP_NAME(_6601), 0, 26113 }, /* Bcc */
{ CPU_OP_NAME(_66ff), 0, 26367 }, /* Bcc */
{ CPU_OP_NAME(_6700), 0, 26368 }, /* Bcc */
{ CPU_OP_NAME(_6701), 0, 26369 }, /* Bcc */
{ CPU_OP_NAME(_67ff), 0, 26623 }, /* Bcc */
{ CPU_OP_NAME(_6800), 0, 26624 }, /* Bcc */
{ CPU_OP_NAME(_6801), 0, 26625 }, /* Bcc */
{ CPU_OP_NAME(_68ff), 0, 26879 }, /* Bcc */
{ CPU_OP_NAME(_6900), 0, 26880 }, /* Bcc */
{ CPU_OP_NAME(_6901), 0, 26881 }, /* Bcc */
{ CPU_OP_NAME(_69ff), 0, 27135 }, /* Bcc */
{ CPU_OP_NAME(_6a00), 0, 27136 }, /* Bcc */
{ CPU_OP_NAME(_6a01), 0, 27137 }, /* Bcc */
{ CPU_OP_NAME(_6aff), 0, 27391 }, /* Bcc */
{ CPU_OP_NAME(_6b00), 0, 27392 }, /* Bcc */
{ CPU_OP_NAME(_6b01), 0, 27393 }, /* Bcc */
{ CPU_OP_NAME(_6bff), 0, 27647 }, /* Bcc */
{ CPU_OP_NAME(_6c00), 0, 27648 }, /* Bcc */
{ CPU_OP_NAME(_6c01), 0, 27649 }, /* Bcc */
{ CPU_OP_NAME(_6cff), 0, 27903 }, /* Bcc */
{ CPU_OP_NAME(_6d00), 0, 27904 }, /* Bcc */
{ CPU_OP_NAME(_6d01), 0, 27905 }, /* Bcc */
{ CPU_OP_NAME(_6dff), 0, 28159 }, /* Bcc */
{ CPU_OP_NAME(_6e00), 0, 28160 }, /* Bcc */
{ CPU_OP_NAME(_6e01), 0, 28161 }, /* Bcc */
{ CPU_OP_NAME(_6eff), 0, 28415 }, /* Bcc */
{ CPU_OP_NAME(_6f00), 0, 28416 }, /* Bcc */
{ CPU_OP_NAME(_6f01), 0, 28417 }, /* Bcc */
{ CPU_OP_NAME(_6fff), 0, 28671 }, /* Bcc */
{ CPU_OP_NAME(_7000), 0, 28672 }, /* MOVE */
{ CPU_OP_NAME(_8000), 0, 32768 }, /* OR */
{ CPU_OP_NAME(_8010), 0, 32784 }, /* OR */
{ CPU_OP_NAME(_8018), 0, 32792 }, /* OR */
{ CPU_OP_NAME(_8020), 0, 32800 }, /* OR */
{ CPU_OP_NAME(_8028), 0, 32808 }, /* OR */
{ CPU_OP_NAME(_8030), 0, 32816 }, /* OR */
{ CPU_OP_NAME(_8038), 0, 32824 }, /* OR */
{ CPU_OP_NAME(_8039), 0, 32825 }, /* OR */
{ CPU_OP_NAME(_803a), 0, 32826 }, /* OR */
{ CPU_OP_NAME(_803b), 0, 32827 }, /* OR */
{ CPU_OP_NAME(_803c), 0, 32828 }, /* OR */
{ CPU_OP_NAME(_8040), 0, 32832 }, /* OR */
{ CPU_OP_NAME(_8050), 0, 32848 }, /* OR */
{ CPU_OP_NAME(_8058), 0, 32856 }, /* OR */
{ CPU_OP_NAME(_8060), 0, 32864 }, /* OR */
{ CPU_OP_NAME(_8068), 0, 32872 }, /* OR */
{ CPU_OP_NAME(_8070), 0, 32880 }, /* OR */
{ CPU_OP_NAME(_8078), 0, 32888 }, /* OR */
{ CPU_OP_NAME(_8079), 0, 32889 }, /* OR */
{ CPU_OP_NAME(_807a), 0, 32890 }, /* OR */
{ CPU_OP_NAME(_807b), 0, 32891 }, /* OR */
{ CPU_OP_NAME(_807c), 0, 32892 }, /* OR */
{ CPU_OP_NAME(_8080), 0, 32896 }, /* OR */
{ CPU_OP_NAME(_8090), 0, 32912 }, /* OR */
{ CPU_OP_NAME(_8098), 0, 32920 }, /* OR */
{ CPU_OP_NAME(_80a0), 0, 32928 }, /* OR */
{ CPU_OP_NAME(_80a8), 0, 32936 }, /* OR */
{ CPU_OP_NAME(_80b0), 0, 32944 }, /* OR */
{ CPU_OP_NAME(_80b8), 0, 32952 }, /* OR */
{ CPU_OP_NAME(_80b9), 0, 32953 }, /* OR */
{ CPU_OP_NAME(_80ba), 0, 32954 }, /* OR */
{ CPU_OP_NAME(_80bb), 0, 32955 }, /* OR */
{ CPU_OP_NAME(_80bc), 0, 32956 }, /* OR */
{ CPU_OP_NAME(_80c0), 0, 32960 }, /* DIVU */
{ CPU_OP_NAME(_80d0), 0, 32976 }, /* DIVU */
{ CPU_OP_NAME(_80d8), 0, 32984 }, /* DIVU */
{ CPU_OP_NAME(_80e0), 0, 32992 }, /* DIVU */
{ CPU_OP_NAME(_80e8), 0, 33000 }, /* DIVU */
{ CPU_OP_NAME(_80f0), 0, 33008 }, /* DIVU */
{ CPU_OP_NAME(_80f8), 0, 33016 }, /* DIVU */
{ CPU_OP_NAME(_80f9), 0, 33017 }, /* DIVU */
{ CPU_OP_NAME(_80fa), 0, 33018 }, /* DIVU */
{ CPU_OP_NAME(_80fb), 0, 33019 }, /* DIVU */
{ CPU_OP_NAME(_80fc), 0, 33020 }, /* DIVU */
{ CPU_OP_NAME(_8100), 0, 33024 }, /* SBCD */
{ CPU_OP_NAME(_8108), 0, 33032 }, /* SBCD */
{ CPU_OP_NAME(_8110), 0, 33040 }, /* OR */
{ CPU_OP_NAME(_8118), 0, 33048 }, /* OR */
{ CPU_OP_NAME(_8120), 0, 33056 }, /* OR */
{ CPU_OP_NAME(_8128), 0, 33064 }, /* OR */
{ CPU_OP_NAME(_8130), 0, 33072 }, /* OR */
{ CPU_OP_NAME(_8138), 0, 33080 }, /* OR */
{ CPU_OP_NAME(_8139), 0, 33081 }, /* OR */
{ CPU_OP_NAME(_8140), 0, 33088 }, /* PACK */
{ CPU_OP_NAME(_8148), 0, 33096 }, /* PACK */
{ CPU_OP_NAME(_8150), 0, 33104 }, /* OR */
{ CPU_OP_NAME(_8158), 0, 33112 }, /* OR */
{ CPU_OP_NAME(_8160), 0, 33120 }, /* OR */
{ CPU_OP_NAME(_8168), 0, 33128 }, /* OR */
{ CPU_OP_NAME(_8170), 0, 33136 }, /* OR */
{ CPU_OP_NAME(_8178), 0, 33144 }, /* OR */
{ CPU_OP_NAME(_8179), 0, 33145 }, /* OR */
{ CPU_OP_NAME(_8180), 0, 33152 }, /* UNPK */
{ CPU_OP_NAME(_8188), 0, 33160 }, /* UNPK */
{ CPU_OP_NAME(_8190), 0, 33168 }, /* OR */
{ CPU_OP_NAME(_8198), 0, 33176 }, /* OR */
{ CPU_OP_NAME(_81a0), 0, 33184 }, /* OR */
{ CPU_OP_NAME(_81a8), 0, 33192 }, /* OR */
{ CPU_OP_NAME(_81b0), 0, 33200 }, /* OR */
{ CPU_OP_NAME(_81b8), 0, 33208 }, /* OR */
{ CPU_OP_NAME(_81b9), 0, 33209 }, /* OR */
{ CPU_OP_NAME(_81c0), 0, 33216 }, /* DIVS */
{ CPU_OP_NAME(_81d0), 0, 33232 }, /* DIVS */
{ CPU_OP_NAME(_81d8), 0, 33240 }, /* DIVS */
{ CPU_OP_NAME(_81e0), 0, 33248 }, /* DIVS */
{ CPU_OP_NAME(_81e8), 0, 33256 }, /* DIVS */
{ CPU_OP_NAME(_81f0), 0, 33264 }, /* DIVS */
{ CPU_OP_NAME(_81f8), 0, 33272 }, /* DIVS */
{ CPU_OP_NAME(_81f9), 0, 33273 }, /* DIVS */
{ CPU_OP_NAME(_81fa), 0, 33274 }, /* DIVS */
{ CPU_OP_NAME(_81fb), 0, 33275 }, /* DIVS */
{ CPU_OP_NAME(_81fc), 0, 33276 }, /* DIVS */
{ CPU_OP_NAME(_9000), 0, 36864 }, /* SUB */
{ CPU_OP_NAME(_9010), 0, 36880 }, /* SUB */
{ CPU_OP_NAME(_9018), 0, 36888 }, /* SUB */
{ CPU_OP_NAME(_9020), 0, 36896 }, /* SUB */
{ CPU_OP_NAME(_9028), 0, 36904 }, /* SUB */
{ CPU_OP_NAME(_9030), 0, 36912 }, /* SUB */
{ CPU_OP_NAME(_9038), 0, 36920 }, /* SUB */
{ CPU_OP_NAME(_9039), 0, 36921 }, /* SUB */
{ CPU_OP_NAME(_903a), 0, 36922 }, /* SUB */
{ CPU_OP_NAME(_903b), 0, 36923 }, /* SUB */
{ CPU_OP_NAME(_903c), 0, 36924 }, /* SUB */
{ CPU_OP_NAME(_9040), 0, 36928 }, /* SUB */
{ CPU_OP_NAME(_9048), 0, 36936 }, /* SUB */
{ CPU_OP_NAME(_9050), 0, 36944 }, /* SUB */
{ CPU_OP_NAME(_9058), 0, 36952 }, /* SUB */
{ CPU_OP_NAME(_9060), 0, 36960 }, /* SUB */
{ CPU_OP_NAME(_9068), 0, 36968 }, /* SUB */
{ CPU_OP_NAME(_9070), 0, 36976 }, /* SUB */
{ CPU_OP_NAME(_9078), 0, 36984 }, /* SUB */
{ CPU_OP_NAME(_9079), 0, 36985 }, /* SUB */
{ CPU_OP_NAME(_907a), 0, 36986 }, /* SUB */
{ CPU_OP_NAME(_907b), 0, 36987 }, /* SUB */
{ CPU_OP_NAME(_907c), 0, 36988 }, /* SUB */
{ CPU_OP_NAME(_9080), 0, 36992 }, /* SUB */
{ CPU_OP_NAME(_9088), 0, 37000 }, /* SUB */
{ CPU_OP_NAME(_9090), 0, 37008 }, /* SUB */
{ CPU_OP_NAME(_9098), 0, 37016 }, /* SUB */
{ CPU_OP_NAME(_90a0), 0, 37024 }, /* SUB */
{ CPU_OP_NAME(_90a8), 0, 37032 }, /* SUB */
{ CPU_OP_NAME(_90b0), 0, 37040 }, /* SUB */
{ CPU_OP_NAME(_90b8), 0, 37048 }, /* SUB */
{ CPU_OP_NAME(_90b9), 0, 37049 }, /* SUB */
{ CPU_OP_NAME(_90ba), 0, 37050 }, /* SUB */
{ CPU_OP_NAME(_90bb), 0, 37051 }, /* SUB */
{ CPU_OP_NAME(_90bc), 0, 37052 }, /* SUB */
{ CPU_OP_NAME(_90c0), 0, 37056 }, /* SUBA */
{ CPU_OP_NAME(_90c8), 0, 37064 }, /* SUBA */
{ CPU_OP_NAME(_90d0), 0, 37072 }, /* SUBA */
{ CPU_OP_NAME(_90d8), 0, 37080 }, /* SUBA */
{ CPU_OP_NAME(_90e0), 0, 37088 }, /* SUBA */
{ CPU_OP_NAME(_90e8), 0, 37096 }, /* SUBA */
{ CPU_OP_NAME(_90f0), 0, 37104 }, /* SUBA */
{ CPU_OP_NAME(_90f8), 0, 37112 }, /* SUBA */
{ CPU_OP_NAME(_90f9), 0, 37113 }, /* SUBA */
{ CPU_OP_NAME(_90fa), 0, 37114 }, /* SUBA */
{ CPU_OP_NAME(_90fb), 0, 37115 }, /* SUBA */
{ CPU_OP_NAME(_90fc), 0, 37116 }, /* SUBA */
{ CPU_OP_NAME(_9100), 0, 37120 }, /* SUBX */
{ CPU_OP_NAME(_9108), 0, 37128 }, /* SUBX */
{ CPU_OP_NAME(_9110), 0, 37136 }, /* SUB */
{ CPU_OP_NAME(_9118), 0, 37144 }, /* SUB */
{ CPU_OP_NAME(_9120), 0, 37152 }, /* SUB */
{ CPU_OP_NAME(_9128), 0, 37160 }, /* SUB */
{ CPU_OP_NAME(_9130), 0, 37168 }, /* SUB */
{ CPU_OP_NAME(_9138), 0, 37176 }, /* SUB */
{ CPU_OP_NAME(_9139), 0, 37177 }, /* SUB */
{ CPU_OP_NAME(_9140), 0, 37184 }, /* SUBX */
{ CPU_OP_NAME(_9148), 0, 37192 }, /* SUBX */
{ CPU_OP_NAME(_9150), 0, 37200 }, /* SUB */
{ CPU_OP_NAME(_9158), 0, 37208 }, /* SUB */
{ CPU_OP_NAME(_9160), 0, 37216 }, /* SUB */
{ CPU_OP_NAME(_9168), 0, 37224 }, /* SUB */
{ CPU_OP_NAME(_9170), 0, 37232 }, /* SUB */
{ CPU_OP_NAME(_9178), 0, 37240 }, /* SUB */
{ CPU_OP_NAME(_9179), 0, 37241 }, /* SUB */
{ CPU_OP_NAME(_9180), 0, 37248 }, /* SUBX */
{ CPU_OP_NAME(_9188), 0, 37256 }, /* SUBX */
{ CPU_OP_NAME(_9190), 0, 37264 }, /* SUB */
{ CPU_OP_NAME(_9198), 0, 37272 }, /* SUB */
{ CPU_OP_NAME(_91a0), 0, 37280 }, /* SUB */
{ CPU_OP_NAME(_91a8), 0, 37288 }, /* SUB */
{ CPU_OP_NAME(_91b0), 0, 37296 }, /* SUB */
{ CPU_OP_NAME(_91b8), 0, 37304 }, /* SUB */
{ CPU_OP_NAME(_91b9), 0, 37305 }, /* SUB */
{ CPU_OP_NAME(_91c0), 0, 37312 }, /* SUBA */
{ CPU_OP_NAME(_91c8), 0, 37320 }, /* SUBA */
{ CPU_OP_NAME(_91d0), 0, 37328 }, /* SUBA */
{ CPU_OP_NAME(_91d8), 0, 37336 }, /* SUBA */
{ CPU_OP_NAME(_91e0), 0, 37344 }, /* SUBA */
{ CPU_OP_NAME(_91e8), 0, 37352 }, /* SUBA */
{ CPU_OP_NAME(_91f0), 0, 37360 }, /* SUBA */
{ CPU_OP_NAME(_91f8), 0, 37368 }, /* SUBA */
{ CPU_OP_NAME(_91f9), 0, 37369 }, /* SUBA */
{ CPU_OP_NAME(_91fa), 0, 37370 }, /* SUBA */
{ CPU_OP_NAME(_91fb), 0, 37371 }, /* SUBA */
{ CPU_OP_NAME(_91fc), 0, 37372 }, /* SUBA */
{ CPU_OP_NAME(_b000), 0, 45056 }, /* CMP */
{ CPU_OP_NAME(_b010), 0, 45072 }, /* CMP */
{ CPU_OP_NAME(_b018), 0, 45080 }, /* CMP */
{ CPU_OP_NAME(_b020), 0, 45088 }, /* CMP */
{ CPU_OP_NAME(_b028), 0, 45096 }, /* CMP */
{ CPU_OP_NAME(_b030), 0, 45104 }, /* CMP */
{ CPU_OP_NAME(_b038), 0, 45112 }, /* CMP */
{ CPU_OP_NAME(_b039), 0, 45113 }, /* CMP */
{ CPU_OP_NAME(_b03a), 0, 45114 }, /* CMP */
{ CPU_OP_NAME(_b03b), 0, 45115 }, /* CMP */
{ CPU_OP_NAME(_b03c), 0, 45116 }, /* CMP */
{ CPU_OP_NAME(_b040), 0, 45120 }, /* CMP */
{ CPU_OP_NAME(_b048), 0, 45128 }, /* CMP */
{ CPU_OP_NAME(_b050), 0, 45136 }, /* CMP */
{ CPU_OP_NAME(_b058), 0, 45144 }, /* CMP */
{ CPU_OP_NAME(_b060), 0, 45152 }, /* CMP */
{ CPU_OP_NAME(_b068), 0, 45160 }, /* CMP */
{ CPU_OP_NAME(_b070), 0, 45168 }, /* CMP */
{ CPU_OP_NAME(_b078), 0, 45176 }, /* CMP */
{ CPU_OP_NAME(_b079), 0, 45177 }, /* CMP */
{ CPU_OP_NAME(_b07a), 0, 45178 }, /* CMP */
{ CPU_OP_NAME(_b07b), 0, 45179 }, /* CMP */
{ CPU_OP_NAME(_b07c), 0, 45180 }, /* CMP */
{ CPU_OP_NAME(_b080), 0, 45184 }, /* CMP */
{ CPU_OP_NAME(_b088), 0, 45192 }, /* CMP */
{ CPU_OP_NAME(_b090), 0, 45200 }, /* CMP */
{ CPU_OP_NAME(_b098), 0, 45208 }, /* CMP */
{ CPU_OP_NAME(_b0a0), 0, 45216 }, /* CMP */
{ CPU_OP_NAME(_b0a8), 0, 45224 }, /* CMP */
{ CPU_OP_NAME(_b0b0), 0, 45232 }, /* CMP */
{ CPU_OP_NAME(_b0b8), 0, 45240 }, /* CMP */
{ CPU_OP_NAME(_b0b9), 0, 45241 }, /* CMP */
{ CPU_OP_NAME(_b0ba), 0, 45242 }, /* CMP */
{ CPU_OP_NAME(_b0bb), 0, 45243 }, /* CMP */
{ CPU_OP_NAME(_b0bc), 0, 45244 }, /* CMP */
{ CPU_OP_NAME(_b0c0), 0, 45248 }, /* CMPA */
{ CPU_OP_NAME(_b0c8), 0, 45256 }, /* CMPA */
{ CPU_OP_NAME(_b0d0), 0, 45264 }, /* CMPA */
{ CPU_OP_NAME(_b0d8), 0, 45272 }, /* CMPA */
{ CPU_OP_NAME(_b0e0), 0, 45280 }, /* CMPA */
{ CPU_OP_NAME(_b0e8), 0, 45288 }, /* CMPA */
{ CPU_OP_NAME(_b0f0), 0, 45296 }, /* CMPA */
{ CPU_OP_NAME(_b0f8), 0, 45304 }, /* CMPA */
{ CPU_OP_NAME(_b0f9), 0, 45305 }, /* CMPA */
{ CPU_OP_NAME(_b0fa), 0, 45306 }, /* CMPA */
{ CPU_OP_NAME(_b0fb), 0, 45307 }, /* CMPA */
{ CPU_OP_NAME(_b0fc), 0, 45308 }, /* CMPA */
{ CPU_OP_NAME(_b100), 0, 45312 }, /* EOR */
{ CPU_OP_NAME(_b108), 0, 45320 }, /* CMPM */
{ CPU_OP_NAME(_b110), 0, 45328 }, /* EOR */
{ CPU_OP_NAME(_b118), 0, 45336 }, /* EOR */
{ CPU_OP_NAME(_b120), 0, 45344 }, /* EOR */
{ CPU_OP_NAME(_b128), 0, 45352 }, /* EOR */
{ CPU_OP_NAME(_b130), 0, 45360 }, /* EOR */
{ CPU_OP_NAME(_b138), 0, 45368 }, /* EOR */
{ CPU_OP_NAME(_b139), 0, 45369 }, /* EOR */
{ CPU_OP_NAME(_b140), 0, 45376 }, /* EOR */
{ CPU_OP_NAME(_b148), 0, 45384 }, /* CMPM */
{ CPU_OP_NAME(_b150), 0, 45392 }, /* EOR */
{ CPU_OP_NAME(_b158), 0, 45400 }, /* EOR */
{ CPU_OP_NAME(_b160), 0, 45408 }, /* EOR */
{ CPU_OP_NAME(_b168), 0, 45416 }, /* EOR */
{ CPU_OP_NAME(_b170), 0, 45424 }, /* EOR */
{ CPU_OP_NAME(_b178), 0, 45432 }, /* EOR */
{ CPU_OP_NAME(_b179), 0, 45433 }, /* EOR */
{ CPU_OP_NAME(_b180), 0, 45440 }, /* EOR */
{ CPU_OP_NAME(_b188), 0, 45448 }, /* CMPM */
{ CPU_OP_NAME(_b190), 0, 45456 }, /* EOR */
{ CPU_OP_NAME(_b198), 0, 45464 }, /* EOR */
{ CPU_OP_NAME(_b1a0), 0, 45472 }, /* EOR */
{ CPU_OP_NAME(_b1a8), 0, 45480 }, /* EOR */
{ CPU_OP_NAME(_b1b0), 0, 45488 }, /* EOR */
{ CPU_OP_NAME(_b1b8), 0, 45496 }, /* EOR */
{ CPU_OP_NAME(_b1b9), 0, 45497 }, /* EOR */
{ CPU_OP_NAME(_b1c0), 0, 45504 }, /* CMPA */
{ CPU_OP_NAME(_b1c8), 0, 45512 }, /* CMPA */
{ CPU_OP_NAME(_b1d0), 0, 45520 }, /* CMPA */
{ CPU_OP_NAME(_b1d8), 0, 45528 }, /* CMPA */
{ CPU_OP_NAME(_b1e0), 0, 45536 }, /* CMPA */
{ CPU_OP_NAME(_b1e8), 0, 45544 }, /* CMPA */
{ CPU_OP_NAME(_b1f0), 0, 45552 }, /* CMPA */
{ CPU_OP_NAME(_b1f8), 0, 45560 }, /* CMPA */
{ CPU_OP_NAME(_b1f9), 0, 45561 }, /* CMPA */
{ CPU_OP_NAME(_b1fa), 0, 45562 }, /* CMPA */
{ CPU_OP_NAME(_b1fb), 0, 45563 }, /* CMPA */
{ CPU_OP_NAME(_b1fc), 0, 45564 }, /* CMPA */
{ CPU_OP_NAME(_c000), 0, 49152 }, /* AND */
{ CPU_OP_NAME(_c010), 0, 49168 }, /* AND */
{ CPU_OP_NAME(_c018), 0, 49176 }, /* AND */
{ CPU_OP_NAME(_c020), 0, 49184 }, /* AND */
{ CPU_OP_NAME(_c028), 0, 49192 }, /* AND */
{ CPU_OP_NAME(_c030), 0, 49200 }, /* AND */
{ CPU_OP_NAME(_c038), 0, 49208 }, /* AND */
{ CPU_OP_NAME(_c039), 0, 49209 }, /* AND */
{ CPU_OP_NAME(_c03a), 0, 49210 }, /* AND */
{ CPU_OP_NAME(_c03b), 0, 49211 }, /* AND */
{ CPU_OP_NAME(_c03c), 0, 49212 }, /* AND */
{ CPU_OP_NAME(_c040), 0, 49216 }, /* AND */
{ CPU_OP_NAME(_c050), 0, 49232 }, /* AND */
{ CPU_OP_NAME(_c058), 0, 49240 }, /* AND */
{ CPU_OP_NAME(_c060), 0, 49248 }, /* AND */
{ CPU_OP_NAME(_c068), 0, 49256 }, /* AND */
{ CPU_OP_NAME(_c070), 0, 49264 }, /* AND */
{ CPU_OP_NAME(_c078), 0, 49272 }, /* AND */
{ CPU_OP_NAME(_c079), 0, 49273 }, /* AND */
{ CPU_OP_NAME(_c07a), 0, 49274 }, /* AND */
{ CPU_OP_NAME(_c07b), 0, 49275 }, /* AND */
{ CPU_OP_NAME(_c07c), 0, 49276 }, /* AND */
{ CPU_OP_NAME(_c080), 0, 49280 }, /* AND */
{ CPU_OP_NAME(_c090), 0, 49296 }, /* AND */
{ CPU_OP_NAME(_c098), 0, 49304 }, /* AND */
{ CPU_OP_NAME(_c0a0), 0, 49312 }, /* AND */
{ CPU_OP_NAME(_c0a8), 0, 49320 }, /* AND */
{ CPU_OP_NAME(_c0b0), 0, 49328 }, /* AND */
{ CPU_OP_NAME(_c0b8), 0, 49336 }, /* AND */
{ CPU_OP_NAME(_c0b9), 0, 49337 }, /* AND */
{ CPU_OP_NAME(_c0ba), 0, 49338 }, /* AND */
{ CPU_OP_NAME(_c0bb), 0, 49339 }, /* AND */
{ CPU_OP_NAME(_c0bc), 0, 49340 }, /* AND */
{ CPU_OP_NAME(_c0c0), 0, 49344 }, /* MULU */
{ CPU_OP_NAME(_c0d0), 0, 49360 }, /* MULU */
{ CPU_OP_NAME(_c0d8), 0, 49368 }, /* MULU */
{ CPU_OP_NAME(_c0e0), 0, 49376 }, /* MULU */
{ CPU_OP_NAME(_c0e8), 0, 49384 }, /* MULU */
{ CPU_OP_NAME(_c0f0), 0, 49392 }, /* MULU */
{ CPU_OP_NAME(_c0f8), 0, 49400 }, /* MULU */
{ CPU_OP_NAME(_c0f9), 0, 49401 }, /* MULU */
{ CPU_OP_NAME(_c0fa), 0, 49402 }, /* MULU */
{ CPU_OP_NAME(_c0fb), 0, 49403 }, /* MULU */
{ CPU_OP_NAME(_c0fc), 0, 49404 }, /* MULU */
{ CPU_OP_NAME(_c100), 0, 49408 }, /* ABCD */
{ CPU_OP_NAME(_c108), 0, 49416 }, /* ABCD */
{ CPU_OP_NAME(_c110), 0, 49424 }, /* AND */
{ CPU_OP_NAME(_c118), 0, 49432 }, /* AND */
{ CPU_OP_NAME(_c120), 0, 49440 }, /* AND */
{ CPU_OP_NAME(_c128), 0, 49448 }, /* AND */
{ CPU_OP_NAME(_c130), 0, 49456 }, /* AND */
{ CPU_OP_NAME(_c138), 0, 49464 }, /* AND */
{ CPU_OP_NAME(_c139), 0, 49465 }, /* AND */
{ CPU_OP_NAME(_c140), 0, 49472 }, /* EXG */
{ CPU_OP_NAME(_c148), 0, 49480 }, /* EXG */
{ CPU_OP_NAME(_c150), 0, 49488 }, /* AND */
{ CPU_OP_NAME(_c158), 0, 49496 }, /* AND */
{ CPU_OP_NAME(_c160), 0, 49504 }, /* AND */
{ CPU_OP_NAME(_c168), 0, 49512 }, /* AND */
{ CPU_OP_NAME(_c170), 0, 49520 }, /* AND */
{ CPU_OP_NAME(_c178), 0, 49528 }, /* AND */
{ CPU_OP_NAME(_c179), 0, 49529 }, /* AND */
{ CPU_OP_NAME(_c188), 0, 49544 }, /* EXG */
{ CPU_OP_NAME(_c190), 0, 49552 }, /* AND */
{ CPU_OP_NAME(_c198), 0, 49560 }, /* AND */
{ CPU_OP_NAME(_c1a0), 0, 49568 }, /* AND */
{ CPU_OP_NAME(_c1a8), 0, 49576 }, /* AND */
{ CPU_OP_NAME(_c1b0), 0, 49584 }, /* AND */
{ CPU_OP_NAME(_c1b8), 0, 49592 }, /* AND */
{ CPU_OP_NAME(_c1b9), 0, 49593 }, /* AND */
{ CPU_OP_NAME(_c1c0), 0, 49600 }, /* MULS */
{ CPU_OP_NAME(_c1d0), 0, 49616 }, /* MULS */
{ CPU_OP_NAME(_c1d8), 0, 49624 }, /* MULS */
{ CPU_OP_NAME(_c1e0), 0, 49632 }, /* MULS */
{ CPU_OP_NAME(_c1e8), 0, 49640 }, /* MULS */
{ CPU_OP_NAME(_c1f0), 0, 49648 }, /* MULS */
{ CPU_OP_NAME(_c1f8), 0, 49656 }, /* MULS */
{ CPU_OP_NAME(_c1f9), 0, 49657 }, /* MULS */
{ CPU_OP_NAME(_c1fa), 0, 49658 }, /* MULS */
{ CPU_OP_NAME(_c1fb), 0, 49659 }, /* MULS */
{ CPU_OP_NAME(_c1fc), 0, 49660 }, /* MULS */
{ CPU_OP_NAME(_d000), 0, 53248 }, /* ADD */
{ CPU_OP_NAME(_d010), 0, 53264 }, /* ADD */
{ CPU_OP_NAME(_d018), 0, 53272 }, /* ADD */
{ CPU_OP_NAME(_d020), 0, 53280 }, /* ADD */
{ CPU_OP_NAME(_d028), 0, 53288 }, /* ADD */
{ CPU_OP_NAME(_d030), 0, 53296 }, /* ADD */
{ CPU_OP_NAME(_d038), 0, 53304 }, /* ADD */
{ CPU_OP_NAME(_d039), 0, 53305 }, /* ADD */
{ CPU_OP_NAME(_d03a), 0, 53306 }, /* ADD */
{ CPU_OP_NAME(_d03b), 0, 53307 }, /* ADD */
{ CPU_OP_NAME(_d03c), 0, 53308 }, /* ADD */
{ CPU_OP_NAME(_d040), 0, 53312 }, /* ADD */
{ CPU_OP_NAME(_d048), 0, 53320 }, /* ADD */
{ CPU_OP_NAME(_d050), 0, 53328 }, /* ADD */
{ CPU_OP_NAME(_d058), 0, 53336 }, /* ADD */
{ CPU_OP_NAME(_d060), 0, 53344 }, /* ADD */
{ CPU_OP_NAME(_d068), 0, 53352 }, /* ADD */
{ CPU_OP_NAME(_d070), 0, 53360 }, /* ADD */
{ CPU_OP_NAME(_d078), 0, 53368 }, /* ADD */
{ CPU_OP_NAME(_d079), 0, 53369 }, /* ADD */
{ CPU_OP_NAME(_d07a), 0, 53370 }, /* ADD */
{ CPU_OP_NAME(_d07b), 0, 53371 }, /* ADD */
{ CPU_OP_NAME(_d07c), 0, 53372 }, /* ADD */
{ CPU_OP_NAME(_d080), 0, 53376 }, /* ADD */
{ CPU_OP_NAME(_d088), 0, 53384 }, /* ADD */
{ CPU_OP_NAME(_d090), 0, 53392 }, /* ADD */
{ CPU_OP_NAME(_d098), 0, 53400 }, /* ADD */
{ CPU_OP_NAME(_d0a0), 0, 53408 }, /* ADD */
{ CPU_OP_NAME(_d0a8), 0, 53416 }, /* ADD */
{ CPU_OP_NAME(_d0b0), 0, 53424 }, /* ADD */
{ CPU_OP_NAME(_d0b8), 0, 53432 }, /* ADD */
{ CPU_OP_NAME(_d0b9), 0, 53433 }, /* ADD */
{ CPU_OP_NAME(_d0ba), 0, 53434 }, /* ADD */
{ CPU_OP_NAME(_d0bb), 0, 53435 }, /* ADD */
{ CPU_OP_NAME(_d0bc), 0, 53436 }, /* ADD */
{ CPU_OP_NAME(_d0c0), 0, 53440 }, /* ADDA */
{ CPU_OP_NAME(_d0c8), 0, 53448 }, /* ADDA */
{ CPU_OP_NAME(_d0d0), 0, 53456 }, /* ADDA */
{ CPU_OP_NAME(_d0d8), 0, 53464 }, /* ADDA */
{ CPU_OP_NAME(_d0e0), 0, 53472 }, /* ADDA */
{ CPU_OP_NAME(_d0e8), 0, 53480 }, /* ADDA */
{ CPU_OP_NAME(_d0f0), 0, 53488 }, /* ADDA */
{ CPU_OP_NAME(_d0f8), 0, 53496 }, /* ADDA */
{ CPU_OP_NAME(_d0f9), 0, 53497 }, /* ADDA */
{ CPU_OP_NAME(_d0fa), 0, 53498 }, /* ADDA */
{ CPU_OP_NAME(_d0fb), 0, 53499 }, /* ADDA */
{ CPU_OP_NAME(_d0fc), 0, 53500 }, /* ADDA */
{ CPU_OP_NAME(_d100), 0, 53504 }, /* ADDX */
{ CPU_OP_NAME(_d108), 0, 53512 }, /* ADDX */
{ CPU_OP_NAME(_d110), 0, 53520 }, /* ADD */
{ CPU_OP_NAME(_d118), 0, 53528 }, /* ADD */
{ CPU_OP_NAME(_d120), 0, 53536 }, /* ADD */
{ CPU_OP_NAME(_d128), 0, 53544 }, /* ADD */
{ CPU_OP_NAME(_d130), 0, 53552 }, /* ADD */
{ CPU_OP_NAME(_d138), 0, 53560 }, /* ADD */
{ CPU_OP_NAME(_d139), 0, 53561 }, /* ADD */
{ CPU_OP_NAME(_d140), 0, 53568 }, /* ADDX */
{ CPU_OP_NAME(_d148), 0, 53576 }, /* ADDX */
{ CPU_OP_NAME(_d150), 0, 53584 }, /* ADD */
{ CPU_OP_NAME(_d158), 0, 53592 }, /* ADD */
{ CPU_OP_NAME(_d160), 0, 53600 }, /* ADD */
{ CPU_OP_NAME(_d168), 0, 53608 }, /* ADD */
{ CPU_OP_NAME(_d170), 0, 53616 }, /* ADD */
{ CPU_OP_NAME(_d178), 0, 53624 }, /* ADD */
{ CPU_OP_NAME(_d179), 0, 53625 }, /* ADD */
{ CPU_OP_NAME(_d180), 0, 53632 }, /* ADDX */
{ CPU_OP_NAME(_d188), 0, 53640 }, /* ADDX */
{ CPU_OP_NAME(_d190), 0, 53648 }, /* ADD */
{ CPU_OP_NAME(_d198), 0, 53656 }, /* ADD */
{ CPU_OP_NAME(_d1a0), 0, 53664 }, /* ADD */
{ CPU_OP_NAME(_d1a8), 0, 53672 }, /* ADD */
{ CPU_OP_NAME(_d1b0), 0, 53680 }, /* ADD */
{ CPU_OP_NAME(_d1b8), 0, 53688 }, /* ADD */
{ CPU_OP_NAME(_d1b9), 0, 53689 }, /* ADD */
{ CPU_OP_NAME(_d1c0), 0, 53696 }, /* ADDA */
{ CPU_OP_NAME(_d1c8), 0, 53704 }, /* ADDA */
{ CPU_OP_NAME(_d1d0), 0, 53712 }, /* ADDA */
{ CPU_OP_NAME(_d1d8), 0, 53720 }, /* ADDA */
{ CPU_OP_NAME(_d1e0), 0, 53728 }, /* ADDA */
{ CPU_OP_NAME(_d1e8), 0, 53736 }, /* ADDA */
{ CPU_OP_NAME(_d1f0), 0, 53744 }, /* ADDA */
{ CPU_OP_NAME(_d1f8), 0, 53752 }, /* ADDA */
{ CPU_OP_NAME(_d1f9), 0, 53753 }, /* ADDA */
{ CPU_OP_NAME(_d1fa), 0, 53754 }, /* ADDA */
{ CPU_OP_NAME(_d1fb), 0, 53755 }, /* ADDA */
{ CPU_OP_NAME(_d1fc), 0, 53756 }, /* ADDA */
{ CPU_OP_NAME(_e000), 0, 57344 }, /* ASR */
{ CPU_OP_NAME(_e008), 0, 57352 }, /* LSR */
{ CPU_OP_NAME(_e010), 0, 57360 }, /* ROXR */
{ CPU_OP_NAME(_e018), 0, 57368 }, /* ROR */
{ CPU_OP_NAME(_e020), 0, 57376 }, /* ASR */
{ CPU_OP_NAME(_e028), 0, 57384 }, /* LSR */
{ CPU_OP_NAME(_e030), 0, 57392 }, /* ROXR */
{ CPU_OP_NAME(_e038), 0, 57400 }, /* ROR */
{ CPU_OP_NAME(_e040), 0, 57408 }, /* ASR */
{ CPU_OP_NAME(_e048), 0, 57416 }, /* LSR */
{ CPU_OP_NAME(_e050), 0, 57424 }, /* ROXR */
{ CPU_OP_NAME(_e058), 0, 57432 }, /* ROR */
{ CPU_OP_NAME(_e060), 0, 57440 }, /* ASR */
{ CPU_OP_NAME(_e068), 0, 57448 }, /* LSR */
{ CPU_OP_NAME(_e070), 0, 57456 }, /* ROXR */
{ CPU_OP_NAME(_e078), 0, 57464 }, /* ROR */
{ CPU_OP_NAME(_e080), 0, 57472 }, /* ASR */
{ CPU_OP_NAME(_e088), 0, 57480 }, /* LSR */
{ CPU_OP_NAME(_e090), 0, 57488 }, /* ROXR */
{ CPU_OP_NAME(_e098), 0, 57496 }, /* ROR */
{ CPU_OP_NAME(_e0a0), 0, 57504 }, /* ASR */
{ CPU_OP_NAME(_e0a8), 0, 57512 }, /* LSR */
{ CPU_OP_NAME(_e0b0), 0, 57520 }, /* ROXR */
{ CPU_OP_NAME(_e0b8), 0, 57528 }, /* ROR */
{ CPU_OP_NAME(_e0d0), 0, 57552 }, /* ASRW */
{ CPU_OP_NAME(_e0d8), 0, 57560 }, /* ASRW */
{ CPU_OP_NAME(_e0e0), 0, 57568 }, /* ASRW */
{ CPU_OP_NAME(_e0e8), 0, 57576 }, /* ASRW */
{ CPU_OP_NAME(_e0f0), 0, 57584 }, /* ASRW */
{ CPU_OP_NAME(_e0f8), 0, 57592 }, /* ASRW */
{ CPU_OP_NAME(_e0f9), 0, 57593 }, /* ASRW */
{ CPU_OP_NAME(_e100), 0, 57600 }, /* ASL */
{ CPU_OP_NAME(_e108), 0, 57608 }, /* LSL */
{ CPU_OP_NAME(_e110), 0, 57616 }, /* ROXL */
{ CPU_OP_NAME(_e118), 0, 57624 }, /* ROL */
{ CPU_OP_NAME(_e120), 0, 57632 }, /* ASL */
{ CPU_OP_NAME(_e128), 0, 57640 }, /* LSL */
{ CPU_OP_NAME(_e130), 0, 57648 }, /* ROXL */
{ CPU_OP_NAME(_e138), 0, 57656 }, /* ROL */
{ CPU_OP_NAME(_e140), 0, 57664 }, /* ASL */
{ CPU_OP_NAME(_e148), 0, 57672 }, /* LSL */
{ CPU_OP_NAME(_e150), 0, 57680 }, /* ROXL */
{ CPU_OP_NAME(_e158), 0, 57688 }, /* ROL */
{ CPU_OP_NAME(_e160), 0, 57696 }, /* ASL */
{ CPU_OP_NAME(_e168), 0, 57704 }, /* LSL */
{ CPU_OP_NAME(_e170), 0, 57712 }, /* ROXL */
{ CPU_OP_NAME(_e178), 0, 57720 }, /* ROL */
{ CPU_OP_NAME(_e180), 0, 57728 }, /* ASL */
{ CPU_OP_NAME(_e188), 0, 57736 }, /* LSL */
{ CPU_OP_NAME(_e190), 0, 57744 }, /* ROXL */
{ CPU_OP_NAME(_e198), 0, 57752 }, /* ROL */
{ CPU_OP_NAME(_e1a0), 0, 57760 }, /* ASL */
{ CPU_OP_NAME(_e1a8), 0, 57768 }, /* LSL */
{ CPU_OP_NAME(_e1b0), 0, 57776 }, /* ROXL */
{ CPU_OP_NAME(_e1b8), 0, 57784 }, /* ROL */
{ CPU_OP_NAME(_e1d0), 0, 57808 }, /* ASLW */
{ CPU_OP_NAME(_e1d8), 0, 57816 }, /* ASLW */
{ CPU_OP_NAME(_e1e0), 0, 57824 }, /* ASLW */
{ CPU_OP_NAME(_e1e8), 0, 57832 }, /* ASLW */
{ CPU_OP_NAME(_e1f0), 0, 57840 }, /* ASLW */
{ CPU_OP_NAME(_e1f8), 0, 57848 }, /* ASLW */
{ CPU_OP_NAME(_e1f9), 0, 57849 }, /* ASLW */
{ CPU_OP_NAME(_e2d0), 0, 58064 }, /* LSRW */
{ CPU_OP_NAME(_e2d8), 0, 58072 }, /* LSRW */
{ CPU_OP_NAME(_e2e0), 0, 58080 }, /* LSRW */
{ CPU_OP_NAME(_e2e8), 0, 58088 }, /* LSRW */
{ CPU_OP_NAME(_e2f0), 0, 58096 }, /* LSRW */
{ CPU_OP_NAME(_e2f8), 0, 58104 }, /* LSRW */
{ CPU_OP_NAME(_e2f9), 0, 58105 }, /* LSRW */
{ CPU_OP_NAME(_e3d0), 0, 58320 }, /* LSLW */
{ CPU_OP_NAME(_e3d8), 0, 58328 }, /* LSLW */
{ CPU_OP_NAME(_e3e0), 0, 58336 }, /* LSLW */
{ CPU_OP_NAME(_e3e8), 0, 58344 }, /* LSLW */
{ CPU_OP_NAME(_e3f0), 0, 58352 }, /* LSLW */
{ CPU_OP_NAME(_e3f8), 0, 58360 }, /* LSLW */
{ CPU_OP_NAME(_e3f9), 0, 58361 }, /* LSLW */
{ CPU_OP_NAME(_e4d0), 0, 58576 }, /* ROXRW */
{ CPU_OP_NAME(_e4d8), 0, 58584 }, /* ROXRW */
{ CPU_OP_NAME(_e4e0), 0, 58592 }, /* ROXRW */
{ CPU_OP_NAME(_e4e8), 0, 58600 }, /* ROXRW */
{ CPU_OP_NAME(_e4f0), 0, 58608 }, /* ROXRW */
{ CPU_OP_NAME(_e4f8), 0, 58616 }, /* ROXRW */
{ CPU_OP_NAME(_e4f9), 0, 58617 }, /* ROXRW */
{ CPU_OP_NAME(_e5d0), 0, 58832 }, /* ROXLW */
{ CPU_OP_NAME(_e5d8), 0, 58840 }, /* ROXLW */
{ CPU_OP_NAME(_e5e0), 0, 58848 }, /* ROXLW */
{ CPU_OP_NAME(_e5e8), 0, 58856 }, /* ROXLW */
{ CPU_OP_NAME(_e5f0), 0, 58864 }, /* ROXLW */
{ CPU_OP_NAME(_e5f8), 0, 58872 }, /* ROXLW */
{ CPU_OP_NAME(_e5f9), 0, 58873 }, /* ROXLW */
{ CPU_OP_NAME(_e6d0), 0, 59088 }, /* RORW */
{ CPU_OP_NAME(_e6d8), 0, 59096 }, /* RORW */
{ CPU_OP_NAME(_e6e0), 0, 59104 }, /* RORW */
{ CPU_OP_NAME(_e6e8), 0, 59112 }, /* RORW */
{ CPU_OP_NAME(_e6f0), 0, 59120 }, /* RORW */
{ CPU_OP_NAME(_e6f8), 0, 59128 }, /* RORW */
{ CPU_OP_NAME(_e6f9), 0, 59129 }, /* RORW */
{ CPU_OP_NAME(_e7d0), 0, 59344 }, /* ROLW */
{ CPU_OP_NAME(_e7d8), 0, 59352 }, /* ROLW */
{ CPU_OP_NAME(_e7e0), 0, 59360 }, /* ROLW */
{ CPU_OP_NAME(_e7e8), 0, 59368 }, /* ROLW */
{ CPU_OP_NAME(_e7f0), 0, 59376 }, /* ROLW */
{ CPU_OP_NAME(_e7f8), 0, 59384 }, /* ROLW */
{ CPU_OP_NAME(_e7f9), 0, 59385 }, /* ROLW */
{ CPU_OP_NAME(_e8c0), 0, 59584 }, /* BFTST */
{ CPU_OP_NAME(_e8d0), 0, 59600 }, /* BFTST */
{ CPU_OP_NAME(_e8e8), 0, 59624 }, /* BFTST */
{ CPU_OP_NAME(_e8f0), 0, 59632 }, /* BFTST */
{ CPU_OP_NAME(_e8f8), 0, 59640 }, /* BFTST */
{ CPU_OP_NAME(_e8f9), 0, 59641 }, /* BFTST */
{ CPU_OP_NAME(_e8fa), 0, 59642 }, /* BFTST */
{ CPU_OP_NAME(_e8fb), 0, 59643 }, /* BFTST */
{ CPU_OP_NAME(_e9c0), 0, 59840 }, /* BFEXTU */
{ CPU_OP_NAME(_e9d0), 0, 59856 }, /* BFEXTU */
{ CPU_OP_NAME(_e9e8), 0, 59880 }, /* BFEXTU */
{ CPU_OP_NAME(_e9f0), 0, 59888 }, /* BFEXTU */
{ CPU_OP_NAME(_e9f8), 0, 59896 }, /* BFEXTU */
{ CPU_OP_NAME(_e9f9), 0, 59897 }, /* BFEXTU */
{ CPU_OP_NAME(_e9fa), 0, 59898 }, /* BFEXTU */
{ CPU_OP_NAME(_e9fb), 0, 59899 }, /* BFEXTU */
{ CPU_OP_NAME(_eac0), 0, 60096 }, /* BFCHG */
{ CPU_OP_NAME(_ead0), 0, 60112 }, /* BFCHG */
{ CPU_OP_NAME(_eae8), 0, 60136 }, /* BFCHG */
{ CPU_OP_NAME(_eaf0), 0, 60144 }, /* BFCHG */
{ CPU_OP_NAME(_eaf8), 0, 60152 }, /* BFCHG */
{ CPU_OP_NAME(_eaf9), 0, 60153 }, /* BFCHG */
{ CPU_OP_NAME(_ebc0), 0, 60352 }, /* BFEXTS */
{ CPU_OP_NAME(_ebd0), 0, 60368 }, /* BFEXTS */
{ CPU_OP_NAME(_ebe8), 0, 60392 }, /* BFEXTS */
{ CPU_OP_NAME(_ebf0), 0, 60400 }, /* BFEXTS */
{ CPU_OP_NAME(_ebf8), 0, 60408 }, /* BFEXTS */
{ CPU_OP_NAME(_ebf9), 0, 60409 }, /* BFEXTS */
{ CPU_OP_NAME(_ebfa), 0, 60410 }, /* BFEXTS */
{ CPU_OP_NAME(_ebfb), 0, 60411 }, /* BFEXTS */
{ CPU_OP_NAME(_ecc0), 0, 60608 }, /* BFCLR */
{ CPU_OP_NAME(_ecd0), 0, 60624 }, /* BFCLR */
{ CPU_OP_NAME(_ece8), 0, 60648 }, /* BFCLR */
{ CPU_OP_NAME(_ecf0), 0, 60656 }, /* BFCLR */
{ CPU_OP_NAME(_ecf8), 0, 60664 }, /* BFCLR */
{ CPU_OP_NAME(_ecf9), 0, 60665 }, /* BFCLR */
{ CPU_OP_NAME(_edc0), 0, 60864 }, /* BFFFO */
{ CPU_OP_NAME(_edd0), 0, 60880 }, /* BFFFO */
{ CPU_OP_NAME(_ede8), 0, 60904 }, /* BFFFO */
{ CPU_OP_NAME(_edf0), 0, 60912 }, /* BFFFO */
{ CPU_OP_NAME(_edf8), 0, 60920 }, /* BFFFO */
{ CPU_OP_NAME(_edf9), 0, 60921 }, /* BFFFO */
{ CPU_OP_NAME(_edfa), 0, 60922 }, /* BFFFO */
{ CPU_OP_NAME(_edfb), 0, 60923 }, /* BFFFO */
{ CPU_OP_NAME(_eec0), 0, 61120 }, /* BFSET */
{ CPU_OP_NAME(_eed0), 0, 61136 }, /* BFSET */
{ CPU_OP_NAME(_eee8), 0, 61160 }, /* BFSET */
{ CPU_OP_NAME(_eef0), 0, 61168 }, /* BFSET */
{ CPU_OP_NAME(_eef8), 0, 61176 }, /* BFSET */
{ CPU_OP_NAME(_eef9), 0, 61177 }, /* BFSET */
{ CPU_OP_NAME(_efc0), 0, 61376 }, /* BFINS */
{ CPU_OP_NAME(_efd0), 0, 61392 }, /* BFINS */
{ CPU_OP_NAME(_efe8), 0, 61416 }, /* BFINS */
{ CPU_OP_NAME(_eff0), 0, 61424 }, /* BFINS */
{ CPU_OP_NAME(_eff8), 0, 61432 }, /* BFINS */
{ CPU_OP_NAME(_eff9), 0, 61433 }, /* BFINS */
{ 0, 0, 0 }};
