#include "water.h"


Water::Water(int w, int h) {
	Create(w,h);

	for (int c=-256; c<256; c++) {
		double d = c/4.0;
		dispLut[c+256] = (unsigned short)((int)(tan(asin(sin(atan(d))/2.0))*d));
	}
}


Water::~Water() {
	Destroy();
	if (prev) {
		delete [] prev;
		delete [] curr;
		prev = NULL;
		curr = NULL;
	}
}


void Water::Create(int w, int h) {
	Destroy();
	this->w = w>>Params::zoom;
	this->h = h>>Params::zoom;
	bSize = (w*h)>>(2*Params::zoom);
	prev = new int[bSize];
	curr = new int[bSize];
	memset(prev, 0, sizeof(int)*bSize);
	memset(curr, 0, sizeof(int)*bSize);
}


void Water::Destroy() {
	if (prev) {
		delete [] prev;
		delete [] curr;
		prev = NULL;
		curr = NULL;
	}
}


void Water::Drop(int x, int y, int size) {
	int index = (y>>Params::zoom)*w + (x>>Params::zoom);
	index = index < (w + 1) ? (w + 1) : (index >= (bSize - w - 1) ? (bSize - w - 2) : index);

	prev[index] = size;

	size >>= 1;
	prev[index - 1] = size;
	prev[index +1] = size;
	prev[index - w] = size;
	prev[index + w] = size;
	
	size >>= 2;
	prev[index - w - 1] = size;
	prev[index - w +1] = size;
	prev[index + w - 1] = size;
	prev[index + w + 1] = size;
}


void Water::Process() {
	int i = w + 1;
	int j = bSize - w - 2;
	
	for (; i < j; ++i) {
		curr[i] = ((prev[i-1] + prev[i+1] + prev[i - w] + prev[i + w])>>2) + ((prev[i - w - 1] + prev[i - w + 1] + prev[i + w - 1] + prev[i + w + 1])>>3) - curr[i];
		curr[i] -= (curr[i]>>(8-Params::damping));
	}

	// swap the buffers
	int d = curr - prev;
	prev += d;
	curr -= d;
}


void Water::Draw(BITMAP *buffer) {
	int ww = w<<Params::zoom;
	int hh = h<<Params::zoom;
	int xx, yy;
	for (int y=2; y<hh-2; ++y) {
		yy = y>>Params::zoom;
		for (int x=0; x<ww; ++x) {
			xx = x>>Params::zoom;

			int xDiff = curr[yy*w + xx + 1] - curr[yy*w + xx];
			int yDiff = curr[(yy+1)*w + xx] - curr[yy*w + xx];
			xDiff = MID(-256, xDiff, 255);
			yDiff = MID(-256, yDiff, 255);
			int xDisplace = dispLut[xDiff+256];
			int yDisplace = dispLut[yDiff+256];

			xDisplace >>= Params::smoothing;
			yDisplace >>= Params::smoothing;
			
			if (xDisplace == 0 || yDisplace == 0) {
				continue;
			}

			int nx, ny;
			if (xDiff < 0) {
				if (yDiff < 0) {
					nx = x-xDisplace;
					ny = y-yDisplace;
				}
				else {
					nx = x-xDisplace;
					ny = y+yDisplace;
				}
			}
			else {
				if (yDiff < 0) {
					nx = x+xDisplace;
					ny = y-yDisplace;
				}
				else {
					nx = x+xDisplace;
					ny = y+yDisplace;
				}
			}

			if (nx >= 0 && nx < buffer->w && ny >= 0 && ny < buffer->h) {
				//int t = getpixel(buffer, nx, ny);
				int t = ((short *)buffer->line[ny])[nx];
				//putpixel(buffer, x, y, makecol(MID(0, getr(t) + xDisplace, 255), MID(0, getg(t) + xDisplace, 255), MID(0, getb(t) + xDisplace, 255)));
				//putpixel(buffer, x, y, makecol(MID(0, getr16(t) + xDisplace, 255), MID(0, getg16(t) + xDisplace, 255), MID(0, getb16(t) + xDisplace, 255)));
				//putpixel(buffer, x, y, t);
				//((short *)buffer->line[y])[x] = makecol(MID(0, getr(t) + xDisplace, 255), MID(0, getg(t) + xDisplace, 255), MID(0, getb(t) + xDisplace, 255));
				((short *)buffer->line[y])[x] = makecol(MID(0, getr16(t) + xDisplace, 255), MID(0, getg16(t) + xDisplace, 255), MID(0, getb16(t) + xDisplace, 255));
				//((short *)buffer->line[y])[x] = t;
			}
		}
	}
}
