#include "MainDlg.h"
#include "params.h"


MainDialog::MainDialog() : Dialog() {
	Params::Load();
		
	Add(desktop);
	
	pan.Shape(10, 10, 620, 460);
	Add(pan);
	
	lTitle.Shape(40, 20, 540, 50);
	Add(lTitle);
	
	grpRipples.Shape(20, 260, 260, 200);
	grpRipples.SetTitle("Ripples settings");
	Add(grpRipples);
	
	lSize.Setup(10, 30, 240, 16, 0, 0, "Average ripple size", 0);
	sSize.Setup(10, 50, 180, 24, 0, 0, 64, 2048, Params::rippleSize, 1);
	eSize.Setup(196, 50, 54, 24, 0, D_DISABLED, NULL, 16);
	eSize.SetNumber(Params::rippleSize);
	lDamping.Setup(10, 86, 240, 16, 0, 0, "Damping", 0);
	sDamping.Setup(10, 106, 180, 24, 0, 0, 0, 8, Params::damping, 1);
	eDamping.Setup(196, 106, 54, 24, 0, D_DISABLED, NULL, 16);
	eDamping.SetNumber(Params::damping);
	lSmoothing.Setup(10, 142, 240, 16, 0, 0, "Smoothing", 0);
	sSmoothing.Setup(10, 162, 180, 24, 0, 0, 0, 4, Params::smoothing, 1);
	eSmoothing.Setup(196, 162, 54, 24, 0, D_DISABLED, NULL, 16);
	eSmoothing.SetNumber(Params::smoothing);
	
	grpRipples.Add(lSize);
	grpRipples.Add(sSize);
	grpRipples.Add(eSize);
	grpRipples.Add(lDamping);
	grpRipples.Add(sDamping);
	grpRipples.Add(eDamping);
	grpRipples.Add(lSmoothing);
	grpRipples.Add(sSmoothing);
	grpRipples.Add(eSmoothing);
	
	grpSettings.Shape(20, 70, 260, 180);
	grpSettings.SetTitle("Simulation settings");
	Add(grpSettings);

	lRainIntesity.Setup(10, 30, 240, 16, 0, 0, "Rain intensity", 0);
	sRainIntensity.Setup(10, 50, 180, 24, 0, 0, 0, 40, (int)(Params::drops*20), 1);
	eRainIntensity.Setup(196, 50, 54, 24, 0, D_DISABLED, NULL, 16);
	eRainIntensity.SetNumber(Params::drops);
	lSpeed.Setup(10, 86, 240, 16, 0, 0, "Simulation speed");
	sSpeed.Setup(10, 106, 180, 24, 0, 0, 5, 100, Params::fps, 1);
	eSpeed.Setup(196, 106, 54, 24, 0, D_DISABLED, NULL, 16);
	eSpeed.SetNumber(Params::fps);
	lZoom.Setup(10, 154, 100, 16, 0, 0, "Zoom factor");
	cmbZoom.list.InsertItem(new ListItemString("0 (far)"), 0);
	cmbZoom.list.InsertItem(new ListItemString("1 (close)"), 1);
	//cmbZoom.list.InsertItem(new ListItemString("2 (close)"), 2);
	cmbZoom.Setup(110, 146, 140, 24, 0, 0, Params::zoom);
	
	grpSettings.Add(lRainIntesity);
	grpSettings.Add(sRainIntensity);
	grpSettings.Add(eRainIntensity);
	grpSettings.Add(lZoom);
	grpSettings.Add(cmbZoom);
	grpSettings.Add(lSpeed);
	grpSettings.Add(eSpeed);
	grpSettings.Add(sSpeed);

	panPool.Shape(288, 76, 328, 208);
	Add(panPool);
	
	pool.Shape(292, 80, 320, 200);
	pool.SetBackground(Params::back);
	Add(pool);
	
	grpBackground.Shape(290, 290, 320, 130);
	grpBackground.SetTitle("Background texture");
	Add(grpBackground);
	
	ckBackgroundFile.Setup(10, 30, 300, 22, 0, 0, "Use background texture");
	lBackgroundFile.Setup(10, 68, 300, 22, 0, 0, "Backgorund texture file", 0);
	eBackgroundFile.Setup(10, 88, 220, 24, 0, 0, Params::back);
	bOpenFile.Setup(240, 88, 70, 24, 0, 0, "Select");
	
	if (ustricmp(Params::back, empty_string) != 0) {
		ckBackgroundFile.Select();
	}
	else {
		eBackgroundFile.Disable();
		bOpenFile.Disable();
	}
	
	grpBackground.Add(ckBackgroundFile);
	grpBackground.Add(lBackgroundFile);
	grpBackground.Add(eBackgroundFile);
	grpBackground.Add(bOpenFile);
	
	lFPS.Shape(590, 16, 32, 16);
	lFPS.AlignRight();
	Add(lFPS);
	
	bExit.Setup(290, 430, 320, 24, KEY_Q, D_EXIT, "&Quit");
	Add(bExit);
}


MainDialog::~MainDialog() {
	if (eBackgroundFile.GetText()) {
		ustrcpy(Params::back, eBackgroundFile.GetText());
	}
	Params::Save();
}


void MainDialog::MsgInitSkin() {
	Dialog::MsgInitSkin();
	
	lFPS.SetTextMode(skin->c_face);
	
	skin->LoadFont("ariali.ttf", Skin::nFonts, 36);
	lTitle.SetFont(Skin::nFonts, Skin::NORMAL);
	lTitle.SetFontColor(Color::red, Color::maroon, Skin::NORMAL);
	lTitle.SetText("Miran Amon's Rain Drop Simulation");
}


void MainDialog::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);
	
	switch (msg) {
		case MSG_SCROLL:
			if (obj == sRainIntensity) {
				Params::drops = (float)arg1 / 20.0f;
				eRainIntensity.SetNumber(Params::drops);
			}
			else if (obj == sSpeed) {
				Params::fps = arg1;
				eSpeed.SetNumber(arg1);
				pool.ChangeSpeed();
			}
			else if (obj == sSize) {
				Params::rippleSize = arg1;
				eSize.SetNumber(arg1);
			}
			else if (obj == sDamping) {
				Params::damping = arg1;
				eDamping.SetNumber(arg1);
			}
			else if (obj == sSmoothing) {
				Params::smoothing = arg1;
				eSmoothing.SetNumber(arg1);
			}
			break;
		
		case MSG_ACTIVATE:
			if (obj == cmbZoom) {
				Params::zoom = cmbZoom.list.Selection();
				pool.RecreateWater();
			}
			else if (obj == ckBackgroundFile) {
				if (ckBackgroundFile.Selected()) {
					if (eBackgroundFile.GetText()) {
						ustrcpy(Params::back, eBackgroundFile.GetText());
						pool.SetBackground(eBackgroundFile.GetText());
					}
					eBackgroundFile.Enable();
					bOpenFile.Enable();
				}
				else {
					ustrcpy(Params::back, empty_string);
					pool.SetBackground(NULL);
					eBackgroundFile.Disable();
					bOpenFile.Disable();
				}
			}
			else if (obj == bOpenFile) {
				FileSelect dlg("Select image...", NULL, "Bitmaps (*.bmp;*.pcx;*.tga)|BMP files (*.bmp)|PCX files (*.pcx)|TGA Files (*.tga)|All files (*.*)", FA_ARCH);
				char *tmp = dlg.Popup(this);
				if (tmp) {
					eBackgroundFile.SetText(tmp);
					ustrcpy(Params::back, tmp);
					pool.SetBackground(tmp);
				}
			}
			break;
	};
}

