#include "pool.h"

Pool::Pool() : Widget(), water(NULL), nDrops(0.0f), timerID(-1) {
}


Pool::~Pool() {
	back.Destroy();
	
	if (water) {
		delete water;
	}
	
	if (timerID >= 0) {
		Timer::Kill(timerID);
	}
}


void Pool::SetBackground(const char *fileName) {
	if (!fileName || ustricmp(fileName, empty_string) == 0) {
		back.Destroy();
		return;
	}
	
	Bitmap bmp;
	bmp.Load(fileName);
	
	if (bmp) {
		if (!back) {
			back.Create(w(), h());
		}
		
		bmp.StretchBlit(back, 0, 0, bmp.w(), bmp.h(), 0, 0, w(), h());
	}
}


void Pool::MsgStart() {
	Widget::MsgStart();
	water = new Water(w(), h());
	nDrops = 0.0f;
	timerID = Timer::InstallEx(Params::fps);
}


void Pool::RecreateWater() {
	water->Create(w(), h());
}


void Pool::ChangeSpeed() {
	Timer::AdjustEx(timerID, Params::fps);
}


void Pool::MsgEnd() {
	Widget::MsgEnd();
	
	Timer::Kill(timerID);
	timerID = -1;
	
	if (water) {
		delete water;
		water = NULL;
	}
}


void Pool::MsgTimer(int id) {
	Widget::MsgTimer(id);
	
	if (id != timerID) return;

	if (mouse_b && HasMouse()) {
		Point mp = GetMousePos();
		water->Drop(mp.x(), mp.y(), -Params::rippleSize);
	}

	nDrops += Params::drops;
	int iDrops = (int)nDrops;
	
	if (iDrops > 0) {
		for (int i=0; i<iDrops; ++i) {
			water->Drop(rand()%w(), rand()%h(), Params::rippleSize + rand()%Params::rippleSize - Params::rippleSize/2);
		}
		
		nDrops = 0.0f;
	}
	
	water->Process();
}


void Pool::MsgIdle() {
	Widget::MsgIdle();
	if (Settings::unlimitedFrameRate) {
		Redraw();
	}
}


void Pool::Draw(Bitmap &canvas) {
	if (back) {
		back.Blit(canvas, 0, 0, 0, 0, w(), h());
	}
	else {
		canvas.Clear(Color(127,180,232));
	}
	water->Draw(canvas);
}
