#include "params.h"

int Params::rippleSize = 1024;
int Params::damping = 5;
int Params::smoothing = 4;
float Params::drops = 0.25f;
int Params::zoom = 0;
int Params::fps = 25;
char Params::back[512];


void Params::Load() {
	set_config_file("rain.cfg");
	rippleSize = get_config_int("RIPPLES", "size", rippleSize);
	damping = get_config_int("RIPPLES", "damping", damping);
	smoothing = get_config_int("RIPPLES", "smoothing", smoothing);
	drops = get_config_float("MISC", "drops", drops);
	zoom = get_config_int("MISC", "zoom", zoom);
	fps = get_config_int("MISC", "fps", fps);
	ustrcpy(back, get_config_string("MISC", "background", empty_string));
}


void Params::Save() {
	set_config_file("rain.cfg");
	set_config_int("RIPPLES", "size", rippleSize);
	set_config_int("RIPPLES", "damping", damping);
	set_config_int("RIPPLES", "smoothing", smoothing);
	set_config_float("MISC", "drops", drops);
	set_config_int("MISC", "zoom", zoom);
	set_config_int("MISC", "fps", fps);
	set_config_string("MISC", "background", back);
	
	flush_config_file();
}
