//Defines////////////////////////
#define SPRITE_DEAD      0
#define SPRITE_ACTIVE    1
#define SPRITE_WAITING   2

#define MAX_TILES        266
#define MAX_SPRITE_FRAMES 8
#define TILE_ANIMSPEED   15
 //Structs/////////////////////////
 //Sprite Stuff....
 typedef struct SPRITES_STRUCT
 {
  BITMAP *image[MAX_SPRITE_FRAMES];
  int init;    //If already Allocated
  int sprites_used; //How many Sprites to grab
 }SPRITES;

 typedef struct SPRITE_STRUCT
  {
   BITMAP *backround; //This will boost the fps, by uh 20 i think.
   SPRITES *image; //New SPRITES
   int x;
   int y;
   int oldx;
   int oldy;
   int width;
   int height;
   int state;
   int cur_frame;
   int num_frame;
   int delay_frame;
   int frame_tick;
   float vx;
   float vy;
   float vangle;
   float vlength;
   int sprite_state;
  }SPRITE,*SPRITE_ptr;


 //Tile Struct
 typedef struct TILE_STRUCT
  {
   BITMAP *image;
   int width;
   int height;
   int anim[5];    //Points to the next tile to animate...
   int anim_speed;
   int anim_clock;
   int anim_tick;
   int anim_on;
   int anim_type;    //Does Tile Rotate?
   int collide_type; //Collision Detection
  } TILE,*TILE_ptr;
 // TileSet Struct
 typedef struct TILE_SET_STRUCT
  {
   TILE tiles[MAX_TILES];
   int num_tiles;       //The actual number of tiles used
   int width;           //It's Universal
   int height;
  }TILE_SET,*TILE_SET_ptr;

//Sprite Timer Stuff
extern volatile long sprite_counter; //The Speed Counter
extern long sprite_countera;
void increment_sprite_counter();
int install_sprite_counter(void);
void update_sprite_counter(void);
//Function List

//Sprite Functions
int sprite_collide(SPRITE *sprite1,SPRITE *sprite2);
void sprite_display(BITMAP *display,SPRITE *sprite);
void sprite_grab(SPRITE *sprite,char filename[40],int x,int y);
void sprite_init(SPRITE *sprite,SPRITES *image,int x, int y, int width, int height, int num_frame, int delay_frame);
void sprite_free(SPRITE *sprite);
void sprite_calc_arcvectors(SPRITE *sprite);//Math Functions
void sprite_calc_vectors(SPRITE *sprite);
//Tile Functions
void tile_display(BITMAP *display,TILE *tile, int x, int y);
void tileset_init(TILE_SET *tile_set,int width,int height,int num);
void tileset_load(TILE_SET *tile_set,char filename[40], int x, int y);
void tile_grab(BITMAP *source,TILE *tile,int x,int y);
void tileset_free(TILE_SET *tile_set);
