#include <math.h>
#include "allegro.h"
#include "sprite.h"
#include "input.h"
#include "pmain.h"
//#define PI 3.14
long sprite_countera = 0;
volatile long sprite_counter = 0;    //Makes Game Run at set Speed
//Functions////////////////////////
//Timer////////////////////////////
void increment_sprite_counter()
{
sprite_counter++;//Increments Speed Counter By One
}
END_OF_FUNCTION(increment_sprite_counter); //Tell Allegro at end of function


int install_sprite_counter(void)
{
LOCK_VARIABLE(sprite_counter);
LOCK_FUNCTION(increment_sprite_counter);
if(install_int_ex(increment_sprite_counter,BPS_TO_TIMER(GAME_FPS_SPEED)))
 return 1;
return 0;
}
void update_sprite_counter(void)
{
 if(sprite_counter >sprite_countera)
 {
 sprite_countera = sprite_counter+1;  //We Reset The On and Off flags
 if(sprite_countera>60)
  {
  sprite_counter=0;
  sprite_countera=0;
  }
 
 }

}

//All The Sprite Routines, in their own seperate Module

//Calculate a collison, returns 1 if a collision was found
int sprite_collide(SPRITE *sprite1,SPRITE *sprite2)
{
if((sprite1->x+sprite1->width) <sprite2->x || (sprite2->x +sprite2->width) < sprite1->x || (sprite1->y+sprite1->height) < sprite2->y || (sprite2->y+sprite2->height) <sprite1->y)
 return 0;
else
 return 1;
}

//Saves my from having a LONG sprite drawing call
//Use this as opposed to draw_sprite
/*void sprite_display(BITMAP *display,SPRITE *sprite)
{
draw_sprite(display, sprite->image->image[sprite->cur_frame], sprite->x, sprite->y);
}*/
//New Sprite Display Routine
void sprite_display(BITMAP *display,SPRITE *sprite)
{
//Okay, this allows the sprite to animate, if applicable, problem
//is is it does not check if sprite is drawn twice
if(sprite_countera != sprite->delay_frame)
 {
 sprite->delay_frame = sprite_countera;
 sprite->frame_tick++;
//Will modify soon so is custom to each sprite
if(sprite->frame_tick > 10)
 {
 sprite->cur_frame++;
  if(sprite->cur_frame > sprite->num_frame -1)
   sprite->cur_frame = 0;
  sprite->frame_tick = 0;
  }
 }
draw_sprite(display, sprite->image->image[sprite->cur_frame], sprite->x, sprite->y);
}


/*
//Grabs a sprite from a gridded set.
//Old version, will keep for reference, grabbed by telling how many rows
//and how long they are, and checking to see was not gone too far
void sprite_grab(SPRITE *sprite, char filename[40], int x, int y)
{
BITMAP *temp_bitmap;
int index;
int index2;
//Loads First Tileset
temp_bitmap = load_bitmap(filename,game_pal);
//Grab the Tiles
for(index=0;index<x;index++)
 {
 for(index2=0;index2<y;index2++)
 {
 if(sprite->num_frame > ((index2*x)+index))
  {
   sprite->image[((index2*x)+index)] = create_bitmap(sprite->width,sprite->height);
   blit(temp_bitmap,sprite->image[((index2*x)+index)],((index*sprite->width)+index+1),((index2*sprite->height)+index2+1),0,0,sprite->width,sprite->height);
//                            blit(source,tile->image,((x*tile->width)+x+1),((y*tile->height)+y+1),0,0,tile->width,tile->height);
  }
 }
 }
destroy_bitmap(temp_bitmap);
}
*/
//New Sprite_grab, you now pass x and y co-ordinated to start grabbing from
//and the code will automatically move to the next line after 10 sprites grabbed
void sprite_free(SPRITE *sprite)
{
//Backward compatibility
SPRITES *image;
int index;
image = sprite->image;
//Wow, i practicly rip old code, and it works fine :)
if(!image->init)
{
 image->init = 0;
 for(index=0;image->sprites_used >index;index++)
   destroy_bitmap(image->image[index]);
  // image->image[index] = create_bitmap(sprite->width,sprite->height);
}
if(sprite->backround)
  destroy_bitmap(sprite->backround);
}

void sprite_grab(SPRITE *sprite,char filename[40], int x, int y)
{
BITMAP *temp_bitmap;
//These Look much neater and easier to understand.
int sprite_on = 0;
int sprite_row = 0;
int sprite_column = 0;
//Loads First Tileset
temp_bitmap = load_bitmap(filename,NULL);
//Grab the Tiles
while(sprite->num_frame > sprite_on)
   {
   sprite_row = sprite_on / 10;    //What row its on
   sprite_column = sprite_on % 10; //What column
   //Grabbing Code, uses allegro's blit statment.
  // blit(temp_bitmap,sprite->image[sprite_on],((sprite_column*sprite->width)+x+1),((sprite_row*sprite->height)+y+1),0,0,sprite->width,sprite->height);

  //new version here, is modified, but assumes SPRITES has already been inited
   blit(temp_bitmap,sprite->image->image[sprite_on],((sprite_column*sprite->width)+x+1+sprite_on),((sprite_row*sprite->height)+y+1),0,0,sprite->width,sprite->height);
   sprite_on++; //Increase amount of tiles added
   }
destroy_bitmap(temp_bitmap);
}


//Initializes the sprite
void sprite_init(SPRITE *sprite,SPRITES *image, int x, int y, int width, int height, int num_frame, int delay_frame)
{
int index;
 sprite->x = x;
 sprite->y = y;
 sprite->oldx = x;
 sprite->oldy = y;
 sprite->width = width;
 sprite->height = height;
 sprite->num_frame = num_frame;
 sprite->delay_frame = delay_frame;
 sprite->cur_frame = 0;
 sprite->state = SPRITE_DEAD;
 sprite->frame_tick = 0;
 sprite->image = image;
 sprite->backround = create_bitmap(sprite->width,sprite->height);
 //Sprites setting
if(!image->init)
{
 image->init = 1;
 image->sprites_used = sprite->num_frame;
 for(index=0;sprite->num_frame >index;index++)
   image->image[index] = create_bitmap(sprite->width,sprite->height);
}
}
//Calculate vy and vy from vlength and vangle
//Integer Version
void sprite_calc_vectors(SPRITE *sprite)
{
sprite->vx = sprite->vlength * cos (sprite->vangle * PI/180)+.5;
sprite->vy = sprite->vlength * sin (sprite->vangle * PI/180)+.5;
//+.5 is only used becuase of damn integer problems
}
//Calculate vangle and vlength from vx and vy
//Integer Version
void sprite_calc_arcvectors(SPRITE *sprite)
{
sprite->vlength = sqrt(sprite->vx * sprite->vx + sprite->vy *sprite->vy) + .6;
sprite->vangle = ((atan2(sprite->vy,sprite->vx))*180 / PI) + .6;
if(sprite->vangle <0)
  sprite->vangle=360-abs(sprite->vangle);
//+.5 is a quick fix for the common rounding error problem
}

//Sets up a tileset
void tileset_init(TILE_SET *tile_set,int width,int height,int num)
{
int index;
tile_set->height = height;
tile_set->width = width;
tile_set->num_tiles = num;    //Tell how many tiles the Tile set has
                              //Maybe I should change this to one call?
for(index=0;index<num;index++)
 {
 tile_set->tiles[index].anim_type = 0;
 tile_set->tiles[index].anim_on = 0;
 tile_set->tiles[index].width =  width;
 tile_set->tiles[index].anim_clock = 0;
 tile_set->tiles[index].anim_speed = TILE_ANIMSPEED;
 tile_set->tiles[index].height = height;
 tile_set->tiles[index].image = create_bitmap(tile_set->width,tile_set->height);
 tile_set->tiles[index].anim[0] = index;
 tile_set->tiles[index].anim_tick= 0;
 }
}





//Zcots fixed point version
//Very Nice and fast
void rotate_blit(BITMAP* sprite, BITMAP* dest,int x, int y,int scale,int angle)
{ 
//float dx, dy;        //                        'Component Vectors 
//float xstart, ystart;  //                      'Next Line 
//float srcx, srcy;  //                         'Array coord 
int dx, dy;        //                        'Component Vectors 
int xstart, ystart;  //                      'Next Line 
int srcx, srcy;  //                         'Array coord 
int arrayxmid , arrayymid;//  'Middle used to get start coord 

//used For loops 
int ya,xa; 
//used for calc; 
int xx,yy;//, color; 
unsigned short color;
//'Scale Factor 
int fixpoint = 128; 


//'We have to rotate from center 
arrayxmid = ((sprite->w) / 2); 
arrayymid = ((sprite->h) / 2); 

//Calc New Angle 
angle = ((float)angle /(float)256) *(float)360; 
{ 
    float ar = angle*((float)3.141593 / (float)180); 

    if(scale < 1) 
        scale = 1; 

    dx = (cos(ar))*(float)fixpoint / (scale / (float)100);
    dy = (-sin(ar))*(float)fixpoint / (scale / (float)100);
} 

//'get Start coords from center darn it!!! this took me a while.... 
//'the first pixel to rotate 
xstart = ((arrayxmid * fixpoint) - (arrayxmid * dx)) + (arrayymid * dy); 
ystart = ((arrayymid * fixpoint) - (arrayymid * dx)) - (arrayxmid * dy); 

/* 
//get destination bitmap ready and get our pitch of memory 
DDSURFACEDESC destsd; 
memset(&destsd,0,sizeof(destsd)); 
destsd.dwSize = sizeof(destsd); 
dest->data->Lock(NULL,&destsd,DDLOCK_SURFACEMEMORYPTR,NULL); 
unsigned short* dest_canvas = (USHORT*)destsd.lpSurface; 
int destptch = destsd.lPitch>>1; 

//get source bitmap ready and get our pitch of memory 
DDSURFACEDESC soarcsd; 
memset(&soarcsd,0,sizeof(soarcsd)); 
soarcsd.dwSize = sizeof(soarcsd); 
sprite->data->Lock(NULL,&soarcsd,DDLOCK_SURFACEMEMORYPTR,NULL); 
unsigned short* soarc_canvas = (USHORT*)soarcsd.lpSurface; 
int soarcptch = soarcsd.lPitch>>1; 
*/ 

for(ya = 0;ya<sprite->h;ya++) 
{ 
    srcx = xstart; 
    srcy = ystart; 
    for(xa = 0;xa<sprite->w;xa++) 
    { 
        //xx = srcx / fixpoint; 
        //yy = srcy / fixpoint; 
        xx = srcx >> 7; 
        yy = srcy >> 7; 
        if((xx >= 0) && (xx <= (sprite->w - 1)) && (yy >= 0) && (yy <= (sprite->h - 1))) 
        //dest_canvas[(xa+x)+(ya+y)*destptch] = soarc_canvas[xx+yy*soarcptch]; 
        color = ((short *)sprite->line[yy])[xx];
        else 
        color = 0; 

        ((short *)dest->line[ya+y])[xa+x]= color;
        srcx = srcx + dx; 
        srcy = srcy + dy; 

    }//end xa 
    xstart = xstart - dy; 
    ystart = ystart + dx; 
}//end ya 

//sprite->data->Unlock(soarcsd.lpSurface); 
//dest->data->Unlock(destsd.lpSurface); 

} 



void tile_grab(BITMAP *source,TILE *tile,int x,int y)
{
blit(source,tile->image,((x*tile->width)+x+1),((y*tile->height)+y+1),0,0,tile->width,tile->height);
}

void tileset_load(TILE_SET *tile_set, char filename[40],int x, int y)
{
BITMAP *temp_bitmap2;
int index;
int index2;
//Loads First Tileset
temp_bitmap2 = load_bitmap(filename,NULL);
if(!temp_bitmap2)
 {
 allegro_message("Unable to Load Tileset");
 exit(1);
 }
//Grab the Tiles
for(index=0;index<x;index++)
 {
 for(index2=0;index2<y;index2++)
  {
   if( tile_set->num_tiles > ((index2*x)+index))
    {
     tile_grab(temp_bitmap2,&tile_set->tiles[((index2*x)+index)],index,index2);
    }
   }
 }
destroy_bitmap(temp_bitmap2);
}
//THIS NEEDS A LOT OF WORK, eg
//Tell wether draw_sprite or blit, or animate etc
//And switch so uses TILE_SET, as opposed to tile.

void tile_display(BITMAP *display,TILE *tile, int x, int y)
{
if(tile->anim_type==1)
 {
 if(sprite_countera!=tile->anim_tick)
  {
  //tile->anim_clock+=1;
  tile->anim_tick = sprite_countera;
  tile->anim_on+=2;
  tile->anim_on&=0xFF;
  }
// rotate_blit(tile->image,display,x,y,tile->anim_on);
 rotate_blit(tile->image,display,x,y,140,tile->anim_on);
// rotate_sprite(display,tile->image,x,y,itofix(tile->anim_on));
//rotate_blit(display,tile->image,x,y,ftofix(0.5),itofix(tile->anim_on));
//fsin(angle) + ftofix (1.5)
 }
else if(tile->anim_type==2)
 {
 if(sprite_countera!=tile->anim_tick)
  {
  tile->anim_clock+=1;
  tile->anim_tick = sprite_countera;
   if(tile->anim_clock >=tile->anim_speed)
    {
    tile->anim_on +=1;
    tile->anim_clock = 0;
    if(tile->anim_on >4 || tile->anim[tile->anim_on] <0)
       tile->anim_on = 0;
    }
  }
  //draw_sprite(display, tile_set.tiles[tile->anim[tile->anim_on]].image, x, y);
  blit(tile_set.tiles[tile->anim[tile->anim_on]].image,display,0,0,x,y,tile->width,tile->height);
  }
else
// draw_sprite(display, tile->image, x, y);
//Test to see whats faster
//Draw_sprite crushed blit->tile
blit(tile->image,display,0,0,x,y,tile->width,tile->height);
}

void tileset_free(TILE_SET *tile_set)
{
int index;
for(index=0;index<tile_set->num_tiles;index++)
 {
 destroy_bitmap(tile_set->tiles[index].image);
 }
}

