//Includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "allegro.h"
#include <jpgalleg.h>
#include "gif.h"
#include "lexgui.h"
//My Own Headers
#include "pgui.h"  //Gui routines
#include "sprite.h"//Sprite routines
#include "mouse.h" //Mouse routines
#include "input.h"
//#include "pmain.h" //Global Pong routines(main)
#include "pmap.h"  //Certain Map Editor Only Routines
#include "map.h"   //Map Loading, Saving, Clearing routines
#include "pack.h"  //PackFile Stuff.....
//Defines/////////////////////////

//Globals/////////////////////////
//FONT
DATAFILE *datafile;
BITMAP *double_buffer; //Double Buffer
//PALETTE game_pal;
//PALETTE forced_pal;    //Palette That stays no matter what....

TILE_SET tile_set;
MAP map;

//Game Objects
PADDLE paddle[MAX_PADDLES]; //The 4 paddles
BALL ball[MAX_BALLS];

const int scrx = 640; //Screen Size
const int scry = 480; //X + Y

int balls_used;
//int game_type;        //2 paddle, 4 paddle or Solo

//FPS stuff
long shown_fps = 0;
long fps_counter = 0;

//Map Editor Stuff
//BMPFULL bmp_full;
int map_exit = 0;
int map_open = D_DISABLED;




//Keeps Track of Time
long speed_fps_counter = 0;
volatile long speed_counter = 0;    //Makes Game Run at set Speed
//Functions////////////////////////
//Timer////////////////////////////
void increment_speed_counter()
{
speed_counter++;//Increments Speed Counter By One
}
END_OF_FUNCTION(increment_speed_counter); //Tell Allegro at end of function



//If Computer Runs out
void mem_error(void)
{
if(set_gfx_mode(GFX_TEXT,0,0,0,0))
  { allegro_message("Cannot Initialize Screen.\n");
    exit(1);
  }
allegro_message("Out of Memory!/n");
exit(1);
}

//fskip, skips bytes in a file
void fskip(FILE *fp, int num_bytes)
{
int i;
for(i=0;i<num_bytes;i++)
 fgetc(fp);

}



//void force_colors(void)
//{
//IMPROVE
//set_palette_range(forced_pal,224,255,0);
//set_color(0,&forced_pal[0]);
//}

void animate(void)
{
static int to_draw_map = 0;
//FPS Stuff
char msg[50];
to_draw_map = !to_draw_map;
mouse_erase();
//clear_bitmap(double_buffer); //Will Change To Show Tiles
//So only draws ever 2 frames
if(to_draw_map)
if(map_open !=D_DISABLED)
   draw_map();
//Press Escape for Menu
rectfill(double_buffer,0,0,120,50,makecol(0,0,0));
sprintf(msg, "Press Escape To See Menu");
textout(double_buffer, font, msg, 0, 0, makecol(255,255,255));
//FPS stuff
sprintf(msg, "Fps: %d", shown_fps);
textout(double_buffer, font, msg, 0, 10, makecol(255,255,255));


mouse_display();


//Draw Buffer
acquire_screen();
blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
release_screen();
update_sprite_counter();
fps_counter++;
}

void show_menu(void)
{
//   file_menu[1].flags = map_open;
   file_menu[2].flags = map_open;
   file_menu[3].flags = map_open;
   file_menu[4].flags = map_open;
   file_menu[5].flags = map_open;
//   file_menu[5].flags = map_open;
  if(map.map_type == 2)
     {
      settings_menu[2].flags = 0;
      settings_menu[3].flags = 0;
      settings_menu[5].flags = D_DISABLED;
     }
  else if(map.map_type == 3)
     {
      settings_menu[2].flags = D_DISABLED;
      settings_menu[3].flags = D_DISABLED;
      settings_menu[5].flags = 0;
     }
  else
     {
      settings_menu[2].flags = D_DISABLED;
      settings_menu[3].flags = D_DISABLED;
      settings_menu[5].flags = D_DISABLED;
     }
animate();
show_gui_mouse();
do_menu(menu,0,0);
scare_mouse();
}

int close_map_editor(void)
{
map_exit =1;
return 0;
}


int update_settings(void)
{
BITMAP *test_bitmap;
BITMAP *test_bitmap2;
int index;
//gets called by the gui
//Only currently updates tileset.
//should check if valid.bmp
//and then attempts to update the tilset.
//First Call the dialog to update the mapfile
index = lex_do_dialog(the_dialog4, -1, double_buffer, update_screen);

if(index == 6 || index <0)
   {
    strncpy(d_filename,map.mapname,20);
    strncpy(d_imagename,map.backround,20);
    strncpy(d_ballname,map.balls,20);
    strncpy(d_paddlename,map.paddles,20);
    strncpy(d_mapname,map.maptitle,20);
    return 0;
   }
//tileset load section
if(check_if_mapname(d_filename))
  {
   lex_alert("Mapname is invalid","Map must end in .map","",NULL,"Okay",NULL,0,0,0);
    strncpy(d_filename,map.mapname,20);
    strncpy(d_imagename,map.backround,20);
    strncpy(d_ballname,map.balls,20);
    strncpy(d_paddlename,map.paddles,20);
    strncpy(d_mapname,map.maptitle,20);
    return 0;
   }
if(!(test_bitmap = load_bitmap(d_imagename,NULL)))
    {
    lex_alert("Tileset is invalid","Pong Map Was Unable to load" ,d_imagename,NULL,"Okay",NULL,0,0,0);
    strncpy(d_filename,map.mapname,20);
    strncpy(d_imagename,map.backround,20);
    strncpy(d_ballname,map.balls,20);
    strncpy(d_paddlename,map.paddles,20);
    strncpy(d_mapname,map.maptitle,20);
//    destroy_bitmap(test_bitmap);
    return 0;
    }
 destroy_bitmap(test_bitmap);
//if(strstr(d_paddlename,".bmp")==NULL)
if(!(test_bitmap = load_bitmap(d_paddlename,NULL)))
 {

//  if(strstr(d_ballname,".bmp")==NULL)
  if(!(test_bitmap2 = load_bitmap(d_ballname,NULL)))
   lex_alert("Ball and Paddle are both invalid","These need to be set properly" ,"to be used in game.",NULL,"Okay",NULL,0,0,0);
   else
   lex_alert("Paddlefile is invalid","It needs to be set properly" ,"to be used in game.",NULL,"Okay",NULL,0,0,0);
 }
else if(!(test_bitmap2 = load_bitmap(d_ballname,NULL)))
 lex_alert("Ballfile is invalid","It needs to be set properly" ,"to be used in game.",NULL,"Okay",NULL,0,0,0);

  destroy_bitmap(test_bitmap);
  destroy_bitmap(test_bitmap2);
//else if(!(test_bitmap = load_bitmap(d_ballname)))
//Argh, yet another ugly hack

//Checks to see wether a title has been entered.
if(!strlen(d_mapname))
   {
   lex_alert("Map Title Must Be Given","Map Name Will Now Become:" ,"None",NULL,"Okay",NULL,0,0,0);
   strcpy(d_mapname,"None");
   }
//Checks to see if ball is 0, if so then resets to 1;
if(map.ball_anim < 1)
 map.ball_anim = 1;
strncpy(map.balls,d_ballname,20);
strncpy(map.paddles,d_paddlename,20);
strncpy(map.backround,d_imagename,20);
strncpy(map.mapname,d_filename,20);
strncpy(map.maptitle,d_mapname,20);
tileset_load(&tile_set, map.backround,19, 14);
//set_pallete(game_pal);
//force_colors();
set_mouse_sprite(NULL);
map_open = 0;
return 0;
}
//Im Going to Comment this so i can understand it, since im gonna
//Heavily Modify it.... And back it up
int create_packed_map(void)
{
//Modify In future So lets user know It failed
FILE *fp; //Ouch, Bad coding Hard Rock,Way to many arrays.. Must write better in the future
char pack_name[25];
char npk_name[25];
char d_test[25];
int index0 = 0; //Really stupid hack to write 0 in afile, so im a moron....
int index;
int index2[10];
int index3;
//Ask The User what they want to do.
index = lex_do_dialog(the_dialog6, -1, double_buffer, update_screen);
//If User Canceled
if(index!=1)
 return 0;
if(map_open ==0)
{
index =  lex_alert("A Map is Open,","If map was not saved all","information will be lost. Close?","YES",NULL,"NO",0,0,0);
if(index!=1)
 return 0;
close_map();
}

if(!strlen(d_packname)) //Only Temp Protection, Will get better sooner
 return 0;
//Get New Titles
sprintf(pack_name,"%s%s",d_packname,".pak");
sprintf(npk_name,"%s%s",d_packname,".npk");
//We open The PackFile Now
if(open_packfile_write(pack_name))
 {
  return 0;
 }
if((fp = fopen(npk_name,"wb"))==NULL)
 {
 close_packfile();//We Screwed Up
 return 0;
 }
//Get All Maps In an array so its actually readable
d_pmap[0] = &d_map0;
d_pmap[1] = &d_map1;
d_pmap[2] = &d_map2;
d_pmap[3] = &d_map3;
d_pmap[4] = &d_map4;
d_pmap[5] = &d_map5;
d_pmap[6] = &d_map6;
d_pmap[7] = &d_map7;
d_pmap[8] = &d_map8;
d_pmap[9] = &d_map9;
index3=0;


//This is a quick map verification test
//Needs to be improved so actually checks if a legitimate file
for(index =0;index <10;index++)
{
index2[index] = 0;
strcpy(d_test,d_pmap[index]);
//Checks if ends in .map, then if is a map file, then if the files in it contain bitmaps
if(!check_if_mapname(d_test) && !check_if_mapfile(d_test) && !check_if_mapfiles(d_test))
   {
     index2[index] = 1;
     index3+=1;
   }
}

//The Actual Writing of the Map
fwrite(&d_packname,sizeof(char),20,fp); //npk,Write How Many Maps in pack
fwrite(&index3,sizeof(int),1,fp); //npk,Write How Many Maps in pack
if(the_dialog6[4].flags == 2)
{
index0 = 1;
fwrite(&index0,sizeof(int),1,fp); //npk,Writes 1 For Tournament Mode
index0 = 0;
}
else
fwrite(&index0,sizeof(int),1,fp); //npk,Writes 0 For Normal Mode
for(index =0;index <10;index++)
{

if(index2[index]==1)
   {
 strcpy(map.mapname,d_pmap[index]);
 strcpy(d_test,d_pmap[index]);
 fwrite(d_test,sizeof(char),20,fp);        //npk,Write mapfilename
 load_map(&map);
 fwrite(map.maptitle,sizeof(char),20,fp); //npk, write mapname
 fwrite(&map.map_type,sizeof(int),1,fp); //npk, write maptitle
 fwrite(&index0,sizeof(int),1,fp);        //npk,Writes 0, Is for map status, modified by
                                         //Pong game, if ==1then unlocked if 2 then topscore included
 fwrite(&index0,sizeof(long),1,fp); //For Top Score
// printf("loaded map: %s",map.mapname); //Will Comment Out soon
 rest(200);
add_file_packfile(map.mapname);   //This shouldnt be hard to guess
add_file_packfile(map.backround);
add_file_packfile(map.balls);
add_file_packfile(map.paddles);
   }
}
fwrite(d_comments,sizeof(char),150,fp); //npk, write comments

fclose(fp); //Close The Files
close_packfile();
sprintf(d_test, "%d Maps Were Added",index3);
lex_alert(d_test,"Creation was succesful. Packname:",d_packname,"Okay",NULL,NULL,0,0,0);
return 0;
}

//Main////////////////////////////
int main(int argc, char* argv[])
{

int index = 0;

//Initializing all the stuff
if (allegro_init())
   { allegro_message("Cannot Initialize Allegro.\n");
     return 1;
   }
set_config_file("../allegro.cfg");
if (install_keyboard())
   { allegro_message("Cannot Initialize Keyboard.\n");
     return 1;
   }
if(install_timer())
   { allegro_message("Cannot Initialize Timer \n.");
     return 1;
   }
if (install_mouse()<0)
   { allegro_message("Cannot Initialize Mouse.\n");
     return 1;
   }
   
//Counter Stuff
 LOCK_VARIABLE(speed_counter);
 LOCK_FUNCTION(increment_speed_counter);
  //Now Set The Actual Timer
  //Stupid thing isn't working right so i use Index to get it first

  if(install_int_ex(increment_speed_counter,BPS_TO_TIMER(GAME_FPS_SPEED)))
  { allegro_message("Cannot Initialize FPS Timer.\n");
    return 1;
  }

  if(install_sprite_counter())
  { allegro_message("Cannot Sprite Timer.\n");
    return 1;
  }

//Set Graphics Mode
set_color_depth(16); //Now 16 bit colour
if(set_gfx_mode(GFX_AUTODETECT,scrx,scry,0,0))
  {
  set_color_depth(16); //How about 15 bit?
  if(set_gfx_mode(GFX_AUTODETECT,scrx,scry,0,0))
   {
    allegro_message("Cannot Initialize Screen.\n");
    return 1;
   }
  }
//Create Double Buffer
 double_buffer =  create_bitmap(scrx, scry);
  if(!double_buffer) mem_error();
  clear_bitmap(double_buffer);

//This is for all other colour modes
set_color_conversion(COLORCONV_TOTAL);
//Lets us load jgep files into memory
jpgalleg_init();
//register_bitmap_file_type("jpg", load_jpg, NULL);
register_bitmap_file_type("gif", load_gif, NULL);
//LEX_GUI
//New Method, Now Loads From File
load_them_number();
//if (!lex_load_skin("./skins/red.skin")) {
//        allegro_message("Unable to load Skin\n");
//        exit(0);
//    }



//Sets Mouse Up For Use In Map Editor
load_game_mouse();
set_mouse_sprite(NULL);
set_default_gui_colors();
show_mouse(screen);
scare_mouse();
map.map_limitx = 0;
map.map_limity = 0;





ball[0].image.x = 0;
ball[0].image.y = 0;
//FONT
//datafile = load_datafile("font.dat");
//if(!datafile)
//  exit(1);
//set_skin_palette();
//get_palette(forced_pal);//Grab all current colors;
//set_palette(forced_pal);
tileset_init(&tile_set,32,32,MAX_TILES);
clear_map();
show_about();
//FONT
//font = datafile[0].dat;
//open_packfile_write("test.pak");
//add_file_packfile("newpal.bmp");
//close_packfile();
//open_packfile_read("test.pak");
//extract_file_packfile();
//close_packfile();

//if(open_packfile("Test"))
// {
// printf("hakfha");
// rest(2000);
// }
//test_binary("newpal.bmp", "testpack.bmp");
//map_exit = 1;


do
{
if (map_open != D_DISABLED)
 {
 if(mouse_b & 2)
  index = change_tile(&tile_set,19,14);
 if(mouse_b & 1)
  place_tile(index);
 }
 if(key[KEY_ESC])
  show_menu();
 if(key[KEY_X] &&(key[KEY_ALT] || key[KEY_ALTGR]))
  map_exit = 1;
 if(key[KEY_S])
      {
//      get_palette(game_pal);
      save_bitmap("dump.bmp", double_buffer, NULL);
      }
while(speed_counter <speed_fps_counter )
{
animate();
}

//FPS stuff
if(speed_counter > GAME_FPS_SPEED - 1)
 {
 shown_fps = fps_counter;
 speed_counter = 0;
 fps_counter =0;
 }

//Time Lockon Variable
speed_fps_counter = speed_counter + 1;
}while(!map_exit);

//map_exit = 1;


//Closing Stuff
//Free up all allocated mem
destroy_bitmap(double_buffer);
tileset_free(&tile_set);
close_game_mouse();
lex_gui_shutdown();
//FONT
//unload_datafile(datafile);
return 0;
}
END_OF_MAIN()

