//Better Random Numbers in DJGPP
//And will work if ported
#ifdef DJGPP
#else
#define PI                3.14159
#define random rand
#define srandom srand
#endif

//Defines/////////////////////////
#define SCREEN_WIDTH      640
#define SCREEN_HEIGHT     480
#define MAX_BALLS         4
#define MAX_PADDLES       4
#define GAME_FPS_SPEED    60


 typedef struct PADDLE_STRUCT
  {
   SPRITE image; //Structure of Sprite
   int user; //Computer, Human
   int user_type; //Keyboard,Joystick and may add in Hard or Normal etc
   int type; //Vertical Or Horizontal
   int team;
  } PADDLE,*PADLLE_ptr;

 typedef struct BALL_STRUCT
  {
   SPRITE image;
   int speed;
   int on;
  }BALL,*BALL_ptr;

 typedef struct MAP_STRUCT
  {
     //The Actual Map
   int map_info[25][13];
   //Type1=2play, 2=4play,3=wallplay etc
   int map_type;
   //The Files Names
   char balls[25];
   char paddles[25];
   char backround[25];
   char mapname[25];
   char maptitle[25];
   //How Many Frames The Ball Will animate for
   int ball_anim;   //1,2,4,or 8
   //Comments for user to enter in
   //char comments[250]; Changed, now comments are only includded in the packfile
   //Number of tiles blocked(each represents 32 pixels)
   int map_limitx;
   int map_limity;
   //The top,bottom etc amount a paddle can move before hitting a wall
   int map_up;
   int map_down;
   int map_right;
   int map_left;
   } MAP,*MAP_ptr;

//Globals/////////////////////////
extern BITMAP *double_buffer; //Double Buffer
extern BITMAP *screen_pic; //Double Buffer
extern BITMAP *menu_buffer; //Menu Buffer
//extern PALETTE game_pal;     //The Main Palette
extern BITMAP *top_bar;
//extern PALETTE forced_pal;
extern DATAFILE *datafile1;
extern DATAFILE *music_datafile;
//Map Stuff
extern TILE_SET tile_set;
extern MAP map;

//Game Objects
extern PADDLE paddle[MAX_PADDLES]; //The 4 paddles
extern P_INPUT paddle_input[MAX_PADDLES]; //4 Player Input Controls
extern COLOR_MAP trans_map;
extern BALL ball[MAX_BALLS];
extern SPRITES sball;
extern SPRITES spaddle1;
extern SPRITES spaddle2;
extern SPRITES spaddle4;
extern SPRITES spaddle3;
extern const int scrx; //Screen Size
extern const int scry; //X + Y
extern int sound_on;
extern int sound_vol;
extern int balls_used;  //How Many Paddles are being used at a time
extern int paddles_used;//How Many Balls are being used
extern int max_ball_speed;
extern int start_game;  //If game is ready to go
extern int score1;      //Score of Team One, should be in a struct
extern int score2;      //Score of Team Two
extern int exit_int;   //Good practice
extern volatile long speed_counter; //The Speed Counter
extern long speed_fps_counter;             //Fps Counter
extern long shown_fps;
extern long fps_counter;
extern int for_score;   //A hack So That The Game Know Whats The Scores For
extern int score_mode;
extern int game_type;
extern int game_time;
extern int paddle_no_slide;
extern int sound_disabled;
//Functions////////////////////////////
void increment_speed_counter();
void wait_for_key(int seconds);
int random_song(void);
int fade_in_hc(BITMAP *image);
//void set_32_palette_col(PALETTE pal);
//void fskip(FILE *fp, int num_bytes);
