//'aldmd' and 'dumbd' in two boxes, making sure 'aldmd' comes above whatever
//   you are using to link with Allegro (or just put 'dumbd' if yo
//      If you are using Allegro: /link aldmd.lib dumbd.lib alld.lib
//   If you are using RHIDE, go to Options -> Libraries. You will need to type
//   'aldmd', 'dumbd' and 'alld' in three boxes, making sure you get them in
//   The above are the debugging libraries. It is VERY HIGHLY RECOMMENDED that
//   If you wish to replace -lalld with -lalleg, feel free. It is not so vital
//      If you are using Allegro: -laldmb -ldumb -lalleg
//


//Includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <stdlib.h>
#include "allegro.h"
#include <jpgalleg.h>
#include "gif.h"
#include "aldumb.h"
#include "music.h"
#include "pack.h"
#include "sprite.h"
#include "input.h"
//#include "particle.h"
#include "pmain.h"
#include "pgmap.h"
#include "pgame.h" //The game engine goes here
//Pong Only Subs
#include "balls.h"
#include "paddles.h"
#include "npk.h"
#include "gmenu.h"
#include "menu.h"
//Defines/////////////////////////
//Globals/////////////////////////
//FONT
DATAFILE *datafile1;
DATAFILE *music_datafile;
FONT *original_font;
NPK *current;
BITMAP *double_buffer; //Double Buffer
BITMAP *menu_buffer; //A different Buffer
BITMAP *screen_pic; //Backround Pic
BITMAP *top_bar;    //Top Bar
//Game Objects
PADDLE paddle[MAX_PADDLES]; //The 4 paddles
P_INPUT paddle_input[MAX_PADDLES]; //4 Player Input Controls
BALL ball[MAX_BALLS];
SPRITES sball;    //Sprite, and Sprites are different, these are images
SPRITES spaddle1;
SPRITES spaddle2;
SPRITES spaddle3;
SPRITES spaddle4;

//Map Stuff
TILE_SET tile_set;
MAP map;
//Music Dumb Stuff
SONG songs[8];
SONG *song;
NPKL npkl;

const int scrx = 640; //Screen Size
const int scry = 480; //X + Y
int game_time;
int sound_on = 1;
int sound_vol = 255;
int exit_int = 0;//I really should be getting in the habit of this
int start_game = 0;
int max_ball_speed = 1;
int balls_used = 1;
int paddles_used = 2;
int score1 = 0;
int score2 = 0;
int for_score;
int score_mode;
int game_type = 0;
int paddle_no_slide = 0;
int sound_disabled = 0;
//FPS stuff
long shown_fps = 0;
long fps_counter = 0;

//Keeps Track of Time
long speed_fps_counter = 0;
volatile long speed_counter = 0;    //Makes Game Run at set Speed
//Functions////////////////////////
//Timer////////////////////////////
void increment_speed_counter()
{
speed_counter++;//Increments Speed Counter By One
}
END_OF_FUNCTION(increment_speed_counter); //Tell Allegro at end of function


//If Computer Runs out
void mem_error(void)
{
allegro_message("Out of Memory!/n");
exit(1);
}

void wait_for_key(int seconds)
{
int cur_time = speed_counter;
clear_keybuf();
while(cur_time+(seconds*60) > speed_counter)
{
play_music(song);
if(keypressed())
 break;
}
clear_keybuf();
}
//Selects a random song, poorly coded, needs MAJOR overhaul
int random_song(void)
{
int num = 0;
int escape = 1;
if(songs_used)
 {
 while(escape)
  {
  num = rand()%7;
  if(songs[num].flags !=SONG_DISABLED)
    escape = 0;
  }
 }
return num;
}

//is gonna be slow as hell on slower comps
int fade_screen_hc(BITMAP *image)
{
BITMAP *speed_up;
int index = 0;
//See if screws up somehow
if(!(speed_up =  create_bitmap(640,480)))
    return 1;

blit(image,speed_up,0,0,0,0,double_buffer->w,double_buffer->h);
blit(speed_up,screen,0,0,0,0,speed_up->w,speed_up->h);
set_trans_blender(256/30,256/30,256/30,256/30);
drawing_mode(DRAW_MODE_TRANS,NULL,NULL,NULL); //Sets draw_mode to trans
speed_counter = 0;
  while(index < 30)
   {
    if(speed_counter / 2 > index)
     {
      rectfill(speed_up,0,0,screen->w,screen->h,makecol(0,0,0));
      blit(speed_up,screen,0,0,0,0,speed_up->w,speed_up->h);
      index++;
     }
   }
destroy_bitmap(speed_up);
set_trans_blender(128,128,128,128);
return 0;
}
//Optmized a little, so wont lag on slower comps
int fade_in_hc(BITMAP *image)
{
BITMAP *speed_up;
int index = 0;
//See if screws up somehow
if(!(speed_up =  create_bitmap(640,480)))
    return 1;
speed_counter = 0;
index = 1;
  while(index < 240)
   {
    if(speed_counter * 4 > index)
     {
      blit(image,speed_up,0,0,0,0,double_buffer->w,double_buffer->h);
//    set_trans_blender(255/index,255/index,255/index,255/index);
      set_trans_blender(255- index,255 -index,255 - index,255 - index);
      drawing_mode(DRAW_MODE_TRANS,NULL,NULL,NULL); //Sets draw_mode to trans
      rectfill(speed_up,0,0,screen->w,screen->h,makecol(0,0,0));
      blit(speed_up,screen,0,0,0,0,speed_up->w,speed_up->h);
      index = speed_counter * 4;
     }
   }
destroy_bitmap(speed_up);
set_trans_blender(128,128,128,128);
return 0;
}

//Temporary Will Move soon enough
void show_map_stats(BITMAP *disp)
{
char text[45];
char *textp = NULL;
int index;
int y = 350;
int x = 310;
int loop_till;//Nuts, have to use another int
textp = &current->comments;
drawing_mode(DRAW_MODE_TRANS,NULL,0,0); //Set to translucent;
rectfill(disp,10,330,609,469, menup_pong->back_color);
loop_till = (strlen(textp)/40)+1;
for(index = 0; index < loop_till;index++)
  {
  strncpy(text,textp,40);
  textout(disp,font,text,10,y, gmenu_normal_color);
  textp += 40;
  y+=15;
  }
if(menup_pong->selected - 1 <= current->num_maps &&menup_pong->selected - 1 >= 0)
 {
  if(current->map_type[menup_pong->selected - 1] == 1)
    strcpy(text, "2 Player Map");
   if(current->map_type[menup_pong->selected -1] == 2)
    strcpy(text, "4 Player Map");
  if(current->map_type[menup_pong->selected - 1] == 3)
    strcpy(text, "Solo Map");
  textprintf_centre(disp,font,x,y, gmenu_normal_color,text);
  y+=15;
  textprintf_centre(disp,font,x,y, gmenu_normal_color,"High Score:  %d",current->map_top_score[menup_pong->selected - 1]);
  y+=15;
 }
}


//Main////////////////////////////
int main(int argc, char* argv[])
{
int index = 0;
int main_do_fade = 1;
//Initializing all the stuff
if (allegro_init())
   { allegro_message("Cannot Initialize Allegro.\n");
     return 1;
   }
//Its one directory before :)
set_config_file("../allegro.cfg");

if (install_keyboard())
   { allegro_message("Cannot Initialize Keyboard.\n");
     return 1;
   }
if(install_timer())
   { allegro_message("Cannot Initialize Timer \n.");
     return 1;
   }
//if (install_mouse()<0)
//   { allegro_message("Cannot Initialize Mouse.\n");
//     return 1;
//   }
//Sound Init Stuff
set_volume_per_voice(0);
if (install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL)) {
allegro_message("Failed to initialise sound driver!\n%s\n", allegro_error);
sound_disabled = 1;
}
//Install Music DUMB, Must Be done after sound
init_music();


//Counter Stuff
 LOCK_VARIABLE(speed_counter);
 LOCK_FUNCTION(increment_speed_counter);
  //Now Set The Actual Timer
  //Stupid thing isn't working right so i use Index to get it first

  if(install_int_ex(increment_speed_counter,BPS_TO_TIMER(GAME_FPS_SPEED)))
  { allegro_message("Cannot Initialize FPS Timer.\n");
    return 1;
  }
  if(install_sprite_counter())
  { allegro_message("Cannot Sprite Timer.\n");
    return 1;
  }


//Set Graphics Mode
set_color_depth(16); //Make 16 bit
if(set_gfx_mode(GFX_AUTODETECT,scrx,scry,0,0))
  {
  set_color_depth(15); //Make 15 bit
  if(set_gfx_mode(GFX_AUTODETECT,scrx,scry,0,0))
    { allegro_message("Cannot Initialize Screen.\n");
      return 1;
    }
  }
//Now loads .jpg
set_color_conversion(COLORCONV_TOTAL);
jpgalleg_init();
//register_bitmap_file_type("jpg", load_jpg, NULL);
register_bitmap_file_type("gif", load_gif, NULL);
//jpgalleg_init(); //New version, new code!
textout(screen,font,"Allegro Initialized",0,index,makecol(255,255,255));
index +=15;
textout(screen,font,"Sound Initialized",0,index,makecol(255,255,255));
index +=15;
textout(screen,font,"Dumb Initialized",0,index,makecol(255,255,255));
index +=15;
textout(screen,font,"Timers Initialized",0,index,makecol(255,255,255));
//en_file("cred.txt", "pnc.dat");
//textout(x,y,
//We Dont Check this becuase a joystick is not mandatory to play this game
if (install_joystick(JOY_TYPE_AUTODETECT) != 0) {
//      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
//      allegro_message("Unable to initialize joystick Drivers\n");
index +=15;
textout(screen,font,"Unable to initilize joystick Drivers!",0,index,makecol(255,255,255));
}
else
{
index +=15;
textout(screen,font,"Joystick Drivers Initialized",0,index,makecol(255,255,255));
/* make sure that we really do have a joystick */
   if (!num_joysticks) {
      index +=15;
      textout(screen,font,"No Joysticks Found",0,index,makecol(255,255,255));
     }
}

//Loads the FONT datafile
datafile1 = load_datafile("pongu.dat");


//If datafile did not load, error
if(!datafile1)
  { allegro_message("Cannot Load General Datafile.\n");
    return 1;
   }
index +=15;
textout(screen,font,"General DataFile Loaded",0,index,makecol(255,255,255));
//Loads the Music
if(sound_disabled)
{
index +=15;
textout(screen,font,"Sound Disabled",0,index,makecol(255,255,255));
}
else
{
index +=15;
textout(screen,font,"Loading Music, Be Patient Please.",0,index,makecol(255,255,255));
music_datafile = load_datafile("music.dat");
//If datafile did not load, error
if(!music_datafile)
  { allegro_message("Cannot Load Music Datafile.\n");
    return 1;
   }
index +=15;
textout(screen,font,"Music Loaded",0,index,makecol(255,255,255));
}

//Randomize timer
srand(time(NULL)); //Randomize Timer


//Create Double Buffer
 double_buffer =  create_bitmap(scrx, scry);
  if(!double_buffer)
   mem_error();
  clear_bitmap(double_buffer); //Make Screen Start Black

 menu_buffer =  create_bitmap(scrx, scry);
  if(!menu_buffer)
   mem_error();
  clear_bitmap(menu_buffer); //Make Screen Start Black

//Init Sprites
       sprite_init(&paddle[0].image,&spaddle1,0,120,20,60,1,0); //The Paddles
       sprite_init(&paddle[1].image,&spaddle2,620,120,20,60,1,0);
       sprite_init(&paddle[2].image,&spaddle3,120,64,60,20,1,0);
       sprite_init(&paddle[3].image,&spaddle4,120,460,60,20,1,0);
       sprite_init(&ball[0].image,&sball,154,106,16,16,8,0); //The Balls
       sprite_init(&ball[1].image,&sball,180,100,16,16,8,0);
       sprite_init(&ball[2].image,&sball,190,100,16,16,8,0);
       sprite_init(&ball[3].image,&sball,140,100,16,16,8,0);
       tileset_init(&tile_set,32,32,MAX_TILES);     //Inits the tileset



//Sets Textmode to trans backdrop
text_mode(-1);
original_font = font; //Keep old font
font = datafile1[0].dat; //Sets new font
index +=15;
textout(screen,original_font,"Sprites Loaded",0,index,makecol(255,255,255));

//Save all settings
if(load_game_settings())
  {
  index +=15;
  textout(screen,original_font,"Unable to load Game_dat",0,index,makecol(255,255,255));
  return 1;
  }
  index +=15;
  textout(screen,original_font,"Game Stats Loaded",0,index,makecol(255,255,255));

/*
//Human Player Default Input Methods
//Player 1
paddle_input[0].input = 1;
paddle_input[0].right_flag = KEY_RIGHT;
paddle_input[0].left_flag = KEY_LEFT;
paddle_input[0].down_flag = KEY_DOWN;
paddle_input[0].up_flag = KEY_UP;
//Player 2
paddle_input[1].input = 1;
paddle_input[1].right_flag = KEY_D;
paddle_input[1].left_flag = KEY_A;
paddle_input[1].down_flag = KEY_S;
paddle_input[1].up_flag = KEY_W;
//Player 3
paddle_input[2].input = 1;
paddle_input[2].right_flag = KEY_L;
paddle_input[2].left_flag = KEY_J;
paddle_input[2].down_flag = KEY_I;
paddle_input[2].up_flag = KEY_K;
//Player 4
paddle_input[3].input = 1;
paddle_input[3].right_flag = KEY_6_PAD;
paddle_input[3].left_flag = KEY_4_PAD;
paddle_input[3].down_flag = KEY_5_PAD;
paddle_input[3].up_flag = KEY_8_PAD;
//This doesnt change, dont know why i bothered
paddle[0].type = 1;
paddle[1].type = 1;
paddle[2].type = 2;
paddle[3].type = 2;
*/


//DuMB Current
load_music_datafile(&songs[0],music_datafile,0);
load_music_datafile(&songs[1],music_datafile,1);
load_music_datafile(&songs[2],music_datafile,2);
load_music_datafile(&songs[3],music_datafile,3);
load_music_datafile(&songs[4],music_datafile,4);
load_music_datafile(&songs[5],music_datafile,5);
load_music_datafile(&songs[6],music_datafile,6);
load_music_datafile(&songs[7],music_datafile,7);


//We use blenders for trans tables now
set_trans_blender(128,128,128,128);
drawing_mode(DRAW_MODE_TRANS,NULL,NULL,NULL); //Sets draw_mode to trans
top_bar =datafile1[7].dat; //Sets Top Bar, Temporary
screen_pic = datafile1[2].dat; //Sets Backround
index +=15;
textout(screen,original_font,"Drawing Modes Set",0,index,makecol(255,255,255));
npkl_get_list(&npkl);//Load Up all Available packfiles
//No maps found?
if(npkl.next == NULL)
 {
 textout(screen,original_font,"Maps Found",0,index,makecol(255,255,255));
 return 1;
 }
current = npkl.next; //I hope this is a bug fix
index +=15;
textout(screen,original_font,"Maps Found",0,index,makecol(255,255,255));
screen_pic = datafile1[1].dat;
//blit(screen_pic,screen,0,0,0,0,double_buffer->w,double_buffer->h);
fade_in_hc(screen_pic);
wait_for_key(5);
fade_screen_hc(screen_pic);
screen_pic = datafile1[2].dat; //Sets Backround
//fade_in(game_pal,1);

//Load stars logo;

while(!exit_int)
{
fade_in_hc(screen_pic);
song = &songs[random_song()];
menup_pong =  init_game_menu(menu_main,1,1,makecol(0,0,255),1);
while(index !=1)
{
index = update_game_menu(menup_pong);
//Player Pressed Escape, Renew Menu
if(index ==2)
 {
 destroy_game_menu(menup_pong);
 menup_pong =  init_game_menu(menu_main,1,1,makecol(0,0,255),1); //Renewed
 }
blit(screen_pic,double_buffer,0,0,0,0,double_buffer->w,double_buffer->h);
//Set Up Menu Co-ordinates
     menup_pong->x = (scrx - menup_pong->menu_width) /2;
      if(menup_pong->menu == menu_level)
       {
       menup_pong->y = 0;
       show_map_stats(double_buffer);
       }
      else
      menup_pong->y = (scry - menup_pong->menu_height) /2;

draw_game_menu(menup_pong, double_buffer);
blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
//A One time Thing
//if(main_do_fade)
// {
// fade_in(game_pal,1);
// main_do_fade = 0;
// }
play_music(song);
}
index = 0;
destroy_game_menu(menup_pong);
stop_music(song);
fade_screen_hc(screen_pic);
//After Exiting menu must be removed and re-created
if(start_game)
  {
  do_game_engine();
  main_do_fade = 1;
  }
else exit_int = 1; //Means User Exited by available means, and game_over
}

//Closing Stuff
//Free up all allocated mem
//Music
//free_music(song);
//Graphics
destroy_bitmap(double_buffer);
//destroy_bitmap(screen_pic);
tileset_free(&tile_set);
//Becuase of new code
sprite_free(&paddle[0].image);
sprite_free(&paddle[1].image);
sprite_free(&paddle[2].image);
sprite_free(&paddle[3].image);
sprite_free(&ball[0].image);
sprite_free(&ball[1].image);
sprite_free(&ball[2].image);
sprite_free(&ball[3].image);
//sprite_free(&sball);
//Other
remove_npk(npkl.next);
unload_datafile(datafile1);
unload_datafile(music_datafile);
//Save all settings
save_game_settings();
return 0;
 }
END_OF_MAIN()

