//Includes
#include <stdio.h>
#include <string.h>
#include "allegro.h"
#include "lexgui.h"
#include "sprite.h"
#include "pgui.h"
#include "input.h"
//#include "pmain.h"
#include "pmap.h"
#include "map.h"
//The Menu Funtions.....
MENU file_menu[32] =
{
   { "&New",                          new_map,           NULL,       0, NULL  },
   { "&Load",                         load_map_dialog,            NULL,       0, NULL  },
   { "&Save",                         save_map_dialog,          NULL,       0, NULL  },
   { "&Edit Settings",                NULL,           settings_menu,      0, NULL  },
   { "&Close Map",                    close_map_do,           NULL,      0, NULL  },
   { "Save &As...",                   save_map_as_dialog,          NULL,       0, NULL  },
  // {"Save &As",                         saveas_map_dialog,          NULL,       0, NULL  },
   { "Create &Packfile",             create_packed_map,          NULL,       0, NULL  },
// { "Load Test.pak",           test_pack,      NULL,       0, NULL  },
   { "Create &Tileset",             create_tileset,          NULL,       0, NULL  },
//For Testing Purposes, used to show new added menu feature.
//   { "GUI Test Show",               gui_6_show,    NULL,       0, NULL  },

  // { "&Read Bitmap\t(ctrl+R)",      NULL,           NULL,       0, NULL  },
  // { "&View Bitmap\t(ctrl+V)",      NULL,           NULL,       0, NULL  },
  // { "",                            NULL,             NULL,       0, NULL  },
   { "E&xit\t Alt+x",                         close_map_editor,          NULL,       0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};


MENU settings_menu[32] =
{

   { "&Edit File names",              update_settings,              NULL,       0, NULL  },
   { "&Map Type",                     show_change_type,          NULL,       0, NULL  },
   { "Set 4 Player Boundaries",           set_4_player_edge,             NULL,       0, NULL  },
   { "Show 4 Player Boundaries",       show_map_boundaries_do,             NULL,       0, NULL  },
   { "Change Ball Animation Stats",          show_change_ballanim,             NULL,       0, NULL  },
   { "Set Solo Player Boundaries",          set_1_player_edge,             NULL,       0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};
MENU help_menu[32] =
{
//   { "&Help",                       NULL,           NULL,       0, NULL  },
   //{ "&System",                     sysinfo,          NULL,       0, NULL  },
   { "&About",                      show_about,            NULL,  0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

MENU theme_menu[32] =
{
   { "Fire Skin",                     set_red_theme, NULL,          0, NULL  },
   { "Beos Skin",                   set_yellow_theme, NULL,        0, NULL  },
   { "Windows Skin",                 set_win_theme,      NULL,   0, NULL  },
   { "Aqua Skin",                   set_aqua_theme,NULL,     0, NULL  },
//   { "White",                    set_white_theme, NULL,     0, NULL  },
//   { "Purple",                    set_purple_theme,NULL,    0, NULL  },
//   { "Orange",                    set_orange_theme,NULL,    0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

MENU menu[32] =
{ 
   { "&File",                       NULL,             file_menu,  0, NULL  },
//   { "&Menu Colors",                      NULL,             color_menu,  0, NULL  },
   { "&Themes",                      NULL,             theme_menu,  0, NULL  },
   { "&Help",                       NULL,             help_menu,  0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

//The Dialog Instructions, Yes I know their HUGE,
//Live With it
//The Settings Dialog
DIALOG lex_alert_dialog[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  150,   -1,  -1,    0,    0,          0,                      0,    "Alert",    NULL, NULL  },
   { d_text_proc,       120,  125,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map name:",     NULL,NULL},
   { d_text_proc,       120,  135,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map name:",     NULL,NULL},
   { d_text_proc,       120,  145,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map name:",     NULL,NULL},
   { lex_button_proc,   120,  200,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Okay",     NULL, NULL  },
   { lex_button_proc,   220,  200,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Okay",     NULL, NULL  },
   { lex_button_proc,   320,  200,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Cancel",     NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};
DIALOG the_dialog[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  440,  200,   -1,  -1,    0,    0,          0,                      0,    "Tile Animation Properties",    NULL, NULL  },
 //  { lex_button_proc,   110,  130,  150,   24,    0,  -1,   't',   D_EXIT,    -1,                     0,    "&Sound && Dialog",    buttonCallback, NULL  },

   //{ lex_radio_proc,    190,  160,   80 ,  20,    0,  -1,    0,    D_SELECTED, 1,                      0,    "Normal Tile (0)",         update_tile_prop, NULL  },
//   { lex_radio_proc,    190,  180,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "Rotate Tile (1)",         update_tile_prop, NULL  },

   { lex_radio_proc,    190,  220,   80 ,  20,    0,  -1,    0,    D_HIDDEN,          1,                      0,    "Animate Tile (3)",         NULL, NULL  },
   { lex_edit_proc ,    410,  130,  120 ,  24,    0,  -1,    0,    0,          3,                     0,   d_extra ,        NULL, NULL  },
   { lex_list_proc ,    410,  160,  120 ,  90,    0  ,-1,    0,    0,          0,                      0,   listbox_callback,        NULL, NULL  },
   { lex_radio_proc,    190,  200,   80 ,  20,    0,  -1,    0,    D_HIDDEN,          1,                      0,    "Change On Touch (2)",         NULL, NULL  },
   { d_text_proc,       210,  137,   120,  24,    0, -1,     0,    0,          0,                      0,    "Tile To Animate Into:",     NULL,NULL},
   { d_text_proc,       105,  157,   120,  24,    0, -1,     0,    0,          0,                      0,    "*Hints*",     NULL,NULL},
   { d_text_proc,       105,  167,   120,  24,    0, -1,     0,    0,          0,                      0,    "-Animation 0 is reserved for ",     NULL,NULL},
   { d_text_proc,       105,  177,   120,  24,    0, -1,     0,    0,          0,                      0,    "    for the Current Tile",     NULL,NULL},
   { d_text_proc,       105,  187,   120,  24,    0, -1,     0,    0,          0,                      0,    "-Inset a negative number to End ",     NULL,NULL},
   { d_text_proc,       105,  197,   120,  24,    0, -1,     0,    0,          0,                      0,    "    Animation after that point",     NULL,NULL},
 //  { lex_slider_proc,   110,  230,  200,   20,   0 , -1,    0,    0,       100,                    0,    NULL,             NULL, NULL  },
      
//   { lex_button_proc,   110,  264,   60,   24,    0,  -1,    'y',  D_EXIT,    0,                     0,    "&Aqua",     onThemeChange, NULL  },
//   { lex_button_proc,   180,  264,   60,   24,    0,  -1,    'b',  D_EXIT,    1,                     0,    "&Bill",     onThemeChange, NULL  },
//   { lex_button_proc,   250,  264,   60,   24,    0,  -1,    'c',  D_EXIT,    2,                     0,    "&Yellow",     onThemeChange, NULL  },
   
   { lex_button_proc,   480,  264,   50,   24,    0,  -1,    0,  D_EXIT,    -1,                     0,    "Okay",     NULL, NULL  },
      
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                     0,    NULL,         NULL, NULL  },
};

//The Load Dialog
DIALOG the_dialog2[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  100,   -1,  -1,    0,    0,          0,                      0,    "File to Load",    NULL, NULL  },
   { d_text_proc,       120,  130,   120,  24,    0, -1,     0,    0,          0,                      0,    "File to Load:",     NULL,NULL},
   { lex_edit_proc,     240,  125,   120,   24,    0,  -1,    'x',  D_EXIT,    19,                      0,    d_loadname,     NULL, NULL  },
   { lex_button_proc,   200,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Load",     load_map_do, NULL  },
   { lex_button_proc,   280,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Cancel",     NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};
DIALOG the_dialog3[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  100,   -1,  -1,    0,    0,          0,                      0,    "Map Type",    NULL, NULL  },
   { lex_radio_proc,    150,  130,   80 ,  20,    0,  -1,    0,    D_SELECTED, 1,                      0,    "2 Player",        NULL, NULL  },
   { lex_radio_proc,    150,  150,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "4 Player",        NULL, NULL  },
   { lex_radio_proc,    150,  170,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "Time Battle",        NULL, NULL  },
   //{ lex_button_proc,   110,  264,   60,   24,    0,  -1,    'y',  D_EXIT,    0,                     0,    "&Save",     save_file, NULL  },
   { lex_button_proc,   300,  170,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                     0,    "Okay",     NULL, NULL  },
      
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                     0,    NULL,         NULL, NULL  },
};

//The Settings Dialog
DIALOG the_dialog4[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  230,   -1,  -1,    0,    0,          0,                      0,    "Settings",    NULL, NULL  },
  // { lex_button_proc,   120,  130,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&New",     NULL, NULL  },
 //  { lex_button_proc,   200,  130,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Load",     NULL, NULL  },
   { d_text_proc,       120,  135,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map File name:",     NULL,NULL},
   { lex_edit_proc,     250,  125,   120,   24,    0,  -1,    'x',  D_EXIT,    19,                      0,    d_filename,     NULL, NULL  },
   { d_text_proc,       120,  165,   120,  24,    0, -1,     0,    0,          0,                      0,    "Tileset name:",     NULL,NULL},
   { lex_edit_proc,     250,  155,   120,   24,    0,  -1,    'x',  D_EXIT,    19,                      0,     d_imagename,     NULL, NULL  },
   { lex_button_proc,   120,  290,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Okay",     NULL, NULL  },
   { lex_button_proc,   320,  290,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Cancel",     NULL, NULL  },
   { d_text_proc,       120,  195,   120,  24,    0, -1,     0,    0,          0,                      0,    "Paddlefile name:",     NULL,NULL},
   { lex_edit_proc,     250,  185,   120,   24,    0,  -1,    'x',  D_EXIT,    19,                      0,    d_paddlename,     NULL, NULL  },
   { d_text_proc,       120,  225,   120,  24,    0, -1,     0,    0,          0,                      0,    "Ballfile name:",     NULL,NULL},
   { lex_edit_proc,     250,  215,   120,   24,    0,  -1,    'x',  D_EXIT,    19,                      0,    d_ballname,     NULL, NULL  },
   { d_text_proc,       120,  255,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name:",     NULL,NULL},
   { lex_edit_proc,     250,  245,   120,   24,    0,  -1,    'x',  D_EXIT,    19,                      0,    d_mapname,     NULL, NULL  },

   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};

//The about dialog
DIALOG the_dialog5[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  200,   -1,  -1,    0,    0,          0,                      0,    "About",    NULL, NULL  },
  // { lex_button_proc,   120,  130,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&New",     NULL, NULL  },
 //  { lex_button_proc,   200,  130,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Load",     NULL, NULL  },
   { d_text_proc,       120,  135,   120,  24,    0, -1,     0,    0,          0,                      0,    "Pong Ultra Map Editor Ver 1.1",     NULL,NULL},
   { d_text_proc,       120,  145,   120,  24,    0, -1,     0,    0,          0,                      0,    "Lex_gui used for Menus",     NULL,NULL},
   { d_text_proc,       120,  155,   120,  24,    0, -1,     0,    0,          0,                      0,    "Allegro for graphics",     NULL,NULL},
   { d_text_proc,       120,  165,   120,  24,    0, -1,     0,    0,          0,                      0,    "By The Stars Dev Company",     NULL,NULL},
   { d_text_proc,       120,  175,   120,  24,    0, -1,     0,    0,          0,                      0,    "- Hard Rock",     NULL,NULL},
   { d_text_proc,       120,  185,   120,  24,    0, -1,     0,    0,          0,                      0,    "Create Tileset Ver 0.99",     NULL,NULL},
   { d_text_proc,       120,  195,   120,  24,    0, -1,     0,    0,          0,                      0,    "Create Packfile Ver 1.1",     NULL,NULL},
   { lex_button_proc,   320,  260,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Okay",     NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};
DIALOG the_dialog6[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  60,   400,  400,   -1,  -1,    0,    0,          0,                      0,    "Create Packfile",    NULL, NULL  },
   { lex_button_proc,   400,  360,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Okay",     NULL, NULL  },
   { lex_button_proc,   400,  390,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Cancel",     NULL, NULL  },
   { d_text_proc,       400,  320,   120,  24,    0, -1,     0,    0,          0,                      0,    "Tournament",     NULL,NULL},
   { lex_check_proc,    400,  330,   80 ,  20,    0,  -1,    0,    0,          0,                      0,    "Map Type",        NULL, NULL  },
// { lex_button_proc,   120,  130,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&New",     NULL, NULL  },
// { lex_button_proc,   200,  130,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Load",     NULL, NULL  },
   { d_text_proc,       120,  105,   120,  24,    0, -1,     0,    0,          0,                      0,    "PackFile Name:",     NULL,NULL},
   { lex_edit_proc,     250,  95,   120,   24,    0,  -1,    'x', 0,    16,                      0,    d_packname,     NULL, NULL  },
   { d_text_proc,       120,  135,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map name 1:",     NULL,NULL},
   { lex_edit_proc,     250,  125,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map0,     NULL, NULL  },
   { d_text_proc,       120,  165,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 2:",     NULL,NULL},
   { lex_edit_proc,     250,  155,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map1,     NULL, NULL  },
   { d_text_proc,       120,  195,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 3:",     NULL,NULL},
   { lex_edit_proc,     250,  185,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map2,     NULL, NULL  },
   { d_text_proc,       120,  225,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 4:",     NULL,NULL},
   { lex_edit_proc,     250,  215,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map3, NULL, NULL  },
   { d_text_proc,       120,  255,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 5:",     NULL,NULL},
   { lex_edit_proc,     250,  245,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map4, NULL, NULL  },
   { d_text_proc,       120,  285,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 6:",     NULL,NULL},
   { lex_edit_proc,     250,  275,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map5, NULL, NULL  },
   { d_text_proc,       120,  315,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 7:",     NULL,NULL},
   { lex_edit_proc,     250,  305,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map6, NULL, NULL  },
   { d_text_proc,       120,  345,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 8:",     NULL,NULL},
   { lex_edit_proc,     250,  335,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map7, NULL, NULL  },
   { d_text_proc,       120,  375,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 9:",     NULL,NULL},
   { lex_edit_proc,     250,  365,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map8, NULL, NULL  },
   { d_text_proc,       120,  405,   120,  24,    0, -1,     0,    0,          0,                      0,    "Map Name 10:",     NULL,NULL},
   { lex_edit_proc,     250,  395,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_map9, NULL, NULL  },
   { d_text_proc,       120,  435,   120,  24,    0, -1,     0,    0,          0,                      0,    "Comments:",     NULL,NULL},
   { lex_edit_proc,     250,  425,   120,   24,    0,  -1,    'x', 0,    149,                      0,    d_comments, NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};

//The Load Dialog
DIALOG the_dialog7[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  100,   -1,  -1,    0,    0,          0,                      0,    "Tile Ball Touch Properties",    NULL, NULL  },
   { d_text_proc,       120,  130,   120,  24,    0, -1,     0,    0,          0,                      0,    "Tile To Animate Into:",     NULL,NULL},
   { lex_edit_proc,     240,  135,   120,   24,    0,  -1,    'x', 0,    19,                      0,         d_extra,     NULL, NULL  },
   { lex_button_proc,   120,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "Okay",     NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};
//Create Tileset Dialog
DIALOG the_dialog8[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  100,   -1,  -1,    0,    0,          0,                      0,    "Create Tileset",    NULL, NULL  },
   { d_text_proc,       120,  130,   120,  24,    0, -1,     0,    0,          0,                      0,    "Picture to convert:",     NULL,NULL},
   { lex_edit_proc,     240,  145,   120,   24,    0,  -1,    'x', 0,    19,                      0,         d_extra,     NULL, NULL  },
   { lex_button_proc,   120,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "Okay",     NULL, NULL  },
   { lex_button_proc,   180,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "Cancel",     NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};
//Save as dialog
DIALOG the_dialog9[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  100,   -1,  -1,    0,    0,          0,                      0,    "Save as",    NULL, NULL  },
   { d_text_proc,       120,  132,   120,  24,    0, -1,     0,    0,          0,                      0,    "Save as:",     NULL,NULL},
   { lex_edit_proc,     240,  125,   120,   24,    0,  -1,    'x', 0,    19,                      0,    d_saveas,     NULL, NULL  },
   { lex_button_proc,   200,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Save",     NULL, NULL  },
   { lex_button_proc,   280,  160,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                      0,    "&Cancel",     NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                      0,    NULL,         NULL, NULL  },
};
DIALOG the_dialog10[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  300,  150,   -1,  -1,    0,    0,          0,                      0,    "Ball Animation Frames",    NULL, NULL  },
   { lex_radio_proc,    150,  130,   80 ,  20,    0,  -1,    0,    D_SELECTED, 1,                      0,    "1",        NULL, NULL  },
   { lex_radio_proc,    150,  150,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "2",        NULL, NULL  },
   { lex_radio_proc,    150,  170,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "4",        NULL, NULL  },
   { lex_radio_proc,    150,  190,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "8",        NULL, NULL  },
   //{ lex_button_proc,   110,  264,   60,   24,    0,  -1,    'y',  D_EXIT,    0,                     0,    "&Save",     save_file, NULL  },
   { lex_button_proc,   300,  190,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                     0,    "Okay",     NULL, NULL  },

   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                     0,    NULL,         NULL, NULL  },
};
/*
DIALOG the_dialog3[] =
{
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)     (d1)                    (d2)  (dp)              (dp2) (dp3)
   { lex_dialog_proc,   100,  100,  440,  200,   -1,  -1,    0,    0,          0,                      0,    "Dialog",    NULL, NULL  },

   { lex_radio_proc,    110,  160,   80 ,  20,    0,  -1,    0,    D_SELECTED, 1,                      0,    "Radio 1",        NULL, NULL  },
   { lex_radio_proc,    110,  180,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "Radio 2",        NULL, NULL  },
   { lex_radio_proc,    110,  200,   80 ,  20,    0,  -1,    0,    0,          1,                      0,    "Radio 3",        NULL, NULL  },

   { lex_check_proc,    270,  160,   80 ,  20,    0,  -1,    0,    D_SELECTED, 0,                      0,    "Check 1",        NULL, NULL  },
   { lex_check_proc,    270,  180,   80 ,  20,    0,  -1,    0,    0,          0,                      0,    "Check 2",        NULL, NULL  },
   { lex_check_proc,    270,  200,   80 ,  20,    0,  -1,    0,    0,          0,                      0,    "Check 3",        NULL, NULL  },

   { lex_edit_proc ,    410,  130,  120 ,  24,    0,  -1,    0,    0,          20,                     0,   d_filename ,        NULL, NULL  },


   { lex_slider_proc,   110,  230,  200,   20,   0 , -1,    0,    0,       100,                    0,    NULL,             NULL, NULL  },
      
   //{ lex_button_proc,   110,  264,   60,   24,    0,  -1,    'y',  D_EXIT,    0,                     0,    "&Save",     save_file, NULL  },
   
   { lex_button_proc,   480,  264,   50,   24,    0,  -1,    'x',  D_EXIT,    -1,                     0,    "E&xit",     NULL, NULL  },
      
   { NULL,              0,    0,    0,    0,    0  ,   0,    0,    0,          0,                     0,    NULL,         NULL, NULL  },
};
*/

//Global GUI arrays
char *d_pmap[10];
char d_map0[25];
char d_map1[25];
char d_map2[25];
char d_map3[25];
char d_map4[25];
char d_map5[25];
char d_map6[25];
char d_map7[25];
char d_map8[25];
char d_map9[25];
char d_filename[25];
char d_mapname[25];
char d_imagename[25];
char d_paddlename[25];
char d_ballname[25];
char d_loadname[25];
char d_saveas[25];
char d_savename[25];
char d_packname[25];
char d_comments[220];
char d_extra[25];
char d_charuse[25];

char* listbox_callback(int index, int *size) {
    static char buffer[20];


    if (index < 0) {
        *size = 4;
        return NULL;
    }

//printf("%d is cur_tile",the_dialog[4].d1);
//printf("%d is selected",the_dialog[5].d1);
//rest(100);
 sprintf(buffer, "Animation %d", index + 1);

//   tile_set.tiles[the_dialog[1].d1].anim[the_dialog[1].d2] =1;
if(the_dialog[2].flags == D_DISABLED)
  the_dialog[2].flags = 0;


if(the_dialog[4].d1 == 0)
   {
   if((atoi(d_extra)) > 265)
    strcpy(d_extra,"0");
   tile_set.tiles[the_dialog[1].d1].anim[the_dialog[1].d2+1] = atoi(d_extra);
   the_dialog[1].d2 = the_dialog[3].d1;
   sprintf(d_extra,"%d",0);
   itoa(tile_set.tiles[the_dialog[1].d1].anim[the_dialog[1].d2+1],d_extra,10);
   d_edit_proc(0,&the_dialog[2],0);
   d_edit_proc(3,&the_dialog[3],0);
   }
the_dialog[4].d1 += 1;

if(the_dialog[4].d1 == 4)
 {
 the_dialog[4].d1 = 0;
 the_dialog[2].flags= D_DIRTY;
 }
if(the_dialog[3].d1 <0)
 the_dialog[2].flags = D_DISABLED;

//   tile_set[the_dialog[1].d1].tiles.anim[index] = atoi(d_extra);
   //    sprintf(buffer, "Line %03i", index);
    return buffer;
}

/*
//My alert replacement, looks much nicer.
int gui_6_show(void)
//{
//int index;
//int index2;
//int index3;
//the_dialog[1].d1 = 3;
//the_dialog[1].d2 = 0;
//the_dialog[3].d1 = 0;
//the_dialog[4].d1 = 0;
//sprintf(the_dialog[0].dp1,"Tile %d Animate Properties",cur_tile);
index = lex_do_dialog(the_dialog8, -1, double_buffer, update_screen);
//printf("%d",index);
rest(400);
return 0;
}
*/
//Allright lets make this ver .99
int create_tileset(void)
{
int index;
int index2;
int index3;
int sright;
int sdown;
int rightdone = 0;
int downdone = 0;
char ssave[25];
//char d_ex[20];
BITMAP *bitmap_to_save;
BITMAP *bitmap_to_load;
strcpy(d_extra,"");
//strcpy(d_ex,"");
index = lex_do_dialog(the_dialog8, -1, double_buffer, update_screen);
if(index !=3)
 return 0;
bitmap_to_load = load_bitmap(d_extra,NULL);
 if(!bitmap_to_load)
  {
  lex_alert("Error, Unable To Load","The Requested File","Make Sure Image is Valid",NULL,"Okay",NULL,0,0,0);
  return 0;
  }
bitmap_to_save = create_bitmap(640,480);
clear_bitmap(bitmap_to_save);
//First we draw lines so that the grid is in place
for(index2=0;index2<20;index2++)
   line(bitmap_to_save,index2 *33,0, index2*33,scry-18,makecol(255,255,255));
for(index3=0;index3<15;index3++)
   line(bitmap_to_save,0,index3 * 33,scrx-14,index3*33,makecol(255,255,255));

//Now we actually copy the bitmap
sright = (bitmap_to_load->w +1) / 32;
sdown = (bitmap_to_load->h+ 1) / 32;
//The move around routine
for(index3=0;index3<sdown;index3++)
  for(index2=0;index2<sright;index2++)
  {
  blit(bitmap_to_load,bitmap_to_save,index2*32,index3*32,rightdone * 33+1, downdone *33+1,32,32);
  rightdone++;
  if(rightdone == 19)
    {
    rightdone = 0;
    downdone++;
    }
  }
//strncpy(d_ex,d_extra, (strlen(d_extra)-3));
//d_extra[strlen(d_extra)-3] = NULL;
d_extra[strlen(d_extra)-3] ='\0';
sprintf(ssave,"%s%s%s","n",d_extra,"bmp");
if(save_bitmap(ssave,bitmap_to_save,NULL))
 {
clear_bitmap(bitmap_to_save);
destroy_bitmap(bitmap_to_save);
destroy_bitmap(bitmap_to_load);
lex_alert("Make Failed","Name of file to create was:",ssave,NULL,"Okay",NULL,0,0,0);
return 0;
 }
clear_bitmap(bitmap_to_save);
destroy_bitmap(bitmap_to_save);
destroy_bitmap(bitmap_to_load);
lex_alert("New Bitmap Created","It has a file name of:",ssave,NULL,"Okay",NULL,0,0,0);
return 0;
}

//Changes The Ball_animation stat in the map file
//and allows 1,2,4, or 8 frames of animation for the ball
int show_change_ballanim(void)
{
int index;
//Lets fix this too, got nothing better to do ;)
//Maybe this game will become 99% bug free!
for (index =1;index<5;index++)
 {
the_dialog10[index].flags = 0; }
if(map.ball_anim == 1)
  the_dialog10[1].flags = D_SELECTED;
else if(map.ball_anim == 2)
  the_dialog10[2].flags = D_SELECTED;
if(map.ball_anim == 4)
  the_dialog10[3].flags = D_SELECTED;
if(map.ball_anim == 8)
  the_dialog10[4].flags = D_SELECTED;
lex_do_dialog(the_dialog10, -1, double_buffer, update_screen);
for (index =1;index<5;index++)
 {
 if(the_dialog10[index].flags ==D_SELECTED)
  {
  switch(index){
  case 1:
  map.ball_anim = 1;
  break;
  case 2:
  map.ball_anim = 2;
  break;
  case 3:
  map.ball_anim = 4;
  break;
  case 4:
  map.ball_anim = 8;
  break;}
  //End switch statement
  }
 }
return 0;
}
int show_change_type(void)
{
int index;
//Gets called by the_dialog3
//to choose which button got called
for(index=1;index<4;index++)
{the_dialog3[index].flags = 0;}
if( map.map_type == 1)
   the_dialog3[1].flags = D_SELECTED;
if(map.map_type ==2)
   the_dialog3[2].flags = D_SELECTED;
if(map.map_type ==3)
   the_dialog3[3].flags= D_SELECTED;


lex_do_dialog(the_dialog3, -1, double_buffer, update_screen);
set_map_type();
return 0;
}
int lex_alert(const char *s1, const char *s2, const char *s3, const char *b1, const char *b2, const char *b3, int c1, int c2, int c3)
{
int index;
if(s1)
 lex_alert_dialog[1].dp = (char *)s1;
if(s2)
 lex_alert_dialog[2].dp = (char *)s2;
if(s3)
 lex_alert_dialog[3].dp = (char *)s3;
if(!b1)
 lex_alert_dialog[4].flags =D_HIDDEN;
if(b1)
 {
 lex_alert_dialog[4].flags =D_EXIT;
 lex_alert_dialog[4].dp = (char *)b1;
 }
if(!b2)
 lex_alert_dialog[5].flags =D_HIDDEN;
if(b2)
 {
 lex_alert_dialog[5].flags =D_EXIT;
 lex_alert_dialog[5].dp = (char *)b2;
 }
if(!b3)
 lex_alert_dialog[6].flags =D_HIDDEN;
if(b3)
 {
 lex_alert_dialog[6].flags =D_EXIT;
 lex_alert_dialog[6].dp = (char *)b3;
 }
index =lex_do_dialog(lex_alert_dialog, -1, double_buffer, update_screen);
if(index==4)
 return 1;
if(index==5)
 return 2;
if(index==6)
 return 3;
return 0;
}
int set_default_gui_colors(void)
{
gui_fg_color = makecol(255,255,255);
gui_bg_color = makecol(0,0,0);
gui_mg_color = makecol(125,125,125);
return 0;
}
void set_gui_colors(int fg,int bg,int mg)
{
gui_fg_color = fg;
gui_bg_color = bg;
gui_mg_color = mg;
}
//LEX_GUI
void update_screen(BITMAP *buffer)
{
    scare_mouse();
    blit(buffer, screen, 0, 0, 0, 0, scrx, scry);
    unscare_mouse();
}
//just implented
int save_map_as_dialog(void)
{
int index;
//Does the dialog
strcpy(d_saveas,map.mapname);
index = lex_do_dialog(the_dialog9, -1, double_buffer, update_screen);
if(index == 3)
  {
  if(check_if_mapname(d_saveas))
    {
    lex_alert("Mapname is invalid","Map must end in .map","",NULL,"Okay",NULL,0,0,0);
    return 0;
    }
  strcpy(map.mapname,d_saveas);
  strcpy(d_filename,d_saveas);

  save_map_dialog();
  }
return 0;
}

int save_map_dialog(void)
{
if (save_map(&map))
   {
   lex_alert("Unable to Save Map","","",NULL,"Okay",NULL,0,0,0);
   return 0;
   }
lex_alert("Map Saved Succesfully","","",NULL,"Okay",NULL,0,0,0);
return 0;
}

int load_map_dialog(void)
{
int index;
//Does the dialog
index = lex_do_dialog(the_dialog2, -1, double_buffer, update_screen);
if(index == 2)
  load_map_do();

return 0;
}


int show_about(void)
{
lex_do_dialog(the_dialog5, -1, double_buffer, update_screen);
return D_O_K;
}
int load_them_number(void)
{
int number;
FILE *fp;
if((fp=fopen("map.dat","r")) == NULL)
 set_theme_number(0);
else
 {
  fread(&number, sizeof(int),1,fp);
  set_theme_number(number);
  fclose(fp);
 }
return 0;
}
int save_theme_number(int number)
{
FILE *fp;
fp = fopen("map.dat","w");
fwrite(&number, sizeof(int),1,fp);
fclose(fp);
return 0;
}
int set_theme_number(int number)
{
 switch(number)
  {
  case 0:
   if (!lex_load_skin("./skins/red.skin"))
       {
          allegro_message("Unable to load Skin\n");
          exit(1);
       }
   break;
  case 1:
   if (!lex_load_skin("./skins/aqua.skin"))
       {
          allegro_message("Unable to load Skin\n");
          exit(1);
       }
   break;
  case 2:
   if (!lex_load_skin("./skins/bill32.skin"))
       {
          allegro_message("Unable to load Skin\n");
          exit(1);
       }
   break;
  case 3:
   if (!lex_load_skin("./skins/yellow.skin"))
       {
          allegro_message("Unable to load Skin\n");
          exit(1);
       }
   break;
  }
return 0;
}
int set_red_theme(void)
{
if (!lex_load_skin("./skins/red.skin")) {
        allegro_message("Unable to load Skin\n");
        exit(1);
    }
save_theme_number(0);
return 0;
}
int set_aqua_theme(void)
{
if (!lex_load_skin("./skins/aqua.skin")) {
        allegro_message("Unable to load Skin\n");
        exit(1);
    }
save_theme_number(1);
return 0;
}
int set_win_theme(void)
{
if (!lex_load_skin("./skins/bill32.skin")) {
        allegro_message("Unable to load Skin\n");
        exit(1);
    }
save_theme_number(2);
return 0;
}
int set_yellow_theme(void)
{
if (!lex_load_skin("./skins/yellow.skin")) {
        allegro_message("Unable to load Skin\n");
        exit(1);
    }
save_theme_number(3);
return 0;
}
int show_map_boundaries_do(void)
{
show_map_boundaries(&map);
return 0;
}
