#include <stdio.h>
#include "allegro.h"
#include "sprite.h"
#include "input.h"
#include "pmain.h"
#include "pgmap.h"
//Skips bytes in a file
void fskip(FILE *fp, int num_bytes)
{
int i;
for(i=0;i<num_bytes;i++)
 fgetc(fp);
}

void draw_map(void)
{
int index1;
int index2;
for(index1=0;index1<13;index1++)
 {
 for(index2=0;index2<20;index2++)
  {
   tile_display(double_buffer,&tile_set.tiles[(map.map_info[index2][index1])],index2*32,(index1*32)+64);
  }
 }
}
//Loads a map
int load_map(MAP *smap)
{
int index1;
int index2;
FILE *fp;
if((fp=fopen(smap->mapname,"rb"))==NULL)
 {
   return(1);
 }
fskip(fp,3);
fread(smap->mapname,sizeof(char),20,fp);
fread(smap->backround,sizeof(char),20,fp);
fread(smap->balls,sizeof(char),20,fp);
fread(smap->paddles,sizeof(char),20,fp);
fread(&smap->maptitle,sizeof(char),20,fp);
//Reads map type
fread(&smap->map_type,sizeof(int),1,fp);
fread(&smap->ball_anim,sizeof(int),1,fp); //ball_frame number
//if map = 4player, get blocked co-ordinates
if(smap->map_type == 2)
 {
 fread(&smap->map_limitx,sizeof(int),1,fp);
 fread(&smap->map_limity,sizeof(int),1,fp);
 }
if(smap->map_type == 3)
 {
 fread(&smap->map_limitx,sizeof(int),1,fp);
 fread(&smap->map_limity,sizeof(int),1,fp);
 }

 calc_map_boundaries(smap);

for(index1=0;index1<13;index1++)
 {
 for(index2=0;index2<20;index2++)
  fread(&smap->map_info[index2][index1],sizeof(int),1,fp);
 }
for(index1=0;index1<266;index1++)
 {
 fread(&tile_set.tiles[index1].anim_type,sizeof(int),1,fp);
//  if(tile_set.tiles[index1].anim_type==2)
//  for(index2=0;index2<5;index2++)
//   fread(&tile_set.tiles[index1].anim[index2],sizeof(int),1,fp);
 if(tile_set.tiles[index1].anim_type==2)
  for(index2=0;index2<5;index2++)
   fread(&tile_set.tiles[index1].anim[index2],sizeof(int),1,fp);

 }
fclose(fp);
sprite_init(&ball[0].image,&sball,154,106,16,16,map.ball_anim,0); //The Ball
sprite_init(&ball[1].image,&sball,154,106,16,16,map.ball_anim,0); //The Ball
sprite_init(&ball[2].image,&sball,190,100,16,16,map.ball_anim,0); //The Ball
sprite_init(&ball[3].image,&sball,140,100,16,16,map.ball_anim,0); //The Ball
//Sets for backround, color not changed
set_color_conversion(COLORCONV_TOTAL);
//set_color_conversion(COLORCONV_NONE);
drawing_mode(DRAW_MODE_SOLID,NULL,NULL,NULL); //Fix for jpegalleg
tileset_load(&tile_set, map.backround,19, 14);
//Sets for backround, transparancy kept
set_color_conversion(COLORCONV_TOTAL | COLORCONV_KEEP_TRANS);
sprite_grab(&paddle[0].image,map.paddles,0,0);
sprite_grab(&paddle[1].image,map.paddles,21,0);
sprite_grab(&ball[0].image,map.balls,0,0);
if(smap->map_type == 2)
{
sprite_grab(&paddle[2].image,map.paddles,42,0);
sprite_grab(&paddle[3].image,map.paddles,42+paddle[3].image.width + 1,0);
}
drawing_mode(DRAW_MODE_TRANS,NULL,NULL,NULL); //Sets draw_mode to trans
//This is used only in final version
delete_file(smap->mapname);
delete_file(smap->backround);
delete_file(smap->balls);
delete_file(smap->paddles);

return 0;
}
void calc_map_boundaries(MAP *smap)
{
//Calculates boundaries from
if(smap->map_type == 1)
{
 //Stupid coding causes problems. It's that simple
 smap->map_limitx  = 0;
 smap->map_limity  = 0;
 smap->map_up = 64;
 smap->map_down = scry;
 smap->map_right = 0;
 smap->map_left = 0;
}
//Fix up

if(smap->map_type == 2)
{
 smap->map_up = smap->map_limity * 32;
 smap->map_down = scry - (smap->map_limity * 32)+64;
 smap->map_left = smap->map_limitx *32;
 smap->map_right = scrx - (smap->map_limitx * 32);
 }
if(smap->map_type == 3)
{
 smap->map_right = scrx - (smap->map_limitx * 32);
 smap->map_left = 0;
 smap->map_up = 64;
 smap->map_down = scry;
}

}
