#include <stdio.h>
#include <string.h>
#include "allegro.h"
#include "sprite.h"
#include "input.h"
#include "pmain.h"
#include "pack.h"
#include "npk.h"




//Loads an npk
int load_npk_file(NPK *npk, const char *filename)
{

FILE *fp;
int index;
sprintf(npk->filename_npk,"%s%s","maps/",filename);
if((fp=fopen(npk->filename_npk,"rb"))==NULL) //Checks to see if opened file
 return 1;
fread(&(npk->filename),sizeof(char),20,fp); //npk,Read Name of Packfile
sprintf(npk->filename_pak,"%s%s",npk->filename,".pak"); //Wow, a little modification, and does it fix things?
fread(&(npk->num_maps),sizeof(int),1,fp); //npk,Write How Many Maps in pack
fread(&(npk->npk_type),sizeof(int),1,fp); //npk,Writes 1 For Tournament Mode
for(index =0;index < npk->num_maps;index++)
 {
 fread(&(npk->map_file_name[index]),sizeof(char),20,fp);        //npk,Write mapfilename
 fread(&(npk->map_name[index]),sizeof(char),20,fp); //npk, write maptitle
 fread(&(npk->map_type[index]),sizeof(int),1,fp); //npk, write maptype
 fread(&(npk->map_status[index]),sizeof(int),1,fp);        //npk,Writes 0, Is for map status, modified by
 fread(&(npk->map_top_score[index]),sizeof(long),1,fp); //npk, write mapscore
 }                                       //Pong game, if ==1then unlocked if 2 then topscore included
fread(npk->comments,sizeof(char),150,fp); //npk, write comments
fclose(fp); //Close The Files
return 0;
}
//Saves an npk
int save_npk_file(NPK *npk)
{
FILE *fp;
int index;
if((fp=fopen(npk->filename_npk,"wb"))==NULL) //Checks to see if opened file
 return 1;

fwrite(&(npk->filename),sizeof(char),20,fp); //npk,Read Name of Packfile
fwrite(&(npk->num_maps),sizeof(int),1,fp); //npk,Write How Many Maps in pack
fwrite(&(npk->npk_type),sizeof(int),1,fp); //npk,Writes 1 For Tournament Mode
for(index =0;index < npk->num_maps;index++)
 {
 fwrite(&(npk->map_file_name[index]),sizeof(char),20,fp);        //npk,Write mapfilename
 fwrite(&(npk->map_name[index]),sizeof(char),20,fp); //npk, write maptitle
 fwrite(&(npk->map_type[index]),sizeof(int),1,fp); //npk, write maptype
 fwrite(&(npk->map_status[index]),sizeof(int),1,fp);        //npk,Writes 0, Is for map status, modified by
 fwrite(&(npk->map_top_score[index]),sizeof(long),1,fp); //npk, write mapscore
 }                                       //Pong game, if ==1then unlocked if 2 then topscore included
fwrite(npk->comments,sizeof(char),150,fp); //npk, write comments
fclose(fp); //Close The Files
return 0;
return 0;
}

void print_npk_header(NPK *npk)
{
int index;
for(index =0;index<npk->num_maps;index++)
 {
 printf("Map #%d Name: %s \n",index,npk->map_name[index]);
 printf("Map #%d Name: %s \n",index,npk->map_file_name[index]);
 }
}

int select_map(NPK *npk)
{
int index = 0;
int index2 = 0;
char text[200];
while(index > -1)
{
for(index2 =0;index2<npk->num_maps;index2++)
  {
  sprintf(text,"%s, Map Number %d",npk->map_name[index2], index2);
  if(index2 == index)
   textout(double_buffer,font,text,0,0+30*index2, 1);
  else
   textout(double_buffer,font,text,0,0+30*index2, 2);
  }
if(key[KEY_ESC] || key[KEY_ENTER])
 {
 clear_bitmap(double_buffer);
 break;
 }
if(key[KEY_UP])
{
index--;
if(index<0)
 index =0;
}
if(key[KEY_DOWN])
{
index++;
if(index>npk->num_maps - 1)
 index = npk->num_maps - 1;
}

blit(double_buffer,screen,0,0,0,0,double_buffer->w,double_buffer->h);
}


return index;
}

/*
typedef struct PACK_FILE_HEADER_STRUCT
{
int mapnum;
char mapnames[10][25];
}PFH;

int load_packfile_header(PFH *pfh,char filename[20]);
void print_packfile_header(PFH *pfh);
#include <stdio.h>
#include "packh.h"
int load_packfile_header(PFH *pfh,char filename[20])
{
FILE *fp;
int index;
if((fp = fopen(filename,"rb"))==NULL)
  return 1;
fread(&pfh->mapnum,sizeof(int),1,fp);
for(index=0;index<pfh->mapnum;index++)
 fread(&pfh->mapnames[index],sizeof(char),20,fp);
fclose(fp);
return 0;
}
*/

//Thanks Goes To White Door, for his
//Particle Tut looks much like this,

//Adds a new level.....
NPK * add_npk(NPK *parent)
{
NPK *tmp;
tmp = (NPK *)malloc(sizeof(NPK));
tmp->next = parent;
return tmp;
}

//Gets all packfiles found in map directory
void npkl_get_list(NPKL *npkl)
{
//This is to Copy File Names
char temp[20] ="";
//Basically The Parent Is Allocated For Future Use
//npkl->next = (NPK *)malloc(sizeof(NPK));
npkl->next = NULL;
/*
  typedef struct NPK_LIST_STRUCT
  {
  int num_mapsets;   //How many maps are in mapset
  struct al_ffblk f_list;
  struct NPK_STRUCT *next;
  } NPK_L;
*/

//Here We Find All Needed Maps and Add as many as needed
        if (!al_findfirst("maps/*.npk", &(npkl->f_list), -1))
        {
                do
                {
                npkl->next = add_npk(npkl->next);
                strcpy(temp,npkl->f_list.name);
//                strncpy(temp,npkl->f_list.name,strlen((npkl->f_list.name))-4);
//                temp[strlen(npkl->f_list.name-3)] = '\0';
                load_npk_file(npkl->next,temp);
               // allegro_message("%s\n",npkl->f_list.name);
               // allegro_message("%s\n",temp);

                } while (!al_findnext(&(npkl->f_list)));
        }
        al_findclose(&(npkl->f_list));
}
void remove_npk(NPK *t)
{
NPK *tmp;
NPK *next;
tmp = t;
t = NULL;

  while(tmp)
   {
  next = tmp->next;
  free(tmp);
  tmp = next;
   }
}

