//Quick Song References
#define SONG_OFF             0
#define SONG_ON              1
#define SONG_PAUSE           2
#define SONG_UNPAUSE         3
#define SONG_DISABLED        4
//File Type References
#define SONG_MOD             1
#define SONG_S3M             2
#define SONG_XM              3
#define SONG_IT              4

//Song Struct
typedef struct SONG_STRUCT
  {
   DUH *duh;             //Music File Info
   AL_DUH_PLAYER *dp;    //Dumb File Player
   char filepath[200];   //Where the file is located, set to 200 for saftey
   int song_data;    //Is song a datafile
   int song_loaded;  //Is a song loaded?
   int flags;         //0 = Disabled, 1 =Enabled, 2 = Paused, 3 =?????
   int file_type;    //S3m, Mod, IT, XM, 0 = None
   }SONG,*SONG_ptr;

typedef struct MPLAYLIST_STRUCT
  {
  SONG *next;
  int num_songs;
  }MPLAY;

int init_music(void);  //Sets up music
int load_music(SONG *song, const char *path); //Loads a file, First Checking if a song is loaded
int load_music_datafile(SONG *song,DATAFILE *datafile,int dat_num); //Loads a file, First Checking if a song is loaded
int free_music(SONG *song); //Deletes all allocated mem, error checking
void play_music(SONG *song);//Plays a Song
void stop_music(SONG *song);//Stops a Song
void pause_music(SONG *song);//Pauses a Song
void unpause_music(SONG *song);//Unpauses a Song
//Tells Wether Music is on or off
extern int music_on;
extern float music_vol;
//extern SONG song;
//extern const int scrx; //Screen Size
//Pong Stuff, Shouldnt be here really.
extern SONG songs[8];
extern SONG *song;
extern int songs_used;

